#*******************************************************************************
# ALMA - Atacama Large Millimeter Array
# Copyright (c) UKATC - UK Astronomy Technology Centre, Science and Technology Facilities Council, 2011
# (in the framework of the ALMA collaboration).
# All rights reserved.
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
#*******************************************************************************
# $Id: inspectnode.py,v 1.5 2004/02/26 08:33:10 amchavan Exp $
# Example Python script, demonstrating how to interact with the runtime
# structures of the Observing Tool, and how to use Swing widgets
# from a Python script.
# Inspects the currently selected node of the Project tree, if any, and
# dumps it to a new top-level window, using the utility methods in 
# alma.obsprep.util.GUIUtilities.
# amchavan, 24-Oct-2003
 
from alma.obsprep.util import GUIUtilities
from alma.obsprep.editors import ObservingToolController

node = ObservingToolController.getCurrentNode()    # Get selected tree node
if node is None:                    
    # A Java null translates to the special Python symbol 'None'.
    GUIUtilities.warning( "No selected tree node" )
else:                       
    n = node.dump()                 # Dump the node to a string
    GUIUtilities.info( GUIUtilities.scroller( n, 500, 200 ))
