/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.nc;

import alma.ACSErrTypeCommon.wrappers.AcsJBadParameterEx;
import alma.ACSErrTypeCommon.wrappers.AcsJCouldntPerformActionEx;
import alma.ACSErrTypeCommon.wrappers.AcsJIllegalStateEventEx;
import alma.ACSErrTypeCommon.wrappers.AcsJStateMachineActionEx;
import alma.acs.container.ContainerServicesBase;
import alma.acs.exceptions.AcsJException;
import alma.acs.logging.MultipleRepeatGuard;
import alma.acs.logging.RepeatGuard;
import alma.acs.nc.AcsEventSubscriber;
import alma.acs.nc.sm.generated.EventSubscriberAction;
import alma.acs.nc.sm.generated.EventSubscriberSignal;
import alma.acs.nc.sm.generated.EventSubscriberSignalDispatcher;
import alma.acs.nc.sm.generic.AcsScxmlActionDispatcher;
import alma.acs.nc.sm.generic.AcsScxmlActionExecutor;
import alma.acs.nc.sm.generic.AcsScxmlEngine;
import alma.acs.util.StopWatch;
import alma.acsErrTypeLifeCycle.wrappers.AcsJEventSubscriptionEx;
import alma.acsnc.EventDescription;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.EventDispatcher;
import org.apache.commons.scxml.SCInstance;
import org.apache.commons.scxml.TriggerEvent;

public abstract class AcsEventSubscriberImplBase<T>
implements AcsEventSubscriber<T>,
AcsScxmlActionExecutor<EventSubscriberAction> {
    protected final String clientName;
    protected final ContainerServicesBase services;
    protected final Logger logger;
    protected final AcsScxmlEngine<EventSubscriberSignal, EventSubscriberAction> stateMachine;
    private static final String scxmlFileName = "/alma/acs/nc/sm/generated/EventSubscriberSCXML.xml";
    protected final EventSubscriberSignalDispatcher stateMachineSignalDispatcher;
    public static final int EVENT_QUEUE_CAPACITY = 50;
    private ThreadPoolExecutor eventHandlingExecutor;
    private final AtomicLong numEventsDiscarded = new AtomicLong(0L);
    private final RepeatGuard receiverTooSlowLogRepeatGuard;
    protected AcsEventSubscriber.GenericCallback genericReceiver;
    protected final Map<Class<? extends T>, AcsEventSubscriber.Callback<? extends T>> receivers = new HashMap<Class<? extends T>, AcsEventSubscriber.Callback<? extends T>>();
    protected final MultipleRepeatGuard processTimeLogRepeatGuard;
    protected final Class<T> eventType;

    protected abstract boolean isTraceEventsEnabled();

    public AcsEventSubscriberImplBase(ContainerServicesBase services, String clientName, Class<T> eventType) throws AcsJException {
        if (services == null) {
            AcsJBadParameterEx ex = new AcsJBadParameterEx();
            ex.setParameter("services");
            ex.setParameterValue("null");
            throw ex;
        }
        this.services = services;
        if (clientName == null) {
            AcsJBadParameterEx ex = new AcsJBadParameterEx();
            ex.setParameter("clientName");
            ex.setParameterValue("null");
            throw ex;
        }
        this.clientName = clientName;
        this.eventType = eventType;
        this.logger = services.getLogger();
        this.processTimeLogRepeatGuard = new MultipleRepeatGuard(0L, TimeUnit.SECONDS, 1, RepeatGuard.Logic.COUNTER, 100);
        this.receiverTooSlowLogRepeatGuard = new RepeatGuard(30L, TimeUnit.SECONDS, 100, RepeatGuard.Logic.OR);
        AcsScxmlActionDispatcher<EventSubscriberAction> actionDispatcher = new AcsScxmlActionDispatcher<EventSubscriberAction>(this.logger, EventSubscriberAction.class);
        actionDispatcher.registerActionHandler(EventSubscriberAction.createEnvironment, this);
        actionDispatcher.registerActionHandler(EventSubscriberAction.destroyEnvironment, this);
        actionDispatcher.registerActionHandler(EventSubscriberAction.createConnection, this);
        actionDispatcher.registerActionHandler(EventSubscriberAction.destroyConnection, this);
        actionDispatcher.registerActionHandler(EventSubscriberAction.suspendConnection, this);
        actionDispatcher.registerActionHandler(EventSubscriberAction.resumeConnection, this);
        this.stateMachine = new AcsScxmlEngine<EventSubscriberSignal, EventSubscriberAction>(scxmlFileName, this.logger, actionDispatcher, EventSubscriberSignal.class);
        this.stateMachineSignalDispatcher = new EventSubscriberSignalDispatcher(){

            @Override
            protected AcsScxmlEngine<EventSubscriberSignal, EventSubscriberAction> getScxmlEngine() {
                return AcsEventSubscriberImplBase.this.stateMachine;
            }
        };
    }

    @Override
    public boolean execute(EventSubscriberAction action, EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
        boolean ret = true;
        switch (action) {
            case createEnvironment: {
                this.createEnvironmentAction(evtDispatcher, errRep, scInstance, derivedEvents);
                break;
            }
            case destroyEnvironment: {
                this.destroyEnvironmentAction(evtDispatcher, errRep, scInstance, derivedEvents);
                break;
            }
            case createConnection: {
                this.createConnectionAction(evtDispatcher, errRep, scInstance, derivedEvents);
                break;
            }
            case destroyConnection: {
                this.destroyConnectionAction(evtDispatcher, errRep, scInstance, derivedEvents);
                break;
            }
            case suspendConnection: {
                this.suspendAction(evtDispatcher, errRep, scInstance, derivedEvents);
                break;
            }
            case resumeConnection: {
                this.resumeAction(evtDispatcher, errRep, scInstance, derivedEvents);
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    protected void createEnvironmentAction(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
    }

    protected void destroyEnvironmentAction(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
    }

    protected void createConnectionAction(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
        this.eventHandlingExecutor = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(50), this.services.getThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
    }

    protected void destroyConnectionAction(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
        this.eventHandlingExecutor.shutdown();
        boolean queueOK = false;
        try {
            queueOK = this.eventHandlingExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!queueOK) {
            int remainingEvents = this.eventHandlingExecutor.getQueue().size();
            this.logQueueShutdownError(500, remainingEvents);
        }
    }

    protected void suspendAction(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
    }

    protected void resumeAction(EventDispatcher evtDispatcher, ErrorReporter errRep, SCInstance scInstance, Collection<TriggerEvent> derivedEvents) throws AcsJStateMachineActionEx {
    }

    protected abstract double getMaxProcessTimeSeconds(String var1);

    protected abstract void logEventReceiveHandlerException(String var1, String var2, Throwable var3);

    protected abstract void logEventProcessingTimeExceeded(String var1, long var2);

    protected abstract void logEventProcessingTooSlowForEventRate(long var1, String var3);

    protected abstract void logNoEventReceiver(String var1);

    protected abstract void logQueueShutdownError(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEventAsync(final Object eventData, final EventDescription eventDesc) {
        boolean isReceiverBusyWithPreviousEvent = this.eventHandlingExecutor.getQueue().size() > 25;
        boolean thisEventDiscarded = false;
        try {
            this.eventHandlingExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    AcsEventSubscriberImplBase.this.processEvent(eventData, eventDesc);
                }
            });
        }
        catch (RejectedExecutionException ex) {
            thisEventDiscarded = true;
            this.numEventsDiscarded.incrementAndGet();
        }
        if (thisEventDiscarded || isReceiverBusyWithPreviousEvent) {
            RepeatGuard repeatGuard = this.receiverTooSlowLogRepeatGuard;
            synchronized (repeatGuard) {
                if (this.receiverTooSlowLogRepeatGuard.checkAndIncrement()) {
                    this.logEventProcessingTooSlowForEventRate(this.numEventsDiscarded.getAndSet(0L), eventData.getClass().getName());
                }
            }
        }
    }

    protected void processEvent(Object eventData, EventDescription eventDesc) {
        Class<?> incomingEventType = eventData.getClass();
        String eventName = incomingEventType.getName();
        double maxProcessTimeSeconds = this.getMaxProcessTimeSeconds(eventName);
        StopWatch profiler = new StopWatch();
        if (this.eventType.isAssignableFrom(incomingEventType) && this.receivers.containsKey(incomingEventType)) {
            Object typedEventData = eventData;
            AcsEventSubscriber.Callback<T> receiver = this.receivers.get(incomingEventType);
            profiler.reset();
            try {
                this._process(receiver, typedEventData, eventDesc);
            }
            catch (Throwable thr) {
                this.logEventReceiveHandlerException(eventName, receiver.getClass().getName(), thr);
            }
            double usedSecondsToProcess = (double)profiler.getLapTimeMillis() / 1000.0;
            if (usedSecondsToProcess > maxProcessTimeSeconds && this.processTimeLogRepeatGuard.checkAndIncrement(eventName)) {
                this.logEventProcessingTimeExceeded(eventName, this.processTimeLogRepeatGuard.counterAtLastExecution(eventName));
            }
        } else if (this.genericReceiver != null) {
            profiler.reset();
            this.genericReceiver.receiveGeneric(eventData, eventDesc);
            double usedSecondsToProcess = (double)profiler.getLapTimeMillis() / 1000.0;
            if (usedSecondsToProcess > maxProcessTimeSeconds && this.processTimeLogRepeatGuard.checkAndIncrement(eventName)) {
                this.logEventProcessingTimeExceeded(eventName, this.processTimeLogRepeatGuard.counterAtLastExecution(eventName));
            }
        } else {
            this.logNoEventReceiver(eventName);
        }
    }

    private <U extends T> void _process(AcsEventSubscriber.Callback<U> receiver, T eventData, EventDescription eventDescrip) {
        Object castCorbaData = null;
        try {
            castCorbaData = receiver.getEventType().cast(eventData);
        }
        catch (ClassCastException ex) {
            this.logger.warning("Failed to deliver incompatible data '" + eventData.getClass().getName() + "' to subscriber '" + receiver.getEventType().getName() + "'. Fix data subscription handling in " + this.getClass().getName() + "!");
        }
        receiver.receive(castCorbaData, eventDescrip);
    }

    @Override
    public String getLifecycleState() {
        return this.stateMachine.getCurrentState();
    }

    public boolean hasGenericReceiver() {
        return this.genericReceiver != null;
    }

    public int getNumberOfReceivers() {
        return this.receivers.size();
    }

    @Override
    public final void addGenericSubscription(AcsEventSubscriber.GenericCallback receiver) throws AcsJEventSubscriptionEx {
        if (this.genericReceiver == null) {
            this.notifyFirstSubscription(null);
        }
        this.genericReceiver = receiver;
    }

    @Override
    public final void removeGenericSubscription() throws AcsJEventSubscriptionEx {
        if (this.genericReceiver == null) {
            AcsJEventSubscriptionEx ex = new AcsJEventSubscriptionEx();
            ex.setContext("Failed to remove generic subscription when not actually subscribed.");
            ex.setEventType("generic");
            throw ex;
        }
        this.notifySubscriptionRemoved(null);
        this.genericReceiver = null;
    }

    @Override
    public final <U extends T> void addSubscription(AcsEventSubscriber.Callback<U> receiver) throws AcsJEventSubscriptionEx {
        Class<U> subscribedEventType = receiver.getEventType();
        if (subscribedEventType == null || !this.eventType.isAssignableFrom(subscribedEventType)) {
            AcsJEventSubscriptionEx ex = new AcsJEventSubscriptionEx();
            ex.setContext("Receiver is returning a null or invalid event type. Check the getEventType() method implementation and try again.");
            ex.setEventType(subscribedEventType == null ? "null" : subscribedEventType.getName());
            throw ex;
        }
        if (!this.receivers.containsKey(subscribedEventType)) {
            this.notifyFirstSubscription(subscribedEventType);
        }
        this.receivers.put(subscribedEventType, receiver);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final <U extends T> void removeSubscription(Class<U> structClass) throws AcsJEventSubscriptionEx {
        if (structClass == null) {
            this.receivers.clear();
            this.notifyNoSubscription();
            return;
        }
        if (this.receivers.containsKey(structClass)) {
            this.receivers.remove(structClass);
            this.notifySubscriptionRemoved(structClass);
            return;
        }
        AcsJEventSubscriptionEx ex = new AcsJEventSubscriptionEx();
        ex.setContext("Trying to unsubscribe from an event type not being subscribed to.");
        ex.setEventType(structClass.getName());
        throw ex;
    }

    @Override
    public final void startReceivingEvents() throws AcsJIllegalStateEventEx, AcsJCouldntPerformActionEx {
        try {
            this.stateMachineSignalDispatcher.startReceivingEvents();
        }
        catch (AcsJStateMachineActionEx ex) {
            throw new AcsJCouldntPerformActionEx((Throwable)ex);
        }
    }

    @Override
    public final void disconnect() throws AcsJIllegalStateEventEx, AcsJCouldntPerformActionEx {
        try {
            this.stateMachineSignalDispatcher.stopReceivingEvents();
        }
        catch (AcsJIllegalStateEventEx ex) {
            try {
                this.stateMachineSignalDispatcher.cleanUpEnvironment();
            }
            catch (AcsJStateMachineActionEx ex2) {
                throw new AcsJCouldntPerformActionEx((Throwable)ex2);
            }
        }
        catch (AcsJStateMachineActionEx ex) {
            throw new AcsJCouldntPerformActionEx((Throwable)ex);
        }
        finally {
            try {
                this.stateMachineSignalDispatcher.cleanUpEnvironment();
            }
            catch (AcsJStateMachineActionEx ex) {
                throw new AcsJCouldntPerformActionEx((Throwable)ex);
            }
        }
    }

    @Override
    public final void suspend() throws AcsJIllegalStateEventEx, AcsJCouldntPerformActionEx {
        try {
            this.stateMachineSignalDispatcher.suspend();
        }
        catch (AcsJStateMachineActionEx ex) {
            throw new AcsJCouldntPerformActionEx((Throwable)ex);
        }
    }

    @Override
    public final void resume() throws AcsJIllegalStateEventEx, AcsJCouldntPerformActionEx {
        try {
            this.stateMachineSignalDispatcher.resume();
        }
        catch (AcsJStateMachineActionEx ex) {
            throw new AcsJCouldntPerformActionEx((Throwable)ex);
        }
    }

    protected abstract void notifyFirstSubscription(Class<?> var1) throws AcsJEventSubscriptionEx;

    protected abstract void notifySubscriptionRemoved(Class<?> var1) throws AcsJEventSubscriptionEx;

    protected abstract void notifyNoSubscription();

    @Override
    public boolean isSuspended() {
        return this.stateMachine.isStateActive("EnvironmentCreated::Connected::Suspended");
    }

    public final boolean isDisconnected() {
        return this.stateMachine.isStateActive("EnvironmentCreated::Disconnected") || this.stateMachine.isStateActive("EnvironmentUnknown");
    }
}

