/*
 * Decompiled with CFR 0.152.
 */
package alma.Correlator.CorrConfigModeClass;

import alma.CorrConfigModeErr.wrappers.AcsJAccessFileEx;
import alma.CorrConfigModeErr.wrappers.AcsJConstructorFailureEx;
import alma.CorrConfigModeErr.wrappers.AcsJEmptyTableEx;
import alma.CorrConfigModeErr.wrappers.AcsJFcOutOfRangeEx;
import alma.CorrConfigModeErr.wrappers.AcsJInvalidFcEx;
import alma.CorrConfigModeErr.wrappers.AcsJInvalidFormatEx;
import alma.CorrConfigModeErr.wrappers.AcsJInvalidKeyEx;
import alma.CorrConfigModeErr.wrappers.AcsJInvalidModeEx;
import alma.CorrConfigModeErr.wrappers.AcsJInvalidStokesParameterEx;
import alma.CorrConfigModeErr.wrappers.AcsJInvalidTypeEx;
import alma.CorrConfigModeErr.wrappers.AcsJModeInconsistencyEx;
import alma.CorrConfigModeErr.wrappers.AcsJReadTypeEx;
import alma.CorrelationBitMod.CorrelationBit;
import alma.Correlator.ConfigMode;
import alma.Correlator.eFilterMode;
import alma.Correlator.eFraction;
import alma.Correlator.ePolarization;
import alma.PolarizationTypeMod.PolarizationType;
import alma.StokesParameterMod.StokesParameter;
import alma.acstime.Duration;
import com.cosylab.CDB.DAL;
import com.cosylab.CDB.DAO;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class CorrConfigModeClass {
    private final float CORR_CONFIG_MODE_TFB_DDS_STEP = 0.030517578f;
    private final float CORR_CONFIG_MODE_TFB_SUBBAND_HALF_BW = 31.25f;
    private final float CORR_CONFIG_MODE_TFB_DROPOFF_FRACTION = 0.0625f;
    private final float CORR_CONFIG_MODE_Vs_CONST = 1.7539656f;
    private HashSet m_knownTypes = new HashSet();
    private String m_type;
    private Map<Integer, ConfigMode> m_table = new HashMap<Integer, ConfigMode>();
    private float[] m_knownNominalBandwidths;
    private int[] m_knownNominalChannels;

    public CorrConfigModeClass(DAL dal) throws AcsJConstructorFailureEx {
        this.setKnownHWTypes();
        try {
            this.readType(dal);
        }
        catch (AcsJReadTypeEx ex) {
            throw new AcsJConstructorFailureEx((Throwable)ex);
        }
        if (!this.m_knownTypes.contains(this.m_type)) {
            AcsJInvalidTypeEx _ex = new AcsJInvalidTypeEx(this.m_type + " not a valid correlator type");
            throw new AcsJConstructorFailureEx("cdb reports invalid correlator type", _ex.getCause());
        }
        try {
            this.generateModesTable();
        }
        catch (AcsJAccessFileEx ex) {
            throw new AcsJConstructorFailureEx((Throwable)ex);
        }
        catch (AcsJInvalidFormatEx ex) {
            throw new AcsJConstructorFailureEx((Throwable)ex);
        }
        catch (AcsJEmptyTableEx ex) {
            throw new AcsJConstructorFailureEx((Throwable)ex);
        }
    }

    public CorrConfigModeClass(String corrType) throws AcsJConstructorFailureEx {
        this.setKnownHWTypes();
        if (!this.m_knownTypes.contains(corrType)) {
            AcsJInvalidTypeEx _ex = new AcsJInvalidTypeEx(corrType + " not a valid correlator type");
            throw new AcsJConstructorFailureEx("constructor received unknow correlator type", _ex.getCause());
        }
        this.m_type = corrType;
        try {
            this.generateModesTable();
        }
        catch (AcsJAccessFileEx ex) {
            throw new AcsJConstructorFailureEx((Throwable)ex);
        }
        catch (AcsJInvalidFormatEx ex) {
            throw new AcsJConstructorFailureEx((Throwable)ex);
        }
        catch (AcsJEmptyTableEx ex) {
            throw new AcsJConstructorFailureEx((Throwable)ex);
        }
    }

    public String getType() {
        return this.m_type;
    }

    public int getSize() {
        return this.m_table.size();
    }

    public int findModeFromResolution(float bandwidthMHz, long channels, CorrelationBit bits, boolean overSampled, StokesParameter[] polarizationProducts, eFraction modeFraction) throws AcsJInvalidModeEx {
        ePolarization polz;
        float resolutionHz = (float)((double)bandwidthMHz * 1000000.0 / (double)channels);
        Iterator<Integer> keyIter = this.m_table.keySet().iterator();
        try {
            polz = CorrConfigModeClass.decodePolzSeq(polarizationProducts);
        }
        catch (AcsJInvalidStokesParameterEx ex) {
            throw new AcsJInvalidModeEx("invalid sequence", ex.getCause());
        }
        while (keyIter.hasNext()) {
            int key = keyIter.next();
            ConfigMode m = this.m_table.get(key);
            if (m.bits != bits || m.overSampled != overSampled || m.polarizationProducts != polz || resolutionHz * (float)m.channels != m.bandWidth * 1000000.0f) continue;
            return key;
        }
        throw new AcsJInvalidModeEx("from resolution parameters do not map to any valid mode (" + bandwidthMHz + "/" + channels + "/" + bits + "/" + overSampled + "/" + polarizationProducts.length + "/" + modeFraction + ")");
    }

    public int findModeFromNominal(float nominalBandwidthMHz, long nominalChannels, CorrelationBit bits, boolean overSampled, StokesParameter[] polarizationProducts) throws AcsJInvalidModeEx {
        ePolarization polz;
        Iterator<Integer> keyIter = this.m_table.keySet().iterator();
        try {
            polz = CorrConfigModeClass.decodePolzSeq(polarizationProducts);
        }
        catch (AcsJInvalidStokesParameterEx ex) {
            throw new AcsJInvalidModeEx("invalid sequence", ex.getCause());
        }
        while (keyIter.hasNext()) {
            int key = keyIter.next();
            ConfigMode m = this.m_table.get(key);
            if (m.bandWidth != nominalBandwidthMHz || (long)m.channels != nominalChannels || m.bits != bits || m.overSampled != overSampled || m.polarizationProducts != polz) continue;
            return key;
        }
        throw new AcsJInvalidModeEx("from nominal parameters do not map to any valid mode (" + nominalBandwidthMHz + "/" + nominalChannels + "/" + bits + "/" + overSampled + "/" + polarizationProducts.length + ")");
    }

    public int findModeFromEffective(float effectiveBandwidthMHz, long effectiveChannels, CorrelationBit bits, boolean overSampled, StokesParameter[] polarizationProducts) throws AcsJInvalidModeEx {
        int i;
        ePolarization polz;
        int n = -1;
        int o = -1;
        int w = -1;
        try {
            polz = CorrConfigModeClass.decodePolzSeq(polarizationProducts);
        }
        catch (AcsJInvalidStokesParameterEx ex) {
            throw new AcsJInvalidModeEx("invalid sequence", ex.getCause());
        }
        if (effectiveChannels == 256L && bits == CorrelationBit.BITS_2x2 && !overSampled && (polz == ePolarization.POLZ_SINGLE_X || polz == ePolarization.POLZ_SINGLE_Y) || effectiveChannels == 64L || effectiveChannels == 128L) {
            if (effectiveChannels != 256L && effectiveChannels != 128L && effectiveChannels != 64L) {
                throw new AcsJInvalidModeEx("invalid TDM mode number of channels");
            }
            return this.findModeFromNominal(effectiveBandwidthMHz, effectiveChannels, bits, overSampled, polarizationProducts);
        }
        for (i = 8; i <= 13; ++i) {
            if (effectiveChannels > (long)(1 << i)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new AcsJInvalidModeEx("invalid effective number of channels");
        }
        if ((long)(1 << n) == effectiveChannels) {
            return this.findModeFromNominal(effectiveBandwidthMHz, effectiveChannels, bits, overSampled, polarizationProducts);
        }
        for (i = 3; i <= 6; ++i) {
            if ((long)(1 << n) - effectiveChannels != (long)(1 << n - i)) continue;
            o = i;
        }
        if (o == -1 || 1 << o != 16) {
            throw new AcsJInvalidModeEx("effective channels do not mach the drop-offfraction");
        }
        for (i = 0; i < this.m_knownNominalBandwidths.length; ++i) {
            if ((double)effectiveBandwidthMHz != (double)this.m_knownNominalBandwidths[i] * 0.9375) continue;
            w = i;
        }
        if (w == -1) {
            throw new AcsJInvalidModeEx("effective bandwidth does not mach the drop-off fraction");
        }
        return this.findModeFromNominal(31.25f * (float)(1 << w), effectiveChannels + (long)(1 << n - o), bits, overSampled, polarizationProducts);
    }

    public ConfigMode getMode(int key) throws AcsJInvalidKeyEx {
        ConfigMode m = this.m_table.get(key);
        if (m == null) {
            throw new AcsJInvalidKeyEx("invalid key " + key);
        }
        return m;
    }

    public int[] getKeys() {
        int[] keys = new int[this.m_table.size()];
        TreeMap<Integer, ConfigMode> sortedTable = new TreeMap<Integer, ConfigMode>(this.m_table);
        Iterator it = sortedTable.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            keys[i++] = (Integer)it.next().getKey();
        }
        return keys;
    }

    public String asString() {
        String s = "# " + this.m_type + "\n";
        s = s + "# size " + this.m_table.size() + "\n";
        s = s + "# mode\tbw\tchan\tbits\t2nyq.\tpolz\tfilterMode\n";
        TreeMap<Integer, ConfigMode> sortedTable = new TreeMap<Integer, ConfigMode>(this.m_table);
        for (Map.Entry entry : sortedTable.entrySet()) {
            ConfigMode m = (ConfigMode)entry.getValue();
            s = s + "  " + entry.getKey() + "\t";
            s = s + m.bandWidth + "\t";
            s = s + m.channels + "\t";
            s = s + m.bits.toString() + "\t";
            s = m.overSampled ? s + "true\t" : s + "false\t";
            s = s + CorrConfigModeClass.enumAsString(m.polarizationProducts) + "\t";
            s = s + CorrConfigModeClass.enumAsString(m.filterMode) + "\n";
        }
        return s;
    }

    public eFraction getFraction(int key) throws AcsJInvalidKeyEx, AcsJModeInconsistencyEx {
        int fullModeChannels;
        ConfigMode m = this.getMode(key);
        if (m.filterMode == eFilterMode.FILTER_TDM || m.bits != CorrelationBit.BITS_2x2) {
            return eFraction.FRACTION_FULL;
        }
        switch (m.polarizationProducts.value()) {
            case 0: 
            case 1: {
                fullModeChannels = 8192;
                break;
            }
            case 2: {
                fullModeChannels = 4096;
                break;
            }
            case 3: {
                fullModeChannels = 2048;
                break;
            }
            default: {
                throw new AcsJModeInconsistencyEx("unexpected polarization products");
            }
        }
        if (m.channels == fullModeChannels) {
            return eFraction.FRACTION_FULL;
        }
        if (m.channels << 1 == fullModeChannels) {
            return eFraction.FRACTION_ONE_HALF;
        }
        if (m.channels << 2 == fullModeChannels) {
            return eFraction.FRACTION_ONE_FOURTH;
        }
        if (m.channels << 3 == fullModeChannels) {
            return eFraction.FRACTION_ONE_EIGHTH;
        }
        throw new AcsJModeInconsistencyEx("unexpected number of channels for a multi-resolution mode");
    }

    public int getNumberSubBands(int key) throws AcsJInvalidKeyEx, AcsJModeInconsistencyEx {
        ConfigMode m = this.getMode(key);
        if (m.filterMode != eFilterMode.FILTER_FDM) {
            throw new AcsJModeInconsistencyEx("this mode does not involve any TFB sub-band");
        }
        if ((double)m.bandWidth == 2000.0) {
            return 32;
        }
        if ((double)m.bandWidth == 1000.0) {
            return 16;
        }
        if ((double)m.bandWidth == 500.0) {
            return 8;
        }
        if ((double)m.bandWidth == 250.0) {
            return 4;
        }
        if ((double)m.bandWidth == 125.0) {
            return 2;
        }
        if ((double)m.bandWidth == 62.5 || (double)m.bandWidth == 31.25) {
            return 1;
        }
        throw new AcsJModeInconsistencyEx("unexpected band-width " + m.bandWidth);
    }

    public int getNumberPolzProducts(int key) throws AcsJInvalidKeyEx {
        ConfigMode m = this.getMode(key);
        if (m.polarizationProducts == ePolarization.POLZ_SINGLE_X || m.polarizationProducts == ePolarization.POLZ_SINGLE_Y) {
            return 1;
        }
        if (m.polarizationProducts == ePolarization.POLZ_DOUBLE) {
            return 2;
        }
        return 4;
    }

    public PolarizationType[][] getPolzProductTypes(int key) throws AcsJInvalidKeyEx {
        PolarizationType[] pair = new PolarizationType[2];
        PolarizationType[][] ret = null;
        ConfigMode m = this.getMode(key);
        switch (m.polarizationProducts.value()) {
            case 0: {
                ret = new PolarizationType[1][2];
                pair[0] = pair[1] = PolarizationType.X;
                System.arraycopy(pair, 0, ret[0], 0, 2);
                break;
            }
            case 1: {
                ret = new PolarizationType[1][2];
                pair[0] = pair[1] = PolarizationType.Y;
                System.arraycopy(pair, 0, ret[0], 0, 2);
                break;
            }
            case 2: {
                ret = new PolarizationType[2][2];
                pair[0] = pair[1] = PolarizationType.X;
                System.arraycopy(pair, 0, ret[0], 0, 2);
                pair[0] = pair[1] = PolarizationType.Y;
                System.arraycopy(pair, 0, ret[1], 0, 2);
                break;
            }
            case 3: {
                ret = new PolarizationType[4][2];
                pair[0] = pair[1] = PolarizationType.X;
                System.arraycopy(pair, 0, ret[0], 0, 2);
                pair[0] = PolarizationType.X;
                pair[1] = PolarizationType.Y;
                System.arraycopy(pair, 0, ret[1], 0, 2);
                pair[0] = PolarizationType.Y;
                pair[1] = PolarizationType.X;
                System.arraycopy(pair, 0, ret[2], 0, 2);
                pair[0] = pair[1] = PolarizationType.Y;
                System.arraycopy(pair, 0, ret[3], 0, 2);
            }
        }
        return ret;
    }

    public float getVs(int key, Duration dumpDuration) throws AcsJInvalidKeyEx {
        ConfigMode m = this.getMode(key);
        float vs = 1.7539656f * (float)dumpDuration.value;
        if (dumpDuration.value >= 160000L) {
            vs /= 16.0f;
        }
        int factor = m.filterMode == eFilterMode.FILTER_TDM ? (m.bits == CorrelationBit.BITS_3x3 ? 800 : 32) : (m.bits == CorrelationBit.BITS_2x2 ? (m.overSampled ? ((double)m.bandWidth == 31.25 ? 1 : 2) : 1) : (m.overSampled ? ((double)m.bandWidth == 31.25 ? 25 : 50) : 25));
        return vs * (float)factor;
    }

    public float[] getSubBandsFc(int key, float fc) throws AcsJInvalidKeyEx, AcsJInvalidFcEx, AcsJFcOutOfRangeEx, AcsJModeInconsistencyEx {
        float hebw;
        int Ns;
        if (Math.IEEEremainder(fc, 0.030517578125) != 0.0) {
            throw new AcsJInvalidFcEx("invalid fc value " + fc);
        }
        ConfigMode m = this.getMode(key);
        if (m.filterMode != eFilterMode.FILTER_FDM) {
            throw new AcsJModeInconsistencyEx("not an FDM mode for frequency center computation");
        }
        try {
            Ns = this.getNumberSubBands(key);
        }
        catch (AcsJInvalidKeyEx ex) {
            throw ex;
        }
        catch (AcsJModeInconsistencyEx ex) {
            throw ex;
        }
        try {
            hebw = this.getEffectiveBandWidth(key) / 2.0f;
        }
        catch (AcsJInvalidKeyEx ex) {
            throw ex;
        }
        catch (AcsJModeInconsistencyEx ex) {
            throw ex;
        }
        if ((double)(fc - hebw) < 0.0 || (double)(fc + hebw) > 2000.0) {
            throw new AcsJModeInconsistencyEx("frequency center incompatible for effective bandwidth " + key + "/" + fc + "/" + 2.0f * hebw);
        }
        float[] freqs = new float[Ns];
        for (int i = 0; i < Ns; ++i) {
            freqs[i] = fc + 29.296875f * (float)(2 * i + 1 - Ns);
        }
        return freqs;
    }

    public float getEffectiveBandWidth(int key) throws AcsJInvalidKeyEx, AcsJModeInconsistencyEx {
        ConfigMode m = this.getMode(key);
        if (m.filterMode != eFilterMode.FILTER_FDM) {
            return m.bandWidth;
        }
        return m.bandWidth * 0.9375f;
    }

    public int getEffectiveChannels(int key) throws AcsJInvalidKeyEx, AcsJModeInconsistencyEx {
        ConfigMode m = this.getMode(key);
        if (m.filterMode != eFilterMode.FILTER_FDM) {
            return m.channels;
        }
        if ((float)m.channels * 0.0625f - (float)((long)((float)m.channels * 0.0625f)) != 0.0f) {
            throw new AcsJModeInconsistencyEx("nominal channels and overlapping fraction do not match");
        }
        return (int)((double)m.channels * 0.9375);
    }

    public int getNominalChannelsPerSubband(int key) throws AcsJInvalidKeyEx, AcsJModeInconsistencyEx {
        ConfigMode m = this.getMode(key);
        if (m.filterMode != eFilterMode.FILTER_FDM) {
            throw new AcsJModeInconsistencyEx("nominal channels per sub-band valid for FDM modes only");
        }
        int ret = m.channels / this.getNumberSubBands(key);
        if (m.channels != ret * this.getNumberSubBands(key)) {
            throw new AcsJModeInconsistencyEx("channels rounding error (channels/subbands=" + m.channels + "/" + this.getNumberSubBands(key) + ")");
        }
        return ret;
    }

    public int getEffectiveChannelsPerSubband(int key) throws AcsJInvalidKeyEx, AcsJModeInconsistencyEx {
        int nominalChannels = this.getNominalChannelsPerSubband(key);
        return nominalChannels - (int)(0.0625f * (float)nominalChannels);
    }

    public int getSubbandsInRegionBandwidth(int key, float regionBandwidthMHz, boolean isEffectiveBandwidth) throws AcsJInvalidKeyEx, AcsJModeInconsistencyEx {
        int totalSubbands = this.getNumberSubBands(key);
        ConfigMode m = this.getMode(key);
        if (m.filterMode != eFilterMode.FILTER_FDM) {
            throw new AcsJModeInconsistencyEx("regions valid for FDM modes only");
        }
        float tbw = isEffectiveBandwidth ? this.getEffectiveBandWidth(key) : m.bandWidth;
        if (regionBandwidthMHz > tbw) {
            throw new AcsJModeInconsistencyEx("region bandwidth too wide (key/mode/region=" + key + "/" + tbw + "/" + regionBandwidthMHz + ")");
        }
        int subBandsCount = (int)((float)totalSubbands * regionBandwidthMHz / tbw);
        if ((float)subBandsCount * tbw != (float)totalSubbands * regionBandwidthMHz) {
            throw new AcsJModeInconsistencyEx("bandwidth rounding error (key/mode/region=" + key + "/" + tbw + "/" + regionBandwidthMHz + ")");
        }
        return subBandsCount;
    }

    private void setKnownHWTypes() {
        int i;
        this.m_knownTypes.add("CORRELATOR_12m_2ANTS");
        this.m_knownTypes.add("CORRELATOR_12m_1QUADRANT");
        this.m_knownTypes.add("CORRELATOR_12m_2QUADRANT");
        this.m_knownTypes.add("CORRELATOR_12m_4QUADRANT");
        this.m_knownNominalBandwidths = new float[7];
        for (i = 0; i < this.m_knownNominalBandwidths.length; ++i) {
            this.m_knownNominalBandwidths[i] = (float)(1 << i) * 31.25f;
        }
        this.m_knownNominalChannels = new int[8];
        for (i = 0; i < this.m_knownNominalChannels.length; ++i) {
            this.m_knownNominalChannels[i] = (1 << i) * 64;
        }
    }

    private void readType(DAL dal) throws AcsJReadTypeEx {
        try {
            DAO dao = dal.get_DAO_Servant("alma/CORR_MASTER_COMP");
            this.m_type = dao.get_string("corrType");
        }
        catch (Throwable thr) {
            throw new AcsJReadTypeEx("access to cdb atribute thrown unknown exception");
        }
    }

    private static String enumAsString(ePolarization polz) {
        if (polz == ePolarization.POLZ_SINGLE_X) {
            return new String("X-X");
        }
        if (polz == ePolarization.POLZ_SINGLE_Y) {
            return new String("Y-Y");
        }
        if (polz == ePolarization.POLZ_DOUBLE) {
            return new String("DOUBLE");
        }
        return new String("FULL");
    }

    private static String enumAsString(eFilterMode filter) {
        if (filter == eFilterMode.FILTER_FDM) {
            return new String("FDM");
        }
        return new String("TDM");
    }

    private static String enumAsString(eFraction fraction) {
        if (fraction == eFraction.FRACTION_FULL) {
            return new String("FULL");
        }
        if (fraction == eFraction.FRACTION_ONE_HALF) {
            return new String("ONE_HALF");
        }
        if (fraction == eFraction.FRACTION_ONE_FOURTH) {
            return new String("ONE_FOURTH");
        }
        return new String("ONE_EIGHTH");
    }

    private static ePolarization decodePolzSeq(StokesParameter[] polz) throws AcsJInvalidStokesParameterEx {
        if (polz.length != 1 && polz.length != 2 && polz.length != 4) {
            throw new AcsJInvalidStokesParameterEx("invalid length");
        }
        for (int i = 0; i < polz.length; ++i) {
            if (polz[i] != StokesParameter.XX && polz[i] != StokesParameter.YY && polz[i] != StokesParameter.XY && polz[i] != StokesParameter.YX) {
                throw new AcsJInvalidStokesParameterEx("at least one Stokes param is not in the valid set");
            }
            for (int j = i + 1; j < polz.length; ++j) {
                if (polz[i] != polz[j]) continue;
                throw new AcsJInvalidStokesParameterEx("at least two Stokes param repeat in the sequence");
            }
        }
        if (polz.length == 1) {
            if (polz[0] == StokesParameter.XX) {
                return ePolarization.POLZ_SINGLE_X;
            }
            return ePolarization.POLZ_SINGLE_Y;
        }
        if (polz.length == 2) {
            return ePolarization.POLZ_DOUBLE;
        }
        return ePolarization.POLZ_FULL;
    }

    private File getFile(String name) {
        File file;
        try {
            file = new File(name);
        }
        catch (Throwable th) {
            return null;
        }
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private void generateModesTable() throws AcsJAccessFileEx, AcsJInvalidFormatEx, AcsJEmptyTableEx {
        this.m_table.clear();
        InputStream is = this.getClass().getResourceAsStream("corrConfigModes.txt");
        if (is == null) {
            throw new AcsJAccessFileEx("cannot find modes file in jar");
        }
        String stringRead = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is));
        }
        catch (Throwable thr) {
            throw new AcsJAccessFileEx("access to modes file thrown exception");
        }
        try {
            stringRead = br.readLine();
        }
        catch (IOException ioex) {
            throw new AcsJAccessFileEx("IO exception when reading line");
        }
        int modeKey = -1;
        while (stringRead != null) {
            ConfigMode mode;
            block40: {
                if (stringRead.startsWith("#")) {
                    try {
                        stringRead = br.readLine();
                        continue;
                    }
                    catch (IOException ioex) {
                        throw new AcsJAccessFileEx("IO exception when reading line");
                    }
                }
                mode = new ConfigMode();
                try {
                    String str;
                    String[] modeStr = stringRead.split("[ \\t]+");
                    if (modeStr.length != 8) {
                        throw new AcsJInvalidFormatEx("invalid number of fields " + modeStr.length);
                    }
                    int i = 1;
                    int tmp = Integer.parseInt(modeStr[i++]);
                    if (modeKey != -1 && tmp <= modeKey) {
                        throw new AcsJInvalidFormatEx("invalid key field " + tmp);
                    }
                    modeKey = tmp;
                    mode.bandWidth = Float.parseFloat(modeStr[i++]);
                    mode.channels = Integer.parseInt(modeStr[i++]);
                    if ((str = modeStr[i++]).equals("2x2")) {
                        mode.bits = CorrelationBit.from_int((int)0);
                    } else if (str.equals("3x3")) {
                        mode.bits = CorrelationBit.from_int((int)1);
                    } else if (str.equals("4x4")) {
                        mode.bits = CorrelationBit.from_int((int)2);
                    } else {
                        throw new AcsJInvalidFormatEx("invalid bits field " + str);
                    }
                    str = modeStr[i++];
                    if (str.equals("true")) {
                        mode.overSampled = true;
                    } else if (str.equals("false")) {
                        mode.overSampled = false;
                    } else {
                        throw new AcsJInvalidFormatEx("invalid over-sampled field " + str);
                    }
                    str = modeStr[i++];
                    if (str.equals("X-X")) {
                        mode.polarizationProducts = ePolarization.POLZ_SINGLE_X;
                    } else if (str.equals("Y-Y")) {
                        mode.polarizationProducts = ePolarization.POLZ_SINGLE_Y;
                    } else if (str.equals("DOUBLE")) {
                        mode.polarizationProducts = ePolarization.POLZ_DOUBLE;
                    } else if (str.equals("FULL")) {
                        mode.polarizationProducts = ePolarization.POLZ_FULL;
                    } else {
                        throw new AcsJInvalidFormatEx("invalid polarizations field " + str);
                    }
                    str = modeStr[i++];
                    if (str.equals("TDM")) {
                        mode.filterMode = eFilterMode.FILTER_TDM;
                        break block40;
                    }
                    if (str.equals("FDM")) {
                        mode.filterMode = eFilterMode.FILTER_FDM;
                        break block40;
                    }
                    throw new AcsJInvalidFormatEx("invalid filter mode field " + str);
                }
                catch (NumberFormatException nfe) {
                    throw new AcsJInvalidFormatEx("some numeric field contains a non numeric value");
                }
                catch (AcsJInvalidFormatEx ex) {
                    throw ex;
                }
            }
            if (this.m_table.put(modeKey, mode) != null) {
                throw new AcsJInvalidFormatEx("table record duplication");
            }
            try {
                stringRead = br.readLine();
            }
            catch (IOException ioex) {
                throw new AcsJAccessFileEx("IO exception when reading line");
            }
        }
        try {
            br.close();
        }
        catch (IOException ioex) {
            throw new AcsJAccessFileEx("IO exception when closing file");
        }
        if (this.m_table.size() == 0) {
            throw new AcsJEmptyTableEx("parsed an empty table");
        }
    }
}

