/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.arch.io;

import ca.nrc.cadc.arch.io.NoisyStream;
import ca.nrc.cadc.arch.io.NoisyStreamListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class NoisyBufferedOutputStream
extends BufferedOutputStream
implements NoisyStream {
    private int bytes = 0;
    private int blocks = 0;
    private int reportSize = 4096;
    private ArrayList listeners = new ArrayList();

    public NoisyBufferedOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public NoisyBufferedOutputStream(OutputStream outputStream, int n) {
        super(outputStream, n);
    }

    public int getNumBytes() {
        return this.reportSize * this.blocks + this.bytes;
    }

    public void setReportSize(int n) {
        this.bytes = this.getNumBytes();
        this.blocks = 0;
        this.reportSize = n;
        this.doit();
    }

    public void addListener(NoisyStreamListener noisyStreamListener) {
        this.listeners.add(noisyStreamListener);
        noisyStreamListener.update(this);
    }

    public void removeListener(NoisyStreamListener noisyStreamListener) {
        ((AbstractCollection)this.listeners).remove(noisyStreamListener);
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    protected void notifyListeners() {
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            NoisyStreamListener noisyStreamListener = (NoisyStreamListener)iterator.next();
            noisyStreamListener.update(this);
        }
    }

    public void write(int n) throws IOException {
        super.write(n);
        ++this.bytes;
        this.doit();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.bytes += Math.min(n2, byArray.length - n);
        this.doit();
    }

    public void close() throws IOException {
        this.notifyListeners();
        super.close();
    }

    private void doit() {
        boolean bl = false;
        while (this.bytes >= this.reportSize) {
            int n = this.bytes / this.reportSize;
            this.blocks += n;
            this.bytes -= n * this.reportSize;
            bl = true;
        }
        if (bl) {
            this.notifyListeners();
        }
    }
}

