/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.arch.io;

import ca.nrc.cadc.arch.io.BulkDataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BulkDataInputStream
extends DataInputStream
implements BulkDataInput {
    protected boolean eos = false;

    public BulkDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int readChar(char[] cArray) throws IOException, EOFException {
        return this.readChar(cArray, 0, cArray.length);
    }

    public int readChar(char[] cArray, int n, int n2) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int n3 = 0;
        while (!this.eos && n3 < n2) {
            try {
                cArray[n3 + n] = this.readChar();
                ++n3;
            }
            catch (EOFException eOFException) {
                this.eos = true;
            }
        }
        return n3;
    }

    public int readByte(byte[] byArray) throws IOException, EOFException {
        return this.readByte(byArray, 0, byArray.length);
    }

    public int readByte(byte[] byArray, int n, int n2) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int n3 = 0;
        while (!this.eos && n3 < n2) {
            try {
                byArray[n3 + n] = this.readByte();
                ++n3;
            }
            catch (EOFException eOFException) {
                this.eos = true;
            }
        }
        return n3;
    }

    public int readUnsignedByte(short[] sArray) throws IOException, EOFException {
        return this.readUnsignedByte(sArray, 0, sArray.length);
    }

    public int readUnsignedByte(short[] sArray, int n, int n2) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int n3 = 0;
        while (!this.eos && n3 < n2) {
            try {
                sArray[n3 + n] = (short)this.readUnsignedByte();
                ++n3;
            }
            catch (EOFException eOFException) {
                this.eos = true;
            }
        }
        return n3;
    }

    public int readShort(short[] sArray) throws IOException, EOFException {
        return this.readShort(sArray, 0, sArray.length);
    }

    public int readShort(short[] sArray, int n, int n2) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int n3 = 0;
        while (n3 < n2 && !this.eos) {
            try {
                sArray[n3 + n] = this.readShort();
                ++n3;
            }
            catch (EOFException eOFException) {
                this.eos = true;
            }
        }
        return n3;
    }

    public int readUnsignedShort(int[] nArray) throws IOException, EOFException {
        return this.readUnsignedShort(nArray, 0, nArray.length);
    }

    public int readUnsignedShort(int[] nArray, int n, int n2) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int n3 = 0;
        while (!this.eos && n3 < n2) {
            try {
                nArray[n3 + n] = this.readUnsignedShort();
                ++n3;
            }
            catch (EOFException eOFException) {
                this.eos = true;
            }
        }
        return n3;
    }

    public int readInt(int[] nArray) throws IOException, EOFException {
        return this.readInt(nArray, 0, nArray.length);
    }

    public int readInt(int[] nArray, int n, int n2) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int n3 = 0;
        while (!this.eos && n3 < n2) {
            try {
                nArray[n3 + n] = this.readInt();
                ++n3;
            }
            catch (EOFException eOFException) {
                this.eos = true;
            }
        }
        return n3;
    }

    public int readLong(long[] lArray) throws IOException, EOFException {
        return this.readLong(lArray, 0, lArray.length);
    }

    public int readLong(long[] lArray, int n, int n2) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int n3 = 0;
        while (!this.eos && n3 < n2) {
            try {
                lArray[n3 + n] = this.readLong();
                ++n3;
            }
            catch (EOFException eOFException) {
                this.eos = true;
            }
        }
        return n3;
    }

    public int readFloat(float[] fArray) throws IOException, EOFException {
        return this.readFloat(fArray, 0, fArray.length);
    }

    public int readFloat(float[] fArray, int n, int n2) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int n3 = 0;
        while (!this.eos && n3 < n2) {
            try {
                fArray[n3 + n] = this.readFloat();
                ++n3;
            }
            catch (EOFException eOFException) {
                this.eos = true;
            }
        }
        return n3;
    }

    public int readDouble(double[] dArray) throws IOException, EOFException {
        return this.readDouble(dArray, 0, dArray.length);
    }

    public int readDouble(double[] dArray, int n, int n2) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int n3 = 0;
        while (!this.eos && n3 < n2) {
            try {
                dArray[n3 + n] = this.readDouble();
                ++n3;
            }
            catch (EOFException eOFException) {
                this.eos = true;
            }
        }
        return n3;
    }
}

