/*
 * Decompiled with CFR 0.152.
 */
package alma.Control;

import alma.Control.LO2Parameters;
import alma.Control.SkyFreqSidebandHelper;
import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public abstract class LO2ParametersHelper {
    private static volatile TypeCode _type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeCode type() {
        if (_type != null) return _type;
        Class<LO2ParametersHelper> clazz = LO2ParametersHelper.class;
        synchronized (LO2ParametersHelper.class) {
            if (_type != null) return _type;
            _type = ORB.init().create_struct_tc(LO2ParametersHelper.id(), "LO2Parameters", new StructMember[]{new StructMember("DYTOFrequency", LO2ParametersHelper.DYTOFrequencyFactory(), null), new StructMember("FTSFrequency", LO2ParametersHelper.FTSFrequencyFactory(), null), new StructMember("tuneHigh", LO2ParametersHelper.tuneHighFactory(), null), new StructMember("skyFreqSideband", LO2ParametersHelper.skyFreqSidebandFactory(), null), new StructMember("use12GHzFilter", LO2ParametersHelper.use12GHzFilterFactory(), null), new StructMember("isUsed", LO2ParametersHelper.isUsedFactory(), null)});
            // ** MonitorExit[var0] (shouldn't be in output)
            return _type;
        }
    }

    private static TypeCode tuneHighFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    private static TypeCode FTSFrequencyFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)7));
    }

    private static TypeCode DYTOFrequencyFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)7));
    }

    private static TypeCode skyFreqSidebandFactory() {
        return ORB.init().create_enum_tc(SkyFreqSidebandHelper.id(), "SkyFreqSideband", new String[]{"USB", "LSB", "DSB"});
    }

    private static TypeCode use12GHzFilterFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    private static TypeCode isUsedFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    public static void insert(Any any, LO2Parameters s) {
        any.type(LO2ParametersHelper.type());
        LO2ParametersHelper.write(any.create_output_stream(), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LO2Parameters extract(Any any) {
        InputStream in = any.create_input_stream();
        try {
            LO2Parameters lO2Parameters = LO2ParametersHelper.read(in);
            return lO2Parameters;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception " + e.toString());
            }
        }
    }

    public static String id() {
        return "IDL:alma/Control/LO2Parameters:1.0";
    }

    public static LO2Parameters read(InputStream in) {
        LO2Parameters result = new LO2Parameters();
        result.DYTOFrequency = in.read_double();
        result.FTSFrequency = in.read_double();
        result.tuneHigh = in.read_boolean();
        result.skyFreqSideband = SkyFreqSidebandHelper.read(in);
        result.use12GHzFilter = in.read_boolean();
        result.isUsed = in.read_boolean();
        return result;
    }

    public static void write(OutputStream out, LO2Parameters s) {
        out.write_double(s.DYTOFrequency);
        out.write_double(s.FTSFrequency);
        out.write_boolean(s.tuneHigh);
        SkyFreqSidebandHelper.write(out, s.skyFreqSideband);
        out.write_boolean(s.use12GHzFilter);
        out.write_boolean(s.isUsed);
    }
}

