/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class SVGUtilities {
    private static final HashMap colors = new HashMap();

    public static Iterator colorNames() {
        return colors.keySet().iterator();
    }

    public static Color getColor(String name) {
        Color color = null;
        char first = (name = name.toLowerCase()).charAt(0);
        if (first == '#' || first == '0') {
            color = Color.decode(name);
        } else {
            color = (Color)colors.get(name);
            if (color == null) {
                color = Color.getColor(name);
            }
        }
        if (color == null) {
            color = Color.black;
        }
        return color;
    }

    public static Map parseStyleString(String style) {
        HashMap<String, String> map = new HashMap<String, String>();
        int sep = style.indexOf(59);
        while (sep > 0) {
            int delim = style.indexOf(sep, 58);
            if (delim > 0) {
                String name = style.substring(0, sep).trim();
                String value = style.substring(sep + 1, delim).trim();
                map.put(name, value);
            }
            style = style.substring(delim + 1);
            sep = style.indexOf(59);
        }
        return map;
    }

    public static double[] parseCoordString(String s) {
        double[] result = new double[4];
        int i = 0;
        StringTokenizer t = new StringTokenizer(s, " ,");
        while (t.hasMoreTokens()) {
            String string = t.nextToken();
            if (string.equals("")) continue;
            result[i++] = Double.parseDouble(string);
            if (i != result.length) continue;
            double[] temp = new double[2 * result.length];
            System.arraycopy(result, 0, temp, 0, result.length);
            result = temp;
        }
        double[] temp = new double[i];
        System.arraycopy(result, 0, temp, 0, i);
        result = temp;
        return result;
    }

    static {
        colors.put("black", Color.black);
        colors.put("blue", Color.blue);
        colors.put("cyan", Color.cyan);
        colors.put("darkgray", Color.darkGray);
        colors.put("darkgrey", Color.darkGray);
        colors.put("gray", Color.gray);
        colors.put("grey", Color.gray);
        colors.put("green", Color.green);
        colors.put("lightgray", Color.lightGray);
        colors.put("lightgrey", Color.lightGray);
        colors.put("magenta", Color.magenta);
        colors.put("orange", Color.orange);
        colors.put("pink", Color.pink);
        colors.put("red", Color.red);
        colors.put("white", Color.white);
        colors.put("yellow", Color.yellow);
    }
}

