/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.interactor;

import diva.canvas.AbstractSite;
import diva.canvas.Figure;
import diva.canvas.Site;
import diva.canvas.interactor.Geometry;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CircleGeometry
implements Geometry {
    private Figure _parentFigure;
    private double _minSize = 1.0;
    private Rectangle2D _rect;
    private static int _siteCount = 1;
    private CircleSite[] _sites = new CircleSite[_siteCount];

    public CircleGeometry(Figure figure, Rectangle2D bounds) {
        this._parentFigure = figure;
        this.setShape(bounds);
    }

    public Site getSite(int id) {
        if (this._sites[id] == null) {
            this._sites[id] = new CircleSite(id);
        }
        return this._sites[id];
    }

    public double getMinimumSize() {
        return this._minSize;
    }

    public Site getN() {
        return this.getSite(1);
    }

    public Figure getFigure() {
        return this._parentFigure;
    }

    public Shape getShape() {
        return this._rect;
    }

    public Rectangle2D getBounds() {
        return this._rect;
    }

    public void setMinimumSize(double minimumSize) {
        this._minSize = minimumSize;
    }

    public void setShape(Shape shape) {
        if (!(shape instanceof Rectangle2D)) {
            throw new IllegalArgumentException("Argument must be a Rectangle2D");
        }
        this._rect = (Rectangle2D)((Rectangle2D)shape).clone();
    }

    public void setBounds(Rectangle2D rect) {
        this._rect = (Rectangle2D)rect.clone();
    }

    public Iterator sites() {
        return new Iterator(){
            int cursor = 0;

            public boolean hasNext() {
                return this.cursor < _siteCount;
            }

            public Object next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Can't get " + this.cursor + "'th element from CircleGeometry of size " + _siteCount);
                }
                if (CircleGeometry.this._sites[this.cursor] == null) {
                    ((CircleGeometry)CircleGeometry.this)._sites[this.cursor] = new CircleSite(this.cursor);
                }
                return CircleGeometry.this._sites[this.cursor++];
            }

            public void remove() {
                throw new UnsupportedOperationException("Site cannot be removed");
            }
        };
    }

    public void translate(double x, double y) {
        this._rect.setFrame(this._rect.getX() + x, this._rect.getY() + y, this._rect.getWidth(), this._rect.getHeight());
    }

    public class CircleSite
    extends AbstractSite {
        private int _id;
        private double _normal;
        private double _offX;
        private double _offY;

        CircleSite(int id) {
            this._id = id;
            this._normal = 1.5707963267948966;
            this._offX = 0.0;
            this._offY = -CircleGeometry.this._rect.getHeight() / 2.0;
        }

        public int getID() {
            return this._id;
        }

        public Figure getFigure() {
            return CircleGeometry.this._parentFigure;
        }

        public double getNormal() {
            return this._normal;
        }

        public Point2D getPoint() {
            return new Point2D.Double(this.getX(), this.getY());
        }

        public double getX() {
            return CircleGeometry.this._rect.getCenterX() + this._offX;
        }

        public double getY() {
            return CircleGeometry.this._rect.getCenterY() + this._offY;
        }

        public boolean hasNormal() {
            return true;
        }

        private final double getAngle(int direction) {
            double piOver4 = 0.7853981633974483;
            switch (direction) {
                case 3: {
                    return 0.0;
                }
                case 2: {
                    return piOver4 * 7.0;
                }
                case 1: {
                    return piOver4 * 6.0;
                }
                case 8: {
                    return piOver4 * 5.0;
                }
                case 7: {
                    return piOver4 * 4.0;
                }
                case 6: {
                    return piOver4 * 3.0;
                }
                case 5: {
                    return piOver4 * 2.0;
                }
                case 4: {
                    return piOver4 * 1.0;
                }
            }
            throw new IllegalArgumentException("Illegal direction: " + direction);
        }

        public boolean isNormal(int direction) {
            double theta1 = this.getAngle(direction);
            double theta2 = this._normal < 0.0 ? this._normal + Math.PI * 2 : this._normal;
            return Math.abs(theta1 - theta2) < 1.0E-6;
        }

        public void translate(double dx, double dy) {
            if (Math.abs(this._offX + dx) > CircleGeometry.this._minSize) {
                this._offX += dx;
            }
            if (Math.abs(this._offY + dy) > CircleGeometry.this._minSize) {
                this._offY += dy;
            }
            double cx = CircleGeometry.this._rect.getCenterX();
            double cy = CircleGeometry.this._rect.getCenterY();
            double r = Math.sqrt(this._offX * this._offX + this._offY * this._offY);
            double theta = Math.atan(this._offY / this._offX);
            if (this._offX < 0.0) {
                theta += Math.PI;
            }
            this._normal = theta;
            CircleGeometry.this._rect.setFrameFromDiagonal(cx - r, cy - r, cx + r, cy + r);
        }

        public void setPoint(Point2D point) {
            this.translate(point.getX() - this.getX(), point.getY() - this.getY());
        }
    }
}

