/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

public final class JCommentFormatter {
    private String _comment = null;
    private int _maxLength = 65;
    private int _offset = 0;
    private int _length = 0;
    private String _prefix = null;
    private StringBuffer _sb = null;

    public JCommentFormatter(String comment, int maxLength, String prefix) {
        this._comment = comment;
        if (comment != null) {
            this._length = comment.length();
        }
        this._sb = new StringBuffer();
        this._maxLength = maxLength;
        this._prefix = prefix;
    }

    public boolean hasMoreLines() {
        if (this._comment == null) {
            return false;
        }
        return this._offset < this._length;
    }

    public String nextLine() {
        int index;
        int max;
        if (this._comment == null) {
            return null;
        }
        if (this._offset >= this._length) {
            return null;
        }
        this._sb.setLength(0);
        if (this._prefix != null) {
            this._sb.append(this._prefix);
        }
        if ((max = this._offset + this._maxLength) > this._length) {
            max = this._length;
        }
        int breakable = this._offset;
        for (index = this._offset; index < max; ++index) {
            char ch = this._comment.charAt(index);
            if (this.isNewLine(ch)) {
                this._sb.append(this._comment.substring(this._offset, index));
                this._offset = index + 1;
                return this._sb.toString();
            }
            if (!this.isWhitespace(ch)) continue;
            breakable = index;
        }
        if (index < this._length - 1) {
            if (this._offset == breakable) {
                while (index < this._length && !this.isBreakable(this._comment.charAt(index))) {
                    ++index;
                }
            } else {
                index = breakable;
            }
        }
        this._sb.append(this._comment.substring(this._offset, index));
        this._offset = index + 1;
        return this._sb.toString();
    }

    private boolean isBreakable(char ch) {
        return this.isWhitespace(ch) || this.isNewLine(ch);
    }

    private boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    private boolean isNewLine(char ch) {
        return ch == '\n' || ch == '\r';
    }
}

