/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;

public class KeepColumnFilter
extends BasicFilter {
    public KeepColumnFilter() {
        super("keepcols", "<colid-list>");
    }

    protected String[] getDescriptionLines() {
        return new String[]{"<p>Select the columns from the input table which will be", "included in the output table.", "The output table will include only those columns listed in", "<code>&lt;colid-list&gt;</code>, in that order.", "The same column may be listed more than once,", "in which case it will appear in the output table more than once.", "</p>", KeepColumnFilter.explainSyntax(new String[]{"colid-list"})};
    }

    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        if (argIt.hasNext()) {
            final String colIdList = (String)argIt.next();
            argIt.remove();
            return new ProcessingStep(){

                public StarTable wrap(StarTable base) throws IOException {
                    return KeepColumnFilter.keepColumnTable(base, colIdList);
                }
            };
        }
        throw new ArgException("Missing column list");
    }

    public static StarTable keepColumnTable(StarTable table, String colIdList) throws IOException {
        int[] colMap = new ColumnIdentifier(table).getColumnIndices(colIdList);
        return new ColumnPermutedStarTable(table, colMap);
    }
}

