/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.convert;

import uk.ac.starlink.pal.Pal;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.convert.Iso8601Converter;

public class Iso8601ToJulian
extends Iso8601Converter {
    private static final Pal pal_ = new Pal();

    public Iso8601ToJulian(ValueInfo isoInfo) {
        super(isoInfo, Iso8601ToJulian.getJulianInfo(isoInfo));
    }

    protected double toMjd(double number) {
        return Iso8601ToJulian.julianToMjd(number);
    }

    protected double fromMjd(double mjd) {
        return Iso8601ToJulian.mjdToJulian(mjd);
    }

    public String toString() {
        return "ISO-8601->Julian Year";
    }

    private static double mjdToJulian(double mjd) {
        return pal_.Epj(mjd);
    }

    private static double julianToMjd(double julianEpoch) {
        return pal_.Epj2d(julianEpoch);
    }

    private static ValueInfo getJulianInfo(ValueInfo isoInfo) {
        DefaultValueInfo numInfo = new DefaultValueInfo(isoInfo);
        numInfo.setContentClass(Double.class);
        numInfo.setUnitString("year");
        numInfo.setDescription("Julian Year");
        numInfo.setNullable(true);
        return numInfo;
    }
}

