/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.meta;

import alma.acs.commandcenter.meta.IMaciSupervisor;
import alma.acs.commandcenter.meta.MaciInfo;
import alma.acs.util.AcsLocations;
import alma.acs.util.UTCUtility;
import alma.maciErrType.NoPermissionEx;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Equator;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import si.ijs.maci.Administrator;
import si.ijs.maci.AdministratorPOA;
import si.ijs.maci.AuthenticationData;
import si.ijs.maci.Client;
import si.ijs.maci.ClientInfo;
import si.ijs.maci.ClientType;
import si.ijs.maci.ComponentInfo;
import si.ijs.maci.ContainerInfo;
import si.ijs.maci.ImplLangType;
import si.ijs.maci.Manager;
import si.ijs.maci.ManagerHelper;

public class MaciSupervisor
implements IMaciSupervisor {
    protected String name = null;
    protected String managerLoc = null;
    protected ORB orb = null;
    protected Logger log = null;
    private final String connect = "MaciSupervisor/connect: ";
    private final String disconnect = "MaciSupervisor/disconnect: ";
    private final String trigger = "MaciSupervisor/triggered: ";
    private final String read = "MaciSupervisor/read: ";
    private final String write = "MaciSupervisor/write: ";
    protected volatile boolean connectsAutomatically = true;
    protected volatile ManagerConnectionExceptionHandler mcehandler;
    protected final MaciInfo maciInfo;
    protected volatile boolean refreshWithoutACause;
    protected volatile int refreshCountdown;
    protected volatile int refreshCountFrom = 5;
    protected volatile int refreshLag = 2;
    protected RefreshIfNeeded refreshTask;
    protected Timer timer = new Timer("MaciSupervisor.Refresher", true);
    protected Manager managerRef = null;
    protected volatile boolean infoShouldBeRefreshed;
    private final Equator<ComponentInfo> eqComponents = new Equator<ComponentInfo>(){

        public boolean equate(ComponentInfo ci1, ComponentInfo ci2) {
            return Arrays.deepEquals(new java.lang.Object[]{ci1.name, ci1.h, ci1.container, ci1.clients}, new java.lang.Object[]{ci2.name, ci2.h, ci2.container, ci2.clients});
        }

        public int hash(ComponentInfo ci) {
            int hash = 7;
            hash = 31 * hash + ci.h;
            hash = 31 * hash + ci.name.hashCode();
            hash = 31 * hash + ci.container;
            hash = 31 * hash + ci.clients.length;
            return hash;
        }
    };
    private final Equator<ContainerInfo> eqContainers = new Equator<ContainerInfo>(){

        public boolean equate(ContainerInfo ci1, ContainerInfo ci2) {
            return Arrays.deepEquals(new java.lang.Object[]{ci1.name, ci1.h, ci1.components}, new java.lang.Object[]{ci2.name, ci2.h, ci2.components});
        }

        public int hash(ContainerInfo ci) {
            int hash = 7;
            hash = 31 * hash + ci.h;
            hash = 31 * hash + ci.name.hashCode();
            hash = 31 * hash + ci.components.length;
            return hash;
        }
    };
    private final Equator<ClientInfo> eqClients = new Equator<ClientInfo>(){

        public boolean equate(ClientInfo ci1, ClientInfo ci2) {
            return Arrays.deepEquals(new java.lang.Object[]{ci1.name, ci1.h, ci1.components}, new java.lang.Object[]{ci2.name, ci2.h, ci2.components});
        }

        public int hash(ClientInfo ci) {
            int hash = 7;
            hash = 31 * hash + ci.h;
            hash = 31 * hash + ci.name.hashCode();
            hash = 31 * hash + ci.components.length;
            return hash;
        }
    };
    protected volatile ClientInfo administratorClientInfo = null;
    protected volatile AdministratorImplementation acImpl;

    protected MaciSupervisor(String clientName, String managerLoc, ORB orb, Logger log) {
        this.name = clientName + ".MaciSupervisor";
        this.managerLoc = managerLoc;
        this.orb = orb;
        this.log = log;
        this.acImpl = new AdministratorImplementation();
        this.maciInfo = new MaciInfo();
    }

    public void setConnectsAutomatically(boolean b) {
        this.connectsAutomatically = b;
    }

    @Override
    public synchronized void start() throws NoPermissionEx, IMaciSupervisor.CannotRetrieveManagerException, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.UnknownErrorException {
        if (this.mcehandler == null) {
            this.mcehandler = new ManagerConnectionExceptionHandler();
            this.mcehandler.start();
        }
        this.enableRefreshTask(true);
        if (this.isConnected()) {
            return;
        }
        try {
            this.connectToManager();
            return;
        }
        catch (IMaciSupervisor.CannotRetrieveManagerException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw exc;
        }
        catch (NoPermissionEx exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw exc;
        }
        catch (TRANSIENT exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaTransientException(exc);
        }
        catch (OBJECT_NOT_EXIST exc) {
            this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
            throw new IMaciSupervisor.CorbaNotExistException(exc);
        }
        catch (RuntimeException exc) {
            this.mcehandler.handleExceptionTalkingToManager(exc);
            throw new IMaciSupervisor.UnknownErrorException(exc);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.mcehandler != null) {
            this.mcehandler.stop();
            this.mcehandler = null;
        }
        this.enableRefreshTask(false);
        this.disconnectFromManager();
    }

    @Override
    public synchronized void dismissManager() {
        this.administratorClientInfo = null;
    }

    @Override
    public boolean isConnected() {
        return this.administratorClientInfo != null;
    }

    @Override
    public int myMaciHandle() throws IMaciSupervisor.NotConnectedToManagerException {
        if (this.administratorClientInfo == null) {
            throw new IMaciSupervisor.NotConnectedToManagerException("not logged in to manager");
        }
        return this.administratorClientInfo.h;
    }

    protected Manager myManagerReference() throws IMaciSupervisor.NotConnectedToManagerException {
        if (this.managerRef == null) {
            throw new IMaciSupervisor.NotConnectedToManagerException("no reference to the manager");
        }
        return this.managerRef;
    }

    @Override
    public String getManagerLocation() {
        return this.managerLoc;
    }

    protected void connectToManager() throws IMaciSupervisor.CannotRetrieveManagerException, NoPermissionEx, SystemException {
        this.log.fine("MaciSupervisor/connect: connecting to manager");
        try {
            Object object = this.orb.string_to_object(this.managerLoc);
            this.managerRef = ManagerHelper.narrow((Object)object);
        }
        catch (Exception exc) {
            this.log.fine("MaciSupervisor/connect: failed to connect to manager: " + exc);
            throw new IMaciSupervisor.CannotRetrieveManagerException("could not retrieve manager reference", exc);
        }
        if (this.managerRef == null) {
            this.log.fine("MaciSupervisor/connect: failed to connect to manager: got null manager reference");
            throw new IMaciSupervisor.CannotRetrieveManagerException("orb delivered null-reference for manager-location " + this.managerLoc);
        }
        Administrator admin = this.acImpl.asCorbaObject(this.orb);
        this.administratorClientInfo = this.managerRef.login((Client)admin);
        this.log.info("MaciSupervisor/connect: connected to manager (" + this.getManagerLocation() + ") as " + this.administratorClientInfo.h + " (= 0x" + Integer.toHexString(this.administratorClientInfo.h) + ")");
    }

    protected void disconnectFromManager() {
        try {
            int hhhh = this.myMaciHandle();
            this.myManagerReference().logout(hhhh);
        }
        catch (IMaciSupervisor.NotConnectedToManagerException exc) {
            this.log.fine("MaciSupervisor/disconnect: couldn't log out from manager: " + exc);
        }
        catch (NoPermissionEx exc) {
            this.log.fine("MaciSupervisor/disconnect: couldn't log out from manager: " + exc);
        }
        this.dismissManager();
    }

    protected ContainerInfo[] retrieveContainerInfo(String name_wildcard) throws IMaciSupervisor.NotConnectedToManagerException, NoPermissionEx, SystemException {
        int hhhhh = this.myMaciHandle();
        int[] container_handles = new int[]{};
        return this.myManagerReference().get_container_info(hhhhh, container_handles, name_wildcard);
    }

    protected ClientInfo[] retrieveClientInfo(String name_wildcard) throws IMaciSupervisor.NotConnectedToManagerException, NoPermissionEx, SystemException {
        int hhhhh = this.myMaciHandle();
        int[] client_handles = new int[]{};
        return this.myManagerReference().get_client_info(hhhhh, client_handles, name_wildcard);
    }

    protected ComponentInfo[] retrieveComponentInfo(String name_wildcard) throws IMaciSupervisor.NotConnectedToManagerException, NoPermissionEx, SystemException {
        int hhhhh = this.myMaciHandle();
        int[] component_handles = new int[]{};
        String type_wildcard = "*";
        boolean active_only = false;
        return this.myManagerReference().get_component_info(hhhhh, component_handles, name_wildcard, type_wildcard, active_only);
    }

    @Override
    public MaciInfo getMaciInfo() throws NoPermissionEx, IMaciSupervisor.NotConnectedToManagerException, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.UnknownErrorException {
        this.refreshNow();
        return this.maciInfo;
    }

    public MaciInfo getMaciInformation() {
        return this.maciInfo;
    }

    public void refreshSoon() {
        this.infoShouldBeRefreshed = true;
    }

    public synchronized void setRefreshesPeriodically(boolean b) {
        this.refreshCountdown = 0;
        this.refreshWithoutACause = b;
    }

    private synchronized void enableRefreshTask(boolean b) {
        if (b && this.refreshTask == null) {
            this.refreshTask = new RefreshIfNeeded();
            this.timer.schedule((TimerTask)this.refreshTask, 2000L, (long)(this.refreshLag * 1000));
        }
        if (!b && this.refreshTask != null) {
            this.refreshTask.cancel();
            this.refreshTask = null;
        }
    }

    public synchronized void setRefreshDelay(int lag, int period) {
        int countfrom;
        if (lag != this.refreshLag) {
            this.refreshLag = lag;
            this.enableRefreshTask(false);
            this.enableRefreshTask(true);
        }
        if ((countfrom = period / lag) != this.refreshCountFrom) {
            this.refreshCountFrom = countfrom;
            this.refreshCountdown = countfrom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshNow() throws NoPermissionEx, IMaciSupervisor.NotConnectedToManagerException, SystemException, IMaciSupervisor.CorbaTransientException, IMaciSupervisor.CorbaNotExistException, IMaciSupervisor.UnknownErrorException {
        this.log.fine("MaciSupervisor/read: retrieving acs deployment info from acs manager");
        List<ComponentInfo> newComponents = Collections.EMPTY_LIST;
        List<ContainerInfo> newContainers = Collections.EMPTY_LIST;
        List<ClientInfo> newClientApps = Collections.EMPTY_LIST;
        HashMap<java.lang.Object, String> newAuxiliary = Collections.EMPTY_MAP;
        boolean nothingChanged = false;
        try {
            try {
                newComponents = Arrays.asList(this.retrieveComponentInfo("*"));
                newContainers = Arrays.asList(this.retrieveContainerInfo("*"));
                newClientApps = Arrays.asList(this.retrieveClientInfo("*"));
            }
            catch (IMaciSupervisor.NotConnectedToManagerException exc) {
                this.log.fine("MaciSupervisor/read: problem: " + exc);
                this.mcehandler.handleExceptionTalkingToManager(exc);
                throw exc;
            }
            catch (NoPermissionEx exc) {
                this.log.fine("MaciSupervisor/read: problem: " + exc);
                this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
                throw exc;
            }
            catch (TRANSIENT exc) {
                this.log.fine("MaciSupervisor/read: problem: " + exc);
                this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
                throw new IMaciSupervisor.CorbaTransientException(exc);
            }
            catch (OBJECT_NOT_EXIST exc) {
                this.log.fine("MaciSupervisor/read: problem: " + exc);
                this.mcehandler.handleExceptionTalkingToManager((Exception)((java.lang.Object)exc));
                throw new IMaciSupervisor.CorbaNotExistException(exc);
            }
            catch (RuntimeException exc) {
                this.log.fine("MaciSupervisor/read: problem: " + exc);
                this.mcehandler.handleExceptionTalkingToManager(exc);
                throw new IMaciSupervisor.UnknownErrorException(exc);
            }
            if (this.log.isLoggable(Level.FINER)) {
                StringBuilder sb = new StringBuilder();
                sb.append("\nretrieved containers (").append(newContainers.size()).append(") = | ");
                for (ContainerInfo ci : newContainers) {
                    sb.append("n=").append(ci.name).append(",h=").append(ci.h).append(" | ");
                }
                sb.append("\nknown containers (").append(this.maciInfo.containers.size()).append(") = | ");
                for (ContainerInfo ci : this.maciInfo.containers) {
                    sb.append("n=").append(ci.name).append(",h=").append(ci.h).append(" | ");
                }
                this.log.finer("MaciSupervisor/read: diffing container info" + sb);
            }
            boolean compsEqual = CollectionUtils.isEqualCollection(this.maciInfo.components, newComponents, this.eqComponents);
            boolean contsEqual = CollectionUtils.isEqualCollection(this.maciInfo.containers, newContainers, this.eqContainers);
            boolean clientsEqual = CollectionUtils.isEqualCollection(this.maciInfo.clientApps, newClientApps, this.eqClients);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("MaciSupervisor/write: diff results: containers=" + !contsEqual + ", components=" + !compsEqual + ", clients=" + !clientsEqual);
            }
            if (compsEqual && contsEqual && clientsEqual) {
                this.log.finer("MaciSupervisor/write: no change found");
                nothingChanged = true;
            } else {
                int infokey;
                newAuxiliary = new HashMap<java.lang.Object, String>();
                for (ContainerInfo containerInfo : newContainers) {
                    infokey = System.identityHashCode(containerInfo);
                    newAuxiliary.put(infokey + ".location", this.extractLocation((Object)containerInfo.reference));
                }
                for (ClientInfo clientInfo : newClientApps) {
                    infokey = System.identityHashCode(clientInfo);
                    newAuxiliary.put(infokey + ".location", this.extractLocation((Object)clientInfo.reference));
                }
            }
            if (!nothingChanged) {
                this.log.fine("MaciSupervisor/write: writing changes to maci-info structure");
                this.maciInfo.setContents(newComponents, newContainers, newClientApps, newAuxiliary);
            }
        }
        catch (Throwable throwable) {
            if (!nothingChanged) {
                this.log.fine("MaciSupervisor/write: writing changes to maci-info structure");
                this.maciInfo.setContents(newComponents, newContainers, newClientApps, (Map<java.lang.Object, String>)newAuxiliary);
            }
            throw throwable;
        }
    }

    public String toString() {
        java.lang.Object s1 = this.managerLoc;
        if (s1 == null) {
            s1 = "<no manager location>";
        } else if (((String)s1).length() > 30) {
            s1 = ((String)s1).substring(0, 22) + "..." + ((String)s1).substring(((String)s1).length() - 5, ((String)s1).length());
        }
        return this.getClass().getName() + "[mgr=" + (String)s1 + "]";
    }

    protected String extractLocation(Object reference) {
        java.lang.Object location;
        try {
            location = this.orb.object_to_string(reference);
            String[] hostport = AcsLocations.convert((String)location);
            location = hostport[0] + ":" + hostport[1];
        }
        catch (Exception e) {
            location = null;
        }
        return location;
    }

    protected class AdministratorImplementation
    extends AdministratorPOA {
        private Administrator asCorbaObject;
        private final long startTimeUTClong = UTCUtility.utcJavaToOmg((long)System.currentTimeMillis());
        private long executionId = -1L;

        protected AdministratorImplementation() {
        }

        protected Administrator asCorbaObject(ORB orb) {
            if (this.asCorbaObject == null) {
                this.asCorbaObject = this._this(orb);
            }
            return this.asCorbaObject;
        }

        public void client_logged_in(ClientInfo info, long timestamp, long execution_id) {
            MaciSupervisor.this.log.finer("MaciSupervisor/triggered: client_logged_in() received");
            MaciSupervisor.this.infoShouldBeRefreshed = true;
        }

        public void client_logged_out(int h, long timestamp) {
            MaciSupervisor.this.log.finer("MaciSupervisor/triggered: client_logged_out() received");
            MaciSupervisor.this.infoShouldBeRefreshed = true;
        }

        public void container_logged_in(ContainerInfo info, long timestamp, long execution_id) {
            MaciSupervisor.this.log.finer("MaciSupervisor/triggered: container_logged_in() received");
            MaciSupervisor.this.infoShouldBeRefreshed = true;
        }

        public void container_logged_out(int h, long timestamp) {
            MaciSupervisor.this.log.finer("MaciSupervisor/triggered: container_logged_out() received");
            MaciSupervisor.this.infoShouldBeRefreshed = true;
        }

        public void components_requested(int[] clients, int[] components, long timestamp) {
            MaciSupervisor.this.log.finer("MaciSupervisor/triggered: components_requested() received");
            MaciSupervisor.this.infoShouldBeRefreshed = true;
        }

        public void components_released(int[] clients, int[] components, long timestamp) {
            MaciSupervisor.this.log.finer("MaciSupervisor/triggered: components_released() received");
            MaciSupervisor.this.infoShouldBeRefreshed = true;
        }

        public void components_available(ComponentInfo[] arg0) {
            MaciSupervisor.this.log.finer("fyi: components_available() received");
        }

        public void components_unavailable(String[] arg0) {
            MaciSupervisor.this.log.finer("fyi: components_unavailable() received");
        }

        public void component_activated(ComponentInfo info, long timestamp, long execution_id) {
            MaciSupervisor.this.log.finer("fyi: component_activated() received");
        }

        public void component_deactivated(int h, long timestamp) {
            MaciSupervisor.this.log.finer("fyi: component_deactivated() received");
        }

        public String name() {
            MaciSupervisor.this.log.finer("fyi: name() received");
            return MaciSupervisor.this.name;
        }

        public AuthenticationData authenticate(long execution_id, String question) {
            MaciSupervisor.this.log.finer("fyi: authenticate() received");
            if (this.executionId < 0L) {
                this.executionId = execution_id;
            }
            AuthenticationData ret = new AuthenticationData("S", ClientType.ADMINISTRATOR_TYPE, ImplLangType.JAVA, false, this.startTimeUTClong, this.executionId);
            return ret;
        }

        public void message(short arg0, String arg1) {
            MaciSupervisor.this.log.finer("fyi: message() received");
            MaciSupervisor.this.log.info("Incoming Maci Network Message: '" + arg1 + "'");
        }

        public void taggedmessage(short type, short messageID, String message) {
            MaciSupervisor.this.log.finer("fyi: taggedmessage() received");
            MaciSupervisor.this.log.info("Incoming Maci Network Message: '" + message + "' (messageId=" + messageID + ")");
        }

        public boolean ping() {
            MaciSupervisor.this.log.finer("fyi: ping() received");
            return true;
        }

        public void disconnect() {
            MaciSupervisor.this.log.finer("MaciSupervisor/triggered: disconnect() received");
            MaciSupervisor.this.disconnectFromManager();
        }
    }

    protected class RefreshIfNeeded
    extends TimerTask {
        protected RefreshIfNeeded() {
        }

        @Override
        public void run() {
            if (MaciSupervisor.this.refreshWithoutACause) {
                if (MaciSupervisor.this.refreshCountdown > 0) {
                    --MaciSupervisor.this.refreshCountdown;
                }
                if (MaciSupervisor.this.refreshCountdown <= 0) {
                    MaciSupervisor.this.infoShouldBeRefreshed = true;
                }
                if (!MaciSupervisor.this.isConnected()) {
                    return;
                }
            }
            if (MaciSupervisor.this.infoShouldBeRefreshed) {
                MaciSupervisor.this.infoShouldBeRefreshed = false;
                MaciSupervisor.this.refreshCountdown = MaciSupervisor.this.refreshCountFrom;
                try {
                    MaciSupervisor.this.refreshNow();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    protected class ManagerConnectionExceptionHandler {
        protected final java.lang.Object connector = new java.lang.Object();
        protected final ConnectorThread connectorThread = new ConnectorThread();

        public ManagerConnectionExceptionHandler() {
            this.connectorThread.setName("MaciSupervisor.Connector");
            this.connectorThread.setDaemon(true);
        }

        public void start() {
            this.connectorThread.start();
        }

        public void stop() {
            this.connectorThread.interrupt();
        }

        public void handleExceptionTalkingToManager(IMaciSupervisor.UnknownErrorException exc) {
            System.err.println("PROBLEM: couldn't access Acs Manager for unexpected reason: " + exc);
            System.err.println("Please report this stacktrace to the Acs Team, together");
            System.err.println("with a description of what you've been doing:");
            System.err.println("---------------------------");
            exc.printStackTrace(System.err);
            System.err.println("---------------------------");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleExceptionTalkingToManager(Exception exc) {
            if (!MaciSupervisor.this.connectsAutomatically) {
                return;
            }
            MaciSupervisor.this.dismissManager();
            java.lang.Object object = this.connector;
            synchronized (object) {
                this.connector.notify();
            }
        }

        protected class ConnectorThread
        extends Thread {
            protected ConnectorThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: while (true) {
                    java.lang.Object object = ManagerConnectionExceptionHandler.this.connector;
                    synchronized (object) {
                        try {
                            ManagerConnectionExceptionHandler.this.connector.wait();
                            MaciSupervisor.this.log.fine("auto-connector triggered");
                        }
                        catch (InterruptedException exc) {
                            break;
                        }
                    }
                    while (true) {
                        try {
                            MaciSupervisor.this.start();
                            break;
                        }
                        catch (Exception exc) {
                            MaciSupervisor.this.log.fine("auto-connector attempt failed with " + exc);
                            try {
                                ConnectorThread.sleep(5000L);
                            }
                            catch (InterruptedException exc2) {
                                break block9;
                            }
                        }
                    }
                    MaciSupervisor.this.log.fine("auto-connector suspended");
                }
            }
        }
    }
}

