/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.IOException;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.RandomAccess;
import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.util.IOUtils;

class ReadableFitsArrayImpl
implements ArrayImpl {
    private final ArrayDataInput stream;
    private final OrderedNDShape oshape;
    private final Type type;
    private final Number badValue;
    private final AccessMode mode;
    private final boolean isRandom;
    private final Header hdr;
    private final long strmBase;
    private final int nByte;
    private final TypedReader rdr;

    ReadableFitsArrayImpl(ArrayDataInput istream, AccessMode mode) throws FitsException, IOException {
        this.stream = istream;
        this.isRandom = this.stream instanceof RandomAccess;
        this.mode = mode;
        this.hdr = Header.readHeader(this.stream);
        this.strmBase = this.isRandom ? ((RandomAccess)this.stream).getFilePointer() : 0L;
        long[] dims = ReadableFitsArrayImpl.getDimsFromHeader(this.hdr);
        long[] origin = ReadableFitsArrayImpl.getOriginFromHeader(this.hdr);
        this.oshape = origin != null ? new OrderedNDShape(origin, dims, Order.COLUMN_MAJOR) : new OrderedNDShape(dims, Order.COLUMN_MAJOR);
        boolean hasBlank = this.hdr.containsKey("BLANK");
        switch (this.hdr.getIntValue("BITPIX")) {
            case 8: {
                this.type = Type.BYTE;
                this.badValue = hasBlank ? new Byte((byte)this.hdr.getIntValue("BLANK")) : null;
                this.rdr = new TypedReader(){

                    public void read(Object buffer, int start, int size) throws IOException {
                        ReadableFitsArrayImpl.this.stream.read((byte[])buffer, start, size);
                    }

                    public void write(Object buffer, int start, int size) throws IOException {
                        ((ArrayDataOutput)((Object)ReadableFitsArrayImpl.this.stream)).write((byte[])buffer, start, size);
                    }
                };
                break;
            }
            case 16: {
                this.type = Type.SHORT;
                this.badValue = hasBlank ? new Short((short)this.hdr.getIntValue("BLANK")) : null;
                this.rdr = new TypedReader(){

                    public void read(Object buffer, int start, int size) throws IOException {
                        ReadableFitsArrayImpl.this.stream.read((short[])buffer, start, size);
                    }

                    public void write(Object buffer, int start, int size) throws IOException {
                        ((ArrayDataOutput)((Object)ReadableFitsArrayImpl.this.stream)).write((short[])buffer, start, size);
                    }
                };
                break;
            }
            case 32: {
                this.type = Type.INT;
                this.badValue = hasBlank ? new Integer(this.hdr.getIntValue("BLANK")) : null;
                this.rdr = new TypedReader(){

                    public void read(Object buffer, int start, int size) throws IOException {
                        ReadableFitsArrayImpl.this.stream.read((int[])buffer, start, size);
                    }

                    public void write(Object buffer, int start, int size) throws IOException {
                        ((ArrayDataOutput)((Object)ReadableFitsArrayImpl.this.stream)).write((int[])buffer, start, size);
                    }
                };
                break;
            }
            case -32: {
                this.type = Type.FLOAT;
                this.badValue = new Float(Float.NaN);
                this.rdr = new TypedReader(){

                    public void read(Object buffer, int start, int size) throws IOException {
                        ReadableFitsArrayImpl.this.stream.read((float[])buffer, start, size);
                    }

                    public void write(Object buffer, int start, int size) throws IOException {
                        ((ArrayDataOutput)((Object)ReadableFitsArrayImpl.this.stream)).write((float[])buffer, start, size);
                    }
                };
                break;
            }
            case -64: {
                this.type = Type.DOUBLE;
                this.badValue = new Double(Double.NaN);
                this.rdr = new TypedReader(){

                    public void read(Object buffer, int start, int size) throws IOException {
                        ReadableFitsArrayImpl.this.stream.read((double[])buffer, start, size);
                    }

                    public void write(Object buffer, int start, int size) throws IOException {
                        ((ArrayDataOutput)((Object)ReadableFitsArrayImpl.this.stream)).write((double[])buffer, start, size);
                    }
                };
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported FITS data type");
            }
        }
        this.nByte = this.type.getNumBytes();
    }

    public OrderedNDShape getShape() {
        return this.oshape;
    }

    public Type getType() {
        return this.type;
    }

    public Number getBadValue() {
        return this.badValue;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return this.mode.isWritable();
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public boolean canMap() {
        return false;
    }

    public Object getMapped() {
        throw new AssertionError();
    }

    public boolean multipleAccess() {
        return false;
    }

    public void open() {
    }

    public AccessImpl getAccess() {
        return new AccessImpl(){
            private long offset = 0L;

            public void setOffset(long off) throws IOException {
                if (ReadableFitsArrayImpl.this.isRandom) {
                    ((RandomAccess)ReadableFitsArrayImpl.this.stream).seek(ReadableFitsArrayImpl.this.strmBase + off * (long)ReadableFitsArrayImpl.this.nByte);
                } else {
                    IOUtils.skipBytes(ReadableFitsArrayImpl.this.stream, (off - this.offset) * (long)ReadableFitsArrayImpl.this.nByte);
                }
                this.offset = off;
            }

            public void read(Object buffer, int start, int size) throws IOException {
                ReadableFitsArrayImpl.this.rdr.read(buffer, start, size);
                this.offset += (long)size;
            }

            public void write(Object buffer, int start, int size) throws IOException {
                ReadableFitsArrayImpl.this.rdr.write(buffer, start, size);
                this.offset += (long)size;
            }

            public void close() {
            }
        };
    }

    public void close() throws IOException {
        this.stream.close();
    }

    Header getHeader() {
        return this.hdr;
    }

    private static long[] getDimsFromHeader(Header hdr) throws FitsException {
        int naxis = hdr.getIntValue("NAXIS");
        long[] dimensions = new long[naxis];
        for (int i = 0; i < naxis; ++i) {
            String key = "NAXIS" + (i + 1);
            if (!hdr.containsKey(key)) {
                throw new FitsException("No header card + " + key);
            }
            dimensions[i] = hdr.getLongValue(key);
        }
        return dimensions;
    }

    private static long[] getOriginFromHeader(Header hdr) {
        int naxis = hdr.getIntValue("NAXIS");
        long[] origin = new long[naxis];
        boolean ok = true;
        for (int i = 0; i < naxis && ok; ++i) {
            String cardName = FitsConstants.originCardName(i);
            if (hdr.containsKey(cardName)) {
                origin[i] = hdr.getLongValue(cardName);
                continue;
            }
            ok = false;
        }
        return (long[])(ok ? origin : null);
    }

    private static interface TypedReader {
        public void read(Object var1, int var2, int var3) throws IOException;

        public void write(Object var1, int var2, int var3) throws IOException;
    }
}

