/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.concurrent;

import java.util.concurrent.ThreadFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private final ThreadFactory tf;
    private final String threadNameSuffix;

    public NamedThreadFactory(ThreadFactory tf, String threadNameSuffix) {
        this.tf = tf;
        this.threadNameSuffix = threadNameSuffix != null && !threadNameSuffix.trim().isEmpty() ? threadNameSuffix.trim() : null;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = this.tf.newThread(r);
        if (this.threadNameSuffix != null) {
            t.setName(t.getName() + "-" + this.threadNameSuffix);
        }
        return t;
    }
}

