/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.BitSet;
import java.util.Iterator;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.MatchStarTables;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowRef;

public abstract class Match1Type {
    static final /* synthetic */ boolean $assertionsDisabled;

    public abstract StarTable createMatchTable(StarTable var1, LinkSet var2);

    public static Match1Type createIdentifyType() {
        final JoinFixAction inFix = JoinFixAction.makeRenameDuplicatesAction("_old");
        final JoinFixAction grpFix = JoinFixAction.NO_ACTION;
        return new Match1Type(){

            public StarTable createMatchTable(StarTable inTable, LinkSet rowLinks) {
                return Match1Type.createIdentifyMatch(inTable, rowLinks, inFix, grpFix);
            }
        };
    }

    public static Match1Type createEliminateMatchesType(final int retainCount) {
        return new Match1Type(){

            public StarTable createMatchTable(StarTable inTable, LinkSet rowLinks) {
                return Match1Type.createDeduplicateMatch(inTable, rowLinks, retainCount);
            }
        };
    }

    public static Match1Type createWideType(final int grpSize) {
        final JoinFixAction[] fixActs = new JoinFixAction[grpSize];
        for (int i = 0; i < grpSize; ++i) {
            fixActs[i] = JoinFixAction.makeRenameDuplicatesAction("_" + (i + 1));
        }
        return new Match1Type(){

            public StarTable createMatchTable(StarTable inTable, LinkSet rowLinks) {
                return MatchStarTables.makeParallelMatchTable(inTable, 0, rowLinks, grpSize, grpSize, grpSize, fixActs);
            }
        };
    }

    private static StarTable createIdentifyMatch(StarTable inTable, LinkSet rowLinks, JoinFixAction inFix, JoinFixAction grpFix) {
        long nrow = inTable.getRowCount();
        StarTable grpTable = MatchStarTables.makeInternalMatchTable(0, rowLinks, nrow);
        return new JoinStarTable(new StarTable[]{inTable, grpTable}, new JoinFixAction[]{inFix, grpFix});
    }

    private static StarTable createDeduplicateMatch(StarTable inTable, LinkSet rowLinks, int retainCount) {
        int nrow = Tables.checkedLongToInt(inTable.getRowCount());
        BitSet bits = new BitSet(nrow);
        bits.set(0, nrow);
        Iterator it = rowLinks.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            for (int i = retainCount; i < nref; ++i) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() != 0) {
                    throw new IllegalArgumentException("Intra-table LinkSet has links from multiple tables");
                }
                bits.clear(Tables.checkedLongToInt(ref.getRowIndex()));
            }
        }
        int nbit = bits.cardinality();
        long[] rowMap = new long[nbit];
        int i = 0;
        int ipos = bits.nextSetBit(0);
        while (ipos >= 0) {
            rowMap[i++] = ipos;
            ipos = bits.nextSetBit(ipos + 1);
        }
        if (!$assertionsDisabled && i != nbit) {
            throw new AssertionError();
        }
        return new RowPermutedStarTable(inTable, rowMap);
    }

    static {
        $assertionsDisabled = !Match1Type.class.desiredAssertionStatus();
    }
}

