/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.submission;

import alma.acs.entityutil.EntityException;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.MendMyStruct;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.ot.valdef.DefaultProblemListModel;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.ValidatorSet;
import alma.obsprep.ot.valdef.ValidatorSetFactory;
import alma.obsprep.ot.valdef.obsproposal.ObsProposalInvestigatorsValidator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import org.exolab.castor.xml.XMLException;

public class ServerOT {
    private ImpexFactory impexFactory = new ImpexFactory();

    public ObsProject importProject(URL uRL) throws XMLException, IOException, PersistenceException {
        boolean bl = false;
        return this.impexFactory.importObsProject(uRL, bl);
    }

    public ProblemListModel validateProject(ObsProject obsProject, boolean bl) {
        DefaultProblemListModel defaultProblemListModel = new DefaultProblemListModel();
        if (bl) {
            ValidatorSet validatorSet = ValidatorSetFactory.createStandardValidatorSet();
            validatorSet.validate((BusinessObject)obsProject, defaultProblemListModel);
        } else {
            try {
                ObsProposal obsProposal = obsProject.getObsProposal();
                ObsProposalInvestigatorsValidator obsProposalInvestigatorsValidator = new ObsProposalInvestigatorsValidator();
                obsProposalInvestigatorsValidator.validate((BusinessObject)obsProposal, defaultProblemListModel);
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
        }
        return defaultProblemListModel;
    }

    public void rewrite(ObsProject obsProject) throws UnknownEntityException, EntityException {
        MendMyStruct.renewIds(obsProject, false);
    }

    public Apdm_to_BO.BoBundle decomposeIncludingFiles(ObsProject obsProject) throws UnknownEntityException, IOException {
        return Apdm_to_BO.decomposeIncludingFiles(obsProject);
    }

    public Apdm_to_BO.SoBundle down(Apdm_to_BO.BoBundle boBundle) {
        return Apdm_to_BO.down(boBundle);
    }

    public void exportRaw(Apdm_to_BO.SoBundle soBundle, List<File> list, OutputStream outputStream) throws IOException {
        this.impexFactory.exportRaw(soBundle, list, outputStream);
    }

    public void discard(ObsProject obsProject) {
    }
}

