/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.sfi;

import alma.common.sourcecatalog.Measurement;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.SpectralMode;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.NonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.workbooks.WorkbookPage;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.obsproject.ObsProposalEditor;
import alma.obsprep.ot.editors.sciencegoals.AbstractTargetEditor;
import alma.obsprep.ot.editors.sciencegoals.FieldSetupEditor;
import alma.obsprep.ot.editors.spectralvisual.ScienceViewSpectralVisualEditor;
import alma.obsprep.ot.models.obsproject.CalibratedGoalModel;
import alma.obsprep.ot.models.obsproject.CalibrationSetupParametersModel;
import alma.obsprep.ot.models.sciencegoals.FieldSetupModel;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.models.sciencegoals.SgNoteModel;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.obsprep.ot.models.spectralvisual.TargetParametersTableModel;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.DGCOnlineCalibratorExpert;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationConfigurationHelper;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimeQueryInterface;
import alma.obsprep.services.generator.refactored.obsparams.UnableToDetermineCalibrationTimeException;
import alma.obsprep.services.sfi.S_AntennaCalculator;
import alma.obsprep.services.sfi.ScienceGoalEditorViewEnum;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.UserFrequency;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Timer;
import javax.xml.bind.JAXBException;
import lombok.NonNull;

public class SingleFieldScienceGoalModel
extends Model
implements CalibratedGoalModel,
ModelChangeSubscriber {
    public static final FieldID EDITOR_SUBVIEW_FID = new FieldID("SingleFieldScienceGoalModel.editorSubview");
    private static CalibrationConfigurationHelper calibrationConfigurationHelper;
    private ScienceGoalEditorViewEnum currentSubview = null;
    private final SgNoteModel sgNoteModel = new SgNoteModel(null);
    private final FieldSetupModel sgFieldSetupModel = new FieldSetupModel(null);
    private final SpectralSetupParametersModel spectralSetupParametersModel = new SpectralSetupParametersModel(null);
    private final SfiControlParameterModel sfiControlParameterModel = new SfiControlParameterModel(null);
    private final CalibrationSetupParametersModel calibrationSetupParametersModel = new CalibrationSetupParametersModel(null);
    private final TargetParametersTableModel targetParametersTableModel = new TargetParametersTableModel(null);
    private final TechnicalJustificationModel technicalJustificationModel = new TechnicalJustificationModel(null);
    private boolean isTimerActive = false;
    private int lastCalculatedSGHashCode = -1;
    private SpectralSpecDocument context;
    private ScienceGoal scienceGoal;

    public SingleFieldScienceGoalModel(Object object2) {
        super(object2);
        this.setDocument(object2);
        this.registerSubModel(this.sgNoteModel);
        this.registerSubModel(this.sgFieldSetupModel);
        this.registerSubModel(this.spectralSetupParametersModel);
        this.registerSubModel(this.sfiControlParameterModel);
        this.registerSubModel(this.calibrationSetupParametersModel);
        this.registerSubModel(this.technicalJustificationModel);
        this.sfiControlParameterModel.subscribe(this.calibrationSetupParametersModel);
        this.sgFieldSetupModel.getTargetParametersModel().subscribeToAllRegisteredModels(this.calibrationSetupParametersModel);
        this.spectralSetupParametersModel.subscribeToAllRegisteredModels((model, fieldID, object) -> {
            if (fieldID == ScienceViewSpectralVisualEditor.FID_VISUALPANEL) {
                this.publish(fieldID, null);
            }
            if (fieldID == ScienceViewSpectralVisualEditor.OVERLAY_LINES_SELECTED_FID) {
                this.publish(fieldID, object);
            }
        });
        this.sgFieldSetupModel.subscribe((Model model, FieldID fieldID, Object object) -> {
            ScienceGoal scienceGoal;
            if (FieldSetupEditor.FID_TABBEDPANE.equals(fieldID) && object instanceof ScienceGoal && (scienceGoal = (ScienceGoal)object).getTargetParametersCount() > 0) {
                TargetParameters targetParameters = scienceGoal.getTargetParameters(0);
                this.calibrationSetupParametersModel.setDefaultSearchPosition(targetParameters);
            }
        });
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> this.scheduleScienceGoalModeCheck();
        ModelChangeSubscriber modelChangeSubscriber2 = new ModelChangeSubscriber(){
            String oldUnit = null;
            String oldVelocity = null;

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (fieldID.equals(AbstractTargetEditor.FID_SOURCEVELOCITY_VALUE) || fieldID.equals(AbstractTargetEditor.FID_SOURCEVELOCITY_UNIT)) {
                    String string;
                    if (fieldID.equals(AbstractTargetEditor.FID_SOURCEVELOCITY_VALUE)) {
                        string = (String)object;
                        if (this.oldVelocity == null) {
                            this.oldVelocity = string;
                            return;
                        }
                        if (this.oldVelocity.equals(string)) {
                            return;
                        }
                        this.oldVelocity = string;
                    }
                    if (fieldID.equals(AbstractTargetEditor.FID_SOURCEVELOCITY_UNIT)) {
                        string = (String)object;
                        if (this.oldUnit == null) {
                            this.oldUnit = string;
                            return;
                        }
                        if (this.oldUnit.equals(string)) {
                            return;
                        }
                        this.oldUnit = string;
                    }
                    SingleFieldScienceGoalModel.this.spectralSetupParametersModel.publishRepSpectralWindow();
                }
            }
        };
        this.sgFieldSetupModel.getTargetParametersModel().subscribeToAllRegisteredModels(modelChangeSubscriber2);
        this.calibrationSetupParametersModel.subscribeToAllRegisteredModels(modelChangeSubscriber);
        this.sgFieldSetupModel.subscribeToAllRegisteredModels(modelChangeSubscriber);
        this.spectralSetupParametersModel.subscribeToAllRegisteredModels(modelChangeSubscriber);
        this.sfiControlParameterModel.subscribeToAllRegisteredModels(modelChangeSubscriber);
    }

    private void scheduleScienceGoalModeCheck() {
        if (!this.isTimerActive) {
            this.isTimerActive = true;
            Timer timer = new Timer(300, actionEvent -> {
                this.isTimerActive = false;
                ScienceGoal scienceGoal = this.getScienceGoal();
                if (scienceGoal == null) {
                    return;
                }
                int n = Objects.hash(scienceGoal.toXml());
                if (n == this.lastCalculatedSGHashCode) {
                    return;
                }
                this.lastCalculatedSGHashCode = n;
                this.determineScienceGoalObservingMode();
                this.setACAselection();
                this.enforceSingleContinuumWithStandardFreqForPolarizationMosaics();
                this.setDGCOverrideUserSelectable();
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    private void enforceSingleContinuumWithStandardFreqForPolarizationMosaics() {
        boolean bl = false;
        if (this.scienceGoal == null) {
            this.spectralSetupParametersModel.setPolarizationRestrictions(false);
            return;
        }
        if (this.scienceGoal.isFullPolarization()) {
            bl = Stream.of(this.scienceGoal.getTargetParameters()).anyMatch(targetParameters -> targetParameters.getNumberOfPointings() > 1);
        }
        this.spectralSetupParametersModel.setPolarizationRestrictions(bl);
    }

    private void setDGCOverrideUserSelectable() {
        if (this.scienceGoal.getCalibrationSetupParameters().isForcedDGC()) {
            this.calibrationSetupParametersModel.setDGCOverrideUserSelectableState(EnumSet.of(DGCExpert.DGCTypeEnum.None));
        } else {
            Set<DGCExpert.DGCTypeEnum> set = DGCExpert.getExpert().dgcObservingStrategiesRequired(this.scienceGoal, false);
            this.calibrationSetupParametersModel.setDGCOverrideUserSelectableState(set);
        }
    }

    private void setACAselection() {
        this.sfiControlParameterModel.setACAScheduling();
    }

    private void determineScienceGoalObservingMode() {
        this.scienceGoal = this.getScienceGoal();
        if (this.scienceGoal == null) {
            return;
        }
        String string = this.scienceGoal.getMode();
        EnumSet<NonStandardMode> enumSet = null;
        try {
            enumSet = SingleFieldScienceGoalModel.establishNonStandardObservingModes(this.scienceGoal);
        }
        catch (UnableToDetermineObservingModesException unableToDetermineObservingModesException) {
            this.scienceGoal.setMode(ScienceGoal.MODE_STANDARD);
            return;
        }
        assert (enumSet != null);
        String string2 = null;
        string2 = enumSet.isEmpty() ? ScienceGoal.MODE_STANDARD : ScienceGoal.MODE_OTHER;
        assert (string2 != null);
        if (!string.equals(string2)) {
            this.scienceGoal.setMode(string2);
        }
    }

    public static EnumSet<NonStandardMode> establishNonStandardObservingModes(@NonNull ScienceGoal scienceGoal) throws UnableToDetermineObservingModesException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        EnumSet<NonStandardMode> enumSet = EnumSet.noneOf(NonStandardMode.class);
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        assert (performanceParameters != null);
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        assert (spectralSetupParameters != null);
        TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
        assert (targetParametersArray != null);
        ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
        if (receiverBand == null) {
            throw new UnableToDetermineObservingModesException("Unable to determine receiver band");
        }
        try {
            ObsProposal obsProposal = scienceGoal.getObsProposal();
            if (obsProposal == null) {
                Log.logger(SingleFieldScienceGoalModel.class).info("Unable to determine obsProposal for science goal");
            } else if (obsProposal.isVLBIorPhasedArray()) {
                Log.logger(SingleFieldScienceGoalModel.class).finer(scienceGoal.getName() + " is experimental as it is a VLBI proposal");
                enumSet.add(NonStandardMode.VLBI_MODE);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SingleFieldScienceGoalModel.class).info("Unable to determine obsProposal for science goal");
        }
        try {
            if (scienceGoal.isSolarScienceGoal()) {
                enumSet.add(NonStandardMode.SOLAR_MODE);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SingleFieldScienceGoalModel.class).info("Unable to determine if this is a solar science goal : " + unknownEntityException.getMessage());
        }
        if (SpectralSetupParameters.POLARISATION_FULL.equals(spectralSetupParameters.getPolarisation())) {
            Log.logger(SingleFieldScienceGoalModel.class).finer(scienceGoal.getName() + " is experimental as it's full polarization");
            enumSet.add(NonStandardMode.FULL_POLARIZATION);
        }
        if (scienceGoal.getCalibrationSetupParameters().isUserDefinedCalibration()) {
            Log.logger(SingleFieldScienceGoalModel.class).finer("User defined calibration strategy is an experimental setup");
            enumSet.add(NonStandardMode.USERDEFINED_CALIBRATION);
        }
        if (SingleFieldScienceGoalModel.isNarrowBWScienceGoal(scienceGoal)) {
            enumSet.add(NonStandardMode.BANDWIDTH_SWITCHING);
        }
        return enumSet;
    }

    @Deprecated
    public static boolean isB7WithLongbaselineConfigurationNonStandard(@NonNull ScienceGoal scienceGoal, @NonNull ReceiverBand receiverBand, @NonNull Configuration configuration) throws InvalidObsProgramParametersException, UnableToDetermineCalibrationTimeException, InvalidFrequencyException, SourceNeverVisibleException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (receiverBand == null) {
            throw new NullPointerException("receiverBand is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("best12mExtConfig is marked non-null but is null");
        }
        return SingleFieldScienceGoalModel.isInBandWithLongbaselineConfigurationNonStandard(scienceGoal, receiverBand, configuration, List.of(ReceiverBand.getReceiverBand(7)));
    }

    @Deprecated
    public static boolean isInBandWithLongbaselineConfigurationNonStandard(@NonNull ScienceGoal scienceGoal, @NonNull ReceiverBand receiverBand, @NonNull Configuration configuration, @NonNull Collection<ReceiverBand> collection) throws InvalidObsProgramParametersException, UnableToDetermineCalibrationTimeException, InvalidFrequencyException, SourceNeverVisibleException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (receiverBand == null) {
            throw new NullPointerException("receiverBand is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("best12mExtConfig is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("legalBands is marked non-null but is null");
        }
        if (!collection.contains(receiverBand)) {
            return false;
        }
        try {
            if (!ConfigurationSet.isConfigurationInSet(configuration, RequestedArray.TWELVE_M, "C43-8", "C43-9", "C43-10")) {
                return false;
            }
        }
        catch (Configuration.UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
            Log.logger(SingleFieldScienceGoalModel.class).finer("Unable to determine the configuration: " + unableToDetermineConfigurationException.getMessage());
            return false;
        }
        return false;
    }

    public static ExtrapolatedFluxValues getExtrapolatedFluxValues(@NonNull Configuration configuration, @NonNull ScienceGoal scienceGoal, @NonNull Optional<Frequency> optional, @NonNull DGCOnlineCalibratorExpert.AdjustedFluxValue adjustedFluxValue, @NonNull Frequency frequency, @NonNull S_AntennaCalculator s_AntennaCalculator) throws UnableToDetermineCalibrationTimeException, InvalidFrequencyException, SourceNeverVisibleException {
        if (configuration == null) {
            throw new NullPointerException("mostExtended12mConfig is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("nonOverlappingBWOverride is marked non-null but is null");
        }
        if (adjustedFluxValue == null) {
            throw new NullPointerException("candidateCalibrator is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("representativeFrequency is marked non-null but is null");
        }
        if (s_AntennaCalculator == null) {
            throw new NullPointerException("sAntennaCalculator is marked non-null but is null");
        }
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        SpectralMode spectralMode = spectralSetupParameters.isPureTDM() ? SpectralMode.TDM : SpectralMode.FDM;
        Time time = calibrationConfigurationHelper.getCalibrationTime(configuration, ObsType.PHASE, CorrelatorType.BL, CalibrationTimeQueryInterface.CalibrationTimeType.DEFAULTINTEGRATIONTIME, scienceGoal.getReceiverBand().getNumber(), spectralMode);
        Measurement measurement = adjustedFluxValue.getMeasurement();
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates();
        skyCoordinates.setLatitude(Latitude.createLatitude((double)measurement.getDec(), (String)Latitude.UNIT_DEG));
        skyCoordinates.setLongitude(Longitude.createLongitude((double)measurement.getRa(), (String)Longitude.UNIT_DEG));
        TargetParameters targetParameters = scienceGoal.getKeyTargetParameters().deepCopy();
        targetParameters.setSourceCoordinates(skyCoordinates);
        targetParameters.setType(TargetParameters.TYPE_F_MULTIPLEPOINTS);
        Frequency frequency2 = optional.orElseGet(() -> NonOverlappingBandwidthCalculator.getCalculator(spectralSetupParameters, scienceGoal.getKeyTargetParameters()).calculatePerPoln());
        ScienceGoal scienceGoal2 = scienceGoal.deepCopy();
        scienceGoal2.getSpectralSetupParameters().setOverrideLO1(Optional.of(frequency));
        ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator.Builder().scienceGoal(scienceGoal2).build();
        Sensitivity sensitivity = observingTimeCalculator.singlePointOnSourceSensitivity(Array.ARRAY_12M, time, targetParameters, frequency, frequency2);
        double d = s_AntennaCalculator.getS_Antenna(sensitivity);
        return new ExtrapolatedFluxValues(adjustedFluxValue.getTimeAdjustedFlux(), d);
    }

    public static double getS_Antenna(@NonNull Sensitivity sensitivity) {
        if (sensitivity == null) {
            throw new NullPointerException("s_image is marked non-null but is null");
        }
        int n = AlmaCapabilities.getInstance().getNominalNumAntennas(Array.ARRAY_12M);
        double d = (double)n * ((double)n - 1.0) / 2.0;
        return sensitivity.getJy() * Math.sqrt(d) / Math.sqrt((double)n - 3.0) * 15.0;
    }

    public static double getS_Antenna_ref(@NonNull Sensitivity sensitivity) {
        if (sensitivity == null) {
            throw new NullPointerException("s_image is marked non-null but is null");
        }
        int n = AlmaCapabilities.getInstance().getNominalNumAntennas(Array.ARRAY_12M);
        double d = (double)n * ((double)n - 1.0) / 2.0;
        return sensitivity.getJy() * Math.sqrt(d) / Math.sqrt((double)n - 3.0);
    }

    public static boolean isNarrowBWScienceGoal(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        Frequency frequency = Frequency.createFrequencyGHZ(0.9375);
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        if (SpectralSetupParameters.TYPE_FULL.equals(spectralSetupParameters.getType()) || SpectralSetupParameters.TYPE_CONTINUUM.equals(spectralSetupParameters.getType())) {
            Object object = UserFrequency.createUserFrequency();
            ArrayList<VupRange> arrayList = new ArrayList<VupRange>();
            for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                arrayList.add(FrequencyRange.fastCentredOn(scienceSpectralWindow.getCenterFrequency(), scienceSpectralWindow.getEffectiveBandwidth()));
            }
            List<VupRange> list = FrequencyRange.aggregate(arrayList);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                VupRange vupRange = (VupRange)iterator.next();
                object = (Frequency)object.plus((AbstractDoubleWithUnit)((Frequency)((Object)vupRange.range())));
            }
            if (object.isLessThan((AbstractDoubleWithUnit)frequency)) {
                Log.logger(SingleFieldScienceGoalModel.class).finer(scienceGoal.getName() + " is experimental: bandwidth switching detected - aggregate BW is " + (Frequency)((Object)object));
                return true;
            }
        } else if (SpectralSetupParameters.TYPE_SCAN.equals(spectralSetupParameters.getType())) {
            SpectralScan.SpectralScanTunings spectralScanTunings = null;
            SpectralScan spectralScan = spectralSetupParameters.getSpectralScan();
            try {
                spectralScanTunings = spectralScan.getTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                // empty catch block
            }
            FrequencyRange frequencyRange = null;
            try {
                frequencyRange = spectralScanTunings.getAchievedScanRange();
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
                // empty catch block
            }
            if (frequencyRange != null && ((Frequency)((Object)frequencyRange.range())).isLessThan((AbstractDoubleWithUnit)frequency)) {
                Log.logger(SingleFieldScienceGoalModel.class).finer("Bandwidth switching science goal detected: aggregate BW in scan is less than 1 GHz");
                return true;
            }
        }
        return false;
    }

    @Override
    public void publish() {
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (ScienceViewSpectralVisualEditor.OVERLAY_LINES_SELECTED_FID.equals(fieldID)) {
            this.spectralSetupParametersModel.update(editor, fieldID, object);
        }
        return object;
    }

    private ScienceGoal getScienceGoal() {
        if (this.document instanceof ScienceGoal) {
            return (ScienceGoal)this.document;
        }
        return null;
    }

    @Override
    public void setDocument(Object object) {
        Object object2 = object;
        if (object instanceof WorkbookPage) {
            object2 = ((WorkbookPage)object).getParent();
        }
        this.document = object2;
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (scienceGoal != null) {
            this.targetParametersTableModel.setDocument(scienceGoal);
            this.sgNoteModel.setDocument(scienceGoal);
            this.sfiControlParameterModel.setModelInTransitionState(true);
            this.sfiControlParameterModel.setonlyDocument(scienceGoal.getPerformanceParameters());
            this.spectralSetupParametersModel.setDocument((Object)scienceGoal.getSpectralSetupParameters());
            this.calibrationSetupParametersModel.setDocument((Object)scienceGoal.getCalibrationSetupParameters());
            this.sgFieldSetupModel.setDocument(scienceGoal);
            this.sfiControlParameterModel.setModelInTransitionState(false);
            this.sfiControlParameterModel.setDocument(scienceGoal.getPerformanceParameters());
            this.technicalJustificationModel.setonlyDocument(scienceGoal);
            this.spectralSetupParametersModel.restoreRF();
        }
        this.publish();
        try {
            ScienceGoalEditorViewEnum scienceGoalEditorViewEnum = ScienceGoalEditorViewEnum.getScienceGoalSubview(scienceGoal);
            if (scienceGoalEditorViewEnum != this.currentSubview || this.currentSubview.equals((Object)ScienceGoalEditorViewEnum.VLBI)) {
                this.publish(EDITOR_SUBVIEW_FID, (Object)scienceGoalEditorViewEnum);
                this.currentSubview = scienceGoalEditorViewEnum;
            }
        }
        catch (ScienceGoalEditorViewEnum.UnableToDetermineSubviewException unableToDetermineSubviewException) {
            // empty catch block
        }
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID == AbstractTargetEditor.FID_SOLARSYSTEMOBJECT || fieldID == ObsProposalEditor.PROPOSALTYPE_FID) {
            try {
                ScienceGoal scienceGoal = (ScienceGoal)this.getDocument();
                if (scienceGoal != null) {
                    this.getSfiControlParameterModel().setonlyDocument(scienceGoal.getPerformanceParameters());
                    ScienceGoalEditorViewEnum scienceGoalEditorViewEnum = ScienceGoalEditorViewEnum.getScienceGoalSubview(scienceGoal);
                    this.publish(EDITOR_SUBVIEW_FID, (Object)scienceGoalEditorViewEnum);
                    if (scienceGoalEditorViewEnum.equals((Object)ScienceGoalEditorViewEnum.SOLAR)) {
                        this.spectralSetupParametersModel.setSolarTDMSingleContinuum();
                    }
                }
            }
            catch (ScienceGoalEditorViewEnum.UnableToDetermineSubviewException unableToDetermineSubviewException) {
                // empty catch block
            }
        }
    }

    public void setKeyTargetParameter(int n) {
        if (this.scienceGoal == null) {
            return;
        }
        if (n < 0 || n > this.scienceGoal.getTargetParametersCount()) {
            return;
        }
        this.scienceGoal.setKeyTargetParameters(n);
    }

    public SgNoteModel getSgNoteModel() {
        return this.sgNoteModel;
    }

    public FieldSetupModel getSgFieldSetupModel() {
        return this.sgFieldSetupModel;
    }

    public SpectralSetupParametersModel getSpectralSetupParametersModel() {
        return this.spectralSetupParametersModel;
    }

    public SfiControlParameterModel getSfiControlParameterModel() {
        return this.sfiControlParameterModel;
    }

    @Override
    public CalibrationSetupParametersModel getCalibrationSetupParametersModel() {
        return this.calibrationSetupParametersModel;
    }

    public TargetParametersTableModel getTargetParametersTableModel() {
        return this.targetParametersTableModel;
    }

    public TechnicalJustificationModel getTechnicalJustificationModel() {
        return this.technicalJustificationModel;
    }

    public SpectralSpecDocument getContext() {
        return this.context;
    }

    static {
        try {
            calibrationConfigurationHelper = CalibrationConfigurationHelper.getInstance();
        }
        catch (FileNotFoundException | JAXBException throwable) {
            String string = "Unable to read in the configuration specific calibration parameter XML file : " + throwable.getMessage();
            Log.logger(SingleFieldScienceGoalModel.class).warning(string);
            throw new RuntimeException(string);
        }
    }

    public static class UnableToDetermineObservingModesException
    extends Exception {
        public UnableToDetermineObservingModesException(String string) {
            super(string);
        }
    }

    public static class ExtrapolatedFluxValues {
        private double s_rf;
        private double s_antenna;

        public double getS_rf() {
            return this.s_rf;
        }

        public double getS_antenna() {
            return this.s_antenna;
        }

        public void setS_rf(double d) {
            this.s_rf = d;
        }

        public void setS_antenna(double d) {
            this.s_antenna = d;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ExtrapolatedFluxValues)) {
                return false;
            }
            ExtrapolatedFluxValues extrapolatedFluxValues = (ExtrapolatedFluxValues)object;
            if (!extrapolatedFluxValues.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getS_rf(), extrapolatedFluxValues.getS_rf()) != 0) {
                return false;
            }
            return Double.compare(this.getS_antenna(), extrapolatedFluxValues.getS_antenna()) == 0;
        }

        protected boolean canEqual(Object object) {
            return object instanceof ExtrapolatedFluxValues;
        }

        public int hashCode() {
            int n = 1;
            long l = Double.doubleToLongBits(this.getS_rf());
            n = n * 59 + (int)(l >>> 32 ^ l);
            long l2 = Double.doubleToLongBits(this.getS_antenna());
            n = n * 59 + (int)(l2 >>> 32 ^ l2);
            return n;
        }

        public String toString() {
            return "SingleFieldScienceGoalModel.ExtrapolatedFluxValues(s_rf=" + this.getS_rf() + ", s_antenna=" + this.getS_antenna() + ")";
        }

        public ExtrapolatedFluxValues(double d, double d2) {
            this.s_rf = d;
            this.s_antenna = d2;
        }
    }

    public static enum NonStandardMode {
        EXPERIMENTAL_RECEIVERBANDS("One of band 9 or 10 has been selected."),
        FULL_POLARIZATION("Full polarization has been requested."),
        SPECTRAL_SCAN("A spectral scan has been requested."),
        LONGBASELINE_CONFIGURATION("No phase cal could be found - increase bandwidth if possible. Special calibration might be necessary."),
        USERDEFINED_CALIBRATION("A user-defined calibration strategy has been selected."),
        BANDWIDTH_SWITCHING("The aggregate bandwidth for the spectral setup is less than 1 GHz."),
        VLBI_MODE("This is a VLBI project"),
        SOLAR_MODE("Solar observing has been requested");

        private String explanation;

        private NonStandardMode(String string2) {
            this.explanation = string2;
        }

        public String getExplanation() {
            return this.explanation;
        }
    }
}

