/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;

abstract class CalibratorFieldSourceWorker {
    CalibratorFieldSourceWorker() {
    }

    private static PointingPattern getPointingPattern() {
        PointingPattern pointingPattern = PointingPattern.createPointingPattern();
        pointingPattern.setType(PointingPattern.TYPE_POINT);
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates(SkyCoordinates.TYPE_RELATIVE);
        skyCoordinates.setLongitude(Longitude.createLongitude((double)0.0, (String)Longitude.UNIT_ARCMIN));
        skyCoordinates.setLatitude(Latitude.createLatitude((double)0.0, (String)Latitude.UNIT_ARCMIN));
        pointingPattern.setPhaseCenterCoordinates(new SkyCoordinates[]{skyCoordinates});
        return pointingPattern;
    }

    protected static FieldSource createCalibratorFieldSource() {
        FieldSource fieldSource = FieldSource.createFieldSource();
        fieldSource.setFieldPattern((FieldPattern)((Object)CalibratorFieldSourceWorker.getPointingPattern()));
        return fieldSource;
    }

    protected static void setUpTPAmplitudeRasterScan(FieldSource fieldSource, SpectralSpec spectralSpec) {
        Frequency frequency;
        Frequency frequency2;
        try {
            frequency2 = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.LOWESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        UserAngle userAngle = UserAngle.createUserAngle(6.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency2);
        userAngle.setAntenna(Antenna.ANTENNA_12M);
        RectanglePattern rectanglePattern = RectanglePattern.createRectanglePattern();
        rectanglePattern.setLongitudeLength(userAngle);
        rectanglePattern.setLatitudeLength(userAngle);
        rectanglePattern.setPatternCenterCoordinates(SkyCoordinates.createOffsetCoordinates());
        rectanglePattern.getPatternCenterCoordinates().setType(SkyCoordinates.TYPE_RELATIVE);
        try {
            frequency = spectralSpec.getSpectralSpec().getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.HIGHESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        UserAngle userAngle2 = UserAngle.createUserAngle(0.31, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        userAngle2.setAntenna(Antenna.ANTENNA_12M);
        rectanglePattern.setOrthogonalStep(Angle.createAngle((double)((Angle)userAngle2.multiply(1.0)).getContentInUnits(UserAngle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC));
        fieldSource.setFieldPattern((FieldPattern)((Object)rectanglePattern));
    }
}

