/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.ArrayRequested;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ACASpectrometerCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.spectralspec.BLSpectralSpecWorker;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import java.util.Optional;
import lombok.NonNull;
import org.apache.axis.utils.StringUtils;

public class Walsh90DegConfiguratorFactory {
    public static Walsh90DegSpectralSpecConfigurator getConfigurator(@NonNull AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        if (abstractCorrelatorConfiguration == null) {
            throw new NullPointerException("abstractCorrelatorConfiguration is marked non-null but is null");
        }
        if (abstractCorrelatorConfiguration instanceof BLCorrelatorConfiguration) {
            return new BL90DegWalshConfigurator();
        }
        if (abstractCorrelatorConfiguration instanceof ACACorrelatorConfiguration || abstractCorrelatorConfiguration instanceof ACASpectrometerCorrelatorConfiguration) {
            return new ACA90DegWalshConfigurator();
        }
        throw new RuntimeException("Unknown correlator type specified: " + abstractCorrelatorConfiguration);
    }

    private static class BL90DegWalshConfigurator
    extends WalshSwitching90DegConfigurator
    implements Walsh90DegSpectralSpecConfigurator {
        private BL90DegWalshConfigurator() {
        }

        public boolean isHighDataRate(@NonNull SpectralSpec spectralSpec) {
            ArrayRequested arrayRequested;
            if (spectralSpec == null) {
                throw new NullPointerException("ss is marked non-null but is null");
            }
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
            boolean bl = abstractCorrelatorConfiguration instanceof BLCorrelatorConfiguration;
            ArrayRequested arrayRequested2 = arrayRequested = bl ? ArrayRequested.TWELVE_M : ArrayRequested.SEVEN_M;
            if (!bl) {
                if (spectralSpec.getParent() == null) {
                    SchedBlock object = SchedBlock.createSchedBlock();
                    object.addSpectralSpec(spectralSpec);
                }
                for (AbstractBaseBandConfig abstractBaseBandConfig : abstractCorrelatorConfiguration.getBaseBandConfig()) {
                    BaseBandSpecification baseBandSpecification = abstractBaseBandConfig.getBaseBandSpecification();
                    if (!StringUtils.isEmpty((String)baseBandSpecification.getEntityPartReference().getEntityId())) continue;
                    baseBandSpecification.getEntityPartReference().setEntityId("fake");
                }
            }
            abstractCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration, arrayRequested);
            DataRate dataRate = spectralSpec.getInstantaneousDataRate();
            Log.logger(BLSpectralSpecWorker.class).fine("instantaneousDataRate delivered by spectral spec is " + dataRate);
            return dataRate.isGreaterThan((AbstractDoubleWithUnit)DataRate.createDataRate((double)AlmaPolicies.getInstance().getWarning12mDataRateMBPS(), (String)DataRate.UNIT_MB_S));
        }

        @Override
        public void configureSpectralSpec(@NonNull SBGenerationContext sBGenerationContext, @NonNull SpectralSpec spectralSpec) {
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            if (spectralSpec == null) {
                throw new NullPointerException("ss is marked non-null but is null");
            }
            if (!(spectralSpec.getAbstractCorrelatorConfiguration() instanceof BLCorrelatorConfiguration)) {
                throw new IllegalArgumentException("abstractCorrelatorConfiguration should be of type BLCorrelatorConfiguration");
            }
            this.configureImageSpectralWindows(sBGenerationContext, spectralSpec);
            BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)spectralSpec.getAbstractCorrelatorConfiguration());
            boolean bl = this.isLongBaseline(sBGenerationContext);
            bLCorrelatorConfiguration.setDumpDuration(Time.createTime((double)2048.0, (String)Time.UNIT_MS));
            bLCorrelatorConfiguration.setChannelAverageDuration(Time.createTimeSec(2.048));
            if (!bl) {
                bLCorrelatorConfiguration.setIntegrationDuration(Time.createTimeSec(bLCorrelatorConfiguration.isTDM() ? 2.048 : 6.144));
            } else {
                bLCorrelatorConfiguration.setIntegrationDuration(Time.createTimeSec(this.isHighDataRate(spectralSpec) ? 4.096 : 2.048));
            }
        }

        @Override
        public void configureObservingParameters(@NonNull Target target, @NonNull SBGenerationContext sBGenerationContext) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            if (target.hasAmplitudeCalParameters()) {
                this.setAmplitudeObservingParametersFor90DegWalshSwitching(target, sBGenerationContext);
            } else if (target.hasCheckSourceCalParameters()) {
                this.setCheckSourceObservingParametersFor90DegWalshSwitching(target, sBGenerationContext);
            } else if (target.hasScienceParameters()) {
                this.setScienceObservingParametersFor90DegWalshSwitching(target, sBGenerationContext);
            } else if (target.hasBandpassCalParameters()) {
                this.setBandPassObservingParametersFor90DegWalshSwitching(target, sBGenerationContext);
            } else if (target.hasPhaseCalParameters()) {
                this.setPhaseCalObservingParametersFor90DegWalshSwitching(target, sBGenerationContext);
            }
        }

        private void setPhaseCalObservingParametersFor90DegWalshSwitching(@NonNull Target target, @NonNull SBGenerationContext sBGenerationContext) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            if (!target.hasPhaseCalParameters()) {
                throw new IllegalArgumentException("Illegal argument: target.hasPhaseCalParameters() (" + target.hasPhaseCalParameters() + ") did not pass the test: target.hasPhaseCalParameters() != true");
            }
            Configuration configuration = sBGenerationContext.getConfiguration();
            boolean bl = this.isLongBaseline(sBGenerationContext);
            boolean bl2 = configuration != null && configuration.getNumber() == 7;
            for (PhaseCalParameters phaseCalParameters : target.getPhaseCalParametersList()) {
                if (bl2) {
                    phaseCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(24.576), target));
                    continue;
                }
                if (bl) continue;
                phaseCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(61.44), target));
            }
        }

        private void setBandPassObservingParametersFor90DegWalshSwitching(@NonNull Target target, @NonNull SBGenerationContext sBGenerationContext) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            if (!target.hasBandpassCalParameters()) {
                throw new IllegalArgumentException("Illegal argument: target.hasBandpassCalParameters() (" + target.hasBandpassCalParameters() + ") did not pass the test: target.hasBandpassCalParameters() != true");
            }
            boolean bl = this.isLongBaseline(sBGenerationContext);
            boolean bl2 = this.isHighDataRate(target.getSpectralSpec());
            for (BandpassCalParameters bandpassCalParameters : target.getBandpassCalParametersList()) {
                if (bl) {
                    bandpassCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(bl2 ? Time.createTimeSec(307.2) : Time.createTimeSec(301.056), target));
                    continue;
                }
                bandpassCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(301.056), target));
            }
        }

        private void setScienceObservingParametersFor90DegWalshSwitching(@NonNull Target target, @NonNull SBGenerationContext sBGenerationContext) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            if (!target.hasScienceParameters()) {
                throw new IllegalArgumentException("Illegal argument: target.hasScienceParameters() (" + target.hasScienceParameters() + ") did not pass the test: target.hasScienceParameters() != true");
            }
            boolean bl = this.isLongBaseline(sBGenerationContext);
            for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                if (bl) {
                    scienceParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(24.576), target));
                    continue;
                }
                scienceParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(30.72), target));
            }
        }

        private void setCheckSourceObservingParametersFor90DegWalshSwitching(@NonNull Target target, @NonNull SBGenerationContext sBGenerationContext) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            if (!target.hasCheckSourceCalParameters()) {
                throw new IllegalArgumentException("Illegal argument: target.hasCheckSourceCalParameters() (" + target.hasCheckSourceCalParameters() + ") did not pass the test: target.hasCheckSourceCalParameters() != true");
            }
            Configuration configuration = sBGenerationContext.getConfiguration();
            boolean bl = this.isLongBaseline(sBGenerationContext);
            boolean bl2 = configuration != null && configuration.getNumber() == 7;
            for (CheckSourceCalParameters checkSourceCalParameters : target.getCheckSourceCalParametersList()) {
                if (bl2) {
                    checkSourceCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(24.576), target));
                    continue;
                }
                if (bl) continue;
                checkSourceCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(61.44), target));
            }
        }

        private void setAmplitudeObservingParametersFor90DegWalshSwitching(@NonNull Target target, @NonNull SBGenerationContext sBGenerationContext) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            if (!target.hasAmplitudeCalParameters()) {
                throw new IllegalArgumentException("Illegal argument: target.hasAmplitudeCalParameters() (" + target.hasAmplitudeCalParameters() + ") did not pass the test: target.hasAmplitudeCalParameters() != true");
            }
            boolean bl = this.isLongBaseline(sBGenerationContext);
            boolean bl2 = this.isHighDataRate(target.getSpectralSpec());
            for (AmplitudeCalParameters amplitudeCalParameters : target.getAmplitudeCalParametersList()) {
                if (bl) {
                    amplitudeCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(bl2 ? Time.createTimeSec(159.744) : Time.createTimeSec(153.6), target));
                    continue;
                }
                amplitudeCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(153.6), target));
            }
        }

        private boolean isLongBaseline(@NonNull SBGenerationContext sBGenerationContext) {
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            Configuration configuration = sBGenerationContext.getConfiguration();
            return configuration != null && configuration.isLongBaselineConfiguration();
        }

        @Override
        public void configureFieldSource(@NonNull Target target, @NonNull SBGenerationContext sBGenerationContext) {
            boolean bl;
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            boolean bl2 = this.isLongBaseline(sBGenerationContext);
            double d = bl2 ? ((bl = this.isHighDataRate(target.getSpectralSpec())) ? 12.288 : 6.144) : 6.144;
            assert (d > 0.0);
            for (Reference reference : target.getFieldSource().getReference()) {
                reference.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d), target));
            }
        }
    }

    private static class ACA90DegWalshConfigurator
    extends WalshSwitching90DegConfigurator
    implements Walsh90DegSpectralSpecConfigurator {
        private ACA90DegWalshConfigurator() {
        }

        public boolean isHighDataRate(@NonNull SpectralSpec spectralSpec) {
            if (spectralSpec == null) {
                throw new NullPointerException("ss is marked non-null but is null");
            }
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
            for (AbstractBaseBandConfig abstractBaseBandConfig : abstractCorrelatorConfiguration.getBaseBandConfig()) {
                for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                    if (spectralWindowI.getSpectralAveragingFactor() != 1) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void configureSpectralSpec(@NonNull SBGenerationContext sBGenerationContext, @NonNull SpectralSpec spectralSpec) {
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            if (spectralSpec == null) {
                throw new NullPointerException("spectralSpec is marked non-null but is null");
            }
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
            if (!(abstractCorrelatorConfiguration instanceof ACACorrelatorConfiguration) && !(abstractCorrelatorConfiguration instanceof ACASpectrometerCorrelatorConfiguration)) {
                throw new IllegalArgumentException("abstractCorrelatorConfiguration should be of type ACACorrelatorConfiguration/ACASpectrometerCorrelatorConfiguration");
            }
            this.configureImageSpectralWindows(sBGenerationContext, spectralSpec);
            abstractCorrelatorConfiguration.setChannelAverageDuration(Time.createTimeSec(2.048));
            if (abstractCorrelatorConfiguration.isTDM()) {
                abstractCorrelatorConfiguration.setIntegrationDuration(Time.createTimeSec(2.048));
            } else {
                boolean bl = this.isHighDataRate(spectralSpec);
                abstractCorrelatorConfiguration.setIntegrationDuration(Time.createTimeSec(bl ? 20.48 : 10.24));
                if (!bl) {
                    abstractCorrelatorConfiguration.setChannelAverageDuration(Time.createTimeSec(2.048));
                }
            }
        }

        @Override
        public void configureObservingParameters(@NonNull Target target, @NonNull SBGenerationContext sBGenerationContext) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            if (target.hasAmplitudeCalParameters()) {
                this.setAmplitudeObservingParametersFor90DegWalshSwitching(target, sBGenerationContext);
            } else if (target.hasCheckSourceCalParameters()) {
                this.setCheckSourceObservingParametersFor90DegWalshSwitching(target, sBGenerationContext);
            } else if (target.hasScienceParameters()) {
                this.setScienceObservingParametersFor90DegWalshSwitching(target, sBGenerationContext);
            } else if (target.hasBandpassCalParameters()) {
                this.setBandPassObservingParametersFor90DegWalshSwitching(target, sBGenerationContext);
            } else if (target.hasPhaseCalParameters()) {
                this.setPhaseCalObservingParametersFor90DegWalshSwitching(target, sBGenerationContext);
            }
        }

        private void setPhaseCalObservingParametersFor90DegWalshSwitching(@NonNull Target target, @NonNull SBGenerationContext sBGenerationContext) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            if (!target.hasPhaseCalParameters()) {
                throw new IllegalArgumentException("Illegal argument: target.hasPhaseCalParameters() (" + target.hasPhaseCalParameters() + ") did not pass the test: target.hasPhaseCalParameters() != true");
            }
            for (PhaseCalParameters phaseCalParameters : target.getPhaseCalParametersList()) {
                phaseCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(61.44), target));
            }
        }

        private void setBandPassObservingParametersFor90DegWalshSwitching(@NonNull Target target, @NonNull SBGenerationContext sBGenerationContext) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            if (!target.hasBandpassCalParameters()) {
                throw new IllegalArgumentException("Illegal argument: target.hasBandpassCalParameters() (" + target.hasBandpassCalParameters() + ") did not pass the test: target.hasBandpassCalParameters() != true");
            }
            SpectralSpec spectralSpec = target.getSpectralSpec();
            boolean bl = spectralSpec.getAbstractCorrelatorConfiguration().isTDM();
            double d = bl ? 301.056 : 307.2;
            for (BandpassCalParameters bandpassCalParameters : target.getBandpassCalParametersList()) {
                bandpassCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d), target));
            }
        }

        private void setScienceObservingParametersFor90DegWalshSwitching(Target target, SBGenerationContext sBGenerationContext) {
            if (!target.hasScienceParameters()) {
                throw new IllegalArgumentException("Illegal argument: target.hasScienceParameters() (" + target.hasScienceParameters() + ") did not pass the test: target.hasScienceParameters() != true");
            }
            boolean bl = target.getSpectralSpec().getAbstractCorrelatorConfiguration().isTDM();
            double d = bl ? 30.72 : 61.44;
            for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                scienceParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d), target));
            }
        }

        private void setCheckSourceObservingParametersFor90DegWalshSwitching(Target target, SBGenerationContext sBGenerationContext) {
            if (!target.hasCheckSourceCalParameters()) {
                throw new IllegalArgumentException("Illegal argument: target.hasCheckSourceCalParameters() (" + target.hasCheckSourceCalParameters() + ") did not pass the test: target.hasCheckSourceCalParameters() != true");
            }
            for (CheckSourceCalParameters checkSourceCalParameters : target.getCheckSourceCalParametersList()) {
                checkSourceCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(61.44), target));
            }
        }

        private void setAmplitudeObservingParametersFor90DegWalshSwitching(Target target, SBGenerationContext sBGenerationContext) {
            if (!target.hasAmplitudeCalParameters()) {
                throw new IllegalArgumentException("Illegal argument: target.hasAmplitudeCalParameters() (" + target.hasAmplitudeCalParameters() + ") did not pass the test: target.hasAmplitudeCalParameters() != true");
            }
            SpectralSpec spectralSpec = target.getSpectralSpec();
            boolean bl = spectralSpec.getAbstractCorrelatorConfiguration().isTDM();
            double d = bl ? 153.6 : 184.32;
            for (AmplitudeCalParameters amplitudeCalParameters : target.getAmplitudeCalParametersList()) {
                amplitudeCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d), target));
            }
        }

        @Override
        public void configureFieldSource(@NonNull Target target, @NonNull SBGenerationContext sBGenerationContext) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            SpectralSpec spectralSpec = target.getSpectralSpec();
            Optional<Object> optional = Optional.empty();
            boolean bl = spectralSpec.getAbstractCorrelatorConfiguration().isTDM();
            if (bl) {
                optional = Optional.of(6.144);
            } else if (!this.isHighDataRate(spectralSpec)) {
                optional = Optional.of(61.44);
            }
            if (optional.isPresent()) {
                for (Reference reference : target.getFieldSource().getReference()) {
                    reference.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec((Double)optional.get()), target));
                }
            }
        }
    }

    private static class WalshSwitching90DegConfigurator {
        private WalshSwitching90DegConfigurator() {
        }

        public void configureImageSpectralWindows(@NonNull SBGenerationContext sBGenerationContext, @NonNull SpectralSpec spectralSpec) {
            if (sBGenerationContext == null) {
                throw new NullPointerException("sbContext is marked non-null but is null");
            }
            if (spectralSpec == null) {
                throw new NullPointerException("ss is marked non-null but is null");
            }
            SpectralSetupParameters spectralSetupParameters = sBGenerationContext.getGoal().getSpectralSetupParameters();
            if (!spectralSetupParameters.isWalshSwitching()) {
                return;
            }
            for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                if (scienceSpectralWindow.getAdvancedWindowSetup().getUseImage()) continue;
                AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
                for (AbstractBaseBandConfig abstractBaseBandConfig : abstractCorrelatorConfiguration.getBaseBandConfig()) {
                    for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                        SideBandUse sideBandUse;
                        ScienceSpectralWindow scienceSpectralWindow2 = spectralWindowI.getScienceSpectralWindow();
                        if (scienceSpectralWindow2 == null || !scienceSpectralWindow2.getUUID().equals(scienceSpectralWindow.getUUID())) continue;
                        AbstractSpectralWindow abstractSpectralWindow = spectralWindowI.getLSB();
                        Frequency frequency = abstractSpectralWindow.getSkyFrequencyLSB();
                        Frequency frequency2 = scienceSpectralWindow.getCenterFrequencySky();
                        FrequencyRange frequencyRange = FrequencyRange.fastCentredOn(frequency, abstractSpectralWindow.getEffectiveBandwidth());
                        boolean bl = frequencyRange.contains(frequency2);
                        if (bl) {
                            sideBandUse = spectralWindowI.getSideBandUse().enableUSB(false);
                            spectralWindowI.changeSideBandUse(sideBandUse);
                            continue;
                        }
                        sideBandUse = spectralWindowI.getSideBandUse().enableLSB(false);
                        spectralWindowI.changeSideBandUse(sideBandUse);
                    }
                }
            }
        }
    }

    public static interface Walsh90DegSpectralSpecConfigurator {
        public void configureSpectralSpec(SBGenerationContext var1, SpectralSpec var2);

        public void configureObservingParameters(Target var1, SBGenerationContext var2);

        public void configureFieldSource(Target var1, SBGenerationContext var2);
    }
}

