/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.StandardCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.valuetypes.Frequency;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;

public class PointingCalForScienceGroupIntermediateTarget
extends StandardCalIntermediateTarget {
    @Override
    protected void determineAdditionalTargetsRequiredForSpectralScans(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray) {
        block6: {
            EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sbContext.getSchemaToUseForSBGeneration();
            assert (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN) || enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN_MULTIPLE_SB)) : "The SB generation schema should be spectral scan";
            try {
                SpectralScan.SpectralScanTunings spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
                if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
                    SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, (List<Frequency>)spectralScanTunings.getTunings().get(0));
                    int n = this.getObservingGroupManager().getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1);
                    Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n, this.sbContext);
                    this.completeTargetConstruction(target, spectralSetupParameters2, requestedArray, targetWithIntent);
                    target.getFieldSource().setName("Science pointing");
                    break block6;
                }
                if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN_MULTIPLE_SB)) {
                    Integer n = this.sbContext.getSpectralScanTuningIndex();
                    assert (n != null) : "The tuning index for which we should generate an SB should be specified";
                    SpectralSetupParameters spectralSetupParameters3 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, spectralScanTunings.getTuning(n));
                    int n2 = this.getObservingGroupManager().getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1);
                    Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters3, n2, this.sbContext);
                    this.completeTargetConstruction(target, spectralSetupParameters3, requestedArray, targetWithIntent);
                    break block6;
                }
                throw new RuntimeException("Unexpected schema type detected " + enumSet);
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
                Log.Logger logger = Log.logger((Object)this);
                logger.log(Level.WARNING, "Failed to create a point cal intermediate target for science group", (Throwable)exception);
                return;
            }
        }
    }

    public PointingCalForScienceGroupIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        super(targetWithIntent, spectralSetupParameters, requestedArray, ObsType.POINTING, observingGroupManager, n, ObservingGroupManager.ObservingGroupType.SCIENCE, enumSet, sBGenerationContext);
        this.setTargetPriority(1);
        Target target = (Target)this.targets.get(0);
        target.getObservingParameters(0).setName("PointingCalParameters (Science Group)");
        boolean bl = sBGenerationContext.getGoal().isSpectralScan();
        target.getFieldSource().setName(bl ? "Science pointing" : "Pointing Template (Science Group)");
    }

    public void assignMultipleVelocitySourceTargetsToObservingGroups(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, SBGenerationContext sBGenerationContext) {
        Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, n, sBGenerationContext);
        this.completeTargetConstruction(target, spectralSetupParameters, requestedArray, targetWithIntent);
    }
}

