/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.entity.xmlbinding.schedblock.types.RectanglePatternTScanningCoordinateSystemType;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntegrationTimeResolverInterface;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.StandardCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.TPReferencePositionWorker;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;

public class AmplitudeCalIntermediateTarget
extends StandardCalIntermediateTarget {
    @Override
    protected void determineAdditionalTargetsRequiredForSpectralScans(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray) {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sbContext.getSchemaToUseForSBGeneration();
        assert (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN) || enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN_MULTIPLE_SB)) : "The SB generation schema should be spectral scan";
        try {
            SpectralScan.SpectralScanTunings spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
            int n = this.getObservingGroupManager().getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.CALIBRATOR, 1);
            for (int i = 0; i < spectralScanTunings.getNumberOfTunings(); ++i) {
                SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, (List<Frequency>)spectralScanTunings.getTunings().get(i));
                Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n, this.sbContext);
                this.completeTargetConstruction(target, spectralSetupParameters2, requestedArray, targetWithIntent);
            }
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
            Log.Logger logger = Log.logger((Object)this);
            logger.log(Level.WARNING, "Failed to create an amplitude intermediate target ", (Throwable)exception);
            return;
        }
    }

    public AmplitudeCalIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, ObservingGroupManager.ObservingGroupType observingGroupType, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        super(targetWithIntent, spectralSetupParameters, requestedArray, ObsType.AMPLITUDE, observingGroupManager, n, observingGroupType, enumSet, sBGenerationContext);
        this.setTargetPriority(2);
        if (RequestedArray.TP.equals((Object)requestedArray)) {
            this.setupTPAmplitudeCalibrations();
        }
    }

    private void setupTPAmplitudeCalibrations() {
        for (Target target : this.targets) {
            if (!target.hasScienceParameters()) continue;
            for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                FieldPattern fieldPattern = target.getFieldSource().getFieldPattern();
                if (fieldPattern instanceof RectanglePattern) {
                    Frequency frequency;
                    RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldPattern);
                    rectanglePattern.setScanDirection(RectanglePattern.SCANDIRECTION_LONGITUDE);
                    rectanglePattern.setScanningCoordinateSystem(RectanglePatternTScanningCoordinateSystemType.J2000.toString());
                    double d = 0.0;
                    SpectralSpec spectralSpec = target.getSpectralSpec();
                    ValueUnitPair<Angle> valueUnitPair = SpectralSpecFactory.getL(null, spectralSpec, ObsType.AMPLITUDE);
                    assert (valueUnitPair != null);
                    try {
                        frequency = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.HIGHESTFREQUENCY);
                    }
                    catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
                        throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
                    }
                    UserAngle userAngle = UserAngle.createUserAngle(1.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
                    userAngle.setAntenna(Antenna.ANTENNA_12M);
                    double d2 = userAngle.getContentInUnits(Angle.UNIT_ARCSEC) * 1.0;
                    Time time = target.getSpectralSpec().getAbstractCorrelatorConfiguration().getIntegrationDuration();
                    double d3 = time.getContentInUnits(Time.UNIT_S) * valueUnitPair.getContentInUnits(Angle.UNIT_ARCSEC) * 5.0 / d2;
                    assert (d3 > 0.0);
                    d = CorrelatorExpert.TPCorrelatorConfiguratorHelper.calcSubscanDuration(d3, time.getContentInUnits(Time.UNIT_S));
                    assert (d > 0.0);
                    scienceParameters.setSubScanDuration(Time.createTime((double)d, (String)Time.UNIT_S));
                    Integer n = rectanglePattern.getRowCount();
                    Time time2 = Time.createTimeSec(d * (double)n.intValue() * 4.0);
                    scienceParameters.getIntegrationTime().setContentAndUnit((ValueUnitPair)time2);
                }
                TPReferencePositionWorker.setupReferencePosition(target);
            }
        }
    }

    @Override
    public Time get7mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        return this.getStandard7mB5AmplitudeCalibrationTime(spectralSetupParameters);
    }

    @Override
    public Time get12mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        return this.getStandard12mB5AmplitudeCalibrationTime(spectralSetupParameters);
    }

    @Override
    public Time get7mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        return this.getStandard7mB5AmplitudeCalibrationTime(spectralSetupParameters);
    }

    @Override
    public Time get12mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        return this.getStandard12mB5AmplitudeCalibrationTime(spectralSetupParameters);
    }

    private Time getStandard12mB5AmplitudeCalibrationTime(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        Time time = null;
        int n = spectralSetupParameters.getReceiverBand().getNumber();
        if (n == 5) {
            time = Time.createTime((double)2.5, (String)Time.UNIT_MIN);
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for ampcal" + n);
        }
        return time;
    }

    private Time getStandard7mB5AmplitudeCalibrationTime(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        Time time = null;
        int n = spectralSetupParameters.getReceiverBand().getNumber();
        if (n == 5) {
            time = Time.createTime((double)5.0, (String)Time.UNIT_MIN);
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for ampcal" + n);
        }
        return time;
    }
}

