/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.OUSStructureBuilder;
import alma.obsprep.services.generator.refactored.OUSStructureBuilderInterface;
import alma.obsprep.services.generator.refactored.SchedBlockConsolidator;
import alma.obsprep.services.generator.refactored.SchedBlockPostProcessor;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.StandardOUSStructureBuilder;
import alma.obsprep.services.generator.refactored.ousgenerator.OUSGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class Simultaneous12mAndACAOUSStructureBuilder
extends OUSStructureBuilder
implements OUSStructureBuilderInterface {
    public Simultaneous12mAndACAOUSStructureBuilder(OUSGenerator oUSGenerator, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        super(oUSGenerator, obsUnitSet, scienceGoal);
    }

    @Override
    public void createOUSStructure(SchedBlockPostProcessor schedBlockPostProcessor, Collection<ScienceGoal> collection2, Integer n, Boolean bl, Boolean bl2) {
        PerformanceParameters performanceParameters = this.userDefinedScienceGoal.getPerformanceParameters();
        for (int i = 0; i < n; ++i) {
            for (ScienceGoal scienceGoal : collection2) {
                Collection<Collection<SchedBlock>> collection3;
                try {
                    collection3 = this.getSchedBlocks(scienceGoal);
                }
                catch (UnknownEntityException | WizardSBGenerationException throwable) {
                    throw new WizardSBGenerationException(throwable);
                }
                this.bundleTPSBsInSameOUSGroup(collection3);
                for (Collection<SchedBlock> collection4 : collection3) {
                    for (ObsUnitSetComponent obsUnitSetComponent : collection4) {
                        for (Collection<SchedBlock> collection5 : collection3) {
                            for (SchedBlock schedBlock : collection5) {
                                if (obsUnitSetComponent.equals(schedBlock) || schedBlock.isTotalPowerAmpcalSB() || ((SchedBlock)obsUnitSetComponent).isTotalPowerAmpcalSB()) continue;
                                Log.logger(Simultaneous12mAndACAOUSStructureBuilder.class).info("SB " + (SchedBlock)obsUnitSetComponent + " to be simultaneously observed with " + schedBlock);
                                SchedulingConstraints schedulingConstraints = obsUnitSetComponent.getSchedulingConstraints();
                                schedulingConstraints.setIsSimultaneous(true);
                                schedulingConstraints.addSimultaneousSbUid(schedBlock.getEntityID());
                            }
                        }
                    }
                }
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                for (Collection<SchedBlock> collection6 : collection3) {
                    ObsUnitSetComponent obsUnitSetComponent;
                    if (collection6.isEmpty()) continue;
                    obsUnitSetComponent = this.ousGenerator.getGroupOUS();
                    this.rootOUS.addObsUnitSet((ObsUnitSet)obsUnitSetComponent);
                    this.addSBsToOUSes(n, performanceParameters, bl, i, scienceGoal, (ObsUnitSet)obsUnitSetComponent, collection6);
                    linkedHashMap.put(obsUnitSetComponent, collection6);
                }
                for (ObsUnitSet obsUnitSet : linkedHashMap.keySet()) {
                    schedBlockPostProcessor.postProcessSBGroup(n, performanceParameters, bl, i, scienceGoal, obsUnitSet, List.of((Collection)linkedHashMap.get(obsUnitSet)), Optional.of(linkedHashMap));
                }
                collection3.stream().forEach(collection -> collection.stream().forEach(SchedBlockConsolidator::consolidate));
            }
            this.setOUSAQUADataProcessingFlags(this.rootOUS);
            try {
                SchedBlockWorker.appendTuningIndicatorToSpectralSpecs(this.rootOUS);
                continue;
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(StandardOUSStructureBuilder.class).warning("Unable to re-label the spectral specs ");
            }
        }
    }

    private void bundleTPSBsInSameOUSGroup(@NonNull Collection<Collection<SchedBlock>> collection) {
        if (collection == null) {
            throw new NullPointerException("schedBlocksForSG is marked non-null but is null");
        }
        ArrayList<Collection<SchedBlock>> arrayList = new ArrayList<Collection<SchedBlock>>();
        Collection<SchedBlock> collection2 = null;
        for (Collection<SchedBlock> collection3 : collection) {
            for (SchedBlock schedBlock : collection3) {
                if (!schedBlock.isTotalPowerAmpcalSB() && !schedBlock.isTotalPowerScienceSB()) continue;
                if (collection2 == null) {
                    collection2 = collection3;
                    continue;
                }
                collection2.add(schedBlock);
                arrayList.add(collection3);
            }
        }
        collection.removeAll(arrayList);
    }
}

