/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedBlockControl;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Time;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import lombok.NonNull;

public class SchedblockExecutionTimeAdjuster {
    private Log.Logger logger;

    void adjustTOSInSBsToMatchRequestedMinimumExecutionTime(Time time, Time time2, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) throws UnknownEntityException, InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException {
        Log.logger(SchedBlockWorker.class).fine("ObsUnit : " + obsUnitSet + " project execution time : ");
        Time time3 = (Time)time2.minus((AbstractDoubleWithUnit)time);
        for (SchedBlock schedBlock : obsUnitSet.getSchedBlock()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            RequestedArray requestedArray;
            EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = SBGeneratorTemplate.determineSBGenerationSchema(scienceGoal, schedBlock.getObsUnitControl().getArrayRequested());
            Time time4 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
            RequestedArray requestedArray2 = requestedArray = scienceGoal.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
            if (!schedBlock.getObsUnitControl().getArrayRequested().equals(requestedArray.getType())) continue;
            ScienceParameters[] scienceParametersArray = Integer.valueOf(0);
            IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource();
            Log.logger(SchedBlockWorker.class).fine("Re-adjusting the execution time of the SB : " + schedBlock.getEntityID());
            HashMap<String, ScienceParameters> hashMap = new HashMap<String, ScienceParameters>();
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                for (Target target : observingGroup.getAllOrderedTargets(ScienceParameters.scienceParametersFilter)) {
                    object4 = target.getScienceParametersList()[0];
                    if (!object4.isIntegrationTimeChangeable()) continue;
                    object3 = scienceParametersArray;
                    scienceParametersArray = scienceParametersArray.intValue() + 1;
                    Integer n = scienceParametersArray;
                    for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                        intTimeSource = (IntTimeSource)intTimeSource.plus((AbstractDoubleWithUnit)scienceParameters.getIntegrationTime());
                        if (hashMap.containsKey(scienceParameters.getEntityPartId())) continue;
                        hashMap.put(scienceParameters.getEntityPartId(), scienceParameters);
                    }
                }
            }
            boolean bl = true;
            if (scienceParametersArray.intValue() > 0) {
                this.apportionAdditionalTOSToScienceParameters(enumSet, (Integer)scienceParametersArray, intTimeSource, hashMap);
            } else {
                bl = false;
            }
            int n = schedBlock.getSchedBlockControl().getExecutionCount();
            Time time5 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
            Time object72 = (Time)time5.minus((AbstractDoubleWithUnit)time4);
            if (object72.isLessThan((AbstractDoubleWithUnit)time3)) {
                object2 = (Time)time3.minus((AbstractDoubleWithUnit)object72);
                int n2 = (int)Math.ceil(((Time)object2).getContentInUnits(Time.UNIT_S) / (time5.getContentInUnits(Time.UNIT_S) / (double)n));
                schedBlock.getSchedBlockControl().setExecutionCount(n + n2);
                if (!bl) continue;
                object4 = (Time)Time.createTimeSec(30.0).divide(hashMap.size());
                object3 = Time.createTimeSec(0.0);
                boolean bl2 = false;
                block4: while (!bl2 && SchedblockExecutionTimeAdjuster.determineOUSExecutionTime(obsUnitSet, scienceGoal).isGreaterThan((AbstractDoubleWithUnit)time2)) {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        object = (ScienceParameters)((Object)hashMap.get(entry.getKey()));
                        Time time6 = (Time)object.getIntegrationTime().getTime().deepCopy().minus((AbstractDoubleWithUnit)object4);
                        if (time6.isGreaterThan((AbstractDoubleWithUnit)object3)) {
                            object.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time6.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
                            continue;
                        }
                        bl2 = true;
                        continue block4;
                    }
                }
                continue;
            }
            if (!bl) continue;
            object2 = (Time)Time.createTimeSec(30.0).divide(hashMap.size());
            Time time7 = Time.createTimeSec(0.0);
            boolean bl3 = false;
            object3 = new HashMap();
            block6: while (!bl3 && SchedblockExecutionTimeAdjuster.determineOUSExecutionTime(obsUnitSet, scienceGoal).isGreaterThan((AbstractDoubleWithUnit)time2)) {
                for (String string : hashMap.keySet()) {
                    ScienceParameters scienceParameters = (ScienceParameters)((Object)hashMap.get(string));
                    object = (Time)scienceParameters.getIntegrationTime().getTime().minus((AbstractDoubleWithUnit)object2);
                    if (object.isGreaterThan((AbstractDoubleWithUnit)time7)) {
                        object3.put(string, scienceParameters.getIntegrationTime());
                        scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)object.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
                        continue;
                    }
                    bl3 = true;
                    continue block6;
                }
            }
            if (!SchedblockExecutionTimeAdjuster.determineOUSExecutionTime(obsUnitSet, scienceGoal).isLessThan((AbstractDoubleWithUnit)time2)) continue;
            assert (object3.size() != 0);
            for (String string : hashMap.keySet()) {
                ScienceParameters scienceParameters = (ScienceParameters)((Object)hashMap.get(string));
                scienceParameters.setIntegrationTime((IntTimeSource)((Object)object3.get(string)));
            }
        }
    }

    private void adjustTOSInSBToMatchRequestedMinimumExecutionTime(Time time, SchedBlock schedBlock, ScienceGoal scienceGoal) throws UnknownEntityException, InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException {
        Time time2 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
        if (time2.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)time)) {
            return;
        }
        Time time3 = (Time)time.minus((AbstractDoubleWithUnit)time2);
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = SBGeneratorTemplate.determineSBGenerationSchema(scienceGoal, schedBlock.getObsUnitControl().getArrayRequested());
        RequestedArray requestedArray = scienceGoal.getPrincipalArray();
        if (schedBlock.getObsUnitControl().getArrayRequested().equals(requestedArray.getType())) {
            Time time4;
            Object object;
            Object object2;
            Object object3;
            int n = 0;
            IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource();
            Log.logger(SchedBlockWorker.class).fine("Re-adjusting the execution time of the SB : " + schedBlock.getEntityID());
            HashMap<String, ScienceParameters> hashMap = new HashMap<String, ScienceParameters>();
            for (Target object42 : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
                object3 = object42.getScienceParametersList()[0];
                if (!object3.isIntegrationTimeChangeable()) continue;
                ++n;
                for (Object object4 : object42.getScienceParametersList()) {
                    intTimeSource = (IntTimeSource)intTimeSource.plus((AbstractDoubleWithUnit)object4.getIntegrationTime());
                    if (hashMap.containsKey(object4.getEntityPartId())) continue;
                    hashMap.put(object4.getEntityPartId(), (ScienceParameters)((Object)object4));
                }
            }
            boolean bl = true;
            if (n > 0) {
                this.apportionAdditionalTOSToScienceParameters(enumSet, n, intTimeSource, hashMap);
            } else {
                bl = false;
            }
            Time time5 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
            object3 = (Time)time5.minus((AbstractDoubleWithUnit)time2);
            HashMap hashMap2 = new HashMap();
            Time time6 = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
            if (object3.isLessThan((AbstractDoubleWithUnit)time3)) {
                SchedBlockControl schedBlockControl = schedBlock.getSchedBlockControl();
                int n2 = schedBlockControl.getExecutionCount();
                object2 = (Time)time3.minus((AbstractDoubleWithUnit)object3);
                int n3 = (int)Math.ceil(((Time)object2).getContentInUnits(Time.UNIT_S) / (time5.getContentInUnits(Time.UNIT_S) / (double)n2));
                schedBlockControl.setExecutionCount(n2 + n3);
                Time time7 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
                if (time7.isLessThan((AbstractDoubleWithUnit)time)) {
                    schedBlockControl.setExecutionCount(schedBlockControl.getExecutionCount() + 1);
                }
                if (bl) {
                    Map.Entry<String, ScienceParameters> entry = Time.createTimeSec(0.0);
                    boolean bl2 = false;
                    object = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
                    Time time8 = Time.createTimeSec(30.0);
                    Time time9 = Time.createTimeSec(10.0);
                    while (!bl2 && object.isGreaterThan((AbstractDoubleWithUnit)time)) {
                        boolean bl3 = ((Time)object.minus((AbstractDoubleWithUnit)time)).isGreaterThan((AbstractDoubleWithUnit)time6);
                        time4 = (Time)(bl3 ? time8 : time9).divide(hashMap.size());
                        for (String string : hashMap.keySet()) {
                            ScienceParameters scienceParameters = hashMap.get(string);
                            Time time10 = (Time)scienceParameters.getIntegrationTime().getTime().minus((AbstractDoubleWithUnit)time4);
                            if (time10.isGreaterThan((AbstractDoubleWithUnit)entry)) {
                                hashMap2.put(string, scienceParameters.getIntegrationTime());
                                scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time10.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
                                continue;
                            }
                            bl2 = true;
                            break;
                        }
                        object = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
                    }
                }
            } else if (bl) {
                Object object4;
                Time time11 = (Time)Time.createTimeSec(30.0).divide(hashMap.size());
                object4 = Time.createTimeSec(0.0);
                boolean bl4 = false;
                block4: while (!bl4 && ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal).isGreaterThan((AbstractDoubleWithUnit)time)) {
                    for (Map.Entry<String, ScienceParameters> entry : hashMap.entrySet()) {
                        String string = entry.getKey();
                        object = hashMap.get(string);
                        time4 = (Time)object.getIntegrationTime().getTime().minus((AbstractDoubleWithUnit)time11);
                        if (time4.isGreaterThan((AbstractDoubleWithUnit)object4)) {
                            hashMap2.put(string, object.getIntegrationTime());
                            object.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time4.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
                            continue;
                        }
                        bl4 = true;
                        continue block4;
                    }
                }
            }
            if (ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal).isLessThan((AbstractDoubleWithUnit)time)) {
                assert (hashMap2.size() != 0);
                for (Map.Entry<String, ScienceParameters> entry : hashMap.entrySet()) {
                    object2 = entry.getKey();
                    ScienceParameters scienceParameters = hashMap.get(object2);
                    scienceParameters.setIntegrationTime((IntTimeSource)((Object)hashMap2.get(object2)));
                }
            }
        }
    }

    private void apportionAdditionalTOSToScienceParameters(EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, Integer n, IntTimeSource intTimeSource, Map<String, ScienceParameters> map) {
        double d = SchedBlockExpert.getNominalExecutionTimeToTOSRatio(enumSet);
        Time time = (Time)((Time)SchedBlockExpert.NOMINAL_SB_LENGTH.divide(d)).minus((AbstractDoubleWithUnit)intTimeSource.getTime());
        Time time2 = (Time)time.divide(n.intValue());
        for (String string : map.keySet()) {
            ScienceParameters scienceParameters = map.get(string);
            Time time3 = (Time)scienceParameters.getIntegrationTime().getTime().plus((AbstractDoubleWithUnit)time2);
            scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time3.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
        }
    }

    public static Time determineOUSExecutionTime(ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException, UnknownEntityException {
        Time time = Time.createTimeSec(0.0);
        for (ObsUnitSet obsUnitSetComponent : obsUnitSet.getObsUnitSet()) {
            time.aggregate(SchedblockExecutionTimeAdjuster.determineOUSExecutionTime(obsUnitSetComponent, scienceGoal));
        }
        for (ObsUnitSetComponent obsUnitSetComponent : obsUnitSet.getSchedBlock()) {
            time.aggregate(ObservingTimeCalculator.getExecutionTimeForSB((SchedBlock)obsUnitSetComponent, scienceGoal));
        }
        return time;
    }

    void enforceMinSBExecutionTime(Time time, @NonNull List<SchedBlock> list, @NonNull ScienceGoal scienceGoal) {
        if (list == null) {
            throw new NullPointerException("schedBlocks is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (time == null) {
            this.logger.warning("The minimum SB execution time is not set");
            return;
        }
        for (SchedBlock schedBlock : list) {
            try {
                this.adjustTOSInSBToMatchRequestedMinimumExecutionTime(time, schedBlock, scienceGoal);
            }
            catch (Exception exception) {
                this.logger.warning("Unable to increase the TOS in the science parameters : " + exception.getMessage());
                throw new WizardSBGenerationException(exception);
            }
            if (!this.logger.isLoggable(Level.FINE)) continue;
            try {
                Time time2 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
                this.logger.fine("Revised SB execution time : " + time2.getContentInUnits(Time.UNIT_MIN) + " mins  for SB " + schedBlock.getName() + " minimum time required was " + time.getContentInUnits(Time.UNIT_MIN));
            }
            catch (Exception exception) {
                this.logger.warning("Unable to determine the SB execution time : " + exception.getMessage());
            }
        }
    }

    void enforceProjectExecutionTime(@NonNull Time time, @NonNull ObsUnitSet obsUnitSet, @NonNull ScienceGoal scienceGoal) {
        Time time2;
        if (time == null) {
            throw new NullPointerException("minimumExecutionTime is marked non-null but is null");
        }
        if (obsUnitSet == null) {
            throw new NullPointerException("ous is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        try {
            time2 = SchedblockExecutionTimeAdjuster.determineOUSExecutionTime(obsUnitSet, scienceGoal);
        }
        catch (Exception exception) {
            this.logger.warning("Unable to determine the project execution time : " + exception.getMessage());
            throw new WizardSBGenerationException(exception);
        }
        this.logger.fine("Minimum execution time : " + time + " project time " + time2 + " for OUS " + obsUnitSet.getName());
        if (time2.isLessThan((AbstractDoubleWithUnit)time)) {
            try {
                this.adjustTOSInSBsToMatchRequestedMinimumExecutionTime(time2, time, obsUnitSet, scienceGoal);
            }
            catch (Exception exception) {
                this.logger.warning("Unable to increase the TOS in the science parameters : " + exception.getMessage());
                throw new WizardSBGenerationException(exception);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                try {
                    Time time3 = SchedblockExecutionTimeAdjuster.determineOUSExecutionTime(obsUnitSet, scienceGoal);
                    this.logger.fine("Revised project time : " + time3.getContentInUnits(Time.UNIT_MIN) + " mins ");
                }
                catch (Exception exception) {
                    this.logger.warning("Unable to determine the project execution time : " + exception.getMessage());
                }
            }
        }
    }

    void enforceSBExecutionTimesForContinuousMonitoring(int n, @NonNull ObsUnitSet obsUnitSet, @NonNull ScienceGoal scienceGoal) {
        if (obsUnitSet == null) {
            throw new NullPointerException("ousContaining12mExtendedArray is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        Time time = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
        Time time2 = scienceGoal.getPerformanceParameters().getMonitoringConstraint(n).getMonitoringLength();
        Time time3 = scienceGoal.isPolarizationObservation() ? (time2.isGreaterThan((AbstractDoubleWithUnit)time) ? time2 : time) : time2;
        this.enforceProjectExecutionTime(time3, obsUnitSet, scienceGoal);
    }

    public SchedblockExecutionTimeAdjuster(Log.Logger logger) {
        this.logger = logger;
    }
}

