/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.MonitoringConstraint;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TemporalParameters;
import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.TemporalConstraints;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.StandardOUSStructureBuilder;
import alma.obsprep.services.generator.refactored.TargetCache;
import alma.obsprep.services.generator.refactored.TotalPowerSBScienceTargetDistributor;
import alma.obsprep.services.generator.refactored.ousgenerator.OUSGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserSensitivity;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import lombok.NonNull;

public abstract class OUSStructureBuilder {
    protected OUSGenerator ousGenerator;
    protected ObsUnitSet rootOUS;
    protected ScienceGoal userDefinedScienceGoal;

    protected void addMultipleVisitRelativeTimeTemporalConstraintsToSB(int n, @NonNull SchedBlock schedBlock, @NonNull ScienceGoal scienceGoal) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Illegal argument: visitIndex (" + n + ") did not pass the test: visitIndex > -1");
        }
        VisitConstraint visitConstraint = scienceGoal.getPerformanceParameters().getVisitConstraint(n);
        if (visitConstraint == null) {
            throw new WizardSBGenerationException("Visit constraint null when not expected");
        }
        schedBlock.getUnitDependencies().setMargin(visitConstraint.getAllowedMargin().deepCopy());
    }

    protected void addSingleVisitTemporalConstraintsToSB(@NonNull SchedBlock schedBlock, @NonNull ScienceGoal scienceGoal) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        for (TemporalParameters temporalParameters : scienceGoal.getPerformanceParameters().getTemporalParameters()) {
            TemporalConstraints temporalConstraints = TemporalConstraints.createTemporalConstraints();
            temporalConstraints.setStartTime(temporalParameters.getStartTime());
            temporalConstraints.setEndTime(temporalParameters.getEndTime());
            schedBlock.addTemporalConstraints(temporalConstraints);
        }
    }

    @Deprecated
    protected void addContinuousMonitoringTemporalConstraintsToSB(int n, SchedBlock schedBlock, ScienceGoal scienceGoal) {
        MonitoringConstraint monitoringConstraint = scienceGoal.getPerformanceParameters().getMonitoringConstraint(n);
        if (monitoringConstraint == null) {
            throw new WizardSBGenerationException("Monitoring constraint null when not expected");
        }
        if (monitoringConstraint.hasIsFixedStart() && monitoringConstraint.getIsFixedStart()) {
            TemporalConstraints temporalConstraints = TemporalConstraints.createTemporalConstraints();
            temporalConstraints.setAllowedMargin(monitoringConstraint.getAllowedMargin());
            temporalConstraints.setStartTime(monitoringConstraint.getStartTime());
            schedBlock.addTemporalConstraints(temporalConstraints);
        }
        throw new UnsupportedOperationException("This method is deprecated - please check code for further advice");
    }

    protected void addMultipleVisitSpecificTimeTemporalConstraintsToSB(int n, @NonNull SchedBlock schedBlock, @NonNull ScienceGoal scienceGoal) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Illegal argument: visitIndex (" + n + ") did not pass the test: visitIndex < 0");
        }
        VisitConstraint visitConstraint = scienceGoal.getPerformanceParameters().getVisitConstraint(n);
        if (visitConstraint == null) {
            throw new WizardSBGenerationException("Visit constraint null when not expected");
        }
        if (visitConstraint.hasIsFixedStart() && visitConstraint.getIsFixedStart()) {
            long l = (long)visitConstraint.getAllowedMargin().getContentInUnits(Time.UNIT_MS);
            ZonedDateTime zonedDateTime = null;
            ZonedDateTime zonedDateTime2 = null;
            ZonedDateTime zonedDateTime3 = visitConstraint.getStartTimeInDate();
            zonedDateTime = zonedDateTime3.minus(l, ChronoUnit.MILLIS);
            zonedDateTime2 = zonedDateTime3.plus(l, ChronoUnit.MILLIS);
            assert (zonedDateTime != null && zonedDateTime2 != null);
            TemporalConstraints temporalConstraints = TemporalConstraints.createTemporalConstraints();
            temporalConstraints.setStartTime(TemporalParameters.convertDateToString(zonedDateTime));
            temporalConstraints.setEndTime(TemporalParameters.convertDateToString(zonedDateTime2));
            schedBlock.addTemporalConstraints(temporalConstraints);
        }
    }

    protected final void setNonStandardModeParameters(@NonNull ScienceGoal scienceGoal) throws UnknownEntityException {
        PerformanceParameters performanceParameters;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        ObsProposal obsProposal = this.userDefinedScienceGoal.getObsProposal();
        if (obsProposal != null && this.userDefinedScienceGoal.getObsProposal().isVLBIorPhasedArray()) {
            performanceParameters = scienceGoal.getPerformanceParameters();
            performanceParameters.setDesiredSensitivity(UserSensitivity.createUserSensitivity(1.0, UserSensitivity.UNIT_MJY));
            performanceParameters.setDesiredAngularResolution(UserAngle.createUserAngle(1.0, Angle.UNIT_MAS));
        }
        if (this.userDefinedScienceGoal.isSolarScienceGoal()) {
            performanceParameters = scienceGoal.getPerformanceParameters();
            performanceParameters.setDesiredSensitivity(UserSensitivity.createUserSensitivity(1.0, UserSensitivity.UNIT_MJY));
        }
    }

    protected final Collection<Collection<SchedBlock>> getSchedBlocks(@NonNull ScienceGoal scienceGoal) throws UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        ArrayList<Collection<SchedBlock>> arrayList = new ArrayList<Collection<SchedBlock>>();
        this.setNonStandardModeParameters(scienceGoal);
        try {
            TargetCache.getInstance().clearCache();
            for (SBGenerator sBGenerator : SBGeneratorFactory.getBuilders(scienceGoal)) {
                arrayList.addAll(sBGenerator.getSchedBlocks(scienceGoal));
            }
        }
        catch (UnknownEntityException | InvalidConfigurationParametersException | InvalidObsProgramParametersException throwable) {
            Log.logger(StandardOUSStructureBuilder.class).warning("Unable to get SB builders: " + throwable.getMessage());
            throw new WizardSBGenerationException("Unable to get schedblocks " + throwable.getMessage());
        }
        return arrayList;
    }

    protected void addSBsToOUSes(int n, PerformanceParameters performanceParameters, boolean bl, int n2, ScienceGoal scienceGoal, ObsUnitSet obsUnitSet, Collection<SchedBlock> collection) {
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        for (SchedBlock schedBlock2 : collection) {
            List<SchedBlock> list;
            try {
                if (schedBlock2.isTotalPowerScienceSB() && !scienceGoal.isSolarScienceGoal()) {
                    list = new TotalPowerSBScienceTargetDistributor(schedBlock2).ensureAllSourcesObservableWithinTPSBExecutionTOS();
                    arrayList.addAll(list);
                } else {
                    list = List.of(schedBlock2);
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                throw new WizardSBGenerationException(unknownEntityException);
            }
            for (SchedBlock schedBlock3 : list) {
                ObsUnitSet obsUnitSet2 = this.ousGenerator.getMemberOUS();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                String string = "Unknown";
                schedBlock3.setObsUnitSet(this.rootOUS);
                schedBlock3.setStatus(obsUnitSet2.getStatus());
                obsUnitSet2.addSchedBlock(schedBlock3);
                try {
                    string = schedBlock3.getSchedulingConstraints().getRepresentativeTarget().getFieldSource().getSourceName();
                }
                catch (NullPointerException nullPointerException) {
                    Log.logger(StandardOUSStructureBuilder.class).warning("targetName is not set when it should be when determining the rep. target.");
                }
                arrayList2.add(schedBlock3.getObsUnitControl().getArrayRequested());
                PerformanceParameters.TemporalConstraintType temporalConstraintType = performanceParameters.getTemporalConstraintType(n2);
                switch (temporalConstraintType) {
                    case MULTIPLEVISIT_RELATIVEDATES: {
                        this.addMultipleVisitRelativeTimeTemporalConstraintsToSB(n2, schedBlock3, scienceGoal);
                        break;
                    }
                    case MULTIPLEVISIT_SPECIFIC_DATES: {
                        this.addMultipleVisitSpecificTimeTemporalConstraintsToSB(n2, schedBlock3, scienceGoal);
                        break;
                    }
                    case SINGLE_VISIT: {
                        this.addSingleVisitTemporalConstraintsToSB(schedBlock3, scienceGoal);
                        break;
                    }
                    case CONTINOUS_MONITORING: 
                    case NO_TEMPORAL_CONSTRAINTS: {
                        break;
                    }
                    default: {
                        throw new WizardSBGenerationException("Unable to process time constraint type of " + temporalConstraintType);
                    }
                }
                if (bl) {
                    this.addContinuousMonitoringTemporalConstraintsToSB(n2, schedBlock3, scienceGoal);
                }
                if (n > 1) {
                    int n3 = n2 + 1;
                    obsUnitSet2.setName("Member OUS (" + string + ")  - Visit " + n3 + ")");
                } else {
                    obsUnitSet2.setName("Member OUS (" + string + ")");
                }
                String string2 = "unknown";
                for (String string3 : arrayList2) {
                    string2 = Array.getArray(string3, string2).toString();
                }
                obsUnitSet2.getObsUnitControl().setArrayRequested(Array.getArray(string2).getName());
                obsUnitSet.addObsUnitSet(obsUnitSet2);
            }
        }
        arrayList.stream().filter(schedBlock -> !collection.contains(schedBlock)).forEach(collection::add);
    }

    protected void setOUSAQUADataProcessingFlags(@NonNull ObsUnitSet obsUnitSet) {
        if (obsUnitSet == null) {
            throw new NullPointerException("topLevelOUS is marked non-null but is null");
        }
        Stream.of(obsUnitSet.getObsUnitSet()).forEach(this::setOUSAQUADataProcessingFlags);
        try {
            Stream.of(obsUnitSet.getSchedBlock()).forEach(schedBlock -> schedBlock.getDataProcessingParameters().stream().forEach(aQUADataProcessingFlags -> obsUnitSet.getDataProcessingParameters().addDataProcessingAttentionFlag(aQUADataProcessingFlags.toString())));
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new WizardSBGenerationException("Unable to set AQUA data processing flagsin SB: " + unknownEntityException.getMessage());
        }
    }

    public OUSStructureBuilder(OUSGenerator oUSGenerator, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        this.ousGenerator = oUSGenerator;
        this.rootOUS = obsUnitSet;
        this.userDefinedScienceGoal = scienceGoal;
    }
}

