/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ACAPhaseSwitchingConfiguration;
import alma.obsprep.bo.schedblock.ACASpectrometerCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.dgcpostprocessor.DGCObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.DGCB2BReferenceSpectralSpecBuilderBase;
import alma.valuetypes.Time;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.NonNull;

public class DGCPostProcessor {
    @NonNull
    private final SchedBlock sb;

    public void postProcessDGCTargets() {
        this.assignDGCScienceTargetFieldSourceToDGCRefTargetFieldSource();
        this.assignScienceTargetSpectralSpecToDGCScienceTarget();
        this.assignCalibratorSpectralSpecToDGCReferenceSpectralSpec();
        this.assignScienceSpectralSpecToBPScienceCalibrator();
        CalibrationSetupParameters calibrationSetupParameters = this.sb.getSbGenerationContext().getGoal().getCalibrationSetupParameters();
        if (calibrationSetupParameters.isAmplitudeSpecificSystemDefinedCalibration()) {
            this.assignCalibratorSpectralSpecToDGCReferenceSpectralSpec();
            this.reassignAmpCalSpectralSpecs();
        }
        this.reassignPhaseCalCalibratorSpectralSpec();
        this.correctCorrelatorConfigurations();
        this.configureInternalCycleCount();
        DGCObservingParametersFactory.getParameterConfigurator(this.sb).configureDGCTargets();
    }

    private void configureInternalCycleCount() {
        int n;
        List<Target> list = this.sb.getAllTargets(DGCScienceCalParameters.DGCScienceCalParametersFilter);
        if (list.isEmpty()) {
            return;
        }
        SBGenerationContext sBGenerationContext = this.sb.getSbGenerationContext();
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = sBGenerationContext.getSchemaToUseForSBGeneration();
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the DGC multiple tuning scenario yet");
        }
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW)) {
            n = 3;
        } else {
            SpectralSpec spectralSpec = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter).get(0).getSpectralSpec();
            n = DGCB2BReferenceSpectralSpecBuilderBase.lookUpDGCB2BRefData(spectralSpec.getReceiverBand(), spectralSpec.getLO1Frequency()).getInternalCycleCount();
        }
        list.forEach(target -> target.getFirstDGCScienceParameters().ifPresent(dGCScienceCalParameters -> dGCScienceCalParameters.setInternalCycleCount(n)));
    }

    private void reassignAmpCalSpectralSpecs() {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sb.getSbGenerationContext().getSchemaToUseForSBGeneration();
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the DGC multiple tuning scenario yet");
        }
        List<Target> list = this.sb.getAllTargets(AmplitudeCalParameters.ampCalParametersFilter);
        List<Target> list2 = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        List<Target> list3 = this.sb.getAllTargets(DGCReferenceCalParameters.DGCReferenceCalParametersFilter);
        if (list2.size() > 1) {
            throw new IllegalArgumentException("Expecting only a single science target for a single tuning");
        }
        if (list.size() != 2) {
            throw new IllegalArgumentException("Expecting to find two ampcals in a DGC setup");
        }
        list.get(0).setSpectralSpec(list2.get(0).getSpectralSpec());
        list.get(1).setSpectralSpec(list3.get(0).getSpectralSpec());
    }

    private void correctCorrelatorConfigurations() {
        List<Target> list = this.sb.getAllTargets(DGCReferenceCalParameters.DGCReferenceCalParametersFilter);
        List<Target> list2 = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        if (list2.isEmpty() || list.isEmpty()) {
            throw new WizardSBGenerationException("Unable to find any science/DGC reference targets");
        }
        Target target3 = list2.get(0);
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = target3.getSpectralSpec().getCorrelatorConfiguration();
        list.stream().forEach(target2 -> {
            SpectralSpec spectralSpec = target2.getSpectralSpec();
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration2 = spectralSpec.getCorrelatorConfiguration();
            abstractCorrelatorConfiguration2.setIntegrationDuration(abstractCorrelatorConfiguration.getIntegrationDuration().deepCopy());
            abstractCorrelatorConfiguration2.setChannelAverageDuration(abstractCorrelatorConfiguration.getChannelAverageDuration().deepCopy());
            abstractCorrelatorConfiguration2.setEnable180DegreeWalshFunction(abstractCorrelatorConfiguration.getEnable180DegreeWalshFunction());
            abstractCorrelatorConfiguration2.setAPCDataSets(abstractCorrelatorConfiguration.getAPCDataSets());
            abstractCorrelatorConfiguration2.setCAM(abstractCorrelatorConfiguration.getCAM());
            if (!spectralSpec.getReceiverBand().is90DegWalshSwitchingCapable()) {
                abstractCorrelatorConfiguration2.setEnable90DegreeWalshFunction(false);
            }
            if (target3.getSpectralSpec().isACASpectralSpec()) {
                AbstractCorrelatorConfiguration abstractCorrelatorConfiguration3 = target3.getSpectralSpec().getCorrelatorConfiguration();
                if (abstractCorrelatorConfiguration3 instanceof ACACorrelatorConfiguration) {
                    ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration = ((ACACorrelatorConfiguration)((Object)((Object)abstractCorrelatorConfiguration2))).getACAPhaseSwitchingConfiguration();
                    ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration2 = ((ACACorrelatorConfiguration)((Object)((Object)abstractCorrelatorConfiguration))).getACAPhaseSwitchingConfiguration();
                    aCAPhaseSwitchingConfiguration.setDoD180demodulation(aCAPhaseSwitchingConfiguration2.getDoD180demodulation());
                    aCAPhaseSwitchingConfiguration.setDoD180modulation(aCAPhaseSwitchingConfiguration2.getDoD180modulation());
                } else if (abstractCorrelatorConfiguration3 instanceof ACASpectrometerCorrelatorConfiguration) {
                    ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration = ((ACASpectrometerCorrelatorConfiguration)((Object)((Object)abstractCorrelatorConfiguration2))).getACAPhaseSwitchingConfiguration();
                    ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration3 = ((ACASpectrometerCorrelatorConfiguration)((Object)((Object)abstractCorrelatorConfiguration))).getACAPhaseSwitchingConfiguration();
                    aCAPhaseSwitchingConfiguration.setDoD180demodulation(aCAPhaseSwitchingConfiguration3.getDoD180demodulation());
                    aCAPhaseSwitchingConfiguration.setDoD180modulation(aCAPhaseSwitchingConfiguration3.getDoD180modulation());
                }
            } else if (target3.getSpectralSpec().isBLSpectralSpec()) {
                BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)((Object)abstractCorrelatorConfiguration2));
                BLCorrelatorConfiguration bLCorrelatorConfiguration2 = (BLCorrelatorConfiguration)((Object)((Object)abstractCorrelatorConfiguration));
                bLCorrelatorConfiguration.setDumpDuration(bLCorrelatorConfiguration2.getDumpDuration().deepCopy());
            } else {
                throw new WizardSBGenerationException("Unknown correlator found");
            }
        });
        list.stream().forEach(target -> {
            Time time = SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(12.0), target);
            Stream.of(target.getDGCReferenceCalParametersList()).forEach(dGCReferenceCalParameters -> dGCReferenceCalParameters.setSubScanDuration(time.deepCopy()));
        });
        this.alignCalibratorSubscanDurations();
    }

    private void assignScienceTargetSpectralSpecToDGCScienceTarget() {
        @NonNull SpectralSpec spectralSpec = this.sb.getScienceTargets().get(0).getSpectralSpec();
        @NonNull List<Target> list = this.sb.getAllUnorderedTargets(DGCScienceCalParameters.DGCScienceCalParametersFilter.get());
        if (list.isEmpty()) {
            throw new WizardSBGenerationException("No DGC science targets have been found");
        }
        list.stream().forEach(target -> target.setSpectralSpec(spectralSpec));
    }

    private void assignDGCScienceTargetFieldSourceToDGCRefTargetFieldSource() {
        @NonNull List<Target> list = this.sb.getAllUnorderedTargets(DGCScienceCalParameters.DGCScienceCalParametersFilter.get());
        if (list.isEmpty()) {
            throw new WizardSBGenerationException("No DGC science targets have been found");
        }
        @NonNull List<Target> list2 = this.sb.getAllUnorderedTargets(DGCReferenceCalParameters.DGCReferenceCalParametersFilter.get());
        if (list2.isEmpty()) {
            throw new WizardSBGenerationException("No DGC reference targets have been found");
        }
        FieldSource fieldSource = list.get(0).getFieldSource();
        list2.forEach(target -> {
            this.sb.removeFieldSource(target.getFieldSource());
            target.setFieldSource(fieldSource);
        });
        fieldSource.setName("DGC");
    }

    private void reassignPhaseCalCalibratorSpectralSpec() {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sb.getSbGenerationContext().getSchemaToUseForSBGeneration();
        if (!enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC)) {
            return;
        }
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the multiple tuning scenario yet");
        }
        List<Target> list = this.sb.getAllTargets(PhaseCalParameters.phaseCalParametersFilter);
        SpectralSpec spectralSpec = this.sb.getAllUnorderedTargets(DGCReferenceCalParameters.DGCReferenceCalParametersFilter.get()).get(0).getSpectralSpec();
        list.stream().forEach(target -> target.setSpectralSpec(spectralSpec));
    }

    private void alignCalibratorSubscanDurations() {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sb.getSbGenerationContext().getSchemaToUseForSBGeneration();
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the multiple tuning scenario yet");
        }
        List<Target> list = this.sb.getAllTargets(PhaseCalParameters.phaseCalParametersFilter);
        list.stream().forEach(target -> Stream.of(target.getFieldSource().getReference()).forEach(reference -> reference.setSubScanDuration(target.getSpectralSpec().getAbstractCorrelatorConfiguration().getIntegrationDuration().deepCopy())));
        for (Optional<Predicate<Target>> optional : List.of(BandpassCalParameters.bandpassParametersFilter, AmplitudeCalParameters.ampCalParametersFilter, PhaseCalParameters.phaseCalParametersFilter)) {
            List<Target> list2 = this.sb.getAllTargets(optional);
            list2.stream().forEach(target -> Stream.of(target.getFieldSource().getReference()).forEach(reference -> reference.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(reference.getSubScanDuration(), target))));
        }
    }

    private void assignCalibratorSpectralSpecToDGCReferenceSpectralSpec() {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sb.getSbGenerationContext().getSchemaToUseForSBGeneration();
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the DGC multiple tuning scenario yet");
        }
        List<Target> list = this.sb.getAllTargets(BandpassCalParameters.bandpassParametersFilter);
        List<Target> list2 = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        List<Target> list3 = this.sb.getAllUnorderedTargets(DGCReferenceCalParameters.DGCReferenceCalParametersFilter.get());
        long l = list.stream().filter(target -> list2.stream().anyMatch(target2 -> target.getSpectralSpec().equals(target2.getSpectralSpec()))).count();
        boolean bl = false;
        for (Target target2 : list) {
            SpectralSpec spectralSpec = target2.getSpectralSpec();
            boolean bl2 = l > 1L && !bl;
            boolean bl3 = list2.stream().map(Target::getSpectralSpec).anyMatch(spectralSpec2 -> spectralSpec.equals(spectralSpec2));
            if (bl3) {
                if (!bl2) continue;
                bl = true;
            }
            SpectralSpec spectralSpec3 = list3.get(0).getSpectralSpec();
            target2.setSpectralSpec(spectralSpec3);
            ObservingParameters observingParameters = target2.getObservingParameters()[0];
            observingParameters.setName(observingParameters.getClass().getSimpleName() + "(" + spectralSpec3.getName() + ")");
            break;
        }
    }

    private void assignScienceSpectralSpecToBPScienceCalibrator() {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sb.getSbGenerationContext().getSchemaToUseForSBGeneration();
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the DGC multiple tuning scenario yet");
        }
        boolean bl = enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW);
        if (bl) {
            this.assignBWSWSpectralSpecsToDGCBandpassCalibrators();
        } else {
            this.assignB2BSpectralSpecsToDGCBandpassCalibrators();
        }
    }

    private void assignB2BSpectralSpecsToDGCBandpassCalibrators() {
        List<Target> list = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        for (Target target : this.sb.getAllTargets(BandpassCalParameters.bandpassParametersFilter)) {
            SpectralSpec spectralSpec = target.getSpectralSpec();
            if (!spectralSpec.getName().contains("TDM")) continue;
            Target target2 = list.get(0);
            SpectralSpec spectralSpec2 = target2.getSpectralSpec();
            target.setSpectralSpec(spectralSpec2);
            BandpassCalParameters bandpassCalParameters = target.getBandpassCalParametersList()[0];
            bandpassCalParameters.setName(((Object)((Object)bandpassCalParameters)).getClass().getSimpleName() + "(" + spectralSpec2.getName() + ")");
        }
    }

    private void assignBWSWSpectralSpecsToDGCBandpassCalibrators() {
        List<Target> list = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        block4: for (Target target2 : this.sb.getAllTargets(BandpassCalParameters.bandpassParametersFilter)) {
            BandpassCalParameters.BandpassSubType bandpassSubType = target2.getBandpassCalParametersList()[0].getBandPassSubtype().orElseThrow(WizardSBGenerationException::new);
            BandpassCalParameters bandpassCalParameters = null;
            switch (bandpassSubType) {
                case DGCReferenceBandPass: {
                    SpectralSpec spectralSpec = this.sb.getAllTargets(Optional.empty()).stream().filter(target -> target.getSpectralSpec().getName().contains("BWSW")).map(target -> target.getSpectralSpec()).findFirst().orElseThrow(WizardSBGenerationException::new);
                    target2.setSpectralSpec(spectralSpec);
                    bandpassCalParameters = target2.getBandpassCalParametersList()[0];
                    bandpassCalParameters.setName(((Object)((Object)bandpassCalParameters)).getClass().getSimpleName() + "(" + spectralSpec.getName() + ")");
                    continue block4;
                }
                case DGCScienceBandPass: {
                    Target target3 = list.get(0);
                    SpectralSpec spectralSpec = target3.getSpectralSpec();
                    target2.setSpectralSpec(spectralSpec);
                    bandpassCalParameters = target2.getBandpassCalParametersList()[0];
                    bandpassCalParameters.setName(((Object)((Object)bandpassCalParameters)).getClass().getSimpleName() + "(" + spectralSpec.getName() + ")");
                    continue block4;
                }
            }
            throw new WizardSBGenerationException("Unable to handle bandpass subtype " + bandpassSubType);
        }
    }

    public DGCPostProcessor(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        this.sb = schedBlock;
    }
}

