/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.Measurement;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.BackgroundCalibratorDatabaseInteractor;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.RequiredConfigurations;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.UnableToDetermineCalibrationTimeException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.python.google.common.base.Objects;

public class DGCOnlineCalibratorExpert
extends DGCExpert {
    private static final CacheAccess<Double, List<Measurement>> calibratorMeasurementResultsCache = JCS.getInstance((String)"calibratorResults");
    public static final Supplier<? extends Exception> UnableToQueryCatalogueException = () -> new UnableToQueryCatalogueException("Unable query online calibrator catalogue");

    @Override
    public boolean isDGCScheduled(@NonNull ScienceGoal scienceGoal, boolean bl) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        return !Sets.intersection(this.dgcObservingStrategiesRequired(scienceGoal, true), DGCExpert.allDGCStrategies).isEmpty();
    }

    @Override
    public Set<DGCExpert.DGCTypeEnum> resolveWhichDGCStrategyToUse(@NonNull ScienceGoal scienceGoal, @NonNull RequestedArray requestedArray, @NonNull Optional<SBGeneratorTemplate.SchedBlockType> optional, Set<DGCExpert.DGCTypeEnum> set, Optional<EnumSet<SBGeneratorTemplate.SBGenerationSchema>> optional2) {
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("sbType is marked non-null but is null");
        }
        if (!set.containsAll(DGCExpert.allDGCStrategies)) {
            return set;
        }
        EnumSet<DGCExpert.DGCTypeEnum> enumSet = EnumSet.noneOf(DGCExpert.DGCTypeEnum.class);
        if (!this.isScienceGoalSetupPreconditionsForDGCSatisfied(scienceGoal)) {
            return enumSet;
        }
        return Set.of(this.isB2BScheduled(scienceGoal, false).isB2BCompliant() ? DGCExpert.DGCTypeEnum.DGCBandToBand : DGCExpert.DGCTypeEnum.DGCBandwidthSwitching);
    }

    private SBGenerationContext createSBGenerationContext(ScienceGoal scienceGoal, RequestedArray requestedArray, Optional<SBGeneratorTemplate.SchedBlockType> optional, Optional<EnumSet<SBGeneratorTemplate.SBGenerationSchema>> optional2) {
        SBGenerationContext sBGenerationContext = new SBGenerationContext();
        try {
            sBGenerationContext.setArray(requestedArray).setScienceGoal(scienceGoal).setSB(SchedBlock.createSchedBlock()).setSBType(optional.orElse(SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION)).setConfiguration(Configuration.getMostCompactConfiguration(RequestedArray.TWELVE_M)).setSBGenerationSchema(optional2.orElseGet(() -> EnumSet.noneOf(SBGeneratorTemplate.SBGenerationSchema.class)));
        }
        catch (Configuration.UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
            throw new WizardSBGenerationException("Unable to create SB generation context");
        }
        return sBGenerationContext;
    }

    @Override
    public DGCExpert.B2BSchedulingOutcome isB2BScheduled(@NonNull ScienceGoal scienceGoal, boolean bl) {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        if (bl && scienceGoal.getCalibrationSetupParameters().getIsDGCOverride()) {
            return DGCExpert.B2BSchedulingOutcome.NotScheduled;
        }
        return this.isB2BRequirementsMet(scienceGoal);
    }

    @Override
    public DGCExpert.B2BSchedulingOutcome isB2BRequirementsMet(@NonNull ScienceGoal scienceGoal) {
        Optional<AdjustedFluxValue> optional;
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (!this.isScienceGoalSetupPreconditionsForDGCSatisfied(scienceGoal)) {
            return DGCExpert.B2BSchedulingOutcome.ScienceGoalConfigurationIncompatible;
        }
        if (MiscUtils.isForceB2B() || scienceGoal.getCalibrationSetupParameters().isForcedB2BDGC()) {
            return DGCExpert.B2BSchedulingOutcome.Scheduled;
        }
        if (scienceGoal.getCalibrationSetupParameters().isForcedDGCBWSW()) {
            return DGCExpert.B2BSchedulingOutcome.UseBWSW;
        }
        Configuration configuration = null;
        try {
            object = scienceGoal.getPerformanceParameters().getRepresentativeFrequency();
            configuration = SchedBlockExpert.getRecommended12mConfigurations(scienceGoal, (Frequency)((Object)object)).getBest12mExtConfig();
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger(DGCExpert.class).warning("Unable to get the 12-m configurations: " + invalidConfigurationParametersException.getMessage());
            return DGCExpert.B2BSchedulingOutcome.ScienceGoalConfigurationIncompatible;
        }
        if (!Configuration.isDGCConfiguration(configuration)) {
            return DGCExpert.B2BSchedulingOutcome.NotScheduled;
        }
        object = Optional.empty();
        Frequency frequency = scienceGoal.getSpectralSetupParameters().getRepresentativeFrequencyWithSkyOffset().deepCopy();
        try {
            object = this.searchOnlineCalibratorCatalogueForInBandCalibrator(scienceGoal, frequency);
        }
        catch (UnableToQueryCatalogueException unableToQueryCatalogueException) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Unable to query calibrator catalogue : " + unableToQueryCatalogueException.getMessage());
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Defaulting to B2B : " + unableToQueryCatalogueException.getMessage());
            return DGCExpert.B2BSchedulingOutcome.FailedToCommunicateWithCalibratorServer;
        }
        if (((Optional)object).isEmpty()) {
            return DGCExpert.B2BSchedulingOutcome.NoCalibratorFoundInCatalogue;
        }
        SingleFieldScienceGoalModel.ExtrapolatedFluxValues extrapolatedFluxValues = null;
        try {
            extrapolatedFluxValues = SingleFieldScienceGoalModel.getExtrapolatedFluxValues(configuration, scienceGoal, Optional.empty(), (AdjustedFluxValue)((Optional)object).get(), frequency, SingleFieldScienceGoalModel::getS_Antenna);
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException | UnableToDetermineCalibrationTimeException exception) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Unable to determine s_rf and s_antenna: " + exception.getMessage());
            return DGCExpert.B2BSchedulingOutcome.ScienceGoalConfigurationIncompatible;
        }
        if (((AdjustedFluxValue)((Optional)object).get()).getTimeAdjustedFlux() >= extrapolatedFluxValues.getS_antenna()) {
            return DGCExpert.B2BSchedulingOutcome.SuitableInBandCalibratorFound;
        }
        if (this.findInBandCalibratorWithMaxBandwidth(scienceGoal, this.getMaxOverlappingBW(scienceGoal))) {
            return DGCExpert.B2BSchedulingOutcome.UseBWSW;
        }
        try {
            optional = this.getCalibratorFluxAtReferenceFrequency(scienceGoal);
        }
        catch (UnableToQueryCatalogueException unableToQueryCatalogueException) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Unable to determine calibrator flux at reference frequency " + unableToQueryCatalogueException.getMessage());
            return DGCExpert.B2BSchedulingOutcome.Scheduled;
        }
        if (optional.isEmpty()) {
            return DGCExpert.B2BSchedulingOutcome.NoCalibratorFoundInCatalogue;
        }
        AdjustedFluxValue adjustedFluxValue = optional.get();
        try {
            extrapolatedFluxValues = SingleFieldScienceGoalModel.getExtrapolatedFluxValues(configuration, scienceGoal, Optional.empty(), adjustedFluxValue, adjustedFluxValue.getRf(), SingleFieldScienceGoalModel::getS_Antenna_ref);
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException | UnableToDetermineCalibrationTimeException exception) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Unable to determine calibrator flux at reference frequency " + exception.getMessage());
            return DGCExpert.B2BSchedulingOutcome.Scheduled;
        }
        Double d = adjustedFluxValue.getTimeAdjustedFlux();
        double d2 = d / extrapolatedFluxValues.getS_antenna();
        if (10.0 <= d2 && d2 < 30.0) {
            return DGCExpert.B2BSchedulingOutcome.B2BWeakCalibratorFound;
        }
        if (d2 < 10.0) {
            return DGCExpert.B2BSchedulingOutcome.UnuseableB2BCalibratorFound;
        }
        return DGCExpert.B2BSchedulingOutcome.Scheduled;
    }

    private boolean isScienceGoalSetupPreconditionsForDGCSatisfied(@NonNull ScienceGoal scienceGoal) {
        boolean bl;
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (this.isForcedDGCPreconditionsMet(scienceGoal)) {
            return true;
        }
        try {
            scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            return false;
        }
        boolean bl2 = !Sets.intersection(Configuration.getDGCConfigurations(), Set.copyOf(scienceGoalConfigurations.getExtendedConfigurations())).isEmpty();
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        boolean bl3 = bl = receiverBand != null && !scienceGoal.isStandAloneACA() && this.dgcLegalBands.contains(receiverBand) && bl2;
        if (bl) {
            Log.logger(DGCOnlineCalibratorExpert.class).fine("ScienceGoal " + scienceGoal.getName() + " satisfies B2B pre-conditions");
        } else {
            Log.logger(DGCOnlineCalibratorExpert.class).fine("ScienceGoal " + scienceGoal.getName() + " does not satisfy B2B pre-conditions");
        }
        return bl;
    }

    private boolean isForcedDGCPreconditionsMet(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        String string = scienceGoal.getCalibrationSetupParameters().getForcedDGCStrategy();
        return string != null && !CalibrationSetupParameters.FORCEDDGCSTRATEGY_NONE.equals(string) && this.dgcLegalBands.contains(scienceGoal.getReceiverBand());
    }

    private Optional<AdjustedFluxValue> getCalibratorFluxAtReferenceFrequency(@NonNull ScienceGoal scienceGoal) throws UnableToQueryCatalogueException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        Frequency frequency = Frequency.createFrequency((double)this.getAverageSPWFrequencyForB2BReferenceSpectralSpec(scienceGoal).orElseThrow(), (String)Frequency.UNIT_GHZ);
        Log.logger(DGCOnlineCalibratorExpert.class).fine("averageFrequency: " + frequency);
        Optional<AdjustedFluxValue> optional = this.searchOnlineCalibratorCatalogueForInBandCalibrator(scienceGoal, frequency);
        optional.ifPresent(adjustedFluxValue -> adjustedFluxValue.setRf(frequency));
        return optional;
    }

    private OptionalDouble getAverageSPWFrequencyForB2BReferenceSpectralSpec(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        SBGenerationContext sBGenerationContext = this.createSBGenerationContext(scienceGoal, RequestedArray.TWELVE_M, Optional.empty(), Optional.empty());
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        Velocity velocity = spectralSetupParameters.getSourceVelocity().deepCopy();
        SpectralSpecFactory spectralSpecFactory = new SpectralSpecFactory(sBGenerationContext);
        spectralSpecFactory.setDGCCalibratorReturnType(DGCExpert.DGCTypeEnum.DGCBandToBand);
        SpectralSpec spectralSpec = spectralSpecFactory.getSpectralSpec(spectralSetupParameters, velocity, ObsType.DGCREFERENCE, Optional.empty());
        return Arrays.stream(spectralSpec.getBaseBand()).mapToDouble(baseBand -> baseBand.getCenterFrequencySky().getContentInGHz()).average();
    }

    private Optional<AdjustedFluxValue> searchOnlineCalibratorCatalogueForInBandCalibrator(@NonNull ScienceGoal scienceGoal, @NonNull Frequency frequency) throws UnableToQueryCatalogueException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("referenceFrequency is marked non-null but is null");
        }
        List<Measurement> list = this.queryCalibratorCatalogue(scienceGoal);
        Integer n = null;
        HashMap<Integer, AdjustedFluxValue> hashMap = new HashMap<Integer, AdjustedFluxValue>(100);
        for (Measurement measurement : list) {
            AdjustedFluxValue adjustedFluxValue;
            if (measurement.getUvMax() != null && measurement.getUvMax() > 0.0 || !measurement.getCatalogueId().equals(5)) continue;
            Integer n2 = measurement.getSourceId();
            if (n == null) {
                adjustedFluxValue = new AdjustedFluxValue();
                adjustedFluxValue.setMeasurement(measurement);
                hashMap.put(n2, adjustedFluxValue);
                n = n2;
                continue;
            }
            if (n.equals(n2)) {
                adjustedFluxValue = (AdjustedFluxValue)hashMap.get(n2);
                if (measurement.getFrequency().compareTo(adjustedFluxValue.getMeasurement().getFrequency()) <= 0) continue;
                adjustedFluxValue.setMeasurement(measurement);
                continue;
            }
            n = null;
        }
        double d = frequency.getContentInUnits(Frequency.UNIT_HZ);
        double d2 = (double)Instant.now().getEpochSecond() / 86400.0;
        hashMap.entrySet().forEach(entry -> {
            AdjustedFluxValue adjustedFluxValue = (AdjustedFluxValue)entry.getValue();
            Measurement measurement = adjustedFluxValue.getMeasurement();
            Double d3 = measurement.getFlux();
            Double d4 = measurement.getFrequency();
            adjustedFluxValue.setFluxAtRF(d3 * Math.pow(d / d4, -0.7));
            double d5 = (double)measurement.getDateObserved().getTime() / 1000.0 / 86400.0;
            double d6 = d2 - d5;
            adjustedFluxValue.setNoDaysAgoCalibratorWasObserved(d6);
            double d7 = adjustedFluxValue.getFluxAtRF() * Math.pow(0.99, d6 / 10.0);
            double d8 = adjustedFluxValue.getFluxAtRF() / 3.0;
            adjustedFluxValue.setTimeAdjustedFlux(d7 < d8 ? d8 : d7);
            Log.logger(DGCOnlineCalibratorExpert.class).fine("adjustedFluxValues: " + adjustedFluxValue);
        });
        Optional optional = hashMap.entrySet().stream().max((entry, entry2) -> ((AdjustedFluxValue)entry.getValue()).getTimeAdjustedFlux() > ((AdjustedFluxValue)entry2.getValue()).getTimeAdjustedFlux() ? 1 : -1);
        return optional.map(Map.Entry::getValue);
    }

    private List<Measurement> queryCalibratorCatalogue(@NonNull ScienceGoal scienceGoal) throws UnableToQueryCatalogueException {
        List<Measurement> list;
        Object object;
        Object object2;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        BackgroundCalibratorDatabaseInteractor backgroundCalibratorDatabaseInteractor = BackgroundCalibratorDatabaseInteractor.getInstance();
        backgroundCalibratorDatabaseInteractor.setCatalogueAccess(CalibratorExpert.SourceCatalog.byName(CalibratorExpert.SourceCatalog.ALMA.getName()));
        backgroundCalibratorDatabaseInteractor.setCatalogsToQuery(List.of(CalibratorExpert.ALMACalibratorCatalogue));
        SkyCoordinates skyCoordinates = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates();
        CatalogQueryParameters catalogQueryParameters = new CatalogQueryParameters();
        catalogQueryParameters.setMinFrequency(84.0);
        catalogQueryParameters.setMaxSources(Integer.valueOf(100));
        RequiredConfigurations requiredConfigurations = null;
        try {
            object2 = scienceGoal.getPerformanceParameters();
            requiredConfigurations = SchedBlockExpert.getRecommended12mConfigurations(scienceGoal, object2.getRepresentativeFrequency());
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger(DGCExpert.class).warning("Unable to get the 12-m configurations: " + invalidConfigurationParametersException.getMessage());
            throw new UnableToQueryCatalogueException("Unable to get 12-m configuration");
        }
        object2 = requiredConfigurations.getBest12mExtConfig();
        try {
            object = ((Configuration)object2).getPhaseCalConeSeparation(scienceGoal.getReceiverBand().getNumber());
            catalogQueryParameters.setRadius(object.getDegs());
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = "Unable to find search radius for " + ((Configuration)object2).getName() + " with rxb " + scienceGoal.getReceiverBand();
            Log.logger(DGCOnlineCalibratorExpert.class).warning(string);
            throw new RuntimeException(string);
        }
        catalogQueryParameters.setDeclination(skyCoordinates.getLatitude().getContentInDeg());
        catalogQueryParameters.setRightAscension(skyCoordinates.getLongitude().getContentInDeg());
        catalogQueryParameters.setSortBy("source_id");
        object = Double.valueOf(Objects.hashCode((Object[])new Object[]{catalogQueryParameters.getDeclination(), catalogQueryParameters.getRightAscension(), catalogQueryParameters.getRadius()}));
        List list2 = (List)calibratorMeasurementResultsCache.get(object);
        if (list2 != null) {
            return Collections.unmodifiableList(list2);
        }
        try {
            list = backgroundCalibratorDatabaseInteractor.query(catalogQueryParameters);
        }
        catch (Exception exception) {
            throw new UnableToQueryCatalogueException(exception);
        }
        calibratorMeasurementResultsCache.put(object, list);
        return Collections.unmodifiableList(list);
    }

    @Override
    protected boolean isBandwidthSwitchingRequirementsMet(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        DGCExpert.B2BSchedulingOutcome b2BSchedulingOutcome = this.isB2BRequirementsMet(scienceGoal);
        if (b2BSchedulingOutcome.equals((Object)DGCExpert.B2BSchedulingOutcome.SuitableInBandCalibratorFound)) {
            return false;
        }
        return b2BSchedulingOutcome.equals((Object)DGCExpert.B2BSchedulingOutcome.UseBWSW) || this.isNonOverlappingBandwidthBWSWCompliant(scienceGoal);
    }

    private boolean findInBandCalibratorWithMaxBandwidth(@NonNull ScienceGoal scienceGoal, @NonNull Frequency frequency) {
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("nonOverlappingBWOverride is marked non-null but is null");
        }
        if (MiscUtils.isForceBWSW()) {
            return true;
        }
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        if (receiverBand == null || scienceGoal.isStandAloneACA()) {
            return false;
        }
        RequiredConfigurations requiredConfigurations = null;
        try {
            object = scienceGoal.getPerformanceParameters();
            requiredConfigurations = SchedBlockExpert.getRecommended12mConfigurations(scienceGoal, object.getRepresentativeFrequency());
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger(DGCExpert.class).warning("Unable to get the 12-m configurations: " + invalidConfigurationParametersException.getMessage());
            return false;
        }
        object = requiredConfigurations.getBest12mExtConfig();
        Optional<Object> optional = Optional.empty();
        Frequency frequency2 = scienceGoal.getSpectralSetupParameters().getRepresentativeFrequencyWithSkyOffset();
        try {
            optional = this.searchOnlineCalibratorCatalogueForInBandCalibrator(scienceGoal, frequency2);
        }
        catch (UnableToQueryCatalogueException unableToQueryCatalogueException) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Unable to query calibrator catalogue : " + unableToQueryCatalogueException.getMessage());
            return false;
        }
        if (optional.isEmpty()) {
            return false;
        }
        try {
            SingleFieldScienceGoalModel.ExtrapolatedFluxValues extrapolatedFluxValues = SingleFieldScienceGoalModel.getExtrapolatedFluxValues((Configuration)object, scienceGoal, Optional.of(frequency), (AdjustedFluxValue)optional.get(), frequency2, SingleFieldScienceGoalModel::getS_Antenna);
            return ((AdjustedFluxValue)optional.get()).getTimeAdjustedFlux() >= extrapolatedFluxValues.getS_antenna();
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException | UnableToDetermineCalibrationTimeException exception) {
            Log.logger(DGCOnlineCalibratorExpert.class).warning("Unable to determine s_rf and s_antenna: " + exception.getMessage());
            return false;
        }
    }

    private Frequency getMaxOverlappingBW(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        if (receiverBand != null && ReceiverBand.isReceiverBandInSet(receiverBand, 9, 10) && scienceGoal.getSpectralSetupParameters().isWalshSwitching()) {
            return Frequency.createFrequencyGHZ(15.0);
        }
        return Frequency.createFrequencyGHZ(7.5);
    }

    public static class UnableToQueryCatalogueException
    extends Exception {
        public UnableToQueryCatalogueException(Exception exception) {
            super(exception);
        }

        public UnableToQueryCatalogueException(String string) {
            super(string);
        }
    }

    public class AdjustedFluxValue {
        private Measurement measurement;
        private Double fluxAtRF;
        private Double timeAdjustedFlux;
        private double noDaysAgoCalibratorWasObserved;
        private Frequency rf;

        public Measurement getMeasurement() {
            return this.measurement;
        }

        public Double getFluxAtRF() {
            return this.fluxAtRF;
        }

        public Double getTimeAdjustedFlux() {
            return this.timeAdjustedFlux;
        }

        public double getNoDaysAgoCalibratorWasObserved() {
            return this.noDaysAgoCalibratorWasObserved;
        }

        public Frequency getRf() {
            return this.rf;
        }

        public void setMeasurement(Measurement measurement) {
            this.measurement = measurement;
        }

        public void setFluxAtRF(Double d) {
            this.fluxAtRF = d;
        }

        public void setTimeAdjustedFlux(Double d) {
            this.timeAdjustedFlux = d;
        }

        public void setNoDaysAgoCalibratorWasObserved(double d) {
            this.noDaysAgoCalibratorWasObserved = d;
        }

        public void setRf(Frequency frequency) {
            this.rf = frequency;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AdjustedFluxValue)) {
                return false;
            }
            AdjustedFluxValue adjustedFluxValue = (AdjustedFluxValue)object;
            if (!adjustedFluxValue.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getNoDaysAgoCalibratorWasObserved(), adjustedFluxValue.getNoDaysAgoCalibratorWasObserved()) != 0) {
                return false;
            }
            Double d = this.getFluxAtRF();
            Double d2 = adjustedFluxValue.getFluxAtRF();
            if (d == null ? d2 != null : !((Object)d).equals(d2)) {
                return false;
            }
            Double d3 = this.getTimeAdjustedFlux();
            Double d4 = adjustedFluxValue.getTimeAdjustedFlux();
            if (d3 == null ? d4 != null : !((Object)d3).equals(d4)) {
                return false;
            }
            Measurement measurement = this.getMeasurement();
            Measurement measurement2 = adjustedFluxValue.getMeasurement();
            if (measurement == null ? measurement2 != null : !measurement.equals(measurement2)) {
                return false;
            }
            Frequency frequency = this.getRf();
            Frequency frequency2 = adjustedFluxValue.getRf();
            return !(frequency == null ? frequency2 != null : !((Object)((Object)frequency)).equals((Object)frequency2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof AdjustedFluxValue;
        }

        public int hashCode() {
            int n = 1;
            long l = Double.doubleToLongBits(this.getNoDaysAgoCalibratorWasObserved());
            n = n * 59 + (int)(l >>> 32 ^ l);
            Double d = this.getFluxAtRF();
            n = n * 59 + (d == null ? 43 : ((Object)d).hashCode());
            Double d2 = this.getTimeAdjustedFlux();
            n = n * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
            Measurement measurement = this.getMeasurement();
            n = n * 59 + (measurement == null ? 43 : measurement.hashCode());
            Frequency frequency = this.getRf();
            n = n * 59 + (frequency == null ? 43 : ((Object)((Object)frequency)).hashCode());
            return n;
        }

        public String toString() {
            return "DGCOnlineCalibratorExpert.AdjustedFluxValue(measurement=" + this.getMeasurement() + ", fluxAtRF=" + this.getFluxAtRF() + ", timeAdjustedFlux=" + this.getTimeAdjustedFlux() + ", noDaysAgoCalibratorWasObserved=" + this.getNoDaysAgoCalibratorWasObserved() + ", rf=" + this.getRf() + ")";
        }
    }
}

