/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.editors.spatialvisual.RectangleMosaic;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class RectangleAreaExpert {
    private final Rectangle rectangle;
    private final Map<Array, RectangleMosaic> mosaics = new HashMap<Array, RectangleMosaic>();

    public static RectangleAreaExpert of(@NonNull Rectangle rectangle) {
        if (rectangle == null) {
            throw new NullPointerException("rect is marked non-null but is null");
        }
        return new RectangleAreaExpert(rectangle);
    }

    private RectangleAreaExpert(@NonNull Rectangle rectangle) {
        if (rectangle == null) {
            throw new NullPointerException("rect is marked non-null but is null");
        }
        this.rectangle = rectangle;
        this.mosaics.put(Array.ARRAY_12M, new RectangleMosaic(rectangle, Array.ARRAY_12M.antenna));
        this.mosaics.put(Array.ARRAY_7M, new RectangleMosaic(rectangle, Array.ARRAY_7M.antenna));
    }

    public PointingPattern getPointingPattern(@NonNull Array array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return this.mosaics.get((Object)array).getPointingPattern();
    }

    public int getNumberOfPointings(@NonNull Array array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (array == Array.ARRAY_TP) {
            return 0;
        }
        return this.mosaics.get((Object)array).getPointings().size();
    }

    public Rectangle getActualTPArrayRectangle(@NonNull Frequency frequency, @NonNull Optional<TargetParameters> optional) {
        boolean bl;
        if (frequency == null) {
            throw new NullPointerException("obsFreq is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        boolean bl2 = false;
        TargetParameters targetParameters = this.rectangle.getTargetParameters();
        ScienceGoal scienceGoal = null;
        if (targetParameters != null) {
            scienceGoal = targetParameters.getScienceGoal();
        }
        if (scienceGoal == null && optional.isPresent()) {
            targetParameters = optional.get();
            scienceGoal = targetParameters.getScienceGoal();
        }
        if (scienceGoal != null) {
            bl2 = scienceGoal.isStandAloneACA();
        }
        boolean bl3 = targetParameters.isPointingPattern() && targetParameters.getPointingPattern().getPhaseCenterCoordinatesCount() == 1;
        boolean bl4 = bl = targetParameters.isPointingPattern() && targetParameters.getPointingPattern().getPhaseCenterCoordinatesCount() > 1;
        assert (!bl || !bl3) : "A pointing pattern can be either multiple point pointing pattern or a single pointing pattern but not both";
        if (bl) {
            return this.getRectangleFromPointingPattern(frequency, bl2);
        }
        if (bl3) {
            return this.getSinglePointingRectangle(frequency, bl2);
        }
        assert (targetParameters.isRectanglePattern());
        return this.getRectangleDerivedTPRectangle(frequency, bl2);
    }

    private Rectangle getRectangleDerivedTPRectangle(@NonNull Frequency frequency, boolean bl) {
        if (frequency == null) {
            throw new NullPointerException("obsFreq is marked non-null but is null");
        }
        UserAngle userAngle = UserAngle.createUserAngle(1.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        userAngle.setAntenna(bl ? Antenna.ANTENNA_7M : Antenna.ANTENNA_12M);
        UserAngle userAngle2 = UserAngle.createUserAngle(1.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        userAngle2.setAntenna(Antenna.ANTENNA_7M);
        Rectangle rectangle = this.rectangle.deepCopy();
        rectangle.setArray(Array.ARRAY_TP);
        rectangle.setReferenceFrequency(frequency);
        if (rectangle.getLong().isLessThan((AbstractDoubleWithUnit)userAngle)) {
            rectangle.setLong((Angle)((Object)userAngle.deepCopy()));
        }
        if (rectangle.getShort().isLessThan((AbstractDoubleWithUnit)userAngle)) {
            rectangle.setShort((Angle)((Object)userAngle.deepCopy()));
        }
        rectangle.setLong((Angle)rectangle.getLong().plus((AbstractDoubleWithUnit)userAngle2));
        rectangle.setShort((Angle)rectangle.getShort().plus((AbstractDoubleWithUnit)userAngle2));
        return rectangle;
    }

    private Rectangle getSinglePointingRectangle(Frequency frequency, boolean bl) {
        Antenna antenna = bl ? Antenna.ANTENNA_7M : Antenna.ANTENNA_12M;
        UserAngle userAngle = UserAngle.createUserAngle(1.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        userAngle.setAntenna(antenna);
        UserAngle userAngle2 = UserAngle.createUserAngle(1.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        userAngle2.setAntenna(Antenna.ANTENNA_7M);
        Rectangle rectangle = this.rectangle.deepCopy();
        rectangle.setArray(Array.ARRAY_TP);
        rectangle.setReferenceFrequency(frequency);
        rectangle.setLong((Angle)userAngle.plus((AbstractDoubleWithUnit)userAngle2));
        rectangle.setShort((Angle)userAngle.plus((AbstractDoubleWithUnit)userAngle2));
        return rectangle;
    }

    private Rectangle getRectangleFromPointingPattern(Frequency frequency, boolean bl) {
        Antenna antenna = bl ? Antenna.ANTENNA_7M : Antenna.ANTENNA_12M;
        UserAngle userAngle = UserAngle.createUserAngle(1.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        userAngle.setAntenna(antenna);
        Rectangle rectangle = this.rectangle.deepCopy();
        rectangle.setArray(Array.ARRAY_TP);
        rectangle.setReferenceFrequency(frequency);
        Angle angle = rectangle.getLong();
        Angle angle2 = rectangle.getShort();
        UserAngle userAngle2 = UserAngle.createUserAngle(1.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        userAngle2.setAntenna(Antenna.ANTENNA_7M);
        rectangle.setLong((Angle)((Angle)angle.plus((AbstractDoubleWithUnit)userAngle)).plus((AbstractDoubleWithUnit)userAngle2));
        rectangle.setShort((Angle)((Angle)angle2.plus((AbstractDoubleWithUnit)userAngle)).plus((AbstractDoubleWithUnit)userAngle2));
        return rectangle;
    }

    public Rectangle getActualTPArrayRectangle(@NonNull SpectralSpec spectralSpec, Optional<TargetParameters> optional) {
        Frequency frequency;
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        try {
            frequency = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.LOWESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        return this.getActualTPArrayRectangle(frequency, optional);
    }
}

