/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.observatorycharacteristics.configuration.ArrayConfigurationType;
import alma.observatorycharacteristics.configuration.ArrayMultiplierType;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.observatorycharacteristics.configuration.OTXMLConfigurationReader;
import alma.observatorycharacteristics.configuration.PhaseCalConeSeparation;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.DeclinationData;
import alma.obsprep.services.experts.InterpolationRange;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.experts.Shadowing;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Length;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;
import alma.valuetypes.data.AngleData;
import alma.valuetypes.data.LengthData;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;

public final class Configuration {
    private static final double CONFIGURATION_RESOLUTION_TOLERANCE = 0.01;
    public static final double INVALID_MULTIPLIER = 0.0;
    private static Map<String, String> configsWithCompactConfigurations;
    private static List<Integer> nonReceivers;
    public static final Configuration ILLEGAL_CONFIG;
    public static final Configuration NO_CONFIG;
    private int configNumber;
    private String configName;
    private double maxBaseline;
    private double minBaseline;
    private double compact12mMultiplier = 0.0;
    private double acaMultiplier = 0.0;
    private double tpMultiplier = 0.0;
    private boolean acaAllowed = false;
    private String[] supportedReceivers;
    private Configuration compactConfiguration = ILLEGAL_CONFIG;
    private double simultaneous12mAnd7mMultiplier = 0.0;
    private List<Integer> solarCompatibleRxBs;
    private List<PhaseCalConeSeparation> phaseCalConeSeparation;
    public static final double DATA_FILE_FREQ_GHZ = 100.0;
    private static Map<RequestedArray, Configuration> VLBI_CONFIGURATION;
    public static Map<RequestedArray, Configuration> MOST_COMPACT;
    public static Map<RequestedArray, Configuration> MOST_EXTENDED;
    public static Map<RequestedArray, Configuration> MOST_EXTENDED_NON_LONGBASELINE;
    private static Map<RequestedArray, List<Configuration>> ALL_CONFIGS;
    private static Map<RequestedArray, LinkedHashMap<Configuration, ArrayList<DeclinationData>>> declinationDataMap;
    private static Set<Configuration> LONGBASELINE_CONFIGS;
    private static Set<Configuration> DGC_CONFIGS;
    private static Set<Configuration> ANY_CONFIGS;
    private static CacheAccess<Integer, DeclinationData> declinationCache;
    private static CacheAccess<Integer, ScienceGoalConfigurations<ConfigurationSet>> configurationSetCache;
    private static boolean isConfigurationSetCacheEnabled;
    private static Map<String, Map<String, Double>> twelveMCompactTimeMultipliers;
    private static Map<RequestedArray, Map<Configuration, InterpolationRange>> interpolationMap;

    public String toString() {
        return "Configuration [configNumber=" + this.configNumber + ", configName=" + this.configName + ", maxBaseline=" + this.maxBaseline + ", minBaseline=" + this.minBaseline + ", compact12mMultiplier=" + this.compact12mMultiplier + ", acaMultiplier=" + this.acaMultiplier + ", tpMultiplier=" + this.tpMultiplier + ", acaAllowed=" + this.acaAllowed + ", supportedReceivers=" + Arrays.toString(this.supportedReceivers) + "] \n";
    }

    public static synchronized void refreshArrayConfigurations() {
        try {
            twelveMCompactTimeMultipliers.clear();
            configsWithCompactConfigurations.clear();
            for (RequestedArray requestedArray : RequestedArray.values()) {
                ALL_CONFIGS.get((Object)requestedArray).clear();
                declinationDataMap.get((Object)requestedArray).clear();
                interpolationMap.get((Object)requestedArray).clear();
            }
            Configuration.loadArrayConfigurationsFromOTConfigurationFile();
            Configuration.loadConfigurationDeclinationDataFiles();
            Configuration.setLongBaseLineConfigurations();
            Configuration.setDGCConfigurations();
            Configuration.setVLBIConfigurations();
            Configuration.setAnyConfigurations();
            Configuration.detectBoundaryConfigurations(RequestedArray.TWELVE_M);
            Configuration.detectBoundaryConfigurations(RequestedArray.SEVEN_M);
        }
        catch (OTXMLConfigurationReader.InvalidOTCOnfigurationException | UnableToDetermineConfigurationException | UnableToReadDeclinationFileException | JAXBException throwable) {
            Log.logger(Configuration.class).warning("Unable to load configurations: " + throwable.getMessage());
            System.exit(-1);
        }
        Log.logger(Configuration.class).info("Array Configurations loaded");
    }

    private static void setAnyConfigurations() {
        ANY_CONFIGS.clear();
        for (Configuration configuration : ALL_CONFIGS.get((Object)RequestedArray.TWELVE_M)) {
            if (Configuration.isLongBaselineConfiguration(configuration)) continue;
            ANY_CONFIGS.add(configuration);
        }
    }

    public static Set<Configuration> getAnyConfigurations() {
        return Collections.unmodifiableSet(ANY_CONFIGS);
    }

    public static Configuration getMostExtendedAnyConfiguration() {
        Configuration configuration = null;
        for (Configuration configuration2 : ANY_CONFIGS) {
            if (configuration == null) {
                configuration = configuration2;
                continue;
            }
            if (!(configuration2.getMaxBaseline() > configuration.getMaxBaseline())) continue;
            configuration = configuration2;
        }
        return configuration;
    }

    private static synchronized void setLongBaseLineConfigurations() throws UnableToDetermineConfigurationException, JAXBException, OTXMLConfigurationReader.InvalidOTCOnfigurationException {
        OTConfiguration oTConfiguration = OTXMLConfigurationReader.getInstance().getOTConfiguration();
        LONGBASELINE_CONFIGS.clear();
        for (OTConfiguration.ArrayConfigurations.ArrayConfiguration arrayConfiguration : oTConfiguration.getArrayConfigurations().getArrayConfiguration()) {
            if (!arrayConfiguration.isIsLongBaselineConfiguration() || !arrayConfiguration.isIsEnabled()) continue;
            RequestedArray requestedArray = OTXMLConfigurationReader.mapArrayConfigurationType(arrayConfiguration.getConfigurationType());
            LONGBASELINE_CONFIGS.add(Configuration.getConfiguration(arrayConfiguration.getConfigurationName(), requestedArray));
        }
    }

    private static synchronized void setDGCConfigurations() throws UnableToDetermineConfigurationException, JAXBException, OTXMLConfigurationReader.InvalidOTCOnfigurationException {
        OTConfiguration oTConfiguration = OTXMLConfigurationReader.getInstance().getOTConfiguration();
        DGC_CONFIGS.clear();
        for (OTConfiguration.ArrayConfigurations.ArrayConfiguration arrayConfiguration : oTConfiguration.getArrayConfigurations().getArrayConfiguration()) {
            if (!arrayConfiguration.isIsDGCConfiguration() || !arrayConfiguration.isIsEnabled()) continue;
            RequestedArray requestedArray = OTXMLConfigurationReader.mapArrayConfigurationType(arrayConfiguration.getConfigurationType());
            DGC_CONFIGS.add(Configuration.getConfiguration(arrayConfiguration.getConfigurationName(), requestedArray));
        }
    }

    public static Set<Configuration> getLongBaseLineConfigurations() {
        return Collections.unmodifiableSet(LONGBASELINE_CONFIGS);
    }

    public static Set<Configuration> getDGCConfigurations() {
        return Collections.unmodifiableSet(DGC_CONFIGS);
    }

    private static synchronized void setVLBIConfigurations() throws UnableToDetermineConfigurationException, JAXBException, OTXMLConfigurationReader.InvalidOTCOnfigurationException {
        OTConfiguration oTConfiguration = OTXMLConfigurationReader.getInstance().getOTConfiguration();
        VLBI_CONFIGURATION.clear();
        for (OTConfiguration.ArrayConfigurations.ArrayConfiguration arrayConfiguration : oTConfiguration.getArrayConfigurations().getArrayConfiguration()) {
            if (!arrayConfiguration.isIsEnabled() || !arrayConfiguration.getConfigurationType().equals((Object)ArrayConfigurationType.TWELVE_M) || !arrayConfiguration.isIsVLBIConfiguration()) continue;
            VLBI_CONFIGURATION.put(RequestedArray.TWELVE_M, Configuration.getConfiguration(arrayConfiguration.getConfigurationName(), RequestedArray.TWELVE_M));
        }
    }

    public static List<Configuration> getSolarConfigurations(ReceiverBand receiverBand) {
        if (receiverBand == null) {
            return new ArrayList<Configuration>();
        }
        return ALL_CONFIGS.get((Object)RequestedArray.TWELVE_M).stream().filter(configuration -> configuration.getSolarCompatibleRxBs().contains(receiverBand.getNumber())).collect(Collectors.toList());
    }

    public static boolean isLongBaselineConfiguration(@NonNull Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        for (Configuration configuration2 : Configuration.getLongBaseLineConfigurations()) {
            if (!configuration2.getName().equals(configuration.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDGCConfiguration(@NonNull Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        for (Configuration configuration2 : Configuration.getLongBaseLineConfigurations()) {
            if (!configuration2.getName().equals(configuration.getName())) continue;
            return true;
        }
        return false;
    }

    private static void sortConfigurationDeclinationMaps() {
        if (declinationDataMap.keySet().isEmpty()) {
            throw new IllegalArgumentException("No declination data is in the maps");
        }
        List list = null;
        for (RequestedArray requestedArray : declinationDataMap.keySet()) {
            for (Configuration configuration : ALL_CONFIGS.get((Object)requestedArray)) {
                if (!declinationDataMap.get((Object)requestedArray).containsKey(configuration)) {
                    throw new IllegalArgumentException("Declination map must contain declination data for array " + requestedArray + " and configuration " + configuration);
                }
                list = declinationDataMap.get((Object)requestedArray).get(configuration);
                assert (list != null);
                DeclinationDataComparator declinationDataComparator = new DeclinationDataComparator();
                Collections.sort(list, declinationDataComparator);
            }
        }
    }

    private static synchronized void loadConfigurationDeclinationDataFiles() throws UnableToReadDeclinationFileException {
        for (RequestedArray requestedArray : EnumSet.of(RequestedArray.SEVEN_M, RequestedArray.TWELVE_M)) {
            for (Configuration configuration : ALL_CONFIGS.get((Object)requestedArray)) {
                Object object;
                Object object2;
                String string = configuration.getName();
                String string2 = System.getProperty("Telescope", "ESALMA");
                String string3 = string2 + "Resolution-" + string + ".dat";
                URL uRL = null;
                try {
                    object2 = new File(System.getProperty("otData.dir"));
                    assert (object2 != null);
                    uRL = MiscUtils.findResource((File)object2, string3);
                }
                catch (Exception exception) {
                    object = "Error accessing " + string3 + " file: " + exception.getMessage();
                    Log.logger(Configuration.class).warning((String)object);
                    exception.printStackTrace(System.err);
                    throw new UnableToReadDeclinationFileException((String)object);
                }
                assert (uRL != null) : "Unable to access declination files";
                object2 = null;
                try {
                    Log.logger(Configuration.class).fine("Reading configuration declination file : " + uRL.getFile());
                    object2 = new BufferedReader(new InputStreamReader(uRL.openStream()));
                }
                catch (Exception exception) {
                    String string4 = "Unable to open declination file : " + string3 + ": " + exception.getMessage();
                    Log.logger(Configuration.class).warning(string4);
                    throw new UnableToReadDeclinationFileException(string4);
                }
                assert (object2 != null);
                int n = 0;
                try {
                    while ((object = ((BufferedReader)object2).readLine()) != null) {
                        Object object3;
                        Object object4;
                        ++n;
                        if ((object = StringUtils.stripToNull((String)object)) == null || StringUtils.startsWith((CharSequence)object, (CharSequence)"#")) continue;
                        String[] stringArray = ((String)object).replaceAll("\\s+", " ").split(" ");
                        if (stringArray.length != 5) {
                            object4 = String.format("Line %d in %s is expected to have five fields, %d found.", n, string3, stringArray.length);
                            ((BufferedReader)object2).close();
                            Log.logger(Configuration.class).warning((String)object4);
                            throw new UnableToReadDeclinationFileException((String)object4);
                        }
                        object4 = null;
                        Double d = null;
                        Double d2 = null;
                        Double d3 = null;
                        Double d4 = null;
                        try {
                            object4 = Double.valueOf(stringArray[0]);
                            d = Double.valueOf(stringArray[1]);
                            d2 = Double.valueOf(stringArray[2]);
                            d3 = Double.valueOf(stringArray[3]);
                            d4 = Double.valueOf(stringArray[4]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            ((BufferedReader)object2).close();
                            object3 = String.format("Unable to process line %d and convert to real numbers : %s", n, object);
                            Log.logger(Configuration.class).warning((String)object3);
                            throw new UnableToReadDeclinationFileException((String)object3);
                        }
                        assert (object4 != null && d != null & d2 != null);
                        LinkedHashMap<Configuration, ArrayList<DeclinationData>> linkedHashMap = declinationDataMap.get((Object)requestedArray);
                        assert (linkedHashMap != null);
                        if (!linkedHashMap.containsKey(configuration)) {
                            linkedHashMap.put(configuration, new ArrayList());
                        }
                        object3 = linkedHashMap.get(configuration);
                        assert (object3 != null);
                        ((ArrayList)object3).add(new DeclinationData((Double)object4, d, d2, d3, d4));
                    }
                    ((BufferedReader)object2).close();
                }
                catch (IOException iOException) {
                    Log.logger(Configuration.class).warning("Unable to close file " + string3 + ": " + iOException.getMessage());
                    throw new UnableToReadDeclinationFileException("Unable to close file : " + string3);
                }
            }
        }
        Configuration.sortConfigurationDeclinationMaps();
    }

    private static synchronized void loadArrayConfigurationsFromOTConfigurationFile() throws JAXBException, OTXMLConfigurationReader.InvalidOTCOnfigurationException, UnableToDetermineConfigurationException {
        OTConfiguration.ArrayConfigurations arrayConfigurations = OTXMLConfigurationReader.getInstance().getOTConfiguration().getArrayConfigurations();
        for (OTConfiguration.ArrayConfigurations.ArrayConfiguration arrayConfiguration : arrayConfigurations.getArrayConfiguration()) {
            Object object;
            if (!arrayConfiguration.isIsEnabled()) continue;
            RequestedArray requestedArray = OTXMLConfigurationReader.mapArrayConfigurationType(arrayConfiguration.getConfigurationType());
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 1.0;
            for (ArrayMultiplierType arrayMultiplierType : arrayConfiguration.getArrayMultiplier()) {
                object = arrayMultiplierType.getMultiplierType();
                switch (object) {
                    case ACATP: {
                        d3 = arrayMultiplierType.getMultiplierValue();
                        break;
                    }
                    case ACA_7_M: {
                        d2 = arrayMultiplierType.getMultiplierValue();
                        break;
                    }
                    case COMPACT_12_M: {
                        d = arrayMultiplierType.getMultiplierValue();
                        break;
                    }
                    case SIMULTANEOUS_7_M_AND_12_M: {
                        d4 = arrayMultiplierType.getMultiplierValue();
                        break;
                    }
                }
            }
            String string = arrayConfiguration.getCompactConfiguration();
            String object22 = arrayConfiguration.getConfigurationName();
            if (string != null) {
                twelveMCompactTimeMultipliers.put(object22, Map.of(string, d));
                configsWithCompactConfigurations.put(object22, string);
            }
            object = new Configuration(arrayConfiguration.getConfigurationNumber(), arrayConfiguration.getMinBaseline(), arrayConfiguration.getMaxBaseline(), object22, arrayConfiguration.getValidReceiverBand(), arrayConfiguration.isIsACAAllowed(), d3, d2, d, string, d4, arrayConfiguration.getSolarCompatibleReceiverBand(), arrayConfiguration.getPhaseCalConeSearchSeparation());
            Configuration.addConfiguration((Configuration)object, requestedArray);
        }
    }

    private static void detectBoundaryConfigurations(@NonNull RequestedArray requestedArray) {
        Configuration configuration3;
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        Configuration configuration2 = null;
        for (Configuration configuration3 : Configuration.getKnownConfigurations(requestedArray)) {
            if (configuration2 != null && !(configuration3.maxBaseline < configuration2.maxBaseline)) continue;
            configuration2 = configuration3;
        }
        assert (configuration2 != null);
        MOST_COMPACT.put(requestedArray, configuration2);
        Object object = null;
        configuration3 = null;
        for (Configuration configuration4 : Configuration.getKnownConfigurations(requestedArray)) {
            if (object != null && !(configuration4.maxBaseline > ((Configuration)object).maxBaseline) || LONGBASELINE_CONFIGS.contains(object = configuration4)) continue;
            configuration3 = configuration4;
        }
        assert (object != null);
        assert (configuration3 != null);
        MOST_EXTENDED.put(requestedArray, (Configuration)object);
        MOST_EXTENDED_NON_LONGBASELINE.put(requestedArray, configuration3);
    }

    public Configuration(int n, double d, double d2, String string, List<Integer> list, boolean bl, double d3, double d4, double d5, String string2, double d6, List<Integer> list2, List<PhaseCalConeSeparation> list3) {
        assert (!list.isEmpty());
        this.configNumber = n;
        this.minBaseline = d;
        this.maxBaseline = d2;
        this.configName = string;
        String[] stringArray = new String[list.size()];
        int n2 = 0;
        for (Integer n3 : list) {
            stringArray[n2++] = n3.toString();
        }
        this.supportedReceivers = stringArray;
        this.acaAllowed = bl;
        this.tpMultiplier = d3;
        this.acaMultiplier = d4;
        this.compact12mMultiplier = d5;
        this.simultaneous12mAnd7mMultiplier = d6;
        this.solarCompatibleRxBs = list2;
        this.phaseCalConeSeparation = list3;
        if (StringUtils.isNotEmpty((CharSequence)string2)) {
            try {
                this.compactConfiguration = Configuration.getConfiguration(string2, RequestedArray.TWELVE_M);
            }
            catch (UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
                throw new RuntimeException("Unable to find configuration " + string2 + " " + unableToDetermineConfigurationException.getMessage());
            }
        }
    }

    public static List<Configuration> getKnownConfigurations(@NonNull RequestedArray requestedArray) {
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return ALL_CONFIGS.get((Object)requestedArray);
    }

    public Angle getPhaseCalConeSeparation(int n) throws NoSuchElementException {
        PhaseCalConeSeparation phaseCalConeSeparation2 = this.phaseCalConeSeparation.stream().filter(phaseCalConeSeparation -> phaseCalConeSeparation.getReceiverBand() == n).findFirst().orElseThrow();
        return OTConfigurationHelper.getAngle(phaseCalConeSeparation2.getConeSearchSize());
    }

    public static Configuration getMostExtendedConfiguration(@NonNull RequestedArray requestedArray) {
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return MOST_EXTENDED.get((Object)requestedArray);
    }

    public static Configuration getMostExtendedCompatibleConfiguration(@NonNull RequestedArray requestedArray, @NonNull ScienceGoal scienceGoal) {
        ReceiverBand receiverBand;
        Object object;
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        assert (performanceParameters != null);
        try {
            object = scienceGoal.getObsProposal();
            if (object != null && object.isVLBIorPhasedArray()) {
                return MOST_COMPACT.get((Object)requestedArray);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new IllegalArgumentException("Unable to determine VLBI: " + unknownEntityException.getMessage());
        }
        object = MOST_COMPACT.get((Object)requestedArray);
        try {
            receiverBand = scienceGoal.getSpectralSetupParameters().getReceiverBand();
            if (receiverBand == null) {
                if (performanceParameters.isAngularResolutionModeAny()) {
                    return MOST_EXTENDED_NON_LONGBASELINE.get((Object)requestedArray);
                }
                return MOST_EXTENDED.get((Object)requestedArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (performanceParameters.isAngularResolutionModeAny()) {
                return MOST_EXTENDED_NON_LONGBASELINE.get((Object)requestedArray);
            }
            return MOST_EXTENDED.get((Object)requestedArray);
        }
        boolean bl = false;
        try {
            bl = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new IllegalArgumentException("Unable to determine whether solar from science goal");
        }
        List<Configuration> list = bl ? Configuration.getSolarConfigurations(scienceGoal.getReceiverBand()) : Configuration.getKnownConfigurations(requestedArray);
        for (Configuration configuration : list) {
            if (!configuration.isReceiverSupported(receiverBand) || performanceParameters.isAngularResolutionModeAny() && LONGBASELINE_CONFIGS.contains(configuration) || object != null && !(configuration.maxBaseline > ((Configuration)object).maxBaseline)) continue;
            object = configuration;
        }
        if (object == MOST_COMPACT.get((Object)requestedArray)) {
            object = MOST_EXTENDED.get((Object)requestedArray);
        }
        return object;
    }

    public static Angle determineAverageDeclination(@NonNull TargetParameters[] targetParametersArray) {
        if (targetParametersArray == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (targetParametersArray.length == 0) {
            throw new IllegalArgumentException("targetParameters is empty");
        }
        double d = 0.0;
        for (TargetParameters targetParameters : targetParametersArray) {
            SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates().getICRSSkyCoordinates();
            d += skyCoordinates.getLatitude().getContentInDeg();
        }
        return Angle.createAngle((double)(d / (double)targetParametersArray.length), (String)Angle.UNIT_DEG);
    }

    static Collection<Configuration> getConfigurations(double d, double d2, @NonNull RequestedArray requestedArray, @NonNull ScienceGoal scienceGoal, Optional<ReceiverBand> optional) {
        ReceiverBand receiverBand;
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Illegal argument: resolution (" + d + ") did not pass the test: resolution < 0");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Illegal argument: frequency (" + d2 + ") did not pass the test: frequency < 0");
        }
        ArrayList<Configuration> object2 = new ArrayList<Configuration>();
        double d3 = Configuration.getResolutionAtExpectedFrequency(d, d2, FrequencyConversion.TO_DATA_FILE_FREQ);
        Angle angle = Configuration.determineAverageDeclination(scienceGoal.getTargetParameters());
        double d4 = Configuration.getConfigurationThresholdTolerance(requestedArray);
        Configuration object3 = null;
        boolean bl = false;
        try {
            receiverBand = optional.orElseGet(() -> scienceGoal.getReceiverBand());
            if (receiverBand == null) {
                return object2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return object2;
        }
        assert (scienceGoal != null);
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        for (Configuration object4 : Configuration.getKnownConfigurations(requestedArray)) {
            try {
                if (!object4.isReceiverSupported(receiverBand)) continue;
                Iterator iterator = Configuration.getConfigurationPerformanceDataForDeclination(requestedArray, object4, angle);
                boolean bl2 = false;
                double d5 = ((DeclinationData)((Object)iterator)).getResolution().getContentInUnits(Angle.UNIT_ARCSEC);
                if (RequestedArray.SEVEN_M.equals((Object)requestedArray)) {
                    bl2 = d3 <= d5 * 1.1 && d3 >= d5 * 0.9;
                } else {
                    if (performanceParameters.isAngularResolutionModeAny() && LONGBASELINE_CONFIGS.contains(object4)) continue;
                    boolean bl3 = bl2 = d5 - d4 <= d3;
                }
                if (bl2) {
                    Log.logger(Configuration.class).finer(String.format("Configuration that can satisfy resolution %.4g arcsecs (%.4g @100GHz) at %.5g GHz, declination %.4g for the %s array is %s", new Object[]{d, d3, d2, angle.getContentInDefaultUnits(), requestedArray, object4.getName()}));
                    if (object3 != null && !bl) {
                        object2.add(object3);
                        bl = true;
                    }
                    object2.add(object4);
                    continue;
                }
                object3 = object4;
            }
            catch (InvalidConfigurationParametersException | IllegalArgumentException exception) {
                Log.logger(Configuration.class).warning("Unable to find " + requestedArray + " configuration: " + exception.getMessage());
            }
        }
        boolean bl4 = false;
        try {
            bl4 = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new IllegalArgumentException("Unable to determine solar mode: " + unknownEntityException.getMessage());
        }
        if (bl4) {
            ArrayList<Configuration> unknownEntityException = new ArrayList<Configuration>();
            for (Configuration configuration : object2) {
                try {
                    if (!Configuration.isConfigurationCompatibleWhenSolarEnabled(scienceGoal, configuration)) continue;
                    unknownEntityException.add(configuration);
                }
                catch (InvalidConfigurationParametersException | InvalidObsProgramParametersException exception) {
                    break;
                }
            }
            object2 = unknownEntityException;
        }
        if (object2.size() == 0) {
            try {
                ObsProposal obsProposal = scienceGoal.getObsProposal();
                if (obsProposal != null && obsProposal.isVLBIorPhasedArray() && RequestedArray.TWELVE_M.equals((Object)requestedArray)) {
                    object2.add(VLBI_CONFIGURATION.get((Object)RequestedArray.TWELVE_M));
                    return object2;
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(Configuration.class).info("Unable to determine VLBI mode : " + unknownEntityException.getMessage());
            }
            object2.add(ILLEGAL_CONFIG);
        }
        if (Log.logger(Configuration.class).finer()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Configuration configuration : object2) {
                stringBuffer.append(configuration.getName() + ",");
            }
            Log.logger(Configuration.class).finer("Suitable configurations found : " + StringUtils.chop((String)stringBuffer.toString()));
        }
        return object2;
    }

    private static double getConfigurationThresholdTolerance(RequestedArray requestedArray) {
        return 0.01;
    }

    public static Configuration getBestConfiguration(UserAngle userAngle, Frequency frequency, RequestedArray requestedArray, ScienceGoal scienceGoal) throws InvalidConfigurationParametersException {
        return Configuration.getBestConfiguration(frequency.getContentInGHz(), requestedArray, scienceGoal);
    }

    public static Configuration getBestConfiguration(double d, @NonNull RequestedArray requestedArray, @NonNull ScienceGoal scienceGoal) throws InvalidConfigurationParametersException {
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
        if (targetParametersArray == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: targetParameters");
        }
        if (d <= 0.0) {
            throw new InvalidConfigurationParametersException(d);
        }
        Optional<ReceiverBand> optional = Optional.empty();
        try {
            optional = Optional.ofNullable(scienceGoal.getSpectralSetupParameters().getReceiverBand());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidConfigurationParametersException(d);
        }
        Optional<Configuration> optional2 = Configuration.getVLBIConfiguration(requestedArray, scienceGoal);
        if (optional2.isPresent()) {
            return optional2.get();
        }
        AngularResolutionMode angularResolutionMode = scienceGoal.getPerformanceParameters().getAngularResolutionMode();
        Configuration configuration = null;
        switch (angularResolutionMode) {
            case Any: {
                configuration = Configuration.getAnyConfiguration(requestedArray, scienceGoal);
                break;
            }
            case Range: {
                ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getRangeOptimalConfigurations(d, requestedArray, scienceGoal, optional);
                ConfigurationSet configurationSet = ConfigurationSet.getConfigurationRequiringMostTime(scienceGoalConfigurations, requestedArray);
                configuration = requestedArray.equals((Object)RequestedArray.TWELVE_M) ? configurationSet.getTM1Configuration().get() : configurationSet.getAca7mConfiguration().get();
                break;
            }
            case SACA: {
                configuration = Configuration.getSACAConfiguration(requestedArray, scienceGoal);
                break;
            }
            case Single: {
                double d2 = scienceGoal.getPerformanceParameters().getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC);
                configuration = Configuration.getSingleOptimalConfiguration(d, requestedArray, scienceGoal, optional, d2);
                break;
            }
            default: {
                throw new RuntimeException("Unknown angular resolution mode found " + angularResolutionMode);
            }
        }
        return configuration;
    }

    private static Optional<Configuration> getVLBIConfiguration(RequestedArray requestedArray, ScienceGoal scienceGoal) throws InvalidConfigurationParametersException {
        Optional<Configuration> optional;
        block3: {
            optional = Optional.empty();
            try {
                ObsProposal obsProposal = scienceGoal.getObsProposal();
                if (obsProposal == null || !obsProposal.isVLBIorPhasedArray()) break block3;
                if (RequestedArray.TWELVE_M.equals((Object)requestedArray)) {
                    optional = Optional.of(VLBI_CONFIGURATION.get((Object)RequestedArray.TWELVE_M));
                    break block3;
                }
                throw new InvalidConfigurationParametersException("VLBI is only compatible with the 12-m array");
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(Configuration.class).info("Unable to determine VLBI mode : " + unknownEntityException.getMessage());
            }
        }
        return optional;
    }

    public static ScienceGoalConfigurations<ConfigurationSet> getRangeOptimalConfigurations(double d, @NonNull RequestedArray requestedArray, @NonNull ScienceGoal scienceGoal, @NonNull Optional<ReceiverBand> optional) throws InvalidConfigurationParametersException {
        Object object;
        double d2;
        double d3;
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("receiverBand is marked non-null but is null");
        }
        Object object2 = new ScienceGoalConfigurations<ConfigurationSet>();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        if (performanceParameters == null) {
            throw new IllegalArgumentException("Could not locate performance parameters in the science goal");
        }
        double d4 = performanceParameters.getAcceptableAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC);
        double d5 = d4 < (d3 = performanceParameters.getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC)) ? d4 : d3;
        double d6 = d2 = d4 > d3 ? d4 : d3;
        if (d5 == d2) {
            ConfigurationSet configurationSet2 = Configuration.getArraySetForZeroWidthAngularResolutionRange(d, requestedArray, scienceGoal, optional);
            ((ArrayList)object2).add(configurationSet2);
            return object2;
        }
        TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
        Angle angle = Configuration.determineAverageDeclination(targetParametersArray);
        ConfigurationHelper.ConfigurationsForResolutionRange configurationsForResolutionRange = ConfigurationHelper.getConfigurationsForResolutionRange(d, requestedArray, scienceGoal, optional, angle, d5, d2);
        List<Configuration> list = configurationsForResolutionRange.getConfigurations();
        if (list.isEmpty()) {
            double d7 = Math.abs((d5 + d2) / 2.0);
            object = Configuration.getSingleOptimalConfiguration(d, requestedArray, scienceGoal, optional, d7);
            list.add((Configuration)object);
        }
        if (list.isEmpty()) {
            throw new InvalidConfigurationParametersException();
        }
        Log.logger(Configuration.class).finer("Range compatible configurations " + list.stream().map(configuration -> configuration.getName()).collect(Collectors.joining(",")));
        boolean bl = false;
        try {
            bl = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidConfigurationParametersException(d3, d4, d);
        }
        object2 = Configuration.getAdditionalArraysToSatisfyLAS(d, requestedArray, scienceGoal, targetParametersArray, list);
        int n = object2.stream().map(configurationSet -> configurationSet.getNoOfArrayRequired()).collect(Collectors.summarizingInt(Integer::intValue)).getMin();
        object = new ScienceGoalConfigurations();
        ((ScienceGoalConfigurations)object).setConfigurationsTruncated(((ScienceGoalConfigurations)object2).isConfigurationsTruncated());
        int n2 = ((ArrayList)object2).size();
        List list2 = object2.stream().filter(configurationSet -> configurationSet.getNoOfArrayRequired() == n).collect(Collectors.toList());
        if (list2.size() < n2) {
            ((ScienceGoalConfigurations)object).setConfigurationsTruncated(true);
        }
        if (list2.stream().filter(configurationSet -> configurationSet.isACA7mRequired() && !configurationSet.getTM2Configuration().isPresent()).findFirst().isPresent()) {
            n2 = list2.size();
            if ((list2 = list2.stream().filter(configurationSet -> !configurationSet.getTM1Configuration().isPresent() || !configurationSet.getTM2Configuration().isPresent()).collect(Collectors.toList())).size() < n2) {
                ((ScienceGoalConfigurations)object).setConfigurationsTruncated(true);
            }
        }
        ((ArrayList)object).addAll(list2);
        object2 = object;
        if (configurationsForResolutionRange.isLongbaselineConfigurationsTruncated()) {
            ((ScienceGoalConfigurations)object).setConfigurationsTruncated(true);
        }
        if (bl) {
            object2 = object2.stream().filter(configurationSet -> {
                if (configurationSet.getTM1Configuration().isEmpty()) {
                    return false;
                }
                Configuration configuration = configurationSet.getTM1Configuration().get();
                try {
                    return configuration.isConfigurationSolarCompatible(scienceGoal);
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    return false;
                }
            }).collect(Collectors.toCollection(() -> new ScienceGoalConfigurations()));
        }
        if (((ArrayList)object2).isEmpty()) {
            throw new InvalidConfigurationParametersException(d3, d4, d);
        }
        return object2;
    }

    public boolean isConfigurationSolarCompatible(@NonNull ScienceGoal scienceGoal) throws InvalidConfigurationParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        try {
            if (!scienceGoal.isSolarScienceGoal()) {
                return true;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidConfigurationParametersException();
        }
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        if (receiverBand == null) {
            throw new InvalidConfigurationParametersException();
        }
        if (this.solarCompatibleRxBs == null || this.solarCompatibleRxBs.isEmpty()) {
            return false;
        }
        return this.solarCompatibleRxBs.contains(receiverBand.getNumber());
    }

    private static ScienceGoalConfigurations<ConfigurationSet> getAdditionalArraysToSatisfyLAS(double d, RequestedArray requestedArray, ScienceGoal scienceGoal, TargetParameters[] targetParametersArray, List<Configuration> list) throws InvalidConfigurationParametersException {
        double d2 = scienceGoal.getPerformanceParameters().getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC);
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = new ScienceGoalConfigurations<ConfigurationSet>();
        Configuration configuration = Configuration.getKnownConfigurations(RequestedArray.SEVEN_M).get(0);
        double d3 = configuration.getRecoverableScale(d, targetParametersArray, RequestedArray.SEVEN_M);
        for (Configuration configuration2 : list) {
            Optional<Configuration> optional;
            ConfigurationSet configurationSet = new ConfigurationSet();
            boolean bl = SchedBlockExpert.determineIfTPArrayIsToBeUsed(true, scienceGoal);
            if (RequestedArray.SEVEN_M.equals((Object)requestedArray)) {
                configurationSet.setACA7mRequired(true);
                configurationSet.setAca7mConfiguration(configuration2);
                configurationSet.setTPRequired(bl);
                scienceGoalConfigurations.add(configurationSet);
                continue;
            }
            Configuration configuration3 = configuration2;
            configurationSet.setTM1Configuration(configuration2);
            try {
                if (scienceGoal.isSolarScienceGoal()) {
                    configurationSet.setTPRequired(true);
                    scienceGoalConfigurations.add(configurationSet);
                    continue;
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(Configuration.class).info("Unable to determine if solar science goal  : " + unknownEntityException.getMessage());
            }
            if (configsWithCompactConfigurations.containsKey(configuration2.getName()) && (optional = Configuration.getSecondCompactArray(configuration2, d2, d, scienceGoal)).isPresent()) {
                Configuration configuration4 = optional.get();
                configurationSet.setTM2Configuration(configuration4);
                configuration3 = configuration4;
            }
            boolean bl2 = d2 > configuration3.getRecoverableScale(d, targetParametersArray, RequestedArray.TWELVE_M);
            boolean bl3 = false;
            if (bl2) {
                if (configuration2.acaAllowed()) {
                    configurationSet.setACA7mRequired(true);
                    boolean bl4 = bl3 = d2 > d3;
                    if (scienceGoal.getPerformanceParameters().isSimultaneous12and7Observation()) {
                        configurationSet.removeTM2Configuration();
                    }
                } else {
                    scienceGoalConfigurations.setConfigurationsTruncated(true);
                    continue;
                }
            }
            if (configurationSet.isACA7mRequired()) {
                if (bl3 && !bl) {
                    scienceGoalConfigurations.setConfigurationsTruncated(true);
                    continue;
                }
                configurationSet.setTPRequired(bl);
            }
            scienceGoalConfigurations.add(configurationSet);
        }
        return scienceGoalConfigurations;
    }

    private static ConfigurationSet getArraySetForZeroWidthAngularResolutionRange(double d, RequestedArray requestedArray, ScienceGoal scienceGoal, Optional<ReceiverBand> optional) throws InvalidConfigurationParametersException {
        double d2 = scienceGoal.getPerformanceParameters().getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC);
        Configuration configuration = Configuration.getSingleOptimalConfiguration(d, requestedArray, scienceGoal, optional, d2);
        ConfigurationSet configurationSet = new ConfigurationSet();
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getAdditionalArraysToSatisfyLAS(d, requestedArray, scienceGoal, scienceGoal.getTargetParameters(), (List<Configuration>)ImmutableList.of((Object)configuration));
        if (scienceGoalConfigurations.isEmpty()) {
            throw new InvalidConfigurationParametersException("Unable to determine configuration that satisifies the desired LAS");
        }
        configurationSet = (ConfigurationSet)scienceGoalConfigurations.get(0);
        return configurationSet;
    }

    public static Optional<Configuration> getSecondCompactArray(Configuration configuration, double d, double d2, ScienceGoal scienceGoal) {
        if (Configuration.getIsSecondConfigurationRequired(configuration, d, d2, scienceGoal, RequestedArray.TWELVE_M, true)) {
            try {
                return Optional.of(Configuration.getSecondCompactConfiguration(configuration));
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static Configuration getSingleOptimalConfiguration(double d, RequestedArray requestedArray, @NonNull ScienceGoal scienceGoal, Optional<ReceiverBand> optional, double d2) throws InvalidConfigurationParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        if (performanceParameters == null) {
            throw new IllegalArgumentException("scienceGoal has no performance parameters");
        }
        double d3 = Configuration.getResolutionAtExpectedFrequency(d2, d, FrequencyConversion.TO_DATA_FILE_FREQ);
        Angle angle = Configuration.determineAverageDeclination(scienceGoal.getTargetParameters());
        Configuration configuration = null;
        double d4 = 0.0;
        for (Configuration configuration2 : Configuration.getConfigurations(d2, d, requestedArray, scienceGoal, optional)) {
            DeclinationData declinationData = Configuration.getConfigurationPerformanceDataForDeclination(requestedArray, configuration2, angle);
            double d5 = declinationData.getResolution().getArcsec();
            if (configuration == null) {
                configuration = configuration2;
                d4 = Math.abs(d5 - d3);
                continue;
            }
            double d6 = Math.abs(d5 - d3);
            if (d6 >= d4) break;
            d4 = d6;
            configuration = configuration2;
        }
        if (configuration != null) {
            try {
                if (!Configuration.isConfigurationCompatibleWhenSolarEnabled(scienceGoal, configuration)) {
                    throw new InvalidConfigurationParametersException("Most suitable configuration not compatible with solar " + configuration.getName());
                }
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new InvalidConfigurationParametersException(d2, d);
            }
            Log.logger(Configuration.class).finer(String.format("**Best configuration** for resolution %.4g arcsec (%.4g arcsec@100 GHz) at frequency %.4g GHz, declination %.4g for the %s array is %s", new Object[]{d2, d3, d, angle.getContentInDefaultUnits(), requestedArray, configuration.getName()}));
            return configuration;
        }
        throw new InvalidConfigurationParametersException(d2, d);
    }

    private static Configuration getSACAConfiguration(RequestedArray requestedArray, ScienceGoal scienceGoal) throws InvalidConfigurationParametersException {
        if (Configuration.isFixedConfigurationToBeReturned(scienceGoal, AngularResolutionMode.SACA) && RequestedArray.SEVEN_M.equals((Object)requestedArray)) {
            return MOST_COMPACT.get((Object)requestedArray);
        }
        throw new InvalidConfigurationParametersException();
    }

    private static Configuration getAnyConfiguration(@NonNull RequestedArray requestedArray, @NonNull ScienceGoal scienceGoal) throws InvalidConfigurationParametersException {
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (Configuration.isFixedConfigurationToBeReturned(scienceGoal, AngularResolutionMode.Any) && RequestedArray.TWELVE_M.equals((Object)requestedArray)) {
            return MOST_COMPACT.get((Object)requestedArray);
        }
        throw new InvalidConfigurationParametersException();
    }

    private static boolean isFixedConfigurationToBeReturned(@NonNull ScienceGoal scienceGoal, @NonNull AngularResolutionMode angularResolutionMode) throws InvalidConfigurationParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (angularResolutionMode == null) {
            throw new NullPointerException("angularResolutionMode is marked non-null but is null");
        }
        if (!EnumSet.of(AngularResolutionMode.Any, AngularResolutionMode.SACA).contains(angularResolutionMode)) {
            return false;
        }
        try {
            ObsProposal obsProposal = scienceGoal.getObsProposal();
            if (obsProposal != null && obsProposal.isVLBIorPhasedArray()) {
                return false;
            }
            switch (angularResolutionMode) {
                case Any: {
                    if (scienceGoal.getPerformanceParameters().isAngularResolutionModeAny()) {
                        return true;
                    }
                    break;
                }
                case SACA: {
                    if (scienceGoal.getPerformanceParameters().isAngularResolutionModeSACA()) {
                        return true;
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown angular resolution mode detected: " + angularResolutionMode);
                }
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidConfigurationParametersException();
        }
        return false;
    }

    public static boolean getIsSecondConfigurationRequired(Configuration configuration, Angle angle, Frequency frequency, ScienceGoal scienceGoal) {
        return Configuration.getIsSecondConfigurationRequired(configuration, angle.getContentInUnits(AngleData.UNIT_ARCSEC), frequency.getContentInGHz(), scienceGoal, RequestedArray.TWELVE_M, false);
    }

    public static boolean getIsSecondConfigurationRequired(@NonNull Configuration configuration, double d, double d2, @NonNull ScienceGoal scienceGoal, RequestedArray requestedArray, boolean bl) {
        Object object;
        if (configuration == null) {
            throw new NullPointerException("primaryConfiguration is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
        if (targetParametersArray.length < 1) {
            throw new IllegalArgumentException("Illegal argument: targetParameters.length (" + targetParametersArray.length + ") did not pass the test: targetParameters.length < 1");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Illegal argument: frequency (" + d2 + ") did not pass the test: frequency < 0");
        }
        if (!bl && scienceGoal.getPerformanceParameters().getIsSimultaneous12and7()) {
            return false;
        }
        if (d < 0.0) {
            return false;
        }
        if (!RequestedArray.TWELVE_M.equals((Object)requestedArray)) {
            return false;
        }
        boolean bl2 = false;
        try {
            object = targetParametersArray[0].getScienceGoal().getObsProposal();
            if (object != null) {
                bl2 = object.isVLBIorPhasedArray();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(Configuration.class).info("Unable to determine VLBI mode : " + unknownEntityException.getMessage());
        }
        if (bl2) {
            return false;
        }
        try {
            if (Configuration.isFixedConfigurationToBeReturned(scienceGoal, AngularResolutionMode.Any)) {
                return false;
            }
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            return false;
        }
        object = Configuration.determineAverageDeclination(targetParametersArray);
        DeclinationData declinationData = null;
        try {
            declinationData = Configuration.getConfigurationPerformanceDataForDeclination(requestedArray, configuration, (Angle)((Object)object));
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger(Configuration.class).warning(String.format("Unable to determine configuration performance data for array %s for config %s for a dec of %.4g", new Object[]{requestedArray, configuration.getName(), object.getContentInUnits(Angle.UNIT_ARCSEC)}));
            return false;
        }
        assert (declinationData != null);
        double d3 = Configuration.getLASAtExpectedFreq(d, d2, FrequencyConversion.TO_DATA_FILE_FREQ);
        boolean bl3 = declinationData.getLAS().isLessThan((AbstractDoubleWithUnit)Angle.createAngle((double)d3, (String)Angle.UNIT_ARCSEC));
        Log.logger(Configuration.class).finer(String.format("Achievable LAS for %s is %.4g arcsecs: requested LAS is %.4g (%.4g@100GHz) for RF of %.4g GHz - second configuration %s", configuration.getName(), Configuration.getLASAtExpectedFreq(declinationData.getLAS().getContentInUnits(Angle.UNIT_ARCSEC), d2, FrequencyConversion.TO_REP_FREQ), d, d3, d2, bl3 ? "required" : "not required"));
        return bl3;
    }

    private static double getLASAtExpectedFreq(double d, double d2, @NonNull FrequencyConversion frequencyConversion) {
        double d3;
        if (frequencyConversion == null) {
            throw new NullPointerException("conversionType is marked non-null but is null");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Illegal argument: resolution (" + d + ") did not pass the test: las < 0");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Illegal argument: frequency (" + d2 + ") did not pass the test: frequency < 0 ");
        }
        switch (frequencyConversion) {
            case TO_REP_FREQ: {
                d3 = d * (100.0 / d2);
                break;
            }
            case TO_DATA_FILE_FREQ: {
                d3 = d * (d2 / 100.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("conversionType not known: " + frequencyConversion);
            }
        }
        return d3;
    }

    private static double getResolutionAtExpectedFrequency(double d, double d2, @NonNull FrequencyConversion frequencyConversion) {
        double d3;
        if (frequencyConversion == null) {
            throw new NullPointerException("conversionType is marked non-null but is null");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Illegal argument: resolution (" + d + ") did not pass the test: resolution < 0");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Illegal argument: frequency (" + d2 + ") did not pass the test: frequency < 0 ");
        }
        switch (frequencyConversion) {
            case TO_REP_FREQ: {
                d3 = d * (100.0 / d2);
                break;
            }
            case TO_DATA_FILE_FREQ: {
                d3 = d * (d2 / 100.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("conversionType not known: " + frequencyConversion);
            }
        }
        return d3;
    }

    public static Configuration getSecondCompactConfiguration(@NonNull Configuration configuration) throws InvalidConfigurationParametersException {
        if (configuration == null) {
            throw new NullPointerException("extendedConfiguration is marked non-null but is null");
        }
        assert (configsWithCompactConfigurations != null);
        if (!configsWithCompactConfigurations.containsKey(configuration.getName())) {
            throw new InvalidConfigurationParametersException("Could not find a suitable second array configuration");
        }
        String string = configsWithCompactConfigurations.get(configuration.getName());
        Configuration configuration2 = null;
        try {
            configuration2 = Configuration.getConfiguration(string, RequestedArray.TWELVE_M);
        }
        catch (UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
            String string2 = "Unable to determine configuration for : " + string;
            Log.logger(Configuration.class).warning(string2);
            throw new InvalidConfigurationParametersException(string2);
        }
        assert (configuration2 != null);
        return configuration2;
    }

    public static Configuration getConfiguration(@NonNull String string, @NonNull RequestedArray requestedArray) throws UnableToDetermineConfigurationException {
        if (string == null) {
            throw new NullPointerException("configName is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (!ALL_CONFIGS.containsKey((Object)requestedArray)) {
            throw new UnableToDetermineConfigurationException("Unable to find configuration: " + string);
        }
        for (Configuration configuration : ALL_CONFIGS.get((Object)requestedArray)) {
            if (!configuration.getName().equals(string)) continue;
            return configuration;
        }
        throw new UnableToDetermineConfigurationException("Unable to find configuration: " + string);
    }

    public int getNumber() {
        return this.configNumber;
    }

    public Length getMaxBaselineVUP() {
        return LengthData.createLength((double)this.maxBaseline, (String)LengthData.UNIT_M);
    }

    public boolean isLongBaselineConfiguration() {
        return Configuration.isLongBaselineConfiguration(this);
    }

    public Length getMinBaselineVUP() {
        return LengthData.createLength((double)this.minBaseline, (String)LengthData.UNIT_M);
    }

    public double getACA7mMultiplier() throws InvalidObsProgramParametersException {
        if (this.acaMultiplier == 0.0) {
            throw new InvalidObsProgramParametersException("The LAS cannot be achieved as only two 12-m configurations are allowed.");
        }
        return this.acaMultiplier;
    }

    public double getACATPMultiplier() throws InvalidObsProgramParametersException {
        return this.tpMultiplier;
    }

    public double get12mCompactMultiplier(@NonNull Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("extendedConfiguration is marked non-null but is null");
        }
        String string = configuration.getName();
        Double d = null;
        if (twelveMCompactTimeMultipliers.containsKey(string)) {
            d = twelveMCompactTimeMultipliers.get(string).get(this.getName());
        }
        if (d == null) {
            throw new IllegalArgumentException("No multiplier associated found for " + string);
        }
        return d;
    }

    public String getName() {
        return this.configName;
    }

    public String getCanonicalName() {
        return this.configName.replaceAll("C[0-9]+", "C");
    }

    public String[] getSupportedReceivers() {
        return this.supportedReceivers;
    }

    public boolean acaAllowed() {
        return this.acaAllowed;
    }

    public boolean isReceiverSupported(@NonNull ReceiverBand receiverBand) {
        if (receiverBand == null) {
            throw new NullPointerException("rxBand is marked non-null but is null");
        }
        int n = receiverBand.getNumber();
        for (String string : this.supportedReceivers) {
            try {
                if (Integer.parseInt(string) != n) continue;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return false;
    }

    public double getAchievableResolution(double d, @NonNull ScienceGoal scienceGoal, @NonNull RequestedArray requestedArray) throws InvalidConfigurationParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        Angle angle = Configuration.determineAverageDeclination(scienceGoal.getTargetParameters());
        DeclinationData declinationData = Configuration.getConfigurationPerformanceDataForDeclination(requestedArray, this, angle);
        double d2 = declinationData.getResolution().getArcsec();
        return Configuration.getResolutionAtExpectedFrequency(d2, d, FrequencyConversion.TO_REP_FREQ);
    }

    public double getRecoverableScale(double d, @NonNull TargetParameters[] targetParametersArray, @NonNull RequestedArray requestedArray) throws InvalidConfigurationParametersException {
        if (targetParametersArray == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (targetParametersArray.length == 0) {
            throw new IllegalArgumentException("Illegal argument: targetParameters.length (" + targetParametersArray.length + ") did not pass the test: targetParameters.length == 0");
        }
        Angle angle = Configuration.determineAverageDeclination(targetParametersArray);
        DeclinationData declinationData = Configuration.getConfigurationPerformanceDataForDeclination(requestedArray, this, angle);
        assert (declinationData != null);
        double d2 = declinationData.getLAS().getArcsec();
        double d3 = Configuration.getLASAtExpectedFreq(d2, d, FrequencyConversion.TO_REP_FREQ);
        return d3;
    }

    public Angle getAchievableAngularResolutionForClusters(@NonNull ScienceGoal scienceGoal, @NonNull SfiControlParameterModel.RequestAngularResolutionEnum requestAngularResolutionEnum, @NonNull Frequency frequency, RequestedArray requestedArray) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (requestAngularResolutionEnum == null) {
            throw new NullPointerException("angularResolutionPerformance is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("repFreq is marked non-null but is null");
        }
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        Double d = null;
        block4: for (ScienceGoal scienceGoal2 : sourceClusterDetector.splitScienceGoalIntoSourceClusters()) {
            double d2 = this.getAchievableResolution(frequency.getContentInGHz(), scienceGoal2, requestedArray);
            if (d == null) {
                d = d2;
                continue;
            }
            switch (requestAngularResolutionEnum) {
                case FINEST: {
                    if (!(d2 < d)) continue block4;
                    d = d2;
                    continue block4;
                }
                case COARSEST: {
                    if (!(d2 > d)) continue block4;
                    d = d2;
                    continue block4;
                }
            }
            throw new RuntimeException("Unable to determine the performance required " + requestAngularResolutionEnum);
        }
        return Angle.createAngle((double)d, (String)Angle.UNIT_ARCSEC);
    }

    private static void addConfiguration(Configuration configuration, RequestedArray requestedArray) {
        ALL_CONFIGS.get((Object)requestedArray).add(configuration);
    }

    public static DeclinationData getConfigurationPerformanceDataForDeclination(RequestedArray requestedArray, Configuration configuration, Angle angle) throws InvalidConfigurationParametersException {
        Object object;
        double d;
        double d2;
        double d3;
        double d4;
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        double[] dArray4;
        double[] dArray5;
        if (configuration.equals(ILLEGAL_CONFIG)) {
            throw new InvalidConfigurationParametersException("Unable to determine configuration for the specified parameters");
        }
        double d5 = angle.getDegs();
        int n = Objects.hash(new Object[]{requestedArray, configuration, d5});
        DeclinationData declinationData = (DeclinationData)declinationCache.get((Object)n);
        if (declinationData != null) {
            return declinationData;
        }
        if (!interpolationMap.get((Object)requestedArray).containsKey(configuration)) {
            int n2 = declinationDataMap.get((Object)requestedArray).get(configuration).size();
            assert (n2 > 0);
            dArray5 = new double[n2];
            dArray4 = new double[n2];
            dArray3 = new double[n2];
            dArray2 = new double[n2];
            dArray = new double[n2];
            int n3 = 0;
            for (DeclinationData declinationData2 : declinationDataMap.get((Object)requestedArray).get(configuration)) {
                dArray5[n3] = declinationData2.getDec().getDegs();
                dArray4[n3] = declinationData2.getLAS().getArcsec();
                dArray3[n3] = declinationData2.getResolution().getArcsec();
                dArray2[n3] = declinationData2.getMinorAxis().getArcsec();
                dArray[n3] = declinationData2.getMajorAxis().getArcsec();
                ++n3;
            }
            interpolationMap.get((Object)requestedArray).put(configuration, new InterpolationRange(dArray5, dArray4, dArray3, dArray2, dArray));
        } else {
            InterpolationRange interpolationRange = interpolationMap.get((Object)requestedArray).get(configuration);
            dArray5 = interpolationRange.getDecArray();
            dArray4 = interpolationRange.getLasArray();
            dArray3 = interpolationRange.getArArray();
            dArray2 = interpolationRange.getMinorAxisArray();
            dArray = interpolationRange.getMajorAxisArray();
        }
        int n4 = dArray5.length - 1;
        if (d5 < dArray5[0]) {
            d4 = dArray4[0];
            d3 = dArray3[0];
            d2 = dArray2[0];
            d = dArray[0];
        } else if (d5 > dArray5[n4]) {
            d4 = dArray4[n4];
            d3 = dArray3[n4];
            d2 = dArray2[n4];
            d = dArray[n4];
        } else {
            object = new LinearInterpolator();
            d3 = object.interpolate(dArray5, dArray3).value(d5);
            d4 = object.interpolate(dArray5, dArray4).value(d5);
            d2 = object.interpolate(dArray5, dArray2).value(d5);
            d = object.interpolate(dArray5, dArray).value(d5);
        }
        object = new DeclinationData(d5, d3, d4, d2, d);
        if (Log.logger(Configuration.class).fine()) {
            Log.logger(Configuration.class).fine(String.format("Optimum declination for candidate declination %.4g degs for %s+%s is %.4g with resolution=%.4g arcsec LAS=%.4g arcsec", new Object[]{angle.getContentInUnits(Angle.UNIT_DEG), requestedArray, configuration.getName(), ((DeclinationData)object).getDec().getDegs(), ((DeclinationData)object).getResolution().getArcsec(), ((DeclinationData)object).getLAS().getArcsec()}));
        }
        declinationCache.put((Object)n, object);
        return object;
    }

    public static Configuration getMostCompactConfiguration(@NonNull RequestedArray requestedArray) throws UnableToDetermineConfigurationException {
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (!MOST_COMPACT.containsKey((Object)requestedArray)) {
            throw new UnableToDetermineConfigurationException("Unable to determine most compact configuration for array: " + requestedArray);
        }
        return MOST_COMPACT.get((Object)requestedArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double getArrayTimeMultiplier(@NonNull MultiplierEnumType multiplierEnumType, @NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        void var5_9;
        if (multiplierEnumType == null) {
            throw new NullPointerException("multiplierType is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        double d = 1.0;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        try {
            ObsProposal obsProposal = scienceGoal.getObsProposal();
            if (obsProposal != null && obsProposal.isVLBIorPhasedArray()) {
                return d;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException("Unable to determine ObsProposal" + unknownEntityException);
        }
        try {
            if (scienceGoal.isSolarScienceGoal()) {
                if (!multiplierEnumType.equals((Object)MultiplierEnumType.COMPACT12M)) return 1.0;
                return 0.0;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException("Unable to determine if SG is solar: " + unknownEntityException.getMessage());
        }
        RequestedArray requestedArray = RequestedArray.TWELVE_M;
        if (scienceGoal.isStandAloneACA()) {
            switch (multiplierEnumType) {
                case ACA7M: {
                    return 1.0;
                }
                case ACATP: {
                    RequestedArray requestedArray2 = RequestedArray.SEVEN_M;
                    break;
                }
                default: {
                    throw new RuntimeException("Unable to determine multiplier for " + multiplierEnumType + " if in standalone ACA mode");
                }
            }
        }
        if (performanceParameters.isAngularResolutionModeRange() && performanceParameters.getDesiredSensitivity().inFluxUnit()) {
            ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
            if (scienceGoalConfigurations.isEmpty()) {
                return d;
            }
            Optional<ConfigurationSet> optional = scienceGoalConfigurations.getMostTimeDemandingSolutionSet(scienceGoal);
            if (!optional.isPresent()) return d;
            ConfigurationSet configurationSet = optional.get();
            switch (multiplierEnumType) {
                case ACA7M: {
                    if (!configurationSet.getTM1Configuration().isPresent()) return d;
                    Configuration configuration = configurationSet.getTM1Configuration().get();
                    return performanceParameters.isSimultaneous12and7Observation() ? configuration.getSimultaneous12mAnd7mMultiplier() : configuration.getACA7mMultiplier();
                }
                case ACATP: {
                    if (!configurationSet.isTPRequired()) return d;
                    Configuration configuration = configurationSet.getTM1Configuration().get();
                    return performanceParameters.isSimultaneous12and7Observation() ? configuration.getSimultaneous12mAnd7mMultiplier() : configuration.getACATPMultiplier();
                }
                case COMPACT12M: {
                    if (!configurationSet.getTM2Configuration().isPresent()) return 0.0;
                    double d2 = configurationSet.getTM1Configuration().get().compact12mMultiplier;
                    return d2;
                }
                default: {
                    throw new RuntimeException("Unable to handle the option " + multiplierEnumType);
                }
            }
        }
        Configuration configuration = Configuration.getBestArrayConfiguration(scienceGoal, (RequestedArray)var5_9);
        assert (configuration != null);
        try {
            if (!configuration.isConfigurationSolarCompatible(scienceGoal)) {
                throw new InvalidObsProgramParametersException("Configuration is not compatible with solar");
            }
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            throw new InvalidObsProgramParametersException("Configuration is not compatible with solar");
        }
        boolean bl = PerformanceParameters.isSimultaneous12and7Observation(performanceParameters);
        switch (multiplierEnumType) {
            case ACA7M: {
                if (bl) {
                    Configuration configuration2 = Configuration.getBestArrayConfiguration(scienceGoal, RequestedArray.TWELVE_M);
                    d = configuration2.getSimultaneous12mAnd7mMultiplier();
                    break;
                }
                d = configuration.getACA7mMultiplier();
                break;
            }
            case ACATP: {
                d = bl ? configuration.getSimultaneous12mAnd7mMultiplier() : configuration.getACATPMultiplier();
                break;
            }
            case COMPACT12M: {
                d = Configuration.get12mCompactArrayConfigurationTimeMultiplier(scienceGoal);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ACA array type specified " + multiplierEnumType);
            }
        }
        Log.logger(Configuration.class).fine(String.format("Multiplier for array %s for configuration %s is %g", new Object[]{multiplierEnumType, configuration.getName(), d}));
        return d;
    }

    private static Configuration getBestArrayConfiguration(ScienceGoal scienceGoal, RequestedArray requestedArray) throws InvalidObsProgramParametersException {
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Configuration configuration = null;
        try {
            configuration = Configuration.getBestConfiguration(performanceParameters.getDesiredAngularResolution(), frequency, requestedArray, scienceGoal);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger(Configuration.class).warning("In ArrayTimeMultiplier: Cannot establish the best configuration for a desired angular resolution of " + performanceParameters.getDesiredAngularResolution() + " with a rep. freq of " + frequency);
            throw new InvalidObsProgramParametersException(invalidConfigurationParametersException);
        }
        return configuration;
    }

    public static double getShadowMultiplierForArray(@NonNull Array array, @NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        Object object;
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        try {
            object = scienceGoal.getObsProposal();
            if (scienceGoal.isSolarScienceGoal() || object != null && object.isVLBIorPhasedArray()) {
                return 1.0;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException("Unable to determine if this is a special (i.e. VLBI or Solar) proposal" + unknownEntityException);
        }
        object = scienceGoal.getRepresentativeFrequencyInSky();
        if (object.isZero()) {
            return 1.0;
        }
        Angle angle = Configuration.determineAverageDeclination(scienceGoal.getTargetParameters());
        if (scienceGoal.isStandAloneACA() && array == Array.ARRAY_7M) {
            double d = Shadowing.getShadowingPercentageForDeclination("ACA", angle);
            return 1.0 - d / 100.0;
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        RequestedArray requestedArray = RequestedArray.TWELVE_M;
        switch (array) {
            case ARRAY_7M: {
                requestedArray = RequestedArray.SEVEN_M;
                break;
            }
            case ARRAY_12M: {
                requestedArray = RequestedArray.TWELVE_M;
                break;
            }
            case ARRAY_TP: {
                return 1.0;
            }
            default: {
                return 1.0;
            }
        }
        Configuration configuration = null;
        double d = 0.0;
        try {
            configuration = Configuration.getBestConfiguration(performanceParameters.getDesiredAngularResolution(), (Frequency)((Object)object), requestedArray, scienceGoal);
            d = Shadowing.getShadowingPercentageForDeclination(configuration.getName(), angle);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            return 1.0;
        }
        double d2 = 1.0 - d / 100.0;
        return d2;
    }

    public static double getShadowingPercentage(@NonNull Array array, @NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        Object object;
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        try {
            object = scienceGoal.getObsProposal();
            if (scienceGoal.isSolarScienceGoal() || object != null && object.isVLBIorPhasedArray()) {
                return 0.0;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException("Unable to determine if this is a special (i.e. VLBI or Solar) proposal" + unknownEntityException);
        }
        object = scienceGoal.getRepresentativeFrequencyInSky();
        if (object.isZero()) {
            return 0.0;
        }
        Angle angle = Configuration.determineAverageDeclination(scienceGoal.getTargetParameters());
        if (scienceGoal.isStandAloneACA() && array == Array.ARRAY_7M) {
            return Shadowing.getShadowingPercentageForDeclination("ACA", angle);
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        RequestedArray requestedArray = RequestedArray.TWELVE_M;
        switch (array) {
            case ARRAY_7M: {
                requestedArray = RequestedArray.SEVEN_M;
                break;
            }
            case ARRAY_12M: {
                requestedArray = RequestedArray.TWELVE_M;
                break;
            }
            case ARRAY_TP: {
                return 0.0;
            }
            default: {
                return 0.0;
            }
        }
        Configuration configuration = null;
        double d = 0.0;
        try {
            configuration = Configuration.getBestConfiguration(performanceParameters.getDesiredAngularResolution(), (Frequency)((Object)object), requestedArray, scienceGoal);
            d = Shadowing.getShadowingPercentageForDeclination(configuration.getName(), angle);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            return 0.0;
        }
        return d;
    }

    public static boolean isConfigurationCompatibleWhenSolarEnabled(ScienceGoal scienceGoal, Configuration configuration) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        boolean bl;
        try {
            bl = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        return !bl || configuration.isConfigurationSolarCompatible(scienceGoal);
    }

    public static ScienceGoalConfigurations<ConfigurationSet> getConfigurationsToBeScheduled(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        RequestedArray requestedArray = scienceGoal.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
        return Configuration.getConfigurationsToBeScheduled(scienceGoal, requestedArray);
    }

    public static ScienceGoalConfigurations<ConfigurationSet> getConfigurationsToBeScheduledForAllClusteredScienceGoals(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        RequestedArray requestedArray = scienceGoal.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = new ScienceGoalConfigurations<ConfigurationSet>();
        for (ScienceGoal scienceGoal2 : sourceClusterDetector.splitScienceGoalIntoSourceClusters()) {
            scienceGoalConfigurations.addAll(Configuration.getConfigurationsToBeScheduled(scienceGoal2, requestedArray));
        }
        return scienceGoalConfigurations;
    }

    public static ScienceGoalConfigurations<ConfigurationSet> getConfigurationsToBeScheduled(ScienceGoal scienceGoal, RequestedArray requestedArray) throws InvalidObsProgramParametersException {
        boolean bl;
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations;
        Integer n = null;
        if (!isConfigurationSetCacheEnabled || (scienceGoalConfigurations = (ScienceGoalConfigurations<ConfigurationSet>)configurationSetCache.get((Object)(n = Integer.valueOf(Objects.hash(new Object[]{requestedArray, scienceGoal.toXml()}))))) != null) {
            // empty if block
        }
        if (!EnumSet.of(RequestedArray.SEVEN_M, RequestedArray.TWELVE_M).contains((Object)requestedArray)) {
            throw new IllegalArgumentException("Illegal argument: array must be 12-m or ACA 7-m");
        }
        scienceGoalConfigurations = new ScienceGoalConfigurations<ConfigurationSet>();
        ConfigurationSet configurationSet = new ConfigurationSet();
        if (requestedArray.getArray().equals((Object)Array.ARRAY_7M)) {
            Configuration configuration;
            try {
                configuration = Configuration.getMostCompactConfiguration(requestedArray);
            }
            catch (UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
                throw new RuntimeException("Unable to determine ACA-7m configuration");
            }
            configurationSet.setAca7mConfiguration(configuration);
            configurationSet.setACA7mRequired(true);
            configurationSet.setTPRequired(SchedBlockExpert.determineIfTPArrayIsToBeUsed(true, scienceGoal));
            scienceGoalConfigurations.add(configurationSet);
            if (isConfigurationSetCacheEnabled) {
                configurationSetCache.put((Object)n, (Object)scienceGoalConfigurations);
            }
            return scienceGoalConfigurations;
        }
        try {
            ObsProposal obsProposal = scienceGoal.getObsProposal();
            if (obsProposal != null && obsProposal.isVLBIorPhasedArray()) {
                configurationSet.setTM1Configuration(MOST_COMPACT.get((Object)requestedArray));
                scienceGoalConfigurations.add(configurationSet);
                return scienceGoalConfigurations;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException("Unable to determine ObsProposal" + unknownEntityException);
        }
        try {
            bl = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        Configuration configuration = null;
        try {
            if (performanceParameters.isAngularResolutionModeRange()) {
                ReceiverBand receiverBand = scienceGoal.getSpectralSetupParameters().getReceiverBand();
                if (receiverBand == null) {
                    throw new InvalidObsProgramParametersException("Unable to determine receiverBand");
                }
                scienceGoalConfigurations = Configuration.getRangeOptimalConfigurations(frequency.getContentInGHz(), requestedArray, scienceGoal, Optional.of(receiverBand));
                if (isConfigurationSetCacheEnabled) {
                    configurationSetCache.put((Object)n, scienceGoalConfigurations);
                }
                return scienceGoalConfigurations;
            }
            if (performanceParameters.isAngularResolutionModeAny()) {
                scienceGoalConfigurations = Configuration.getAnyConfigurationSets(bl, scienceGoal.getReceiverBand());
                if (isConfigurationSetCacheEnabled) {
                    configurationSetCache.put((Object)n, scienceGoalConfigurations);
                }
                return scienceGoalConfigurations;
            }
            configuration = Configuration.getBestConfiguration(performanceParameters.getDesiredAngularResolution(), frequency, requestedArray, scienceGoal);
            scienceGoalConfigurations = Configuration.getAdditionalArraysToSatisfyLAS(frequency.getContentInGHz(), requestedArray, scienceGoal, scienceGoal.getTargetParameters(), (List<Configuration>)ImmutableList.of((Object)configuration));
            if (scienceGoalConfigurations.isEmpty()) {
                throw new InvalidObsProgramParametersException("Unable to calculate optimal array configuration - please check the LAS and/or the desired angular resolution specified.");
            }
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            String string = "Cannot establish the best 12-m extended array configuration for a desired angular resolution of " + performanceParameters.getDesiredAngularResolution() + " with a rep. freq of " + frequency;
            throw new InvalidObsProgramParametersException(string);
        }
        if (bl) {
            try {
                if (!configuration.isConfigurationSolarCompatible(scienceGoal)) {
                    String string = "Cannot determine a 12-m configuration for the desired angular resolution of " + performanceParameters.getDesiredAngularResolution() + " with a rep. freq of " + frequency + " when configured for solar";
                    Log.logger(Configuration.class).fine(string);
                    throw new InvalidObsProgramParametersException(string);
                }
                if (isConfigurationSetCacheEnabled) {
                    configurationSetCache.put((Object)n, scienceGoalConfigurations);
                }
                return scienceGoalConfigurations;
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                invalidConfigurationParametersException.printStackTrace();
            }
        }
        if (Configuration.getIsSecondConfigurationRequired(configuration, performanceParameters.getDesiredLargestScale(), frequency, scienceGoal)) {
            try {
                Configuration configuration2 = Configuration.getSecondCompactConfiguration(configuration);
                configurationSet.setTM2Configuration(configuration2);
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                // empty catch block
            }
        }
        if (isConfigurationSetCacheEnabled) {
            configurationSetCache.put((Object)n, scienceGoalConfigurations);
        }
        return scienceGoalConfigurations;
    }

    private static ScienceGoalConfigurations<ConfigurationSet> getAnyConfigurationSets(boolean bl, ReceiverBand receiverBand) {
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = new ScienceGoalConfigurations<ConfigurationSet>();
        List<Object> list = new ArrayList();
        if (receiverBand != null) {
            list = Configuration.getSolarConfigurations(receiverBand);
        }
        for (Configuration configuration : Configuration.getAnyConfigurations()) {
            if (bl && !list.contains(configuration)) continue;
            ConfigurationSet configurationSet = new ConfigurationSet();
            configurationSet.setTM1Configuration(configuration);
            if (bl) {
                configurationSet.setTPRequired(true);
            }
            scienceGoalConfigurations.add(configurationSet);
        }
        return scienceGoalConfigurations;
    }

    private static double get12mCompactArrayConfigurationTimeMultiplier(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        Object object;
        Double d = 0.0;
        assert (scienceGoal != null);
        try {
            object = scienceGoal.getObsProposal();
            if (object != null && ((ObsProposal)((Object)object)).isVLBIorPhasedArray()) {
                return d;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ObservingTimeCalculator.class).warning("Unable to determine if project is a VLBI project");
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        object = scienceGoal.getPerformanceParameters();
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        if (((PerformanceParameters)object).isAngularResolutionModeRange() && object.getDesiredSensitivity().inFluxUnit()) {
            ConfigurationSet configurationSet;
            ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
            if (scienceGoalConfigurations.isEmpty()) {
                return d;
            }
            Optional<ConfigurationSet> optional = scienceGoalConfigurations.getMostTimeDemandingSolutionSet(scienceGoal);
            if (optional.isPresent() && (configurationSet = optional.get()).getTM2Configuration().isPresent()) {
                d = configurationSet.getTM1Configuration().get().compact12mMultiplier;
            }
        } else {
            Configuration configuration = null;
            try {
                configuration = Configuration.getBestConfiguration(object.getDesiredAngularResolution(), frequency, RequestedArray.TWELVE_M, scienceGoal);
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                Log.logger(Configuration.class).warning("Cannot establish the best array configuration for a desired angular resolution of " + object.getDesiredAngularResolution() + " with a rep. freq of " + frequency);
                throw new InvalidObsProgramParametersException(invalidConfigurationParametersException);
            }
            if (Configuration.getIsSecondConfigurationRequired(configuration, object.getDesiredLargestScale(), frequency, scienceGoal)) {
                try {
                    Configuration.getSecondCompactConfiguration(configuration);
                    d = d + configuration.getCompact12mMultiplier();
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    // empty catch block
                }
            }
        }
        return d;
    }

    public double getMaxBaseline() {
        return this.maxBaseline;
    }

    public double getMinBaseline() {
        return this.minBaseline;
    }

    public double getCompact12mMultiplier() {
        return this.compact12mMultiplier;
    }

    public double getAcaMultiplier() {
        return this.acaMultiplier;
    }

    public double getTpMultiplier() {
        return this.tpMultiplier;
    }

    public double getSimultaneous12mAnd7mMultiplier() {
        return this.simultaneous12mAnd7mMultiplier;
    }

    public List<Integer> getSolarCompatibleRxBs() {
        return this.solarCompatibleRxBs;
    }

    static {
        nonReceivers = ImmutableList.of((Object)0);
        ILLEGAL_CONFIG = new Configuration(0, 0.0, 0.0, "Config0", nonReceivers, true, 0.0, 0.0, 0.0, null, 0.0, null, null);
        NO_CONFIG = new Configuration(0, 0.0, 0.0, "None", nonReceivers, true, 0.0, 0.0, 0.0, null, 0.0, null, null);
        VLBI_CONFIGURATION = new HashMap<RequestedArray, Configuration>();
        ALL_CONFIGS = new HashMap<RequestedArray, List<Configuration>>();
        declinationDataMap = new ConcurrentHashMap<RequestedArray, LinkedHashMap<Configuration, ArrayList<DeclinationData>>>();
        isConfigurationSetCacheEnabled = false;
        twelveMCompactTimeMultipliers = new HashMap<String, Map<String, Double>>();
        interpolationMap = new ConcurrentHashMap<RequestedArray, Map<Configuration, InterpolationRange>>();
        declinationCache = JCS.getInstance((String)"declinationCache");
        configurationSetCache = JCS.getInstance((String)"configurationSetCache");
        configsWithCompactConfigurations = new HashMap<String, String>();
        MOST_COMPACT = new HashMap<RequestedArray, Configuration>();
        MOST_EXTENDED = new HashMap<RequestedArray, Configuration>();
        MOST_EXTENDED_NON_LONGBASELINE = new HashMap<RequestedArray, Configuration>();
        LONGBASELINE_CONFIGS = new LinkedHashSet<Configuration>();
        DGC_CONFIGS = new LinkedHashSet<Configuration>();
        ANY_CONFIGS = new LinkedHashSet<Configuration>();
        for (RequestedArray requestedArray : RequestedArray.values()) {
            declinationDataMap.put(requestedArray, new LinkedHashMap());
            interpolationMap.put(requestedArray, new ConcurrentHashMap());
        }
        for (RequestedArray requestedArray : RequestedArray.values()) {
            ALL_CONFIGS.put(requestedArray, new ArrayList());
        }
        Configuration.refreshArrayConfigurations();
    }

    public static class UnableToReadDeclinationFileException
    extends Exception {
        private static final long serialVersionUID = -6829886701997275722L;

        public UnableToReadDeclinationFileException(String string) {
            super(string);
        }
    }

    public static class DeclinationDataComparator<T extends DeclinationData>
    implements Comparator<T> {
        @Override
        public int compare(T t, T t2) {
            return ((DeclinationData)t).getDec().compareTo((AbstractDoubleWithUnit)((DeclinationData)t2).getDec());
        }
    }

    public static class UnableToDetermineConfigurationException
    extends Exception {
        private static final long serialVersionUID = 1375772038754743074L;

        public UnableToDetermineConfigurationException(String string) {
            super(string);
        }
    }

    private static enum FrequencyConversion {
        TO_DATA_FILE_FREQ,
        TO_REP_FREQ;

    }

    public static enum MultiplierEnumType {
        ACA7M,
        ACATP,
        COMPACT12M;

    }

    public static enum ConfigurationExtent {
        EXTENDED,
        COMPACT;

    }

    public static enum DesiredAngularResolution {
        FINEST,
        COARSEST;

    }
}

