/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.valuetypes.Time;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public class SolarExecutionTimeCalculator {
    public static final double t_i = 25.0;
    public static final double t_p = 3.0;
    private final Map<Integer, Double> t_int_scan_map;
    private final Map<Integer, Double> t_tp_scan_map;
    private final Map<Integer, Double> t_t_per_band;
    private final Map<Integer, Double> t_tp_scan_regional_mapping_map;

    public SolarExecutionTimeCalculator() {
        List<OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand> list = AlmaCapabilities.getInstance().getSolarBands();
        assert (list != null);
        this.t_int_scan_map = list.stream().collect(Collectors.toMap(OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand::getBand, solarBand -> OTConfigurationHelper.getTime(solarBand.getTIntScan()).getMins()));
        this.t_tp_scan_map = list.stream().collect(Collectors.toMap(OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand::getBand, solarBand -> OTConfigurationHelper.getTime(solarBand.getTTpScan()).getMins()));
        this.t_tp_scan_regional_mapping_map = list.stream().collect(Collectors.toMap(OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand::getBand, solarBand -> OTConfigurationHelper.getTime(solarBand.getTTpScanRegionalMapping()).getMins()));
        this.t_t_per_band = list.stream().collect(Collectors.toMap(OTConfiguration.TelescopeCapabilities.SolarBands.SolarBand::getBand, solarBand -> OTConfigurationHelper.getTime(solarBand.getTTMax()).getMins()));
    }

    public SolarExecutionTimeResult calculateSolarIntegrationTimes(@NonNull Time time, int n, int n2, boolean bl) {
        if (time == null) {
            throw new NullPointerException("piDefinedExecutionTime is marked non-null but is null");
        }
        if (!(this.t_int_scan_map.containsKey(n) && this.t_tp_scan_map.containsKey(n) && this.t_tp_scan_regional_mapping_map.containsKey(n))) {
            throw new IllegalArgumentException("bandNo should be a valid solar band");
        }
        SolarExecutionTimeResult solarExecutionTimeResult = new SolarExecutionTimeResult();
        double d = this.t_int_scan_map.get(n);
        double d2 = time.getContentInUnits(Time.UNIT_MIN);
        double d3 = this.t_t_per_band.get(n);
        double d4 = Math.ceil(d2 / d3);
        double d5 = d2 / d4;
        double d6 = 25.0 + d5 + 3.0 * (Math.floor(d5 / d) + 2.0);
        double d7 = d6 * d4;
        solarExecutionTimeResult.t_t = Time.createTimeMin(d2);
        solarExecutionTimeResult.t_int_SB = Time.createTimeMin(d7);
        solarExecutionTimeResult.t_int_EB = Time.createTimeMin(d6);
        solarExecutionTimeResult.t_t_EB = Time.createTimeMin(d5);
        solarExecutionTimeResult.n_EB_int = (int)d4;
        double d8 = bl ? this.t_tp_scan_regional_mapping_map.get(n) : this.t_tp_scan_map.get(n);
        double d9 = Math.ceil(d7 / d8);
        double d10 = d9 * d8;
        solarExecutionTimeResult.t_tp_SB = Time.createTimeMin(d10);
        solarExecutionTimeResult.n_tp_EB = (int)d9;
        solarExecutionTimeResult.t_tp = Time.createTimeMin(d8);
        solarExecutionTimeResult.n_FS = n2;
        Log.logger(SolarExecutionTimeCalculator.class).fine(solarExecutionTimeResult.toString());
        return solarExecutionTimeResult;
    }

    public static void main(String[] stringArray) {
        try {
            InitServices.init();
        }
        catch (IOException iOException) {
            Log.logger(SolarExecutionTimeCalculator.class).warning(iOException.getMessage());
        }
        SolarExecutionTimeCalculator solarExecutionTimeCalculator = new SolarExecutionTimeCalculator();
        SolarExecutionTimeResult solarExecutionTimeResult = solarExecutionTimeCalculator.calculateSolarIntegrationTimes(Time.createTimeMin(60.0), 3, 1, false);
        System.out.println(solarExecutionTimeResult);
    }

    public static class SolarExecutionTimeResult {
        public Time t_t = Time.createTime();
        public Time t_tp_SB = Time.createTime();
        public Time t_int_EB = Time.createTime();
        public Time t_int_SB = Time.createTime();
        public int n_tp_EB;
        public Time t_t_EB = Time.createTime();
        public int n_EB_int;
        public Time t_tp;
        public int n_FS;

        public String toString() {
            return "SolarExecutionTimeResult [t_t=" + this.t_t + ", t_tp_SB=" + this.t_tp_SB + ", t_int_EB=" + this.t_int_EB + ", t_int_SB=" + this.t_int_SB + ", n_tp_EB=" + this.n_tp_EB + ", t_t_EB=" + this.t_t_EB + ", n_EB_int=" + this.n_EB_int + ", t_tp=" + this.t_tp + ", n_FS=" + this.n_FS + "]";
        }
    }
}

