/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.models.valuetypes.AbstractValueUnitPairModel;
import alma.obsprep.services.calibration.CalibrationTimeModel;
import alma.obsprep.services.calibration.PhaseCalObs;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Length;
import alma.valuetypes.Speed;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CycleTimeEditor
extends EditorWithGridBagLayout {
    public CycleTimeEditor(Model model) {
        this.setModel(model);
        this.build();
    }

    @Override
    public void set(JComponent jComponent, Object object) {
        if (jComponent == this) {
            this.set((JPanel)jComponent, object);
        } else {
            super.set(jComponent, object);
        }
    }

    @Override
    protected void build() {
        this.setBorder(BorderFactory.createTitledBorder("Cycle Time"));
        super.build("Cycle Time");
    }

    @Override
    protected void addComponents(String string) {
        CalibrationTimeModel calibrationTimeModel = (CalibrationTimeModel)this.getModel();
        this.constraints.weightx = 1.0;
        ValueUnitPairEditor valueUnitPairEditor = this.makeValueUnitPairEditor(calibrationTimeModel.getFrequencyModel(), "observing frequency (center)");
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Center Frequency", (JComponent)valueUnitPairEditor);
        JTextField jTextField = this.makeTextField(CalibrationTimeModel.wavelengthFid, false, "wavelength at the center frequency");
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Wavelength", (JComponent)jTextField);
        String[] stringArray = new String[]{Speed.UNIT_M_S};
        valueUnitPairEditor = this.makeValueUnitPairEditor((AbstractValueUnitPairModel)calibrationTimeModel.getWindModel(), stringArray, "Wind speed (Average on site ~10[m/s]");
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Wind Speed", (JComponent)valueUnitPairEditor);
        String string2 = "Zenithial angle of the calibator at the meridian";
        jTextField = this.makeTextField(CalibrationTimeModel.zenithFid, false, string2);
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Zenith Angle", (JComponent)jTextField);
        string2 = "Phase fluctuations, it is a function of weather contditions.";
        JComboBox jComboBox = this.makeComboBox(CalibrationTimeModel.phFluctFid, PhaseCalObs.PhaseFluctuations.getKnownLabels(), string2);
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Phase Fluctuations", (JComponent)jComboBox);
        string2 = "<html>Exponent of the Fluctuations' Structure Function.<br> Meridian value at AOS = 0.6</html>";
        this.addTextComponent(this, this.layout, this.constraints, CalibrationTimeModel.fluctStrFid, "Fluctuation Structure", string2);
        Box box = Box.createHorizontalBox();
        box.add(this.makeTextField(CalibrationTimeModel.cycleTimeFid, false, "Estimated calibration cycle time"));
        box.add(this.makeButton(CalibrationTimeModel.cycCalcBtnFid, "Calculate", "Click to calculate/update cycle time estimate"));
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Cycle Time", (JComponent)box);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(CalibrationTimeModel.wavelengthFid)) {
            if (object == null) {
                super.update(fieldID, null);
                return;
            }
            Length length = (Length)((Object)object);
            String string = String.format("%.0f microns", length.getContentInUnits(Length.UNIT_M) * 1000000.0);
            super.update(fieldID, string);
            return;
        }
        if (fieldID.equals(CalibrationTimeModel.zenithFid)) {
            Angle angle = (Angle)((Object)object);
            super.update(fieldID, TextUtils.format(angle, 0, 1));
            return;
        }
        if (fieldID.equals(CalibrationTimeModel.cycleTimeFid)) {
            super.update(fieldID, object);
        }
        if (fieldID.equals(CalibrationTimeModel.fluctStrFid)) {
            double d = (Double)object;
            super.update(fieldID, String.format("%.1f", d));
        } else {
            super.update(fieldID, object);
        }
    }
}

