/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.ExpectedProperties;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.obsproject.EphemerisValidator;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;
import alma.valuetypes.data.UserFrequencyData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jsky.coords.WorldCoords;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.util.Precision;

public class TargetParametersValidator
extends AbstractValidator {
    private final Log.Logger logger = Log.logger((Object)this);
    private static final AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
    private static boolean isSourceParametersRequired = almaPolicies.isSourceParametersRequired();
    private final Map<ScienceGoal, ScienceGoal> circularPolarizationBeamSizeIssueReported = new ConcurrentHashMap<ScienceGoal, ScienceGoal>();
    private final Map<ScienceGoal, ScienceGoal> linearPolarizationBeamSizeIssueReported = new ConcurrentHashMap<ScienceGoal, ScienceGoal>();
    private static final double MIN_THRESHOLD_CIRCULAR_POLARIZATION_PERCENT = 1.8;

    public void setSourceParametersRequired(boolean bl) {
        isSourceParametersRequired = bl;
    }

    public TargetParametersValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        boolean bl;
        boolean bl2;
        Object object;
        Problem problem;
        TargetParameters targetParameters = (TargetParameters)businessObject;
        targetParameters.setSourceName(MiscUtils.getSanitizedSourceName(targetParameters.getSourceName()));
        if (targetParameters.getSourceName() == null || targetParameters.getSourceName().length() == 0) {
            problem = DefaultProblem.createError("No source name provided", "Check the Target Parameters in the Science Goal and ensure all have a non-blank source name", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates().getJ2000SkyCoordinates();
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        if (targetParameters.isMaxElevationTooLow()) {
            object = String.format("The source %s cannot be observed with ALMA as its elevation never exceeds %g degrees", targetParameters.getSourceName(), almaCapabilities.getElLoWarn().getContentInUnits(Angle.UNIT_DEG));
            problem = DefaultProblem.createError((String)object, "Choose another target", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if ((bl2 = ((ScienceGoal)(object = targetParameters.getScienceGoal())).isPhase1ScienceGoal()) && targetParameters.isMaxElevationNeedingJustification()) {
            String string = String.format("The source %s has a maximum elevation between %g and %g degrees", targetParameters.getSourceName(), almaCapabilities.getElLoWarn().getContentInUnits(Angle.UNIT_DEG), almaCapabilities.getElLoWarnThreshold().getContentInUnits(Angle.UNIT_DEG));
            problem = DefaultProblem.createWarning(string, "Please justify (minimum 50 characters) in the TJ node.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!(bl = targetParameters.getNonSiderealMotion()) && skyCoordinates.getLatitude().getContent() == 0.0 && skyCoordinates.getLongitude().getContent() == 0.0) {
            problem = DefaultProblem.createWarning("Your field source coordinates are 0.0, 0.0", "Please be sure you mean this - OK for ToO goals", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!bl && targetParameters.getSourceCoordinates().getSystem().equals(SkyCoordinates.SYSTEM_J2000)) {
            problem = DefaultProblem.createWarning("Coordinate system is FK5, but ICRS will be observed.", "Switch to ICRS. The systems differ by tens of mas so the coordinates probably do not need to be updated.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        String string = targetParameters.getSolarSystemObject();
        if (bl && string == TargetParameters.SOLARSYSTEMOBJECT_UNSPECIFIED) {
            problem = DefaultProblem.createError("You have selected a solar system target without specifying one", "Choose a solar system object from the list", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (bl && (string.equals(TargetParameters.SOLARSYSTEMOBJECT_EPHEMERIS) || string.equals(TargetParameters.SOLARSYSTEMOBJECT_SUN))) {
            EphemerisValidator ephemerisValidator = new EphemerisValidator(this.logger);
            ephemerisValidator.validateEphemeris(targetParameters.getSourceEphemeris(), (BusinessObject)targetParameters, problemListModel, bl2);
        }
        if (targetParameters.isPointingPattern()) {
            this.validatePointingPattern(businessObject, problemListModel, targetParameters);
        }
        boolean bl3 = false;
        try {
            bl3 = ((ScienceGoal)object).isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(TargetParametersValidator.class).info("Unable to determine science goal is configured for Solar");
        }
        if (!bl3) {
            if (isSourceParametersRequired) {
                this.validateExpectedProperties(businessObject, problemListModel, targetParameters);
            } else if (VLBIExpert.isScienceGoalLegalVLBISpectralLine((ScienceGoal)object)) {
                this.performVLBISpectralLineValidation(businessObject, problemListModel, targetParameters, targetParameters.getExpectedProperties());
            }
        }
        this.validatePointingsNotTooFarFromSourceCoordinate(businessObject, problemListModel, targetParameters);
        this.validateVLBIPointingSetup(businessObject, problemListModel, targetParameters);
        if (!bl3) {
            this.validateLASWithFullPolarization(problemListModel, (ScienceGoal)object, targetParameters);
        }
        this.validateRedundantEphemeris(businessObject, problemListModel, targetParameters);
        this.validateTPSolarMapping(businessObject, problemListModel, targetParameters);
    }

    private void validateTPSolarMapping(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull TargetParameters targetParameters) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (!targetParameters.isSun()) {
            return;
        }
        if (targetParameters.getSolarMapping() == null || targetParameters.getSolarMappingPattern() == null) {
            return;
        }
        if (targetParameters.getSolarMapping().equals(AbstractTargetParameters.SOLARMAPPING_REGIONALMAPPING) && targetParameters.getSolarMappingPattern().equals(AbstractTargetParameters.SOLARMAPPINGPATTERN_DOUBLECIRCLE) && targetParameters.getSolarMappingDiameter().isZero()) {
            problemListModel.add(DefaultProblem.createError("TP regional mapping diameter is too small", "Select the Field Setup in the Science Goal and enter a valid value", (IBusinessObject)businessObject));
        }
    }

    private void validateRedundantEphemeris(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull TargetParameters targetParameters) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (!targetParameters.isEphemerisSource() && !StringUtils.isEmpty((String)targetParameters.getSourceEphemeris())) {
            problemListModel.add(DefaultProblem.createWarning("An ephemeris has been loaded but is not being used", "Either select an ephemeris-type field source or the ephemeris will be deleted at the next save or submit", (IBusinessObject)businessObject));
        }
    }

    private void performVLBISpectralLineValidation(BusinessObject businessObject, ProblemListModel problemListModel, TargetParameters targetParameters, ExpectedProperties expectedProperties) {
        String string = "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value";
        if (!expectedProperties.gettrueExpectedLineWidth().hasContent()) {
            Problem problem = DefaultProblem.createError("There is no value for the expected line width", string, (IBusinessObject)businessObject);
            problemListModel.add(problem);
        } else if (expectedProperties.getExpectedLineWidth().getContentInGHz() <= 0.0) {
            Problem problem = DefaultProblem.createError("Expected line width is invalid", string, (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private void validateVLBIPointingSetup(BusinessObject businessObject, ProblemListModel problemListModel, TargetParameters targetParameters) {
        try {
            if (targetParameters.getScienceGoal().getObsProposal().isVLBIorPhasedArray()) {
                if (!targetParameters.getFieldPattern().getFieldPatternType().equals((Object)FieldPattern.FieldPatternType.POINT)) {
                    Problem problem = DefaultProblem.createError("A rectangle target type is not permitted with VLBI", "Change field type of source " + this.getTargetParametersName(targetParameters), (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                } else if (targetParameters.getFieldSinglePointCount() > 1 || targetParameters.isMosaic()) {
                    Problem problem = DefaultProblem.createError("A source may have only a single pointing when configured for VLBI", this.getTargetParametersName(targetParameters) + " has multiple pointings associated with it", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(TargetParametersValidator.class).info("Unable to determine proposal type: " + unknownEntityException.getMessage());
            Problem problem = DefaultProblem.createError("Unable to determine proposal type", "Please contact your support contact.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private void validatePointingPattern(BusinessObject businessObject, ProblemListModel problemListModel, TargetParameters targetParameters) {
        boolean bl;
        Problem problem;
        if (targetParameters.getFieldSinglePointCount() < 1) {
            problem = DefaultProblem.createError("No pointings specified in the Field Setup!", "Select the Field Setup in the Science Goal and ensure there is at least one pointing", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        boolean bl2 = bl = targetParameters.getFieldSinglePointCount() > 1 && targetParameters.isMosaic();
        if (bl) {
            boolean bl3 = false;
            try {
                bl3 = SchedBlockWorker.isMosaicPointingsOverlapping(targetParameters);
            }
            catch (SchedBlockWorker.InfiniteBandwithException infiniteBandwithException) {
                problem = DefaultProblem.createError("The bandwidth cannot be calculated - unable to do mosaic spacing checks for target " + targetParameters.getSourceName(), "Please check the parameters for the science goal " + targetParameters.getScienceGoal().getNameOrDefault(), (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            catch (SchedBlockWorker.NotAMosaicException notAMosaicException) {
                throw new RuntimeException("Logic error in determining if target parameters " + targetParameters.getSourceName() + " is a mosaic");
            }
            if (!bl3) {
                String string = targetParameters.gettrueSourceName();
                if (string == null || string.trim().equals("")) {
                    string = "Single Point";
                }
                problem = DefaultProblem.createError("All pointings of a source must overlap.", "Please reduce the distance between pointings for " + string + ", or place non-overlapping pointings into separate targets.", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
    }

    private void validateExpectedProperties(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull TargetParameters targetParameters) {
        boolean bl;
        Problem problem;
        boolean bl2;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        ScienceGoal scienceGoal = targetParameters.getScienceGoal();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        boolean bl3 = spectralSetupParameters.isFullPolarisation();
        boolean bl4 = false;
        try {
            bl4 = ObsProposal.isVLBIRelated();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(TargetParametersValidator.class).warning("Unable to determine if VLBI proposal");
        }
        ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
        try {
            bl2 = targetParameters.getScienceGoal().isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(TargetParametersValidator.class).warning("Unable to determine if science goal is solar");
            return;
        }
        boolean bl5 = !bl2 && !bl4;
        String string = expectedProperties.getExpectedLineWidth().getUserUnit();
        if (!UserFrequencyData.USERUNIT_M_S.equals(string) && !UserFrequencyData.USERUNIT_KM_S.equals(string)) {
            problem = DefaultProblem.createError("Line width should be defined in units of velocity", this.getTargetParametersName(targetParameters) + " has it's line width specified in frequency, change it to units of velocity", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!bl4 && expectedProperties.getExpectedPeakFluxDensity().getContentInUnits(Sensitivity.UNIT_JY) < 0.0) {
            problem = DefaultProblem.createError("Expected peak flux density is too small", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!bl4 && expectedProperties.getExpectedPeakLineFluxDensity().getContentInUnits(Sensitivity.UNIT_JY) < 0.0) {
            problem = DefaultProblem.createError("Expected peak line flux density is too small", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!bl4) {
            this.validateLineWidth(businessObject, problemListModel, targetParameters, expectedProperties);
        }
        double d = expectedProperties.getDesiredPolarizationPercentage();
        if (bl5 && d < 0.0 || d > 100.0) {
            problem = DefaultProblem.createError("Expected polarization value is invalid", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        double d2 = expectedProperties.getDesiredLinePolarizationPercentage();
        if (bl5 && d2 < 0.0 || d2 > 100.0) {
            problem = DefaultProblem.createError("Expected line polarization value is invalid", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        double d3 = expectedProperties.getDesiredCircularPolarizationPercentage();
        if (bl5 && d3 < 0.0 || d3 > 100.0) {
            problem = DefaultProblem.createError("Expected continuum circular polarization value is invalid", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        double d4 = expectedProperties.getDesiredLineCircularPolarizationPercentage();
        if (!bl5 && d4 < 0.0 || d4 > 100.0) {
            problem = DefaultProblem.createError("Expected spectral line circular polarization value is invalid", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (bl5 && bl3) {
            this.validatePolarizationConfiguration(businessObject, problemListModel, targetParameters, expectedProperties, scienceGoal);
        }
        if (spectralSetupParameters.isSingleContinuum()) {
            if (!bl4 && expectedProperties.getExpectedPeakFluxDensity().getContentInUnits(Sensitivity.UNIT_JY) <= 0.0) {
                problem = DefaultProblem.createError("Expected peak continuum flux is required for a single continuum setup", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        } else if (spectralSetupParameters.isSpectralLine() || spectralSetupParameters.isSpectralScan()) {
            if (!bl4 && expectedProperties.getExpectedPeakLineFluxDensity().getContentInUnits(Sensitivity.UNIT_JY) <= 0.0) {
                problem = DefaultProblem.createError("Expected peak line flux is required for a spectral line or spectral scan setup", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            bl = VLBIExpert.isScienceGoalLegalVLBISpectralLine(scienceGoal);
            if ((!bl4 || bl) && expectedProperties.getExpectedLineWidth().getContentInGHz() <= 0.0) {
                problem = DefaultProblem.createError("Expected line width is required for a spectral line or spectral scan setup", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
        if (!bl4) {
            double d5 = expectedProperties.getExpectedLineWidth().getContent();
            double d6 = expectedProperties.getExpectedPeakLineFluxDensity().getContent();
            if (d6 > 0.0 && d5 <= 0.0 || d5 > 0.0 && d6 <= 0.0) {
                problem = DefaultProblem.createWarning("Both or neither of line width and line flux must be specified", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and ensure both line flux and line width values are provided, or neither", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
        boolean bl6 = bl = bl5 && bl3;
        if (bl && d <= 0.0 && d2 <= 0.0 && d3 <= 0.0 && d4 <= 0.0) {
            problem = DefaultProblem.createError("A polarization percentage is required for a full-polarization setup.", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private void validateLineWidth(BusinessObject businessObject, ProblemListModel problemListModel, TargetParameters targetParameters, ExpectedProperties expectedProperties) {
        if (!expectedProperties.gettrueExpectedLineWidth().hasContent()) {
            Problem problem = DefaultProblem.createError("There is no value for the expected line width", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        } else if (expectedProperties.getExpectedLineWidth().getContentInGHz() < 0.0) {
            Problem problem = DefaultProblem.createError("Expected line width is invalid", "Select the Target Parameters " + this.getTargetParametersName(targetParameters) + " in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private void validatePolarizationConfiguration(BusinessObject businessObject, ProblemListModel problemListModel, TargetParameters targetParameters, ExpectedProperties expectedProperties, ScienceGoal scienceGoal) {
        double d;
        double d2;
        double d3;
        Problem problem;
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        if (!spectralSetupParameters.isFullPolarisation()) {
            return;
        }
        ScienceSpectralWindow[] scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralWindow();
        if (scienceSpectralWindowArray.length == 0) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray) {
            if (scienceSpectralWindow.isModeFilterTDM()) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        assert (bl2 || bl);
        boolean bl3 = scienceGoal.getPerformanceParameters().getIsEquivalentToPointSource();
        if (bl2 && bl) {
            double d4 = bl3 ? 0.1 : 0.3;
            double d5 = bl3 ? 1.0 : 3.0;
        } else if (bl) {
            double d6;
            double d7 = d6 = bl3 ? 0.1 : 0.3;
        } else if (bl2) {
            double d8;
            double d9 = d8 = bl3 ? 1.0 : 3.0;
        } else {
            throw new RuntimeException("Logic error: unable to determine the mode types of the spectral windows");
        }
        double d10 = expectedProperties.getDesiredPolarizationPercentage();
        if (d10 < 0.1 && d10 > 0.0) {
            problem = DefaultProblem.createError("The expected continuum linear polarization  for " + this.getTargetParametersName(targetParameters) + " is too low to be reliably detected", "Observe a more highly polarized source, if possible", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if ((d3 = expectedProperties.getDesiredLinePolarizationPercentage()) < 0.1 && d3 > 0.0) {
            problem = DefaultProblem.createError("The expected line linear polarization for " + this.getTargetParametersName(targetParameters) + " is too low to be reliably detected", "Observe a more highly polarized source, if possible", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if ((d2 = expectedProperties.getDesiredLineCircularPolarizationPercentage()) < 1.8 && d2 > 0.0) {
            problem = DefaultProblem.createError("The expected line circular polarization for " + this.getTargetParametersName(targetParameters) + " is too low to be reliably detected", "Observe a more highly polarized source, if possible", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if ((d = expectedProperties.getDesiredCircularPolarizationPercentage()) < 1.8 && d > 0.0) {
            problem = DefaultProblem.createError("The expected continuum circular polarization  for " + this.getTargetParametersName(targetParameters) + " is too low to be reliably detected", "Observe a more highly polarized source, if possible", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private String getTargetParametersName(TargetParameters targetParameters) {
        String string = targetParameters.getSourceName();
        if (string == null || string.length() == 0) {
            string = "no source name";
        }
        return "(" + string + ")";
    }

    private void validatePointingsNotTooFarFromSourceCoordinate(BusinessObject businessObject, ProblemListModel problemListModel, TargetParameters targetParameters) {
        double d = almaPolicies.getMaxSeparationFromSourceCoordinate().getContentInUnits(Angle.UNIT_DEG);
        SkyPoint skyPoint = targetParameters.getSourceCoordinates().getAbsoluteSkyPointInJ2000Deg();
        if (targetParameters.getFieldPatternType().equals((Object)FieldPattern.FieldPatternType.POINT)) {
            SkyCoordinates[] skyCoordinatesArray = targetParameters.getPointingPattern().getPhaseCenterCoordinates();
            for (int i = 0; i < skyCoordinatesArray.length; ++i) {
                SkyCoordinates skyCoordinates = skyCoordinatesArray[i];
                if (skyCoordinates.isOffsetCoordinates()) {
                    skyCoordinates = skyCoordinates.getAbsoluteCoordinates(targetParameters.getFieldCenterCoordinates());
                }
                SkyPoint skyPoint2 = skyCoordinates.getAbsoluteSkyPointInJ2000Deg();
                double d2 = WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint2.getX(), (double)skyPoint2.getY()) / 60.0;
                if (!(d2 >= d)) continue;
                Problem problem = DefaultProblem.createError(String.format("A pointing is more than %.0f degrees of separation from the source coordinate", d), "Please revise your field setup", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
                break;
            }
        } else if (targetParameters.getFieldPatternType().equals((Object)FieldPattern.FieldPatternType.RECTANGLE)) {
            SkyCoordinates skyCoordinates;
            Rectangle rectangle = targetParameters.getFieldRectangle()[0];
            SkyCoordinates skyCoordinates2 = skyCoordinates = rectangle.getCentre();
            if (skyCoordinates.isOffsetCoordinates()) {
                skyCoordinates2 = skyCoordinates.getAbsoluteCoordinates(targetParameters.getFieldCenterCoordinates());
            }
            SkyPoint skyPoint3 = skyCoordinates2.getAbsoluteSkyPointInJ2000Deg();
            double d3 = WorldCoords.dist((double)skyPoint.getX(), (double)skyPoint.getY(), (double)skyPoint3.getX(), (double)skyPoint3.getY()) / 60.0;
            if (d3 >= d) {
                Problem problem = DefaultProblem.createError(String.format("Rectangle field pattern is offset by more than %.0f degrees of separation from the source coordinate", d), "Please revise you field setup", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        } else {
            throw new RuntimeException("Unknown field type specified" + targetParameters.getFieldPatternType());
        }
    }

    private synchronized void validateLASWithFullPolarization(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal, @NonNull TargetParameters targetParameters) {
        boolean bl;
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (!scienceGoal.getSpectralSetupParameters().isFullPolarisation()) {
            return;
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        boolean bl2 = bl = targetParameters.getNumberOfPointings() > 1;
        if (!performanceParameters.getIsPointSource()) {
            boolean bl3;
            Map<ScienceGoal, ScienceGoal> map;
            String string;
            String string2;
            double d;
            Antenna antenna = scienceGoal.isStandAloneACA() ? Antenna.ANTENNA_7M : Antenna.ANTENNA_12M;
            double d2 = antenna.getBeamSize(performanceParameters.getRepresentativeFrequency()).getContentInUnits(Angle.UNIT_ARCSEC);
            double d3 = performanceParameters.getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC);
            ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
            double d4 = expectedProperties.getDesiredCircularPolarizationPercentage();
            double d5 = expectedProperties.getDesiredLineCircularPolarizationPercentage();
            if (d4 > 0.0 || d5 > 0.0) {
                d = 0.1;
                string2 = "1/10";
                string = "circular";
                map = this.circularPolarizationBeamSizeIssueReported;
                bl3 = true;
            } else {
                d = 0.3333333333333333;
                string2 = "1/3";
                string = "linear";
                map = this.linearPolarizationBeamSizeIssueReported;
                boolean bl4 = bl3 = !bl;
            }
            if (d3 / d2 > d && bl3) {
                ScienceGoal scienceGoal2;
                ScienceGoal scienceGoal3 = scienceGoal2 = scienceGoal.getParentScienceGoal() != null ? scienceGoal.getParentScienceGoal() : scienceGoal;
                if (map.containsKey(scienceGoal2)) {
                    return;
                }
                map.put(scienceGoal2, scienceGoal2);
                String string3 = String.format("The source LAS must be &lt; %s of the antenna beamsize for measurements of %s polarization", string2, string);
                Problem problem = DefaultProblem.createError(string3, "Adjust the size of the largest angular structure", (IBusinessObject)performanceParameters);
                problemListModel.addProblemToBuffer(problem);
            }
        }
        this.validateCircularPolarizationWithSinglePointingOnly(problemListModel, scienceGoal, targetParameters);
        this.validateNyquistSpacing(problemListModel, scienceGoal, targetParameters);
    }

    private void validateNyquistSpacing(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal, @NonNull TargetParameters targetParameters) {
        double d;
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (!scienceGoal.getSpectralSetupParameters().isFullPolarisation() || !targetParameters.isRectanglePattern()) {
            return;
        }
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        Angle angle = Angle.createAngle();
        angle.setContent(frequency.getWavelengthM() / Antenna.ANTENNA_12M.getDiameter());
        angle.setUnit(Angle.UNIT_RAD);
        angle.convertToUnit(Angle.UNIT_ARCSEC);
        UserAngle userAngle = UserAngle.createUserAngle((Angle)angle.divide(Math.sqrt(3.0)));
        userAngle.setAntenna(Antenna.ANTENNA_12M);
        userAngle.setObservingFrequency(frequency);
        assert (!userAngle.isZero());
        Rectangle rectangle = targetParameters.getFieldRectangle()[0];
        double d2 = rectangle.getSpacing().getContentInUnits(Angle.UNIT_ARCSEC);
        if (Precision.compareTo((double)d2, (double)(d = userAngle.getContentInUnits(Angle.UNIT_ARCSEC)), (double)1.0E-7) > 0) {
            Problem problem = DefaultProblem.createWarning("Full-polarization mosaics with spacing > Nyquist are not recommended", "Better results will result if spacing equal to or better than Nyquist is selected", (IBusinessObject)targetParameters);
            problemListModel.addProblemToBuffer(problem);
            Log.logger(TargetParametersValidator.class).fine("Requested spacing " + rectangle.getSpacing().getArcsec() + " Nyquist " + userAngle.getArcsec());
        }
    }

    private void validateCircularPolarizationWithSinglePointingOnly(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal, @NonNull TargetParameters targetParameters) {
        boolean bl;
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (!scienceGoal.getSpectralSetupParameters().isFullPolarisation()) {
            return;
        }
        ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
        double d = expectedProperties.getDesiredCircularPolarizationPercentage();
        double d2 = expectedProperties.getDesiredLineCircularPolarizationPercentage();
        boolean bl2 = bl = targetParameters.getNumberOfPointings() > 1;
        if ((d2 > 0.0 || d > 0.0) && bl) {
            Problem problem = DefaultProblem.createError("Circular polarization can only be observed with a single pointing", "Remove the additional pointings for " + targetParameters.getSourceName(), (IBusinessObject)targetParameters);
            problemListModel.addProblemToBuffer(problem);
        }
    }
}

