/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.services.generator.refactored.DGCExpert;
import lombok.NonNull;

public final class ObsProjectValidationUtils {
    public static void validateNoDGCInLargeProgram(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        if (scienceGoal.getCalibrationSetupParameters().getIsDGCOverride()) {
            return;
        }
        if (DGCExpert.getExpert().isDGCScheduled(scienceGoal, true)) {
            problemListModel.add(DefaultProblem.createError("Band-to-band calibration or bandwidth switching are not allowed for Large Programs.", "Edit/remove the offending Science Goals or reduce the time request.", (IBusinessObject)scienceGoal));
        }
    }

    private ObsProjectValidationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

