/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.obsprep.ot.scripting.Console;
import alma.obsprep.util.MiscUtils;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.lang3.StringUtils;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class PythonEnv {
    public static final String PYTHON_PATH_PROPERTY = "python.path";
    private static final int CONSOLEH = 350;
    private static final int CONSOLEW = 500;
    private static PythonEnv instance = null;
    private Console console;
    private JFrame consoleFrame = null;
    private PrintStream consoleStream;
    private PythonInterpreter pythonInterpreter = null;
    private static Properties preProperties = null;
    private static Properties postProperties = null;
    private static String[] argv = null;
    private static boolean initialized = false;

    private PythonEnv(PrintStream printStream, boolean bl) {
        if (!initialized) {
            throw new RuntimeException("Not yet initialized.");
        }
        PythonInterpreter.initialize((Properties)preProperties, (Properties)postProperties, (String[])argv);
        this.pythonInterpreter = new PythonInterpreter();
        this.makeConsole(printStream, bl, 500, 350);
    }

    private void error(PyException pyException) {
        String string = this.message(pyException);
        this.consoleStream.println(string);
        this.consoleStream.flush();
    }

    public void setVariable(String string, Object object) {
        this.pythonInterpreter.set(string, object);
    }

    public int execfile(String string) throws IOException {
        File file = new File(string);
        return this.execfile(file);
    }

    public int execfile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return this.execfile(fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execfile(InputStream inputStream) {
        int n;
        block7: {
            n = 0;
            try {
                this.pythonInterpreter.execfile(inputStream);
            }
            catch (PyException pyException) {
                if (StringUtils.contains((CharSequence)PyException.exceptionClassName((PyObject)pyException.type), (CharSequence)"SystemExit")) {
                    PyObject pyObject = pyException.value;
                    if (!(pyObject instanceof PyNone)) {
                        PyInteger pyInteger = (PyInteger)pyObject;
                        n = pyInteger.getValue();
                    }
                    break block7;
                }
                this.error(pyException);
                throw pyException;
            }
            finally {
                this.consoleStream.flush();
            }
        }
        return n;
    }

    public PrintStream getConsoleStream() {
        return this.consoleStream;
    }

    public void hideConsole() {
        if (this.consoleFrame != null) {
            this.consoleFrame.setVisible(false);
        }
    }

    public void load(String string) throws IOException {
        if (string == null || string.length() == 0) {
            return;
        }
        String[] stringArray = string.split(":");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() == 0) continue;
            URL uRL = MiscUtils.findResource(null, string2);
            if (uRL == null) {
                throw new IOException("File not found: " + string2);
            }
            InputStream inputStream = uRL.openStream();
            int n = this.execfile(inputStream);
            if (n == 0) continue;
            RuntimeException runtimeException = new RuntimeException("Failed to load " + string2);
            runtimeException.printStackTrace();
        }
    }

    private void makeConsole(PrintStream printStream, boolean bl, int n, int n2) {
        PipedOutputStream pipedOutputStream;
        PipedInputStream pipedInputStream = new PipedInputStream();
        try {
            pipedOutputStream = new PipedOutputStream(pipedInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        JTextArea jTextArea = null;
        if (bl) {
            jTextArea = new JTextArea();
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            Dimension dimension = new Dimension(n, n2);
            jScrollPane.setPreferredSize(dimension);
            this.consoleFrame = new JFrame("Python console");
            this.consoleFrame.getContentPane().add(jScrollPane);
            this.consoleFrame.pack();
            this.consoleFrame.setVisible(false);
        }
        this.console = new Console(pipedInputStream, printStream, jTextArea);
        this.consoleStream = new PrintStream(pipedOutputStream);
        this.pythonInterpreter.setOut((OutputStream)this.consoleStream);
        this.pythonInterpreter.setErr((OutputStream)this.consoleStream);
    }

    public String message(PyException pyException) {
        return pyException.toString();
    }

    public void showConsole() {
        if (this.consoleFrame != null) {
            this.consoleFrame.setVisible(true);
        }
    }

    public static void reset() {
        instance = null;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static PythonEnv getInstance() {
        return PythonEnv.getInstance(System.out, false);
    }

    public static PythonEnv getInstance(PrintStream printStream, boolean bl) {
        if (!initialized) {
            throw new RuntimeException("Not yet inizialized.");
        }
        if (instance == null) {
            instance = new PythonEnv(printStream, bl);
        }
        return instance;
    }

    public static PythonEnv getInstance(PrintStream printStream, boolean bl, String string) throws IOException {
        PythonEnv.reset();
        PythonEnv pythonEnv = PythonEnv.getInstance(printStream, bl);
        pythonEnv.load(string);
        return pythonEnv;
    }

    public static void initialize(Properties properties, Properties properties2, String[] stringArray) {
        if (initialized) {
            throw new RuntimeException("Cannot initialize twice.");
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
            StringBuffer stringBuffer = new StringBuffer();
            String string = System.getProperty("path.separator");
            for (int i = 0; i < uRLArray.length; ++i) {
                stringBuffer.append(uRLArray[i].getPath()).append(string);
            }
            System.setProperty("python.packages.fakepath", stringBuffer.toString());
        }
        PythonEnv.convertPathSeparator(properties, properties2);
        preProperties = properties == null ? System.getProperties() : properties;
        if (properties2 != null) {
            postProperties = properties2;
        }
        if (stringArray != null) {
            argv = stringArray;
        }
        initialized = true;
    }

    private static void convertPathSeparator(Properties properties, Properties properties2) {
        String string;
        if (properties2 != null && (string = (String)properties2.get(PYTHON_PATH_PROPERTY)) != null) {
            string = string.replace('|', File.pathSeparatorChar);
            properties2.setProperty(PYTHON_PATH_PROPERTY, string);
            return;
        }
        if (properties != null && (string = (String)properties.get(PYTHON_PATH_PROPERTY)) != null) {
            string = string.replace('|', File.pathSeparatorChar);
            properties.setProperty(PYTHON_PATH_PROPERTY, string);
            return;
        }
    }
}

