/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.obsprep.util.job.ObsprepThreadGroup;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Console
extends Thread {
    private Container toplevel = null;
    private static final int BUFSIZE = 1024;
    private PipedInputStream input = null;
    private OutputStream output = null;
    private JTextArea textarea = null;

    public Console(PipedInputStream pipedInputStream, OutputStream outputStream, JTextArea jTextArea) {
        super(ObsprepThreadGroup.getInstance(), null, "Console");
        this.input = pipedInputStream;
        this.textarea = jTextArea;
        this.output = outputStream;
        if (jTextArea != null) {
            this.toplevel = jTextArea.getTopLevelAncestor();
        }
        this.start();
    }

    @Override
    public void run() {
        byte[] byArray = new byte[1024];
        try {
            while (true) {
                int n;
                if ((n = this.input.read(byArray, 0, 1024)) == -1) {
                    if (this.output != null) {
                        this.output.flush();
                    }
                    return;
                }
                if (this.output != null) {
                    this.output.write(byArray, 0, n);
                    this.output.flush();
                }
                if (this.textarea == null) continue;
                String string = new String(byArray, 0, n);
                this.textarea.append(string);
                int n2 = this.textarea.getDocument().getLength() - 1;
                this.textarea.setCaretPosition(n2);
                this.toplevel.setVisible(true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public static void main(String[] stringArray) {
        JTextArea jTextArea = new JTextArea("");
        jTextArea.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(500, 200));
        JFrame jFrame = new JFrame("GUI console");
        jFrame.getContentPane().add(jScrollPane);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
        try {
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            PrintStream printStream = new PrintStream(pipedOutputStream);
            new Console(pipedInputStream, System.out, jTextArea);
            for (int i = 0; i < 25; ++i) {
                String string = "Iteration: " + i;
                printStream.println(string);
                Thread.sleep(500L);
            }
            printStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

