/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.CalibratedAbstractScienceGoal;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.GoalTargetParameters;
import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.obsproject.CalibrationSetupParametersEditor;
import alma.obsprep.ot.editors.obsproject.CalibratorTableElement;
import alma.obsprep.ot.editors.sciencegoals.AbstractTargetEditor;
import alma.obsprep.ot.editors.sciencegoals.SfiControlParameterEditor;
import alma.obsprep.ot.models.obsproject.CalibrationTargetParametersModel;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;

public class CalibrationSetupParametersModel
extends Model
implements RoleDirectoryService.UserAuthenticatesListener,
ModelChangeSubscriber {
    public static final FieldID CALIBRATOR_TABLE_ELEMENTS = new FieldID("CalibrationSetupParametersModel query sources FID");
    private final CalibratorExpertModel calibratorExpertModel = new CalibratorExpertModel(null);
    private final CalibrationTargetParametersModel calibrationTargetParametersModel = new CalibrationTargetParametersModel(null);
    private GoalTargetParameters firstTarget;
    private Object lastCalibratorAdded = null;

    public CalibrationSetupParametersModel(CalibrationSetupParameters calibrationSetupParameters) {
        super((Object)calibrationSetupParameters);
        this.calibratorExpertModel.subscribe(new CalibratorExpertController());
        this.setDocument((Object)calibrationSetupParameters);
        RoleDirectoryService.addUserAuthenticatesListener(this);
    }

    public void setDefaultCalibratorIntents() {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters == null) {
            return;
        }
        this.clearCalibrations();
        for (String string : this.getDefaultIntents()) {
            this.addQuerySource(string);
        }
    }

    public void addCalibration(QuerySource querySource) {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters != null && querySource != null) {
            calibrationSetupParameters.addQuerySource(querySource);
        }
    }

    public void addCalibration(CalibrationTargetParameters calibrationTargetParameters) {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters != null && calibrationTargetParameters != null) {
            calibrationSetupParameters.addCalibrationTargetParameters(calibrationTargetParameters);
        }
    }

    public void clearCalibrations() {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters != null) {
            calibrationSetupParameters.clearQuerySource();
            calibrationSetupParameters.clearCalibrationTargetParameters();
        }
        this.publish();
    }

    private Collection<String> getDefaultIntents() {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters == null) {
            return new ArrayList<String>();
        }
        BusinessObject businessObject = calibrationSetupParameters.getParent();
        if (businessObject instanceof CalibratedAbstractScienceGoal) {
            CalibratedAbstractScienceGoal calibratedAbstractScienceGoal = (CalibratedAbstractScienceGoal)businessObject;
            List<String> list = ObservingModeExpert.getDefaultCalibratorIntents(calibratedAbstractScienceGoal);
            list.remove(QuerySource.INTENDEDUSE_ATMOSPHERIC);
            list.remove(QuerySource.INTENDEDUSE_BANDPASS);
            return list;
        }
        throw new AssertionError((Object)"Parent entity does not implement CalibratedAbstractScienceGoal");
    }

    public Collection<String> getCalibrationIntents() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (QuerySource targetWithIntent : this.getQuerySources()) {
            arrayList.add(targetWithIntent.getIntendedUse());
        }
        for (CalibrationTargetParameters calibrationTargetParameters : this.getCalibrationTargetParameters()) {
            arrayList.add(calibrationTargetParameters.getIntendedUse());
        }
        return arrayList;
    }

    private CalibrationSetupParameters getCalibrationSetupParameters() {
        return (CalibrationSetupParameters)((Object)this.getDocument());
    }

    public Collection<QuerySource> getQuerySources() {
        ArrayList<QuerySource> arrayList = new ArrayList<QuerySource>();
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters != null) {
            Collections.addAll(arrayList, calibrationSetupParameters.getQuerySource());
        }
        return arrayList;
    }

    public Collection<CalibrationTargetParameters> getCalibrationTargetParameters() {
        ArrayList<CalibrationTargetParameters> arrayList = new ArrayList<CalibrationTargetParameters>();
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters != null) {
            Collections.addAll(arrayList, calibrationSetupParameters.getCalibrationTargetParameters());
        }
        return arrayList;
    }

    @Override
    public void publish() {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters == null) {
            return;
        }
        this.publish(CALIBRATOR_TABLE_ELEMENTS, this.getCalibratorTableElements());
        if (CalibrationSetupParameters.SELECTION_SYSTEM.equals(calibrationSetupParameters.getSelection())) {
            this.publish(CalibrationSetupParametersEditor.SYSTEM_CALIBRATORS_STANDARD, null);
        } else if (CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE.equals(calibrationSetupParameters.getSelection())) {
            this.publish(CalibrationSetupParametersEditor.SYSTEM_CALIBRATORS_AMPLITUDE, null);
        } else {
            this.publish(CalibrationSetupParametersEditor.MANUAL_CALIBRATORS, null);
        }
        this.publish(CalibrationSetupParametersEditor.ASTROMETRY_MODE_FID, calibrationSetupParameters.getPositionalAccuracy());
        this.publish(CalibrationSetupParametersEditor.DGC_OVERRIDE_SELECTOR, calibrationSetupParameters.getIsDGCOverride());
        this.publish(CalibrationSetupParametersEditor.FORCE_DGC, calibrationSetupParameters.getForcedDGCStrategy());
    }

    public QuerySource addQuerySource(@NonNull String string) {
        CalibrationSetupParameters calibrationSetupParameters;
        if (string == null) {
            throw new NullPointerException("intent is marked non-null but is null");
        }
        QuerySource querySource = QuerySource.createQuerySource(string);
        if (this.firstTarget != null) {
            querySource.setQueryCenter(this.firstTarget.getSourceCoordinates().deepCopy());
            querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
        }
        if ((calibrationSetupParameters = this.getCalibrationSetupParameters()) != null) {
            calibrationSetupParameters.addQuerySource(querySource);
        }
        return querySource;
    }

    public CalibrationTargetParameters addCalibrationTargetParameters(@NonNull String string) {
        CalibrationSetupParameters calibrationSetupParameters;
        if (string == null) {
            throw new NullPointerException("calibrationIntent is marked non-null but is null");
        }
        CalibrationTargetParameters calibrationTargetParameters = CalibrationTargetParameters.createCalibrationTargetParameters(string);
        if (this.firstTarget != null) {
            calibrationTargetParameters.setSourceCoordinates(this.firstTarget.getSourceCoordinates().deepCopy());
        }
        if ((calibrationSetupParameters = this.getCalibrationSetupParameters()) != null) {
            calibrationSetupParameters.addCalibrationTargetParameters(calibrationTargetParameters);
        }
        return calibrationTargetParameters;
    }

    public void removeCalibrator(QuerySource querySource) {
        if (querySource != null) {
            CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
            calibrationSetupParameters.removeQuerySource(querySource);
        }
    }

    public void removeCalibrator(CalibrationTargetParameters calibrationTargetParameters) {
        if (calibrationTargetParameters != null) {
            CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
            calibrationSetupParameters.removeCalibrationTargetParameters(calibrationTargetParameters);
        }
    }

    @Override
    public void setDocument(Object object) {
        if (object instanceof CalibrationSetupParameters) {
            this.calibratorExpertModel.setDocument(null);
            this.calibrationTargetParametersModel.setDocument(null);
            super.setDocument(object);
            try {
                if (ObsProposal.isProposalPhasedArray()) {
                    this.configureCalibrationSetupParametersForPhasedArray((CalibrationSetupParameters)((Object)object));
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(CalibrationSetupParametersModel.class).warning("Unable to determine if the project is VLBI pulsar");
            }
        }
    }

    private void configureCalibrationSetupParametersForPhasedArray(@NonNull CalibrationSetupParameters calibrationSetupParameters) {
        if (calibrationSetupParameters == null) {
            throw new NullPointerException("calibrationSetupParameters is marked non-null but is null");
        }
        calibrationSetupParameters.setSelection(CalibrationSetupParameters.SELECTION_USER);
        if (calibrationSetupParameters.getQuerySource().length == 0) {
            ScienceGoal scienceGoal;
            if (calibrationSetupParameters.getParent() instanceof ScienceGoal && (scienceGoal = (ScienceGoal)calibrationSetupParameters.getParent()).getTargetParametersCount() > 0) {
                this.setDefaultSearchPosition(scienceGoal.getTargetParameters(0));
            }
            this.setDefaultCalibratorIntents();
        }
        this.publish();
    }

    private List<CalibratorTableElement> getCalibratorTableElements() {
        ArrayList<CalibratorTableElement> arrayList = new ArrayList<CalibratorTableElement>();
        for (QuerySource targetWithIntent : this.getQuerySources()) {
            arrayList.add(new CalibratorTableElement(targetWithIntent));
        }
        for (CalibrationTargetParameters calibrationTargetParameters : this.getCalibrationTargetParameters()) {
            arrayList.add(new CalibratorTableElement(calibrationTargetParameters));
        }
        return arrayList;
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (CalibrationSetupParametersEditor.ADD_CALIBRATOR_QUERY.equals(fieldID)) {
            if (object instanceof String) {
                String string = (String)object;
                QuerySource querySource = null;
                if (!string.isEmpty()) {
                    querySource = this.addQuerySource(string);
                }
                this.publish(CALIBRATOR_TABLE_ELEMENTS, this.getCalibratorTableElements());
                this.lastCalibratorAdded = querySource;
                return querySource;
            }
        } else if (CalibrationSetupParametersEditor.ADD_FIXED_CALIBRATOR.equals(fieldID)) {
            if (object instanceof String) {
                String string = (String)object;
                CalibrationTargetParameters calibrationTargetParameters = null;
                if (!string.isEmpty()) {
                    calibrationTargetParameters = this.addCalibrationTargetParameters(string);
                }
                this.publish(CALIBRATOR_TABLE_ELEMENTS, this.getCalibratorTableElements());
                this.lastCalibratorAdded = calibrationTargetParameters;
                return calibrationTargetParameters;
            }
        } else if (CalibrationSetupParametersEditor.FORCE_DGC.equals(fieldID) && object instanceof String) {
            String string = (String)object;
            calibrationSetupParameters.setForcedDGCStrategy(string);
            if (!CalibrationSetupParameters.FORCEDDGCSTRATEGY_NONE.equals(string) && !calibrationSetupParameters.isUserDefinedCalibration()) {
                this.update(null, CalibrationSetupParametersEditor.MANUAL_CALIBRATORS, true);
            }
        } else if (CalibrationSetupParametersEditor.DGC_OVERRIDE_SELECTOR.equals(fieldID)) {
            Boolean bl = (Boolean)object;
            if (calibrationSetupParameters != null) {
                calibrationSetupParameters.setIsDGCOverride(bl);
                this.publish(CalibrationSetupParametersEditor.DGC_OVERRIDE_SELECTOR, bl);
            }
        } else if (CalibrationSetupParametersEditor.DELETE_CALIBRATOR_QUERY.equals(fieldID)) {
            if (object instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)object;
                for (Object e : arrayList) {
                    TargetWithIntent targetWithIntent;
                    if (e instanceof QuerySource) {
                        targetWithIntent = (QuerySource)e;
                        this.removeCalibrator((QuerySource)targetWithIntent);
                        continue;
                    }
                    if (e instanceof CalibrationTargetParameters) {
                        targetWithIntent = (CalibrationTargetParameters)e;
                        this.removeCalibrator((CalibrationTargetParameters)targetWithIntent);
                        continue;
                    }
                    throw new AssertionError((Object)"Non-string intent published");
                }
                this.publish(CALIBRATOR_TABLE_ELEMENTS, this.getCalibratorTableElements());
            }
        } else {
            if (CalibrationSetupParametersEditor.DELETE_ALL_CALIBRATORS.equals(fieldID)) {
                this.clearCalibrations();
                return object;
            }
            if (fieldID.equals(CalibrationSetupParametersEditor.SYSTEM_CALIBRATORS_STANDARD)) {
                if (calibrationSetupParameters != null) {
                    calibrationSetupParameters.setSelection(CalibrationSetupParameters.SELECTION_SYSTEM);
                }
                this.publish(CalibrationSetupParametersEditor.SYSTEM_CALIBRATORS_STANDARD, null);
            } else if (fieldID.equals(CalibrationSetupParametersEditor.SYSTEM_CALIBRATORS_AMPLITUDE)) {
                if (calibrationSetupParameters != null) {
                    calibrationSetupParameters.setSelection(CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE);
                }
                this.publish(CalibrationSetupParametersEditor.SYSTEM_CALIBRATORS_AMPLITUDE, null);
            } else if (fieldID.equals(CalibrationSetupParametersEditor.MANUAL_CALIBRATORS)) {
                if (calibrationSetupParameters != null) {
                    calibrationSetupParameters.setSelection(CalibrationSetupParameters.SELECTION_USER);
                    if (calibrationSetupParameters.getQuerySource().length == 0) {
                        this.setDefaultCalibratorIntents();
                        this.publish(CALIBRATOR_TABLE_ELEMENTS, this.getCalibratorTableElements());
                    }
                }
                this.publish(CalibrationSetupParametersEditor.MANUAL_CALIBRATORS, null);
            } else if (fieldID.equals(CalibrationSetupParametersEditor.EDIT_CALIBRATOR_QUERY)) {
                this.publish();
            } else if (fieldID.equals(CalibrationSetupParametersEditor.ASTROMETRY_MODE_FID) && calibrationSetupParameters != null) {
                calibrationSetupParameters.setPositionalAccuracy((String)object);
            }
        }
        return object;
    }

    public void setDefaultSearchPosition(GoalTargetParameters goalTargetParameters) {
        this.firstTarget = goalTargetParameters;
    }

    public void setDefaultSearchPosition(TargetParameters targetParameters) {
        SkyCoordinates skyCoordinates = targetParameters.getFieldCenterCoordinates();
        this.firstTarget = ObservatoryGoalTargetParameters.createObservatoryGoalTargetParameters();
        this.firstTarget.setSourceCoordinates(skyCoordinates);
    }

    public void setDGCOverrideUserSelectableState(@NonNull Set<DGCExpert.DGCTypeEnum> set) {
        boolean bl;
        if (set == null) {
            throw new NullPointerException("dgcObservingStrategiesScheduled is marked non-null but is null");
        }
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters == null) {
            return;
        }
        boolean bl2 = bl = !set.contains((Object)DGCExpert.DGCTypeEnum.None);
        if (!bl) {
            calibrationSetupParameters.setIsDGCOverride(false);
            this.publish(CalibrationSetupParametersEditor.DGC_OVERRIDE_SELECTOR, false);
        }
        if (calibrationSetupParameters.getIsDGCOverride()) {
            ScienceGoal scienceGoal = (ScienceGoal)calibrationSetupParameters.getParent();
            if (set.containsAll(DGCExpert.allDGCStrategies)) {
                Set<DGCExpert.DGCTypeEnum> set2 = DGCExpert.getExpert().resolveWhichDGCStrategyToUse(scienceGoal, scienceGoal.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M, Optional.empty(), set, Optional.empty());
                this.publish(CalibrationSetupParametersEditor.DGC_STRATEGY, set2);
            } else {
                this.publish(CalibrationSetupParametersEditor.DGC_STRATEGY, set);
            }
        }
        this.publish(CalibrationSetupParametersEditor.DGC_USER_SELECTABLE, bl);
    }

    @Override
    public void userHasAuthenticated() {
        this.publish();
        boolean bl = RoleDirectoryServiceHelper.isUserP2G() && Telescope.isOTConfiguredAs(Telescope.CSVALMA);
        this.publish(CalibrationSetupParametersEditor.FORCE_DGC_AVAILABLE, bl);
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID.equals(SfiControlParameterEditor.FID_ANGULARRESOLUTIONMODE)) {
            if (object == null) {
                return;
            }
            String string = (String)object;
            if (string.equals(PerformanceParameters.RESOLUTIONOPTION_STANDALONEACA)) {
                this.resetAstrometryModeToStandard();
            }
        } else if (fieldID.equals(AbstractTargetEditor.FID_SOLARSYSTEMOBJECT)) {
            if (this.getCalibrationSetupParameters() == null || this.getCalibrationSetupParameters().getParent() == null) {
                return;
            }
            ScienceGoal scienceGoal = (ScienceGoal)this.getCalibrationSetupParameters().getParent();
            try {
                if (scienceGoal.isSolarScienceGoal()) {
                    this.resetAstrometryModeToStandard();
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(CalibrationSetupParametersModel.class).warning("Unable to determine if solar science goal");
            }
        }
    }

    private void resetAstrometryModeToStandard() {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters != null) {
            calibrationSetupParameters.setPositionalAccuracy(CalibrationSetupParameters.POSITIONALACCURACY_STANDARD);
            this.publish(CalibrationSetupParametersEditor.ASTROMETRY_MODE_FID, CalibrationSetupParameters.POSITIONALACCURACY_STANDARD);
        }
    }

    public void removeMostRecentlyAddedCalibrator() {
        if (this.lastCalibratorAdded != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.lastCalibratorAdded);
            this.update(null, CalibrationSetupParametersEditor.DELETE_CALIBRATOR_QUERY, arrayList);
        }
    }

    public void retainCalibratorSelection() {
        this.lastCalibratorAdded = null;
    }

    public CalibratorExpertModel getCalibratorExpertModel() {
        return this.calibratorExpertModel;
    }

    public CalibrationTargetParametersModel getCalibrationTargetParametersModel() {
        return this.calibrationTargetParametersModel;
    }
}

