/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.acs.commandcenter.gui.thirdparty.SpringUtilities;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.factory.TextField;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.services.submission.RemoteProgressListener;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.IHelpfulError;
import alma.obsprep.util.job.AbstractJob;
import alma.obsprep.util.job.JobUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.lang3.StringUtils;

public class ObsProjectChooser
extends JPanel {
    private static final long serialVersionUID = -3210424097579377994L;
    protected static DialogId DIALOG_DELETE_PROJECT = new DialogId("ProjectFinder.DeleteProject");
    protected static final String NULL = "";
    protected Log.Logger logger = Log.logger((Object)this);
    protected ProjectRepository repository;
    protected JButton btnChoose;
    protected JButton btnDone;
    protected JButton btnDelete;
    protected JButton btnSearch;
    protected JCheckBox chkIgnoreCase;
    protected JCheckBox chkExactMatch;
    protected JCheckBox chkIncludeStatus;
    protected JRadioButton radAll;
    protected JRadioButton radMine;
    protected JRadioButton radPI;
    protected JRadioButton radProjName;
    protected JRadioButton radProjCode;
    protected TextField txtPI;
    protected TextField txtProjName;
    protected TextField txtProjCode;
    private JPanel pnlAdv;
    private final RemoteProgressListener progressListener = new RemoteProgressListener(){

        @Override
        public void remoteProgress(final int n, final int n2, final String string) {
            new AbstractJob("Update status label", true, JobUtility.swing){

                @Override
                public void job() throws Exception {
                    ObsProjectChooser.this.lblStatus.setText(string + " (" + (n + 1) + "/" + n2 + ")");
                }
            }.go();
        }
    };
    protected Vector<Vector<String>> modelData;
    protected Vector<String> columnNames;
    protected Table table;
    protected ReadonlyModel tableModel;
    protected JLabel lblStatus;
    protected ChangeListener changeListener;
    protected String username;
    protected JobUtility.CustomExecutor networkQueue = JobUtility.createCustomExecutor(3, "OT-NetworkQueue");
    protected AbstractJob currentSearchJob;
    private boolean everpaint;
    private int idxName;
    private int idxUid;

    /*
     * WARNING - void declaration
     */
    public ObsProjectChooser(ChangeListener changeListener, final ProjectRepository projectRepository) {
        super(new BorderLayout());
        void var10_24;
        void var8_14;
        int n;
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.changeListener = changeListener;
        this.repository = projectRepository;
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        jPanel.setBorder(new TitledBorder(new LineBorder(Color.black, 2), " Found Projects "));
        jPanel.setLayout(new BorderLayout());
        this.setupTableColumns();
        this.modelData = new Vector();
        this.tableModel = new ReadonlyModel(this.modelData, this.columnNames);
        this.table = new Table(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setRowSorter(new TableRowSorter<ReadonlyModel>(this.tableModel));
        this.table.setSelectionMode(0);
        this.table.setFocusPainted(false);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(15);
        this.table.setAutoResizeMode(3);
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        JComponent jComponent = Box.createVerticalBox();
        jPanel.add((Component)jComponent, "East");
        this.btnChoose = new JButton("Open", Icons.okay);
        jComponent.add(this.btnChoose);
        this.btnChoose.setEnabled(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ObsProjectChooser.this.btnChoose.setEnabled(ObsProjectChooser.this.tableModel.getRowCount() > 0 && ObsProjectChooser.this.table.getSelectedRowCount() > 0);
            }
        });
        jComponent.add(Box.createVerticalStrut(10));
        Object object = new JSeparator(0);
        jComponent.add((Component)object);
        jComponent.add(Box.createVerticalStrut(10));
        this.btnDelete = new JButton("Cancel Project", Icons.destroy);
        jComponent.add(this.btnDelete);
        jComponent.add(Box.createVerticalStrut(20));
        jComponent.add(Box.createVerticalGlue());
        this.btnDone = new JButton("Cancel", Icons.close);
        jComponent.add(this.btnDone);
        Dimension object2 = new Dimension(Short.MAX_VALUE, new JButton().getPreferredSize().height);
        JComponent[] buttonGroup = new JComponent[]{this.btnChoose, this.btnDelete, this.btnDone, object};
        int n2 = buttonGroup.length;
        for (n = 0; n < n2; ++n) {
            JComponent jComponent2 = buttonGroup[n];
            jComponent2.setMaximumSize(object2);
        }
        this.lblStatus = new JLabel(" ");
        this.lblStatus.setBorder(new EmptyBorder(0, 5, 0, 0));
        jPanel.add((Component)this.lblStatus, "South");
        jComponent = new JPanel();
        this.add((Component)jComponent, "North");
        jComponent.setBorder(new TitledBorder(new LineBorder(Color.black, 2), " Search for Projects "));
        jComponent.setLayout(new BorderLayout());
        this.pnlAdv = new JPanel(new SpringLayout());
        this.radAll = new JRadioButton("all projects");
        this.pnlAdv.add(this.radAll);
        this.pnlAdv.add(new JPanel());
        SpringUtilities.makeCompactGrid((Container)this.pnlAdv, (int)0, (int)2);
        jComponent.add((Component)this.pnlAdv, "North");
        object = new JPanel(new SpringLayout());
        this.radMine = new JRadioButton("all my projects");
        ((Container)object).add(this.radMine);
        ((Container)object).add(new JPanel());
        this.radPI = new JRadioButton("by PI ALMA ID");
        ((Container)object).add(this.radPI);
        this.txtPI = new TextField(20);
        ((Container)object).add(this.txtPI);
        this.radProjCode = new JRadioButton("by Project Code");
        ((Container)object).add(this.radProjCode);
        this.txtProjCode = new TextField(20);
        ((Container)object).add(this.txtProjCode);
        this.radProjName = new JRadioButton("by Project Name");
        ((Container)object).add(this.radProjName);
        this.txtProjName = new TextField(20);
        ((Container)object).add(this.txtProjName);
        SpringUtilities.makeCompactGrid((Container)object, (int)0, (int)2);
        jComponent.add((Component)object, "Center");
        this.radAll.setMnemonic('a');
        this.radMine.setMnemonic('m');
        this.radPI.setMnemonic('i');
        this.radProjCode.setMnemonic('c');
        this.radProjCode.setDisplayedMnemonicIndex(this.radProjCode.getText().indexOf(67));
        this.radProjName.setMnemonic('n');
        object = new JPanel();
        ((JComponent)object).setBorder(new EmptyBorder(0, 20, 0, 5));
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        ((Container)object).add(Box.createVerticalGlue());
        this.chkIgnoreCase = new JCheckBox("Ignore Case");
        ((Container)object).add(this.chkIgnoreCase);
        this.chkExactMatch = new JCheckBox("Exact Match");
        ((Container)object).add(this.chkExactMatch);
        this.chkIncludeStatus = new JCheckBox("Retrieve Status");
        ((Container)object).add(this.chkIncludeStatus);
        ((Container)object).add(Box.createVerticalStrut(5));
        this.btnSearch = new JButton("   Search   ");
        ((Container)object).add(this.btnSearch);
        ((Container)object).add(Box.createVerticalStrut(5));
        jComponent.add((Component)object, "East");
        object = new TextField.ActivationRequestHandler(){

            @Override
            public void activationRequested(TextField textField) {
                ObsProjectChooser.this.radPI.setSelected(ObsProjectChooser.this.txtPI.hasFocus());
                ObsProjectChooser.this.radProjName.setSelected(ObsProjectChooser.this.txtProjName.hasFocus());
                ObsProjectChooser.this.radProjCode.setSelected(ObsProjectChooser.this.txtProjCode.hasFocus());
            }
        };
        TextField[] textFieldArray = new TextField[]{this.txtPI, this.txtProjName, this.txtProjCode};
        int n3 = textFieldArray.length;
        boolean bl = false;
        while (var8_14 < n3) {
            TextField textField = textFieldArray[var8_14];
            textField.setActivationRequestHandler((TextField.ActivationRequestHandler)object);
            ++var8_14;
        }
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ObsProjectChooser.this.txtPI.setActive(ObsProjectChooser.this.radPI.isSelected());
                    ObsProjectChooser.this.txtProjName.setActive(ObsProjectChooser.this.radProjName.isSelected());
                    ObsProjectChooser.this.txtProjCode.setActive(ObsProjectChooser.this.radProjCode.isSelected());
                    ObsProjectChooser.this.chkExactMatch.setEnabled(ObsProjectChooser.this.txtPI.isActive() || ObsProjectChooser.this.txtProjName.isActive() || ObsProjectChooser.this.txtProjCode.isActive());
                    ObsProjectChooser.this.chkIgnoreCase.setEnabled(ObsProjectChooser.this.chkExactMatch.isEnabled());
                }
            }
        };
        for (JRadioButton jRadioButton : new JRadioButton[]{this.radAll, this.radMine, this.radPI, this.radProjCode, this.radProjName}) {
            jRadioButton.addItemListener(itemListener);
        }
        ButtonGroup buttonGroup2 = new ButtonGroup();
        JRadioButton[] jRadioButtonArray = new JRadioButton[]{this.radAll, this.radMine, this.radPI, this.radProjCode, this.radProjName};
        n = jRadioButtonArray.length;
        boolean bl2 = false;
        while (var10_24 < n) {
            JRadioButton jRadioButton = jRadioButtonArray[var10_24];
            buttonGroup2.add(jRadioButton);
            ++var10_24;
        }
        this.chkIgnoreCase.setSelected(true);
        this.chkExactMatch.setSelected(false);
        this.chkIncludeStatus.setSelected(false);
        this.chkIncludeStatus.setVisible(false);
        this.btnDelete.setVisible(false);
        this.chkIgnoreCase.setVisible(false);
        this.chkExactMatch.setVisible(false);
        this.radMine.setSelected(true);
        this.table.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (ObsProjectChooser.this.table.getSelectedRow() == -1) {
                    ObsProjectChooser.this.table.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ObsProjectChooser.this.getSelectedEntityId();
                if (string != ObsProjectChooser.NULL) {
                    ObsProjectChooser.this.fireChosen(string);
                }
            }
        };
        this.btnChoose.addActionListener(actionListener);
        this.table.addActionListener(actionListener);
        this.btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObsProjectChooser.this.fireChosen(ObsProjectChooser.NULL);
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final String string = ObsProjectChooser.this.getSelectedEntityId();
                if (string == ObsProjectChooser.NULL) {
                    return;
                }
                if (!GUIUtilities.confirm(DIALOG_DELETE_PROJECT, "This will delete project \"" + ObsProjectChooser.this.getSelectedProjectName() + "\" from the archive.\nUndoing this operation is possible but requires help from external tools.\nAre you sure?")) {
                    return;
                }
                ObsProjectChooser.this.lblStatus.setText(" ");
                new AbstractJob("delete project " + string, false, ObsProjectChooser.this.networkQueue){

                    @Override
                    public void job() throws Exception {
                        try {
                            final Vector<String> vector = ObsProjectChooser.this.getSelectedRow();
                            projectRepository.delete(string);
                            new AbstractJob("remove row", false, JobUtility.swing){

                                @Override
                                public void job() throws Exception {
                                    ObsProjectChooser.this.lblStatus.setText("1 project deleted");
                                    ObsProjectChooser.this.modelData.remove(vector);
                                    ObsProjectChooser.this.tableModel.fireTableDataChanged();
                                }
                            }.go();
                        }
                        catch (Exception exception) {
                            String string2 = "Delete operation cancelled: " + string + ": " + exception.getMessage();
                            ObsProjectChooser.this.logger.log(Level.FINE, string2, (Throwable)exception);
                            GUIUtilities.error(null, string2, exception);
                        }
                    }
                }.go();
            }
        });
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                boolean bl2;
                String string;
                int n;
                ObsProjectChooser.this.lblStatus.setText("Searching");
                ObsProjectChooser.this.btnSearch.setEnabled(false);
                if (ObsProjectChooser.this.radAll.isSelected()) {
                    n = 2;
                    string = ObsProjectChooser.NULL;
                    bl2 = true;
                    bl = true;
                } else if (ObsProjectChooser.this.radMine.isSelected()) {
                    n = 1;
                    string = "__{RequestingUser}__";
                    bl2 = true;
                    bl = false;
                } else if (ObsProjectChooser.this.radPI.isSelected()) {
                    n = 0;
                    string = StringUtils.trim((String)ObsProjectChooser.this.txtPI.getText());
                    bl2 = !ObsProjectChooser.this.chkIgnoreCase.isSelected();
                    bl = !ObsProjectChooser.this.chkExactMatch.isSelected();
                } else if (ObsProjectChooser.this.radProjName.isSelected()) {
                    n = 2;
                    string = ObsProjectChooser.this.txtProjName.getText();
                    bl2 = !ObsProjectChooser.this.chkIgnoreCase.isSelected();
                    bl = !ObsProjectChooser.this.chkExactMatch.isSelected();
                } else if (ObsProjectChooser.this.radProjCode.isSelected()) {
                    n = 3;
                    string = StringUtils.trim((String)ObsProjectChooser.this.txtProjCode.getText());
                    bl2 = !ObsProjectChooser.this.chkIgnoreCase.isSelected();
                    bl = !ObsProjectChooser.this.chkExactMatch.isSelected();
                } else {
                    return;
                }
                final boolean bl3 = ObsProjectChooser.this.chkIncludeStatus.isSelected();
                ObsProjectChooser.this.currentSearchJob = new AbstractJob("search for projects", false, ObsProjectChooser.this.networkQueue){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void job() throws Exception {
                        block4: {
                            try {
                                final String[][] stringArray = ObsProjectChooser.this.search(n, string, bl2, bl, bl3);
                                if (this != ObsProjectChooser.this.currentSearchJob) break block4;
                                new AbstractJob("show results", false, JobUtility.swing){

                                    @Override
                                    public void job() throws Exception {
                                        ObsProjectChooser.this.lblStatus.setText(stringArray.length + " project(s) found");
                                        ObsProjectChooser.this.setListContent(stringArray, bl3);
                                        if (stringArray.length > 0) {
                                            ObsProjectChooser.this.table.requestFocusInWindow();
                                        }
                                    }
                                }.go();
                            }
                            catch (Exception exception) {
                                try {
                                    String string3 = exception instanceof IHelpfulError ? ((IHelpfulError)((Object)exception)).getUserMeaning() : exception.getMessage();
                                    final String string2 = "Search operation cancelled: " + string3;
                                    new AbstractJob("show error", false, JobUtility.swing){

                                        @Override
                                        public void job() {
                                            if (!ObsProjectChooser.this.lblStatus.isShowing()) {
                                                return;
                                            }
                                            ObsProjectChooser.this.lblStatus.setText("Search Failed");
                                            GUIUtilities.error(null, string2, exception);
                                        }
                                    }.go();
                                }
                                catch (Throwable throwable) {
                                    new AbstractJob("re-enable search button", false, JobUtility.swing){

                                        @Override
                                        public void job() {
                                            if (ObsProjectChooser.this.btnSearch != null) {
                                                ObsProjectChooser.this.btnSearch.setEnabled(true);
                                            }
                                        }
                                    }.go();
                                    throw throwable;
                                }
                                new /* invalid duplicate definition of identical inner class */.go();
                            }
                        }
                        new /* invalid duplicate definition of identical inner class */.go();
                    }
                }.go();
            }
        });
        this.setName("ProjectFinder");
        this.btnChoose.setName("ProjectFinder.btnChoose");
        this.btnDone.setName("ProjectFinder.btnDone");
        this.btnDelete.setName("ProjectFinder.btnDelete");
        this.btnSearch.setName("ProjectFinder.btnSearch");
        this.chkIgnoreCase.setName("ProjectFinder.chkIgnoreCase");
        this.chkExactMatch.setName("ProjectFinder.chkExactMatch");
        this.chkIncludeStatus.setName("ProjectFinder.chkIncludeStatus");
        this.radAll.setName("ProjectFinder.radAll");
        this.radMine.setName("ProjectFinder.radMine");
        this.radPI.setName("ProjectFinder.radPI");
        this.radProjName.setName("ProjectFinder.radProjName");
        this.radProjCode.setName("ProjectFinder.radProjCode");
        this.txtPI.setName("ProjectFinder.txtPI");
        this.txtProjName.setName("ProjectFinder.txtProjName");
        this.txtProjCode.setName("ProjectFinder.txtProjCode");
        this.table.setName("ProjectFinder.tblResults");
        this.lblStatus.setName("ProjectFinder.lblStatus");
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.everpaint) {
            JRadioButton[] jRadioButtonArray;
            this.everpaint = true;
            for (JRadioButton jRadioButton : jRadioButtonArray = new JRadioButton[]{this.radAll, this.radMine, this.radPI, this.radProjName, this.radProjCode}) {
                if (!jRadioButton.isSelected()) continue;
                jRadioButton.requestFocusInWindow();
                break;
            }
        }
    }

    protected void fireChosen(String string) {
        ChangeEvent changeEvent = new ChangeEvent(string);
        this.changeListener.stateChanged(changeEvent);
    }

    public void cleanUp() {
        this.networkQueue.shutdown();
    }

    protected String[][] search(int n, String string, boolean bl, boolean bl2, boolean bl3) throws PersistenceException {
        try {
            return this.repository.query2(n, string, bl, bl2, this.progressListener);
        }
        catch (PersistenceException persistenceException) {
            if (persistenceException.getErrorCode() == 401) {
                return new String[0][];
            }
            throw persistenceException;
        }
    }

    protected void setupTableColumns() {
        this.columnNames = new Vector();
        this.columnNames.add("Project Name");
        this.idxName = this.columnNames.size() - 1;
        this.columnNames.add("Project Code");
        this.columnNames.add("PI ALMA ID");
        this.columnNames.add("Creation Time");
        this.columnNames.add("Submission Time");
        this.columnNames.add("Project ID");
        this.idxUid = this.columnNames.size() - 1;
    }

    protected String getSelectedProjectName() {
        return this.getSelectedValue(this.idxName);
    }

    protected String getSelectedEntityId() {
        return this.getSelectedValue(this.idxUid);
    }

    protected void setListContent(String[][] stringArray, boolean bl) {
        this.modelData.clear();
        for (String[] stringArray2 : stringArray) {
            Vector<String> vector = new Vector<String>();
            vector.add(stringArray2[1]);
            vector.add(stringArray2[2]);
            vector.add(stringArray2[3]);
            vector.add(stringArray2[4]);
            vector.add(stringArray2[5]);
            vector.add(stringArray2[0]);
            this.modelData.add(vector);
        }
        this.tableModel.fireTableDataChanged();
        ColumnResizer.adjustColumnPreferredWidths(this.table);
    }

    protected String getSelectedValue(int n) {
        Vector<String> vector = this.getSelectedRow();
        if (vector == null) {
            return NULL;
        }
        return vector.get(n);
    }

    protected Vector<String> getSelectedRow() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return null;
        }
        n = this.table.convertRowIndexToModel(n);
        Vector<String> vector = this.modelData.get(n);
        return vector;
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        DefaultDialog defaultDialog = new DefaultDialog(new BogoRepository());
        defaultDialog.setDefaultCloseOperation(2);
        String string = defaultDialog.letUserChooseProject();
        System.out.println("You chose '" + string + "'.");
        System.exit(0);
    }

    private static class BogoRepository
    implements ProjectRepository {
        private BogoRepository() {
        }

        @Override
        public void delete(String string) throws PersistenceException {
            JOptionPane.showMessageDialog(null, "You deleted '" + string + "'.");
        }

        @Override
        public ObsProject retrieve(String string, ProjectRepository.RetrieveVariant retrieveVariant) throws PersistenceException {
            return null;
        }

        @Override
        public String[][] query2(int n, String string, boolean bl, boolean bl2, RemoteProgressListener remoteProgressListener) throws PersistenceException {
            String[][] stringArray = new String[][]{{"id1", "ProjName 1", "code 1", "Some PI", "1999-12-31", "1999-12-31", "Phase1Submitted"}, {"id2", "ProjName 2", "code 2", "Other PI", "2000-01-01", "2000-01-01", "Phase2Submitted"}};
            return stringArray;
        }

        @Override
        public ObsProject store(ObsProject obsProject, ProjectRepository.StoreVariant storeVariant, RemoteProgressListener remoteProgressListener) throws PersistenceException {
            return null;
        }
    }

    public static class DefaultDialog
    extends GuiFactory.Dialog
    implements ChangeListener {
        private static final long serialVersionUID = 8282898081357338361L;
        private final ObsProjectChooser chooser;
        protected String answer;

        public DefaultDialog(ProjectRepository projectRepository) {
            this.setTitle("Find Projects In ALMA Archive");
            this.setModal(true);
            this.setSize(1050, 500);
            this.setLocationRelativeTo(this.getOwner());
            this.chooser = new ObsProjectChooser(this, projectRepository);
            this.getContentPane().add(this.chooser);
            this.setDefaultButton(this.chooser.btnSearch);
            this.setAdvancedOptionsVisible(false);
        }

        public String letUserChooseProject() {
            this.answer = null;
            this.setVisible(true);
            this.chooser.cleanUp();
            return this.answer;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            String string = (String)changeEvent.getSource();
            this.answer = string == ObsProjectChooser.NULL ? null : string;
            this.setVisible(false);
        }

        public void setAdvancedOptionsVisible(boolean bl) {
            this.chooser.pnlAdv.setVisible(bl);
            this.chooser.radAll.setEnabled(bl);
        }
    }

    protected class ReadonlyModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 2882981784374408252L;

        ReadonlyModel(Vector<? extends Vector> vector, Vector<?> vector2) {
            super(vector, vector2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

