/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.BOCollection;
import alma.obsprep.bo.OusCollection;
import alma.obsprep.bo.ResourceCollection;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.OpticalPointingScienceGoal;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TechnicalJustification;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.AtmosphericCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.HolographyParameters;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.OpticalPointingParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.RadiometricPointingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SidebandRatioCalParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.GuiApi;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.actions.OusComponentProtect;
import alma.obsprep.ot.editors.misc.DefaultEditor;
import alma.obsprep.ot.editors.misc.SummaryTableEditor;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.editors.obsproject.ObsProjectEditor;
import alma.obsprep.ot.editors.obsproject.ObsProposalEditor;
import alma.obsprep.ot.editors.obsproject.ObsUnitSetEditor;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalEditor;
import alma.obsprep.ot.editors.schedblock.FieldSourceEditor;
import alma.obsprep.ot.editors.schedblock.ObservingGroupEditor;
import alma.obsprep.ot.editors.schedblock.OpticalCameraSpecEditor;
import alma.obsprep.ot.editors.schedblock.SchedBlockEditor;
import alma.obsprep.ot.editors.schedblock.SpectralSpecFormEditor;
import alma.obsprep.ot.editors.schedblock.SpectralSpecVisualEditor;
import alma.obsprep.ot.editors.schedblock.TargetEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.ObservingParameterTabEditor;
import alma.obsprep.ot.editors.spatialvisual.SchedBlockSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.ScienceGoalSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualEditor;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualEditorForSB;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualEditorForSG;
import alma.obsprep.ot.editors.spectralvisual.ScienceViewSpectralVisualEditor;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.misc.DefaultModel;
import alma.obsprep.ot.models.misc.SummaryTableModel;
import alma.obsprep.ot.models.obsproject.ObsProjectModel;
import alma.obsprep.ot.models.obsproject.ObsProposalModel;
import alma.obsprep.ot.models.obsproject.ObsUnitSetModel;
import alma.obsprep.ot.models.obsproject.ObservatoryGoalModel;
import alma.obsprep.ot.models.schedblock.FieldSourceModel;
import alma.obsprep.ot.models.schedblock.ObservingGroupModel;
import alma.obsprep.ot.models.schedblock.OpticalCameraSpecModel;
import alma.obsprep.ot.models.schedblock.SchedBlockModel;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.obsprep.ot.models.schedblock.TargetModel;
import alma.obsprep.ot.models.schedblock.observingparameters.ObservingParameterTabModel;
import alma.obsprep.ot.models.sciencegoals.TargetParametersModel;
import alma.obsprep.services.optical.OpticalPointingScienceGoalEditor;
import alma.obsprep.services.optical.OpticalPointingScienceGoalModel;
import alma.obsprep.services.sfi.SingleFieldScienceGoalEditor;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.MiscUtils;
import com.google.common.base.Stopwatch;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.help.CSH;
import lombok.NonNull;

public class EditorManager {
    private static final String HTML_HEADER = "<html><head><style type=\"text/css\">body { font-family: sans-serif; font-size: 110%;margin-left:20px; margin-right:0px; margin-top:10px; margin-bottom:0px;}</style></head>";
    private static final String SCIENCE_PLAN = "<html><head><style type=\"text/css\">body { font-family: sans-serif; font-size: 110%;margin-left:20px; margin-right:0px; margin-top:10px; margin-bottom:0px;}</style></head><body width=700>For approved proposals, the Phase-1 Science Goals have been copied to the Phase-2 Program tab where they are contained within the Science Plan folder. PIs should check that the information in each Science Goal is correct, particularly the requested positions and frequencies. Minor changes to these parameters in the Science Goal are allowed by the PI (as shown by color-coding), but major changes and any change to other parameters must be performed by observatory staff and requested via the Helpdesk.<p><br>Once the information in each Science Goal is confirmed, the project should be submitted to the archive (via the File menu). Resubmissions after the deadline will not be possible. <p><br>Once a Major Change has been made via a request to the Helpdesk, no further changes to the project will be possible and therefore any Minor Changes should be made first.</body></html>";
    private static final String OUS_COLLECTION = "<html><head><style type=\"text/css\">body { font-family: sans-serif; font-size: 110%;margin-left:20px; margin-right:0px; margin-top:10px; margin-bottom:0px;}</style></head><body width=700>This folder contains ObsUnitSets and SBs that are not connected with Science Goals but instead have been created \"by hand\" or by using actions for creating a few specific Observatory Calibration modes.</body></html>";
    private static final String RESOURCE_COLLECTION = "<html><head><style type=\"text/css\">body { font-family: sans-serif; font-size: 110%;margin-left:20px; margin-right:0px; margin-top:10px; margin-bottom:0px;}</style></head><body width=700>This folder contains the resources (field source setups, instrument setups, observing parameters) that may be used and re-used to create \"target descriptions.\"</body></html>";
    private final Map<EditorType, Map<BusinessObject, Editor>> objectEditors;
    private final Map<EditorType, Map<Class<?>, Editor>> classEditors;
    private final Map<BusinessObject, Model> objectModels;
    private final Map<Class<?>, Model> classModels;
    private final Editor summaryFormEditor;
    private final Editor summaryVisualEditor;
    private final Model summaryTableModel;
    private final GuiApi guiApi;
    private final ObservingToolController otc;
    private boolean ousCompProtected = true;

    private void addModels() {
        ObsProjectModel obsProjectModel = new ObsProjectModel(null);
        this.addModel(ObsProject.class, obsProjectModel);
        ObsProposalModel obsProposalModel = new ObsProposalModel(null);
        this.addModel(ObsProposal.class, obsProposalModel);
        obsProposalModel.setParentModel(obsProjectModel);
        SingleFieldScienceGoalModel singleFieldScienceGoalModel = new SingleFieldScienceGoalModel(null);
        this.addModel(ScienceGoal.class, singleFieldScienceGoalModel);
        singleFieldScienceGoalModel.getSpectralSetupParametersModel().setObsProposalModel(obsProposalModel);
        singleFieldScienceGoalModel.getSfiControlParameterModel().setObsProposalModel(obsProposalModel);
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        List<Runnable> list = List.of(() -> this.addModel(ObsUnitSet.class, new ObsUnitSetModel(null)), () -> this.addModel(SchedBlock.class, new SchedBlockModel(null)), () -> this.addModel(SpectralSpec.class, new SpectralSpecModel(null)), () -> this.addModel(OpticalCameraSpec.class, new OpticalCameraSpecModel(null)), () -> this.addModel(FieldSource.class, new FieldSourceModel(null)), () -> this.addModel(ObservingParameters.class, new ObservingParameterTabModel()), () -> this.addModel(ObservingGroup.class, new ObservingGroupModel(null)), () -> this.addModel(Target.class, new TargetModel(null, this.otc)), () -> this.addModel(SpectralSetupParameters.class, singleFieldScienceGoalModel.getSpectralSetupParametersModel()), () -> this.addModel(TargetParameters.class, singleFieldScienceGoalModel.getSgFieldSetupModel().getTargetParametersModel()), () -> this.addModel(PerformanceParameters.class, singleFieldScienceGoalModel.getSfiControlParameterModel()), () -> this.addModel(TechnicalJustification.class, singleFieldScienceGoalModel.getTechnicalJustificationModel()), () -> this.addModel(CalibrationSetupParameters.class, singleFieldScienceGoalModel.getCalibrationSetupParametersModel()), () -> this.addModel(OpticalPointingScienceGoal.class, new OpticalPointingScienceGoalModel(null)), () -> this.addModel(ObservatoryGoal.class, new ObservatoryGoalModel(null)), () -> this.addModel(ObsProgram.class, new DefaultModel(null)), () -> this.addModel(OusCollection.class, new DefaultModel(null)), () -> this.addModel(ResourceCollection.class, new DefaultModel(null)));
        MiscUtils.processFutures(executorService, list);
    }

    private void addFormEditors() {
        ObsProjectEditor obsProjectEditor = new ObsProjectEditor(this.modelFor(ObsProject.class), this.modelFor(ObsProposal.class), this.otc);
        this.addClassEditor(EditorType.FORM, ObsProject.class, obsProjectEditor);
        CSH.setHelpIDString((Component)obsProjectEditor, (String)"TOC-The Phase 1 Proposal: Basic Details");
        ObsProposalEditor obsProposalEditor = new ObsProposalEditor(this.modelFor(ObsProposal.class), this.otc);
        this.addClassEditor(EditorType.FORM, ObsProposal.class, obsProposalEditor);
        CSH.setHelpIDString((Component)obsProposalEditor, (String)"TOC-The Phase 1 Proposal: Basic Details-Proposal Information");
        this.modelFor(ObsProject.class).subscribe(this.editorFor(EditorType.FORM, ObsProposal.class));
        this.modelFor(ObsProposal.class).subscribe((ObsProjectModel)this.modelFor(ObsProject.class));
        ObservingParameterTabEditor observingParameterTabEditor = new ObservingParameterTabEditor(this.modelFor(ObservingParameters.class));
        SingleFieldScienceGoalModel singleFieldScienceGoalModel = (SingleFieldScienceGoalModel)this.modelFor(ScienceGoal.class);
        SingleFieldScienceGoalEditor singleFieldScienceGoalEditor = new SingleFieldScienceGoalEditor(singleFieldScienceGoalModel);
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        List<Runnable> list = List.of(() -> {
            ObsUnitSetEditor obsUnitSetEditor = new ObsUnitSetEditor(this.modelFor(ObsUnitSet.class));
            this.addClassEditor(EditorType.FORM, ObsUnitSet.class, obsUnitSetEditor);
            CSH.setHelpIDString((Component)obsUnitSetEditor, (String)"TOC-Phase 2 Program Scheduling Blocks-Observing Unit Set");
        }, () -> {
            SchedBlockEditor schedBlockEditor = new SchedBlockEditor(this.modelFor(SchedBlock.class));
            this.addClassEditor(EditorType.FORM, SchedBlock.class, schedBlockEditor);
            CSH.setHelpIDString((Component)schedBlockEditor, (String)"TOC-Phase 2 Program Scheduling Blocks-The Scheduling Block");
        }, () -> {
            SpectralSpecFormEditor spectralSpecFormEditor = new SpectralSpecFormEditor(this.modelFor(SpectralSpec.class), this.otc);
            this.addClassEditor(EditorType.FORM, SpectralSpec.class, spectralSpecFormEditor);
            CSH.setHelpIDString((Component)spectralSpecFormEditor, (String)"TOC-Phase 2 Program Scheduling Blocks-Instrument Setup");
        }, () -> this.addClassEditor(EditorType.FORM, OpticalCameraSpec.class, new OpticalCameraSpecEditor(this.modelFor(OpticalCameraSpec.class))), () -> {
            FieldSourceEditor fieldSourceEditor = new FieldSourceEditor(this.modelFor(FieldSource.class));
            this.addClassEditor(EditorType.FORM, FieldSource.class, fieldSourceEditor);
            CSH.setHelpIDString((Component)fieldSourceEditor, (String)"TOC-Phase 2 Program Scheduling Blocks-Field Sources");
        }, () -> this.addClassEditor(EditorType.FORM, ObservingParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, ScienceParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, PhaseCalParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, PointingCalParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, AmplitudeCalParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, PolarizationCalParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, FocusCalParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, AtmosphericCalParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, DelayCalParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, CheckSourceCalParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, SidebandRatioCalParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, BandpassCalParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, OpticalPointingParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, RadiometricPointingParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, DGCScienceCalParameters.class, observingParameterTabEditor), () -> this.addClassEditor(EditorType.FORM, DGCReferenceCalParameters.class, observingParameterTabEditor), () -> {
            this.addClassEditor(EditorType.FORM, HolographyParameters.class, observingParameterTabEditor);
            CSH.setHelpIDString((Component)observingParameterTabEditor, (String)"TOC-Phase 2 Program Scheduling Blocks-Observing Parameters-Science Parameters");
        }, () -> {
            ObservingGroupEditor observingGroupEditor = new ObservingGroupEditor(this.modelFor(ObservingGroup.class));
            this.addClassEditor(EditorType.FORM, ObservingGroup.class, observingGroupEditor);
            CSH.setHelpIDString((Component)observingGroupEditor, (String)"TOC-Phase 2 Program Scheduling Blocks-The Scheduling Block-Observing Groups");
        }, () -> {
            TargetEditor targetEditor = new TargetEditor(this.modelFor(Target.class), this.otc);
            this.addClassEditor(EditorType.FORM, Target.class, targetEditor);
            CSH.setHelpIDString((Component)targetEditor, (String)"TOC-Phase 2 Program Scheduling Blocks-Targets");
        }, () -> this.addClassEditor(EditorType.FORM, ObsProgram.class, new DefaultEditor(this.modelFor(ObsProgram.class), SCIENCE_PLAN)), () -> this.addClassEditor(EditorType.FORM, OusCollection.class, new DefaultEditor(this.modelFor(OusCollection.class), OUS_COLLECTION)), () -> this.addClassEditor(EditorType.FORM, ResourceCollection.class, new DefaultEditor(this.modelFor(ResourceCollection.class), RESOURCE_COLLECTION)), () -> {
            OpticalPointingScienceGoalEditor opticalPointingScienceGoalEditor = new OpticalPointingScienceGoalEditor((OpticalPointingScienceGoalModel)this.modelFor(OpticalPointingScienceGoal.class));
            this.addClassEditor(EditorType.FORM, OpticalPointingScienceGoal.class, opticalPointingScienceGoalEditor);
            CSH.setHelpIDString((Component)opticalPointingScienceGoalEditor, (String)"TOC-Phase 1 and Phase 2 Science Goals");
        }, () -> {
            ObservatoryGoalEditor observatoryGoalEditor = new ObservatoryGoalEditor((ObservatoryGoalModel)this.modelFor(ObservatoryGoal.class));
            this.addClassEditor(EditorType.FORM, ObservatoryGoal.class, observatoryGoalEditor);
            CSH.setHelpIDString((Component)observatoryGoalEditor, (String)"TOC-Phase 1 and Phase 2 Science Goals");
        }, () -> {
            this.addClassEditor(EditorType.FORM, ScienceGoal.class, singleFieldScienceGoalEditor);
            CSH.setHelpIDString((Component)singleFieldScienceGoalEditor, (String)"TOC-Phase 1 and Phase 2 Science Goals");
        });
        MiscUtils.processFutures(executorService, list);
        this.modelFor(ObsProposal.class).subscribe(singleFieldScienceGoalModel);
        this.modelFor(TargetParameters.class).subscribe(singleFieldScienceGoalModel);
        this.modelFor(PerformanceParameters.class).subscribe((TargetParametersModel)this.modelFor(TargetParameters.class));
        this.modelFor(CalibrationSetupParameters.class).subscribe(singleFieldScienceGoalModel);
        singleFieldScienceGoalModel.subscribe(singleFieldScienceGoalEditor.getFieldSetupEditor());
        singleFieldScienceGoalModel.subscribe(singleFieldScienceGoalEditor.getControlParameterEditor());
        singleFieldScienceGoalModel.subscribe(singleFieldScienceGoalEditor.getSpectralEditor());
        singleFieldScienceGoalModel.subscribe(singleFieldScienceGoalEditor.getCalibrationSetupParametersEditor());
    }

    private void addVisualEditors() {
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        List<Runnable> list = List.of(() -> {
            SpectralSpecVisualEditor spectralSpecVisualEditor = new SpectralSpecVisualEditor(this.modelFor(SpectralSpec.class), this.otc);
            this.addClassEditor(EditorType.VISUAL_SPECTRAL, SpectralSpec.class, spectralSpecVisualEditor);
            this.addClassEditor(EditorType.VISUAL_SPECTRAL, Target.class, spectralSpecVisualEditor);
            CSH.setHelpIDString((Component)spectralSpecVisualEditor, (String)"TOC-The Visual Editors-The Visual Spectral Editor-Visual Spectral Editor for Scheduling Blocks");
        }, () -> {
            ScienceViewSpectralVisualEditor scienceViewSpectralVisualEditor = new ScienceViewSpectralVisualEditor(this.modelFor(ScienceGoal.class));
            this.addClassEditor(EditorType.VISUAL_SPECTRAL, ScienceGoal.class, scienceViewSpectralVisualEditor);
            this.modelFor(ObsProposal.class).subscribe(scienceViewSpectralVisualEditor.getSpectralSetupEditor());
            CSH.setHelpIDString((Component)scienceViewSpectralVisualEditor, (String)"TOC-The Visual Editors-The Visual Spectral Editor-Visual Spectral Editor for Science Goals");
        }, () -> {
            FieldSourceModel fieldSourceModel = (FieldSourceModel)this.modelFor(FieldSource.class);
            SchedBlockSpatialVisualModel schedBlockSpatialVisualModel = new SchedBlockSpatialVisualModel(null, fieldSourceModel);
            SpatialVisualEditor spatialVisualEditor = new SpatialVisualEditorForSB(schedBlockSpatialVisualModel);
            this.addClassEditor(EditorType.VISUAL_SPATIAL, Target.class, spatialVisualEditor);
            this.addClassEditor(EditorType.VISUAL_SPATIAL, FieldSource.class, spatialVisualEditor);
            CSH.setHelpIDString((Component)spatialVisualEditor, (String)"TOC-The Visual Editors-The Visual Spatial Editor");
            SingleFieldScienceGoalModel singleFieldScienceGoalModel = (SingleFieldScienceGoalModel)this.modelFor(ScienceGoal.class);
            ScienceGoalSpatialVisualModel scienceGoalSpatialVisualModel = new ScienceGoalSpatialVisualModel(null, singleFieldScienceGoalModel.getSgFieldSetupModel());
            spatialVisualEditor = new SpatialVisualEditorForSG(scienceGoalSpatialVisualModel);
            this.modelFor(PerformanceParameters.class).subscribe(spatialVisualEditor.getFovParameterEditor());
            this.modelFor(TargetParameters.class).subscribe(spatialVisualEditor.getFovParameterEditor());
            this.addClassEditor(EditorType.VISUAL_SPATIAL, ScienceGoal.class, spatialVisualEditor);
            CSH.setHelpIDString((Component)spatialVisualEditor, (String)"TOC-The Visual Editors-The Visual Spatial Editor");
        });
        try {
            MiscUtils.processFutures(executorService, list);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Editor addObjectEditor(EditorType editorType, BusinessObject businessObject, Editor editor) {
        return this.objectEditors.get((Object)editorType).put(businessObject, editor);
    }

    public Editor addFormEditor(BusinessObject businessObject, Editor editor) {
        return this.addObjectEditor(EditorType.FORM, businessObject, editor);
    }

    private Editor addVisualSpatialEditor(BusinessObject businessObject, Editor editor) {
        return this.addObjectEditor(EditorType.VISUAL_SPATIAL, businessObject, editor);
    }

    private Editor addVisualSpectralEditor(BusinessObject businessObject, Editor editor) {
        return this.addObjectEditor(EditorType.VISUAL_SPECTRAL, businessObject, editor);
    }

    public Editor useSummaryFormEditor(BusinessObject businessObject) {
        this.summaryFormEditor.setGuiApi(this.guiApi);
        return this.addFormEditor(businessObject, this.summaryFormEditor);
    }

    private synchronized Editor addClassEditor(EditorType editorType, Class<?> clazz, Editor editor) {
        return this.classEditors.get((Object)editorType).put(clazz, editor);
    }

    private synchronized Model addModel(Class<?> clazz, Model model) {
        return this.classModels.put(clazz, model);
    }

    private void setGuiApi() {
        for (EditorType editorType : EditorType.values()) {
            for (Editor editor : this.classEditors.get((Object)editorType).values()) {
                editor.setGuiApi(this.guiApi);
            }
            for (Editor editor : this.objectEditors.get((Object)editorType).values()) {
                editor.setGuiApi(this.guiApi);
            }
        }
    }

    public EditorManager(GuiApi guiApi, ObservingToolController observingToolController) {
        UserEditRestrictionController.getInstance();
        this.otc = observingToolController;
        this.guiApi = guiApi;
        this.objectEditors = new HashMap<EditorType, Map<BusinessObject, Editor>>(48);
        this.classEditors = new HashMap(48);
        for (EditorType editorType : EditorType.values()) {
            this.objectEditors.put(editorType, new WeakHashMap(64));
            this.classEditors.put(editorType, new WeakHashMap(64));
        }
        this.objectModels = new WeakHashMap<BusinessObject, Model>(48);
        this.classModels = new Hashtable(48);
        this.summaryTableModel = new SummaryTableModel(null, observingToolController);
        this.summaryFormEditor = new SummaryTableEditor(this.summaryTableModel);
        this.summaryVisualEditor = new SummaryTableEditor(this.summaryTableModel);
    }

    public void init() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.addModels();
            Log.logger(EditorManager.class).info("addModel took " + stopwatch);
            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            List<Runnable> list = List.of(() -> {
                this.addFormEditors();
                Log.logger(EditorManager.class).info("addFormEditor took " + stopwatch);
            }, () -> {
                this.addVisualEditors();
                Log.logger(EditorManager.class).info("addVisualEditors took " + stopwatch);
            });
            MiscUtils.processFutures(executorService, list);
            this.setGuiApi();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Model modelFor(Class<?> clazz) {
        return this.classModels.get(clazz);
    }

    public Model modelFor(BusinessObject businessObject) {
        Model model;
        try {
            model = this.objectModels.containsKey(businessObject) ? this.objectModels.get(businessObject) : this.classModels.get(businessObject.getClass());
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            model = null;
        }
        return model;
    }

    public Editor editorFor(EditorType editorType, Class<?> clazz) {
        return this.classEditors.get((Object)editorType).get(clazz);
    }

    public Editor editorFor(@NonNull EditorType editorType, BusinessObject businessObject) {
        Editor editor;
        if (editorType == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        try {
            editor = this.objectEditors.get((Object)editorType).containsKey(businessObject) ? this.objectEditors.get((Object)editorType).get(businessObject) : this.classEditors.get((Object)editorType).get(businessObject.getClass());
            if (editor == this.summaryFormEditor && this.guiApi.usesWorkbookSummary() && !(businessObject instanceof ObsProgram) && !(businessObject instanceof BOCollection)) {
                editor = this.classEditors.get((Object)editorType).get(businessObject.getClass());
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            editor = null;
        }
        return editor;
    }

    public Collection<Editor> getAllFormEditors() {
        return this.classEditors.get((Object)EditorType.FORM).values();
    }

    public Collection<Editor> getAllVisualSpatialEditors() {
        return this.classEditors.get((Object)EditorType.VISUAL_SPATIAL).values();
    }

    public Collection<Editor> getAllVisualSpectralEditors() {
        return this.classEditors.get((Object)EditorType.VISUAL_SPECTRAL).values();
    }

    public Collection<Editor> getAllEditors() {
        ArrayList<Editor> arrayList = new ArrayList<Editor>(this.getAllFormEditors());
        arrayList.addAll(this.getAllVisualSpatialEditors());
        arrayList.addAll(this.getAllVisualSpectralEditors());
        arrayList.add(this.summaryFormEditor);
        arrayList.add(this.summaryVisualEditor);
        return arrayList;
    }

    public void ousCompProtect(boolean bl) {
        this.ousCompProtected = bl;
    }

    public boolean isOusCompProtected() {
        boolean bl = OusComponentProtect.getOusComponentProtectPreference();
        return bl && this.ousCompProtected;
    }

    public Editor getSummaryFormEditor() {
        return this.summaryFormEditor;
    }

    public static enum EditorType {
        FORM,
        VISUAL_SPATIAL,
        VISUAL_SPECTRAL;

    }
}

