/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.subform;

import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.obsproject.RectangleEditor;
import alma.obsprep.ot.editors.schedblock.PointingPatternEditor;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParametersModel;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.valuetypes.Angle;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import lombok.NonNull;

public class FovParameterEditor
extends EditorWithGridBagLayout {
    public static final FieldID FID_REP_FREQ = new FieldID("FovParameter.ReprFreq");
    public static final FieldID FID_FOV_SIZE = new FieldID("FovParameter.FovSize");
    public static final FieldID FID_ARRAY_TYPE = new FieldID("FovParameter.Antenna");
    public static final FieldID FID_SHOW_FOV = new FieldID("FovParameter.ShowFov");
    static final Map<FieldID, String> tooltips = new HashMap<FieldID, String>();
    public static final FieldID FID_IS_PHASE_ONE = new FieldID("FovParameter.isPhaseOne");
    private OTButtonGroup antennaButtonGroup;
    private final ModelChangeSubscriber acaEnabledSubscriber = new ModelChangeSubscriber(){
        private final String label12m = Antenna.ANTENNA_12M.getLabel();
        private final String label7m = Antenna.ANTENNA_7M.getLabel();

        @Override
        public void modelChanged(Model model, FieldID fieldID, Object object) {
            if (RectangleEditor.ACA_ENABLED_FID.equals(fieldID) && object instanceof Boolean) {
                boolean bl = (Boolean)object;
                try {
                    if (!bl && this.label7m.equals(FovParameterEditor.this.antennaButtonGroup.getSelectedItem())) {
                        FovParameterEditor.this.getController().widgetUpdated(FovParameterEditor.this, FID_ARRAY_TYPE, this.label12m);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    return;
                }
                JRadioButton jRadioButton = FovParameterEditor.this.antennaButtonGroup.find(this.label7m);
                if (jRadioButton != null) {
                    jRadioButton.setVisible(bl);
                }
            }
        }
    };

    public FovParameterEditor(@NonNull SpatialVisualParametersModel spatialVisualParametersModel) {
        if (spatialVisualParametersModel == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.setModel(spatialVisualParametersModel);
        this.build();
        spatialVisualParametersModel.publish();
    }

    public SpatialVisualParametersModel getMyModel() {
        return (SpatialVisualParametersModel)this.getModel();
    }

    @Override
    protected void build() {
        super.build("FovParameter");
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        JTextField jTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FID_REP_FREQ, "Representative Frequency (Sky)", tooltips.get(FID_REP_FREQ));
        jTextField.setEditable(false);
        jTextField.setFocusable(true);
        this.antennaButtonGroup = this.addOTButtonGroup((JComponent)jPanel, gridBagLayout, gridBagConstraints, FID_ARRAY_TYPE, "Array Type", tooltips.get(FID_ARRAY_TYPE), Antenna.getLabels());
        jTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FID_FOV_SIZE, "Antenna Beamsize (HPBW)", tooltips.get(FID_FOV_SIZE));
        jTextField.setEditable(false);
        jTextField.setFocusable(true);
        this.addBooleanComponent(jPanel, gridBagLayout, gridBagConstraints, FID_SHOW_FOV, "Show Antenna Beamsize", tooltips.get(FID_SHOW_FOV));
        this.constraints.weightx = 1.0;
        this.addGroup(jPanel, "FOV Parameters");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_ARRAY_TYPE)) {
            Antenna antenna = (Antenna)((Object)object);
            super.update(fieldID, antenna.getLabel());
            return;
        }
        if (fieldID.equals(SfiControlParameterModel.FID_STANDALONE_ACA)) {
            boolean bl = (Boolean)object;
            String string = bl ? Antenna.ANTENNA_7M.getLabel() : Antenna.ANTENNA_12M.getLabel();
            super.update(FID_ARRAY_TYPE, string);
            this.getMyModel().update(this, FID_ARRAY_TYPE, string);
            this.antennaButtonGroup.setEnabled(!bl);
            this.antennaButtonGroup.find(Antenna.ANTENNA_12M.getLabel()).setVisible(!bl);
            if (bl) {
                this.antennaButtonGroup.find(Antenna.ANTENNA_7M.getLabel()).setVisible(true);
            }
            return;
        }
        if (fieldID.equals(FID_FOV_SIZE)) {
            Angle angle = (Angle)((Object)object);
            super.update(fieldID, Antenna.formatBeamSize(angle));
            return;
        }
        if (fieldID.equals(PointingPatternEditor.POINTING_TYPE_SELECTION)) {
            this.antennaButtonGroup.setSelectedItem((String)object);
            this.getMyModel().update(this, FID_ARRAY_TYPE, object);
        } else if (fieldID.equals(FID_IS_PHASE_ONE)) {
            boolean bl = (Boolean)object;
            this.antennaButtonGroup.setEnabled(bl);
        }
        super.update(fieldID, object);
    }

    public ModelChangeSubscriber getAcaEnabledSubscriber() {
        return this.acaEnabledSubscriber;
    }

    static {
        tooltips.put(FID_REP_FREQ, "<html>Taken from the spectral setup and used to calculate antenna beamsize</html>");
        tooltips.put(FID_FOV_SIZE, "<html>The size of the antenna beamsize : " + Antenna.BEAMSIZE_TIP_STRING + "</html>");
        tooltips.put(FID_ARRAY_TYPE, "Array Type");
        tooltips.put(FID_SHOW_FOV, "If checked, circles representing FOV are displayed on the image.");
    }
}

