/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.mapper;

import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.annotations.FieldPatternI;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.RectangleMosaic;
import alma.obsprep.ot.editors.spatialvisual.mapper.PatternFigure;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.RoiMapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.RoiMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.ShowPointingsException;
import alma.obsprep.ot.editors.spatialvisual.subform.FovParameterEditor;
import alma.obsprep.services.generator.refactored.targetcreator.TargetParametersFieldSourceWorker;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.data.AngleData;
import alma.valuetypes.data.SkyCoordinatesData;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Optional;
import jsky.image.gui.MainImageDisplay;
import lombok.NonNull;

public class OverlayPointingMapperModel
extends PointingMapperModel {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PointingPattern pointingPattern;
    private final RoiMapperModel roiMapperModel;

    public OverlayPointingMapperModel(BaseSpatialVisualModel baseSpatialVisualModel, RoiMapperModel roiMapperModel) {
        super(baseSpatialVisualModel);
        this.roiMapperModel = roiMapperModel;
        baseSpatialVisualModel.getSpatialVisualParametersModel().subscribe((model, fieldID, object) -> {
            if (fieldID == FovParameterEditor.FID_ARRAY_TYPE) {
                try {
                    this.configurePointingPattern();
                }
                catch (ShowPointingsException showPointingsException) {
                    // empty catch block
                }
            }
        });
    }

    public void configurePointingPattern() throws ShowPointingsException {
        Object object;
        Object object2;
        Object object3;
        Rectangle rectangle;
        try {
            rectangle = (Rectangle)this.roiMapperModel.getFieldPattern();
        }
        catch (ClassCastException classCastException) {
            throw new ShowPointingsException("This feature is not available for the selected field setup");
        }
        if (rectangle == null) {
            this.pointingPattern = null;
            return;
        }
        double d = rectangle.getSpacing().getContentInUnits(AngleData.UNIT_ARCSEC);
        if (d <= 0.0) {
            Log.logger((Object)this).warning("Spacing must be positive.");
            throw new ShowPointingsException("Spacing must be positive.");
        }
        double d2 = 0.0;
        Optional<Object> optional = Optional.empty();
        if (this.imageCoordinateSystem != null && rectangle.getTargetParameters() != null) {
            object3 = rectangle.getTargetParameters().getSourceCoordinates();
            object2 = null;
            if (SkyCoordinates.isEquatorial(object3.getSystem()) && this.imageCoordinateSystem.equals((Object)MainImageDisplay.CoordSystemType.GALACTIC)) {
                optional = Optional.of(TargetParametersFieldSourceWorker.SystemRotationConversion.ICRSToGalactic);
                object2 = RoiMapper.RotationCase.GalacticImageAndICRSSource;
            } else if (SkyCoordinates.isGalactic(object3.getSystem()) && this.imageCoordinateSystem.equals((Object)MainImageDisplay.CoordSystemType.EQUATORIAL)) {
                optional = Optional.of(TargetParametersFieldSourceWorker.SystemRotationConversion.GalacticToICRS);
                object2 = RoiMapper.RotationCase.ICRSImageAndGalacticSource;
            }
            if (optional.isPresent()) {
                assert (object2 != null);
                object = (TargetParametersFieldSourceWorker.SystemRotationConversion)((Object)optional.get());
                rectangle = this.convertRectangleCoordinateSystem((TargetParametersFieldSourceWorker.SystemRotationConversion)((Object)object), rectangle);
                SkyCoordinates skyCoordinates = rectangle.getFieldCenterCoordinates();
                SkyCoordinates skyCoordinates2 = skyCoordinates.getType().equals(SkyCoordinatesData.TYPE_RELATIVE) ? skyCoordinates.getAbsoluteCoordinates(rectangle.getOrigin()) : skyCoordinates;
                SkyCoordinates skyCoordinates3 = skyCoordinates2.getICRSSkyCoordinates();
                d2 = TargetParametersFieldSourceWorker.transformPABetweenCoordinateSystems(rectangle.getRotationAngle().getDegs() * -1.0, skyCoordinates3.getLongitude().getContentInDeg(), skyCoordinates3.getLatitude().getContentInDeg(), (TargetParametersFieldSourceWorker.SystemRotationConversion)((Object)object));
                Log.logger(OverlayPointingMapperModel.class).fine("coordinateSystemCompensatedRotationDegs: " + d2);
                double d3 = Math.toDegrees(RoiMapper.getROIRotationAngle(Math.toRadians(d2), (RoiMapper.RotationCase)((Object)object2), 0.0, this.isImageFlipped()));
                rectangle.setRotationAngle(AngleData.createAngle((double)d3, (String)AngleData.UNIT_DEG));
            }
        }
        Log.logger(OverlayPointingMapperModel.class).fine("Overlay rectangle rotation: " + rectangle.getRotationAngle());
        object3 = Antenna.ANTENNA_12M;
        object2 = this.getSpatialVisualModel().getSpatialVisualParametersModel().getSpatialVisualParameters();
        if (object2 != null) {
            object3 = object2.getAntenna();
        }
        object = new RectangleMosaic(rectangle, (Antenna)((Object)object3));
        this.pointingPattern = object.getPointingPattern(true);
        boolean bl = true;
        bl = this.pointingPattern.getIllegalNumberOfPointings().isPresent() ? false : AlmaPolicies.getInstance().getMaxNumberPointings() >= this.pointingPattern.getPhaseCenterCoordinatesCount();
        this.propertyChangeSupport.firePropertyChange("isPointingCountValid", !bl, bl);
    }

    private Rectangle convertRectangleCoordinateSystem(@NonNull TargetParametersFieldSourceWorker.SystemRotationConversion systemRotationConversion, @NonNull Rectangle rectangle) {
        if (systemRotationConversion == null) {
            throw new NullPointerException("coordinateSystemConversion is marked non-null but is null");
        }
        if (rectangle == null) {
            throw new NullPointerException("rectangleToCopy is marked non-null but is null");
        }
        if (systemRotationConversion.equals((Object)TargetParametersFieldSourceWorker.SystemRotationConversion.NoConversionRequired)) {
            return rectangle;
        }
        TargetParameters targetParameters = rectangle.getTargetParameters().deepCopy();
        targetParameters.clearField();
        Rectangle rectangle2 = rectangle.deepCopy();
        rectangle2.setCentre(rectangle.getCentre().deepCopy());
        rectangle2.referrers.get(Referring.By.UmlComposition).stream().forEach(iBusinessObject -> rectangle2.removedFrom((IBusinessObject)iBusinessObject, Referring.By.UmlComposition));
        targetParameters.addField((Field)((Object)rectangle2));
        SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates();
        SkyCoordinates skyCoordinates2 = rectangle2.getSourceCoordinates();
        switch (systemRotationConversion) {
            case GalacticToICRS: {
                skyCoordinates.convertToICRS();
                skyCoordinates2.convertToICRS();
                skyCoordinates.setSystem(SkyCoordinatesData.SYSTEM_ICRS);
                skyCoordinates2.setSystem(SkyCoordinatesData.SYSTEM_ICRS);
                break;
            }
            case ICRSToGalactic: {
                skyCoordinates.convertToGalactic();
                skyCoordinates2.convertToGalactic();
                skyCoordinates.setSystem(SkyCoordinatesData.SYSTEM_GALACTIC);
                skyCoordinates2.setSystem(SkyCoordinatesData.SYSTEM_GALACTIC);
                break;
            }
        }
        return rectangle2;
    }

    public static TargetParameters getPointingSourceInICRS(TargetParameters targetParameters) {
        if (targetParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: targetParameters");
        }
        TargetParameters targetParameters2 = targetParameters.deepCopy();
        SkyCoordinates skyCoordinates2 = targetParameters.getSourceCoordinates();
        if (skyCoordinates2.isGalactic()) {
            targetParameters2.setSourceCoordinates(skyCoordinates2.getICRSSkyCoordinates());
            PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter(targetParameters2.getSourceCoordinates());
            boolean bl = targetParameters.isOffsetPointingPattern();
            SkyCoordinates[] skyCoordinatesArray = (SkyCoordinates[])Arrays.asList(targetParameters2.getPointingPattern().getPhaseCenterCoordinates()).stream().map(skyCoordinates -> {
                if (bl) {
                    pointingCoordsConverter.matchSystemToOrigin((SkyCoordinates)skyCoordinates);
                } else {
                    skyCoordinates.convertToSystem(SkyCoordinatesData.SYSTEM_ICRS);
                }
                return skyCoordinates;
            }).toArray(SkyCoordinates[]::new);
            if (targetParameters2.getPointingPattern().isPointingPattern()) {
                targetParameters2.getPointingPattern().setPhaseCenterCoordinates(skyCoordinatesArray);
            }
        }
        return targetParameters2;
    }

    public void clearPointingPattern() {
        this.pointingPattern = null;
    }

    @Override
    public FieldPatternI getFieldPattern() {
        return this.pointingPattern;
    }

    @Override
    public boolean isFovFigureSelectionEnabled() {
        return false;
    }

    @Override
    protected void updateBO(PatternFigure patternFigure) {
    }

    @Override
    public void updateFormEditor() {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

