/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock.observingparameters;

import alma.obsprep.bo.schedblock.OpticalPointingParameters;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.observingparameters.ObservingParameterEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.observingparameters.OpticalPointingParameterModel;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class OpticalPointingParameterEditor
extends ObservingParameterEditor {
    public static final FieldID FID_NAME = new FieldID("OpticalPointing.name");
    public static final FieldID FID_RANDOMORDER = new FieldID("OpticalPointing.random");
    public static final FieldID FID_ELEVATIONLIMIT_VALUE = new FieldID("OpticalPointing.elevLimit.value");
    public static final FieldID FID_ELEVATIONLIMIT_UNIT = new FieldID("OpticalPointing.elevLimit.unit");
    public static final FieldID FID_ANNTENAPOSITIONTOLERANCE_VALUE = new FieldID("OpticalPointing.positionTolerance.value");
    public static final FieldID FID_ANNTENAPOSITIONTOLERANCE_UNIT = new FieldID("OpticalPointing.positionTolerance.unit");
    public static final FieldID FID_MINMAGNITUDE = new FieldID("OpticalPointing.minMagnitude");
    public static final FieldID FID_MAXMAGNITUDE = new FieldID("OpticalPointing.maxMagnitude");

    public OpticalPointingParameterEditor(Model model, boolean bl) {
        super(model, bl);
    }

    public OpticalPointingParameterEditor(Model model) {
        super(model);
    }

    @Override
    protected JPanel addGroup(JComponent jComponent, String string) {
        if (this.collapse) {
            return super.addGroup(jComponent, string);
        }
        return (JPanel)this.addNonCollapsingGroup(jComponent, string);
    }

    @Override
    protected void build() {
        super.build("Optical Pointing Parameters");
    }

    @Override
    protected void addComponents(String string) {
        this.panel = this.createNewGroup();
        this.gl = this.createNewLayout(this.panel);
        this.gc = this.createNewConstraints();
        OpticalPointingParameterModel opticalPointingParameterModel = (OpticalPointingParameterModel)this.getModel();
        this.addTextComponent(this.panel, this.gl, this.gc, FID_NAME, string + " Name", "Name of this " + string);
        this.addBooleanComponent(this.panel, this.gl, this.gc, FID_RANDOMORDER, "Randomize Observing Order", "<html>Select if the targets should be<br>observed in a random order</html>");
        this.addValueUnitPair((JComponent)this.panel, this.gl, this.gc, opticalPointingParameterModel.getElevationLimitModel(), "Elevation Limit", "Elevation Limit");
        this.addValueUnitPair((JComponent)this.panel, this.gl, this.gc, opticalPointingParameterModel.getAntennaPositionToleranceModel(), "Antenna Position Tolerance", "Antenna Position Tolerance");
        this.addLabeledComponent((JComponent)this.panel, this.gl, this.gc, "Faintest Magnitude", (JComponent)this.makeTextFieldWithDoubleVerifier(FID_MINMAGNITUDE, "Faintest (numerically highest) magnitude star to be used", -1.7976931348623157E308, Double.MAX_VALUE));
        this.addLabeledComponent((JComponent)this.panel, this.gl, this.gc, "Brightest magnitude", (JComponent)this.makeTextFieldWithDoubleVerifier(FID_MAXMAGNITUDE, "Brightest (numerically lowest) magnitude star to be used", -1.7976931348623157E308, Double.MAX_VALUE));
        this.addGroup(this.panel, string);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        OpticalPointingParameterModel opticalPointingParameterModel = new OpticalPointingParameterModel(null);
        OpticalPointingParameterEditor opticalPointingParameterEditor = new OpticalPointingParameterEditor(opticalPointingParameterModel);
        OpticalPointingParameters opticalPointingParameters = OpticalPointingParameters.createOpticalPointingParameters();
        opticalPointingParameterModel.setDocument((Object)opticalPointingParameters);
        EditorWithGridBagLayout.runTestApp(opticalPointingParameterEditor);
    }
}

