/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.annotations.ACASpectralWindowI;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.SpectralAverage;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BLSpectralWindow;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.bo.schedblock.data.ACASpectralWindowData;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.verifiers.IntegerVerifier;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.ChannelAverageRegionEditor;
import alma.obsprep.ot.editors.schedblock.SpectralWindowComboBoxPair;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.models.schedblock.SpectralWindowModel;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SpectralWindowEditor
extends EditorWithGridBagLayout {
    private static final long serialVersionUID = 2360824524471312379L;
    public static final FieldID DOCUMENTLABEL_FID = new FieldID("SpectralWindowEditor.documentLabel");
    public static final FieldID CENTERFREQ_VALUE_FID = new FieldID("SpectralWindowEditor.centerFreqValue");
    public static final FieldID CENTERFREQ_UNIT_FID = new FieldID("SpectralWindowEditor.centerFreqUnit");
    public static final FieldID DESIREDCENTERFREQ_VALUE_FID = new FieldID("SpectralWindowEditor.desiredCenterFreqValue");
    public static final FieldID DESIREDCENTERFREQ_UNIT_FID = new FieldID("SpectralWindowEditor.desiredCenterFreqUnit");
    public static final FieldID OMEGA_IF2_FID = new FieldID("SpectralWindowEditor.omegaIF2");
    public static final FieldID LSB_FREQREST_FID = new FieldID("SpectralWindowEditor.LSBFrequencyRest");
    public static final FieldID USB_FREQREST_FID = new FieldID("SpectralWindowEditor.USBFrequencyRest");
    public static final FieldID LSB_FREQSKY_FID = new FieldID("SpectralWindowEditor.LSBFrequencySky");
    public static final FieldID USB_FREQSKY_FID = new FieldID("SpectralWindowEditor.USBFrequencySky");
    public static final FieldID USE_LSB_FID = new FieldID("SpectralWindowEditor.UseLSB");
    public static final FieldID USE_USB_FID = new FieldID("SpectralWindowEditor.UseUSB");
    public static final FieldID CF_ADJUST_BUTTON_FID = new FieldID("SpectralWindowEditor.centerFreqAdjustButton");
    public static final FieldID AVGFACTOR_FID = new FieldID("SpectralWindowEditor.averagingFactor");
    public static final FieldID AVGFACTOR_LSB_FID = new FieldID("SpectralWindowEditor.averagingFactor1");
    public static final FieldID AVGFACTOR_USB_FID = new FieldID("SpectralWindowEditor.averagingFactor2");
    public static final FieldID AVGFACTOR_BL_FID = new FieldID("SpectralWindowEditor.averagingFactorBL");
    public static final FieldID AVGFACTOR_BL_LSB_FID = new FieldID("SpectralWindowEditor.averagingFactorBL1");
    public static final FieldID AVGFACTOR_BL_USB_FID = new FieldID("SpectralWindowEditor.averagingFactorBL2");
    public static final FieldID NAME_FID = new FieldID("SpectralWindowEditor.name");
    public static final FieldID NOM_BANDWIDTH_FID = new FieldID("SpectralWindowEditor.nominalBandwidth");
    public static final FieldID EFF_BANDWIDTH_FID = new FieldID("SpectralWindowEditor.effectiveBandwidth");
    public static final FieldID NOM_CHANNELS_FID = new FieldID("SpectralWindowEditor.nominalNumberOfChannels");
    public static final FieldID EFF_CHANNELS_FID = new FieldID("SpectralWindowEditor.effectiveNumberOfChannels");
    public static final FieldID ACA_EFF_BW_FID = new FieldID("SpectralWindowEditor.ACASpecificEffectiveBandwidthTextField");
    public static final FieldID ACA_EFF_BW_FORM_FID = new FieldID("SpectralWindowEditor.ACASpecificEffectiveBandwidthForm");
    public static final FieldID ACA_EFF_CHANNELS_FID = new FieldID("SpectralWindowEditor.ACASpecificEffectiveNumberOfChannelsValue");
    public static final FieldID RESOLUTION_FID = new FieldID("SpectralWindowEditor.resolution");
    public static final FieldID EFF_RESOLUTION_FID = new FieldID("SpectralWindowEditor.effectiveResolution");
    public static final FieldID EFF_RESOLUTION_ERR = new FieldID("SpectralWindowEditor.effectiveResolutionError");
    public static final FieldID CONFIGMODE_FID = new FieldID("SpectralWindowEditor.correlatorConfigMode");
    public static final FieldID FILTERMODE_FID = new FieldID("SpectralWindowEditor.filterMode");
    public static final FieldID POLNPRODUCTS_FID = new FieldID("SpectralWindowEditor.polnProducts");
    public static final FieldID WINDOWFUNCTION_FID = new FieldID("SpectralWindowEditor.windowFunction");
    public static final FieldID CORRELATIONBITS_FID = new FieldID("SpectralWindowEditor.correlationBits");
    public static final FieldID OVERSAMPLING_FID = new FieldID("SpectralWindowEditor.ovsersampling");
    public static final FieldID QUANTCORRECTION_FID = new FieldID("SpectralWindowEditor.quantCorrection");
    public static final FieldID FRQCHPROFREPROD_FID = new FieldID("SpectralWindowEditor.frqChProfReprod");
    public static final FieldID SYNTHPROF_FID = new FieldID("SpectralWindowEditor.synthProfile");
    public static final FieldID ACAPANEL_FID = new FieldID("SpectralWindowEditor.ACAPanel");
    public static final FieldID BLPANEL_FID = new FieldID("SpectralWindowEditor.BLPanel");
    private JLabel nominalBandwidthLabel;
    private JLabel effectiveBandwidthLabel_editable;
    private JLabel effectiveBandwidthLabel_nonEditable;
    private JLabel resolutionSmoothingWarning;
    private JTextField resolutionTextField;
    private AveragingFactorComponents avgFactors;
    private final Set<Component> acaComponents = new HashSet<Component>();
    private final Set<Component> blComponents = new HashSet<Component>();
    protected ChannelAverageRegionEditor carEditor;
    protected Box desiredCenterFreqBox;
    protected JLabel desiredCenterFreqLabel;
    private boolean allowsAcaSpecificMode = false;
    private static final String polnProdTooltipACA = "<html>Polarization Mode must be uniq in a BaseBandConfig for ACA Correlator.<br>Set the mode in the \"ACA Specific Settings\" part of the BaseBandConfigEditor above.</html>";
    private static final String polnProdTooltipBL = "Stokes Parameters";

    public SpectralWindowEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    protected SpectralWindowEditor() {
    }

    @Override
    public boolean wantGlobalButtons() {
        return false;
    }

    protected void setAllowsAcaSpecificMode(boolean bl) {
        this.allowsAcaSpecificMode = bl;
        this.updateChannelType();
    }

    @Override
    protected void build() {
        super.build("SpectralWindow");
    }

    @Override
    protected void addComponents(String string) {
        this.constraints.weightx = 1.0;
        this.textFieldWidth = 10;
        JPanel jPanel = null;
        JPanel jPanel2 = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel2);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        int n = gridBagConstraints.insets.right;
        JTextField jTextField = this.addTextComponent(jPanel2, gridBagLayout, gridBagConstraints, NAME_FID, "SpectralWindow Name", "The name of this SpectralWindow ( not editable )");
        jTextField.setEditable(false);
        Box box = Box.createHorizontalBox();
        ValueUnitPairEditor valueUnitPairEditor = this.makeValueUnitPairEditor(this.getMyModel().getCenterFreqModel(), "Offset of the center frequency");
        valueUnitPairEditor.getInput().setColumns(19);
        box.add(valueUnitPairEditor);
        box.add(this.makeButton(CF_ADJUST_BUTTON_FID, "Adjust", "Adjust the center frequency to a spectral window channel"));
        this.addLabeledComponent((JComponent)jPanel2, gridBagLayout, gridBagConstraints, "Center Offset Frequency", (JComponent)box);
        this.desiredCenterFreqBox = Box.createHorizontalBox();
        valueUnitPairEditor = this.makeValueUnitPairEditor(this.getMyModel().getDesiredCenterFreqModel(), "<html>Offset of the center frequency without correcting for actual LO2 value</html>");
        valueUnitPairEditor.getInput().setColumns(19);
        this.desiredCenterFreqBox.add(valueUnitPairEditor);
        this.desiredCenterFreqLabel = new JLabel("<html><em>Uncorrected</em> Center Offset Frequency</html>");
        this.addLabeledComponent((JComponent)jPanel2, gridBagLayout, gridBagConstraints, this.desiredCenterFreqLabel, (JComponent)this.desiredCenterFreqBox);
        jTextField = this.addTextComponent(jPanel2, gridBagLayout, gridBagConstraints, OMEGA_IF2_FID, "Equivalent Omega IF2", "Value of Omega IF2 equivalent to center frequencyResolution");
        jTextField.setEditable(false);
        jTextField.setFocusable(true);
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Center Freq(Rest) LSB/USB"));
        JComponent[] jComponentArray = new JComponent[1];
        jTextField = this.makeTextField(LSB_FREQREST_FID, false, "LSB frequency(Rest)");
        jComponentArray[0] = jTextField;
        componentCollection.remember(jComponentArray);
        jTextField.setFocusable(true);
        jTextField.setColumns(19);
        JComponent[] jComponentArray2 = new JComponent[1];
        jTextField = this.makeTextField(USB_FREQREST_FID, false, "USB frequency(Rest)");
        jComponentArray2[0] = jTextField;
        componentCollection.remember(jComponentArray2);
        jTextField.setFocusable(true);
        jTextField.setColumns(19);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Center Freq(Sky) LSB/USB"));
        JComponent[] jComponentArray3 = new JComponent[1];
        jTextField = this.makeTextField(LSB_FREQSKY_FID, false, "LSB frequency(Sky)");
        jComponentArray3[0] = jTextField;
        componentCollection.remember(jComponentArray3);
        jTextField.setFocusable(true);
        jTextField.setColumns(19);
        JComponent[] jComponentArray4 = new JComponent[1];
        jTextField = this.makeTextField(USB_FREQSKY_FID, false, "USB frequency(Sky)");
        jComponentArray4[0] = jTextField;
        componentCollection.remember(jComponentArray4);
        jTextField.setFocusable(true);
        jTextField.setColumns(19);
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel(""));
        componentCollection.remember(this.makeCheckBox(USE_LSB_FID, "Use LSB", "Check when using the lower sideband"));
        componentCollection.remember(this.makeCheckBox(USE_USB_FID, "Use USB", "Check when using the upper sideband"));
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        JComboBox jComboBox = this.makeComboBox(NOM_BANDWIDTH_FID, oTConfigModeDecoder.getKnownNominalBandwidthLabels(), "The nominal bandwidth");
        JComboBox jComboBox2 = this.makeComboBox(NOM_CHANNELS_FID, oTConfigModeDecoder.getKnownNominalChannelLabels(), "The number of channels");
        new SpectralWindowComboBoxPair(this, jComboBox, jComboBox2){

            @Override
            public SpectralWindowI getSpectralWindow() {
                return SpectralWindowEditor.this.getMyModel().getSpectralWindow();
            }
        };
        componentCollection = new ComponentCollection();
        JComponent[] jComponentArray5 = new JComponent[1];
        this.nominalBandwidthLabel = this.makeLabel("Nominal BW / # Channels");
        jComponentArray5[0] = this.nominalBandwidthLabel;
        componentCollection.remember(jComponentArray5);
        componentCollection.remember(jComboBox);
        componentCollection.remember(jComboBox2);
        n = gridBagConstraints.insets.right;
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints, 3);
        JTextField jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        JTextField jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        componentCollection = new ComponentCollection();
        JComponent[] jComponentArray6 = new JComponent[1];
        this.effectiveBandwidthLabel_nonEditable = this.makeLabel("Effective BW / # Channels");
        jComponentArray6[0] = this.effectiveBandwidthLabel_nonEditable;
        componentCollection.remember(jComponentArray6);
        JTextField jTextField4 = this.makeTextField(EFF_BANDWIDTH_FID, false, "The effective bandwidth ( not editable )");
        jTextField4.setFocusable(true);
        componentCollection.remember(jTextField4);
        jTextField3 = this.makeTextField(EFF_CHANNELS_FID, false, "The effective number of channels ( not editable )");
        jTextField3.setFocusable(true);
        componentCollection.remember(jTextField3);
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints, 3);
        gridBagConstraints.insets.right = n;
        this.effectiveBandwidthLabel_editable = this.makeLabel("Effective BW / # Channels");
        jTextField4 = this.makeTextFieldWithDoubleVerifier(ACA_EFF_BW_FID, "Effective Bandwidth in MHz", 0.0, 2000.0);
        jTextField4.setFocusable(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jTextField4);
        jPanel3.add(this.makeLabel("MHz"));
        this.register(jPanel3, ACA_EFF_BW_FORM_FID);
        jTextField3 = this.makeTextField(ACA_EFF_CHANNELS_FID, "The effective number of channels");
        jTextField3.setFocusable(true);
        this.setVerifier(jTextField3, "FOCUSLOST_VERIFIER", new IntegerVerifier(this, jTextField3, 0, 8192));
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.effectiveBandwidthLabel_editable);
        componentCollection.remember(jPanel3);
        componentCollection.remember(jTextField3);
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints, 3);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Channel spacing"));
        JTextField jTextField5 = this.makeTextField(RESOLUTION_FID, false, "Spectral Channel spacing (not editable)");
        jTextField5.setFocusable(true);
        componentCollection.remember(jTextField5);
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints, 3);
        this.addComboBox((JComponent)jPanel2, gridBagLayout, gridBagConstraints, POLNPRODUCTS_FID, "Polarization Products", "", AbstractSpectralWindow.getKnownPolnProductsList());
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints, 3);
        componentCollection = new ComponentCollection();
        JLabel jLabel = new JLabel("CorrConfigMode/FilterMode");
        componentCollection.remember(jLabel);
        this.blComponents.add(jLabel);
        jTextField = this.makeTextField(CONFIGMODE_FID, false, "Correlator configuration mode number ( not editable )");
        componentCollection.remember(jTextField);
        this.blComponents.add(jTextField);
        jTextField = this.makeTextField(FILTERMODE_FID, false, "Filter Mode ( not editable )");
        componentCollection.remember(jTextField);
        this.blComponents.add(jTextField);
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints, 3);
        this.addComboBox((JComponent)jPanel2, gridBagLayout, gridBagConstraints, WINDOWFUNCTION_FID, "Window Smoothing Function", "The data smoothing function to use", AbstractSpectralWindow.getKnownWindowFunctionList());
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints, 3);
        this.avgFactors = new AveragingFactorComponents();
        this.avgFactors.layout(jPanel2, gridBagLayout, gridBagConstraints);
        this.avgFactors.switchPanel(false);
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints, 3);
        JPanel jPanel4 = this.createNewGroup();
        GridBagLayout gridBagLayout2 = this.createNewLayout(jPanel4);
        GridBagConstraints gridBagConstraints2 = this.createNewConstraints();
        gridBagConstraints2.weightx = 1.0;
        this.carEditor = new ChannelAverageRegionEditor(this.getMyModel().getChannelAverageRegionModel());
        this.addComponent(jPanel4, gridBagLayout2, gridBagConstraints2, this.carEditor);
        jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout3 = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints3 = this.createNewConstraints();
        gridBagConstraints3.weightx = 1.0;
        gridBagLayout3.setConstraints(jPanel2, gridBagConstraints3);
        jPanel.add(jPanel2);
        ++gridBagConstraints3.gridx;
        jPanel.add(Box.createHorizontalStrut(20));
        ++gridBagConstraints3.gridx;
        gridBagConstraints3.weightx = 0.5;
        gridBagLayout3.setConstraints(jPanel4, gridBagConstraints3);
        jPanel.add(jPanel4);
        this.addComponent(this, this.layout, this.constraints, jPanel);
        this.addVerticalSpace(jPanel2, gridBagLayout, gridBagConstraints, 3);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Resolution"));
        this.resolutionTextField = this.makeTextField(EFF_RESOLUTION_FID, false, "Effective Resolution ( not editable )");
        this.resolutionTextField.setFocusable(true);
        componentCollection.remember(this.resolutionTextField);
        this.resolutionSmoothingWarning = this.makeLabel("Averaging factor not a power of two");
        this.resolutionSmoothingWarning.setForeground(Color.red);
        componentCollection.remember(this.resolutionSmoothingWarning);
        this.addComponentArray(jPanel2, gridBagLayout, gridBagConstraints, componentCollection);
        jPanel = this.createNewGroup();
        gridBagLayout3 = this.createNewLayout(jPanel);
        gridBagConstraints3 = this.createNewConstraints();
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Correlation Bits"));
        componentCollection.remember(this.makeComboBox(CORRELATIONBITS_FID, BLSpectralWindow.getKnownCorrelationBitsList(), "Correlation Bits"));
        JComponent[] jComponentArray7 = new JComponent[1];
        JCheckBox jCheckBox = this.makeCheckBox(OVERSAMPLING_FID, "Oversampling", "Check if Nyquist oversampling mode is used");
        jComponentArray7[0] = jCheckBox;
        componentCollection.remember(jComponentArray7);
        jCheckBox.setHorizontalTextPosition(2);
        JComponent[] jComponentArray8 = new JComponent[1];
        jCheckBox = this.makeCheckBox(QUANTCORRECTION_FID, "Quantization Correction", "Check if quantization correction is used");
        jComponentArray8[0] = jCheckBox;
        componentCollection.remember(jComponentArray8);
        jCheckBox.setHorizontalTextPosition(2);
        this.addComponentArray(jPanel, gridBagLayout3, gridBagConstraints3, componentCollection);
        JPanel jPanel5 = this.addGroup(jPanel, "64-antenna correlator only");
        this.register(jPanel5, BLPANEL_FID);
        jPanel5.setVisible(false);
        this.blComponents.add(jPanel5);
        jPanel = this.createNewGroup();
        gridBagLayout3 = this.createNewLayout(jPanel);
        gridBagConstraints3 = this.createNewConstraints();
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Synth. Profile"));
        componentCollection.remember(this.makeComboBox(SYNTHPROF_FID, ACASpectralWindowData.getKnownSynthProfList(), "Method of performing Frequency Profile Synthesis"));
        this.addComponentArray(jPanel, gridBagLayout3, gridBagConstraints3, componentCollection);
        JPanel jPanel6 = this.addGroup(jPanel, "ACA correlator only");
        this.register(jPanel6, ACAPANEL_FID);
        jPanel6.setVisible(false);
        this.acaComponents.add(jPanel6);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(DOCUMENTLABEL_FID) && object != null) {
            this.updateCorrelatorDependingComponent();
            this.updateSideband();
            this.avgFactors.switchPanel(this.getMyModel().getSpectralWindow().isPair());
            this.avgFactors.switchWidget(this.getMyModel().getSpectralWindow().getSingleSpectralWindow().isACA());
            if (this.desiredCenterFreqBox != null) {
                if (this.getMyModel().getDesiredCenterFreqModel().getDocument() != null) {
                    this.desiredCenterFreqBox.setVisible(true);
                    this.desiredCenterFreqLabel.setVisible(true);
                } else {
                    this.desiredCenterFreqBox.setVisible(false);
                    this.desiredCenterFreqLabel.setVisible(false);
                }
            }
        }
        if (fieldID.equals(CF_ADJUST_BUTTON_FID)) {
            return;
        }
        if (fieldID.equals(LSB_FREQREST_FID) || fieldID.equals(USB_FREQREST_FID) || fieldID.equals(LSB_FREQSKY_FID) || fieldID.equals(USB_FREQSKY_FID)) {
            Frequency frequency = (Frequency)((Object)object);
            super.update(fieldID, frequency == null ? "---" : TextUtils.format(frequency, 15));
            return;
        }
        if (fieldID.equals(OMEGA_IF2_FID)) {
            Frequency frequency = (Frequency)((Object)object);
            super.update(fieldID, frequency == null ? "---" : TextUtils.format(frequency, 15));
            return;
        }
        if (fieldID.equals(USE_LSB_FID) || fieldID.equals(USE_USB_FID)) {
            if (object == null) {
                return;
            }
            JCheckBox jCheckBox = (JCheckBox)this.getComponent(fieldID);
            this.suspendEvents(jCheckBox);
            super.update(fieldID, object);
            this.resumeEvents(jCheckBox);
            this.updateCarEditor();
            return;
        }
        if (fieldID.equals(CONFIGMODE_FID)) {
            Integer n;
            try {
                n = (Integer)object;
            }
            catch (ClassCastException classCastException) {
                return;
            }
            JTextField jTextField = (JTextField)this.getComponent(fieldID);
            if (n == -1) {
                super.update(fieldID, "Invalid Mode");
                jTextField.setForeground(Color.red);
            } else {
                super.update(fieldID, object);
                jTextField.setForeground(Color.black);
            }
            return;
        }
        if (fieldID.equals(NOM_CHANNELS_FID)) {
            int n = (Integer)object;
            OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
            int n2 = oTConfigModeDecoder.getNominalChannelLabelIndex(n);
            JComboBox jComboBox = (JComboBox)this.getComponent(fieldID);
            String string = (String)jComboBox.getItemAt(n2);
            super.update(fieldID, string);
            return;
        }
        if (fieldID.equals(NOM_BANDWIDTH_FID)) {
            Frequency frequency;
            try {
                frequency = (Frequency)((Object)object);
            }
            catch (ClassCastException classCastException) {
                return;
            }
            OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
            int n = oTConfigModeDecoder.getNominalBandwidthLabelIndex(frequency);
            JComboBox jComboBox = (JComboBox)this.getComponent(fieldID);
            String string = (String)jComboBox.getItemAt(n);
            super.update(fieldID, string);
            return;
        }
        if (fieldID.equals(EFF_BANDWIDTH_FID)) {
            Frequency frequency;
            if (object == null) {
                return;
            }
            try {
                frequency = (Frequency)((Object)object);
            }
            catch (ClassCastException classCastException) {
                return;
            }
            super.update(fieldID, frequency.getContentInMHz() + " MHz");
            return;
        }
        if (fieldID.equals(RESOLUTION_FID) || fieldID.equals(EFF_RESOLUTION_FID)) {
            Frequency frequency;
            if (object == null) {
                return;
            }
            try {
                frequency = ((Frequency)((Object)object)).deepCopy().convertToFriendlyUnit();
            }
            catch (ClassCastException classCastException) {
                return;
            }
            super.update(fieldID, TextUtils.format(frequency, 12));
            return;
        }
        if (fieldID.equals(EFF_RESOLUTION_ERR)) {
            String string = (String)object;
            if (null == string) {
                this.resolutionSmoothingWarning.setVisible(false);
                this.resolutionTextField.setVisible(true);
            } else {
                this.resolutionSmoothingWarning.setVisible(true);
                this.resolutionSmoothingWarning.setText(string);
                this.resolutionTextField.setVisible(false);
            }
            return;
        }
        if (fieldID.equals(FILTERMODE_FID)) {
            String string = (String)object;
            if (object == null) {
                string = "";
            }
            this.updateCarEditor();
            super.update(fieldID, string);
        }
        super.update(fieldID, object);
    }

    private boolean isAca() {
        SpectralWindowI spectralWindowI = this.getMyModel().getSpectralWindow();
        if (spectralWindowI == null) {
            return false;
        }
        AbstractSpectralWindow abstractSpectralWindow = spectralWindowI.getSingleSpectralWindow();
        if (abstractSpectralWindow == null) {
            return false;
        }
        return spectralWindowI instanceof ACASpectralWindowI;
    }

    private void updateCorrelatorDependingComponent() {
        boolean bl = this.isAca();
        for (Component component : this.blComponents) {
            component.setVisible(!bl);
        }
        for (Component component : this.acaComponents) {
            component.setVisible(bl);
        }
        JComboBox jComboBox = (JComboBox)this.getComponent(POLNPRODUCTS_FID);
        jComboBox.setEnabled(!bl);
        jComboBox.setToolTipText(bl ? polnProdTooltipACA : polnProdTooltipBL);
        this.updateChannelType();
    }

    private void updateChannelType() {
        boolean bl = this.isAca() && this.isAllowsAcaSpecificMode();
        this.nominalBandwidthLabel.setVisible(!bl);
        this.getComponent(NOM_BANDWIDTH_FID).setVisible(!bl);
        this.getComponent(NOM_CHANNELS_FID).setVisible(!bl);
        this.effectiveBandwidthLabel_nonEditable.setVisible(!bl);
        this.getComponent(EFF_BANDWIDTH_FID).setVisible(!bl);
        this.getComponent(EFF_CHANNELS_FID).setVisible(!bl);
        this.effectiveBandwidthLabel_editable.setVisible(bl);
        this.getComponent(ACA_EFF_BW_FORM_FID).setVisible(bl);
        this.getComponent(ACA_EFF_CHANNELS_FID).setVisible(bl);
    }

    private void updateCarEditor() {
        this.carEditor.refresh();
    }

    private void updateSideband() {
        boolean bl = this.getMyModel().getSpectralWindow().isPair();
        ((JCheckBox)this.getComponent(USE_LSB_FID)).setEnabled(bl);
        ((JCheckBox)this.getComponent(USE_USB_FID)).setEnabled(bl);
    }

    private SpectralWindowModel getMyModel() {
        return (SpectralWindowModel)this.getModel();
    }

    protected boolean isAllowsAcaSpecificMode() {
        return this.allowsAcaSpecificMode;
    }

    private class AveragingFactorComponents {
        private final JLabel labelSingle;
        private final JComponent compSingle;
        private final JLabel labelPair;
        private final JComponent compPair;

        AveragingFactorComponents() {
            this.labelSingle = SpectralWindowEditor.this.makeLabel("Averaging Factor");
            this.labelPair = SpectralWindowEditor.this.makeLabel("Averaging Factor");
            this.compSingle = Box.createHorizontalBox();
            this.compSingle.add(SpectralWindowEditor.this.makeTextField(AVGFACTOR_FID, "The spectral averaging factor"));
            this.compSingle.add(SpectralWindowEditor.this.makeComboBox(AVGFACTOR_BL_FID, SpectralAverage.getLabels(), "The spectral averaging factor"));
            this.compPair = Box.createHorizontalBox();
            this.compPair.add(SpectralWindowEditor.this.makeLabel("LSB"));
            this.compPair.add(SpectralWindowEditor.this.makeTextField(AVGFACTOR_LSB_FID, 5, true, "The spectral averaging factor for the spectral window in LSB"));
            this.compPair.add(SpectralWindowEditor.this.makeComboBox(AVGFACTOR_BL_LSB_FID, SpectralAverage.getLabels(), "The spectral averaging factor for the spectral window in LSB"));
            this.compPair.add(SpectralWindowEditor.this.makeLabel("USB"));
            this.compPair.add(SpectralWindowEditor.this.makeTextField(AVGFACTOR_USB_FID, 5, true, "The spectral averaging factor for the spectral window in USB"));
            this.compPair.add(SpectralWindowEditor.this.makeComboBox(AVGFACTOR_BL_USB_FID, SpectralAverage.getLabels(), "The spectral averaging factor for the spectral window in USB"));
        }

        void layout(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
            SpectralWindowEditor.this.addLabeledComponent(jPanel, gridBagLayout, gridBagConstraints, this.labelSingle, this.compSingle);
            SpectralWindowEditor.this.addLabeledComponent(jPanel, gridBagLayout, gridBagConstraints, this.labelPair, this.compPair);
        }

        void switchPanel(boolean bl) {
            this.labelSingle.setVisible(!bl);
            this.compSingle.setVisible(!bl);
            this.labelPair.setVisible(bl);
            this.compPair.setVisible(bl);
        }

        void switchWidget(boolean bl) {
            FieldID[] fieldIDArray = new FieldID[]{AVGFACTOR_FID, AVGFACTOR_LSB_FID, AVGFACTOR_USB_FID};
            FieldID[] fieldIDArray2 = new FieldID[]{AVGFACTOR_BL_FID, AVGFACTOR_BL_LSB_FID, AVGFACTOR_BL_USB_FID};
            for (FieldID fieldID : fieldIDArray) {
                SpectralWindowEditor.this.getComponent(fieldID).setVisible(bl);
            }
            for (FieldID fieldID : fieldIDArray2) {
                SpectralWindowEditor.this.getComponent(fieldID).setVisible(!bl);
            }
        }
    }
}

