/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BLBaseBandConfig;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTComboBox;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FrequencyVerifier;
import alma.obsprep.ot.editors.schedblock.NumberOfSwitchingPositionCombo;
import alma.obsprep.ot.editors.schedblock.SpectralWindowEditor;
import alma.obsprep.ot.editors.schedblock.SpectralWindowTabbedEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.models.misc.TabbedEditorModel;
import alma.obsprep.ot.models.schedblock.BaseBandConfigModel;
import alma.obsprep.ot.models.schedblock.SpectralWindowTabbedModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BaseBandConfigEditor
extends EditorWithGridBagLayout {
    public static final FieldID DOCUMENTLABEL_FID = new FieldID("BaseBandConfigEditor.documentLabel");
    public static final FieldID PRODUCTS_FID = new FieldID("BaseBandConfigEditor.Products");
    public static final FieldID FRQSWITCHING_FID = new FieldID("BaseBandConfig.FrequencySwitching");
    public static final FieldID NUMPOS_FID = new FieldID("BaseBandConfigEditor.NumberOfSwitchingPosition");
    public static final FieldID DWELLTIME_VUP_FID = new FieldID("BaseBandConfig.DwellTimeVUP");
    public static final FieldID BASEBANDNAME_TF_FID = new FieldID("BaseBandConfigEditor.basebandName");
    public static final FieldID BASEBANDNAME_CB_FID = new FieldID("BaseBandConfigEditor.basebandNameComboBox");
    public static final FieldID BBNAMEEDIT_BTN_FID = new FieldID("BaseBandConfigEditor.basebandNameEditButton");
    public static final FieldID DESIREDCNTRFRQREST_VUP_FID = new FieldID("BaseBandConfigEditor.desiredCenterFrequencyRestVup");
    public static final FieldID DESIREDIMGFRQREST_VUP_FID = new FieldID("BaseBandConfigEditor.desiredImageFrequencyRestVup");
    public static final FieldID ACTUALCNTRFREQREST_FID = new FieldID("BaseBandConfigEditor.actualCenterFrequencyRest");
    public static final FieldID ACTUALCNTRFREQSKY_FID = new FieldID("BaseBandConfigEditor.actualCenterFrequencySky");
    public static final FieldID USE_USB_FID = new FieldID("BaseBandConfigEditor.useUSB");
    public static final FieldID USE_12GFILTER_FID = new FieldID("BaseBandConfigEditor.use12GHzFilter");
    public static final FieldID SS_FRQSWITCHING_FID = new FieldID("BaseBandConfigEditor.ssFrqSwitching");
    public static final FieldID ACAPANEL_FID = new FieldID("BaseBandConfigEditor.ACAPanel");
    public static final FieldID POLNMODE_FID = new FieldID("BaseBandConfigEditor.polarizationMode");
    public static final FieldID SWPANEL_FID = new FieldID("BaseBandConfigEditor.SpectralWindowPanel");
    public static final FieldID SWITCHINGEDITOR_FID = new FieldID("BaseBandConfigEditor.SwitchingEditor");
    private final Set<Component> squareLawComponents = new HashSet<Component>();
    private final Set<Component> correlatorComponents = new HashSet<Component>();
    private final Set<Component> acaComponents = new HashSet<Component>();
    private final Set<Component> blComponents = new HashSet<Component>();
    private JComboBox productsCombo = null;
    private JCheckBox useUSBButton = null;
    private JCheckBox use12GHzFilterButton = null;
    protected SpectralWindowTabbedEditor swTabEditor = null;

    public BaseBandConfigEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public BaseBandConfigModel getModel() {
        return (BaseBandConfigModel)super.getModel();
    }

    @Override
    public boolean wantGlobalButtons() {
        return false;
    }

    @Override
    protected void build() {
        super.build("BaseBandConfig");
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = null;
        jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        ComponentCollection componentCollection = new ComponentCollection();
        JLabel jLabel = this.makeLabel("Baseband Name");
        JTextField jTextField = this.makeTextField(BASEBANDNAME_TF_FID, 5, false, "Baseband Name ( not editable )");
        OTComboBox oTComboBox = new OTComboBox(BaseBandSpecification.getKnownBaseBandNameList());
        this.initEvents(oTComboBox, BASEBANDNAME_CB_FID);
        oTComboBox.setToolTipText("Select Baseband name to set");
        JButton jButton = this.makeButton(BBNAMEEDIT_BTN_FID, "Set another name", "Press if you select another Baseband name");
        ActionListener actionListener = actionEvent -> {
            jTextField.setVisible(!jTextField.isVisible());
            oTComboBox.setVisible(!oTComboBox.isVisible());
            jButton.setVisible(!oTComboBox.isVisible());
        };
        jButton.addActionListener(actionListener);
        oTComboBox.setVisible(false);
        componentCollection.remember(jLabel);
        componentCollection.remember(jTextField);
        componentCollection.remember(oTComboBox);
        componentCollection.remember(jButton);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        ValueUnitPairEditor valueUnitPairEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getDesiredCenterFreqRestModel(), "Desired Center Freq", "Desired Center Frequency of this BaseBand in the selected doppler reference frame");
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new FrequencyVerifier(valueUnitPairEditor, 0.0, Double.POSITIVE_INFINITY));
        this.register(valueUnitPairEditor, DESIREDCNTRFRQREST_VUP_FID);
        valueUnitPairEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getDesiredImageFreqRestModel(), "Desired Image Freq (Optional)", "Desired Center Frequency of the image BaseBand in the selected doppler reference frame");
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new FrequencyVerifier(valueUnitPairEditor, 0.0, 1000.0));
        this.register(valueUnitPairEditor, DESIREDIMGFRQREST_VUP_FID);
        JTextField jTextField2 = this.makeTextField(ACTUALCNTRFREQREST_FID, false, "Actual Center Frequency of this BaseBand calculated using the LO frequencies");
        jTextField2.setFocusable(true);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Actual Center Freq", (JComponent)jTextField2);
        jTextField2 = this.makeTextField(ACTUALCNTRFREQSKY_FID, false, "Actual Center Frequency on the Sky of this BaseBand calculated using the LO frequencies");
        jTextField2.setFocusable(true);
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Actual Center Freq(Sky)", (JComponent)jTextField2);
        this.productsCombo = this.makeComboBox(PRODUCTS_FID, AbstractBaseBandConfig.getKnownDataProductsList(), "Select one of the data products");
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Products", (JComponent)this.productsCombo);
        ComponentCollection componentCollection2 = new ComponentCollection();
        this.use12GHzFilterButton = this.makeCheckBox(USE_12GFILTER_FID, "Use 12 GHz filter", "Use 12 GHz filter option");
        componentCollection2.remember(this.use12GHzFilterButton);
        this.useUSBButton = this.makeCheckBox(USE_USB_FID, "Use USB", "Use USB option");
        componentCollection2.remember(this.useUSBButton);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection2);
        BaseBandSwitchingSetupEditor baseBandSwitchingSetupEditor = new BaseBandSwitchingSetupEditor(this.getModel());
        baseBandSwitchingSetupEditor.setBorder(BorderFactory.createTitledBorder("LO2 Switching (Not Currently Implemented)"));
        baseBandSwitchingSetupEditor.setEnabled(false);
        this.register(baseBandSwitchingSetupEditor, SWITCHINGEDITOR_FID);
        componentCollection2 = new ComponentCollection();
        componentCollection2.remember(jPanel);
        componentCollection2.remember(baseBandSwitchingSetupEditor);
        this.addComponentArray(componentCollection2);
        jPanel = this.createNewGroup();
        gridBagLayout = this.createNewLayout(jPanel);
        gridBagConstraints = this.createNewConstraints();
        componentCollection2 = new ComponentCollection();
        componentCollection2.remember(this.makeLabel("Polarization Mode"));
        componentCollection2.remember(this.makeComboBox(POLNMODE_FID, AbstractSpectralWindow.getKnownPolnProductsList(), "ACA Polarization Mode"));
        componentCollection2.remember(this.makeLabel("Center Freq of Residual Delay"));
        JComponent[] jComponentArray = new JComponent[1];
        valueUnitPairEditor = this.makeValueUnitPairEditor(this.getModel().getResDelayFreqModel(), "<html>For practical purposes, 0Hz should be used as the center frequency in most cases,<br>and -4GHz, -2GHz, +2GHz, +4GHz are probable alternatives of the center frequency<br>of the residual delay compensation.</html>");
        jComponentArray[0] = valueUnitPairEditor;
        componentCollection2.remember(jComponentArray);
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new FrequencyVerifier(valueUnitPairEditor, -4.0, 4.0));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection2);
        JPanel jPanel2 = this.addGroup(jPanel, "ACA Only");
        this.register(jPanel2, ACAPANEL_FID);
        jPanel2.setVisible(false);
        this.acaComponents.add(jPanel2);
        JPanel jPanel3 = this.addSpectralWindowComponent();
        this.register(jPanel3, SWPANEL_FID);
        this.correlatorComponents.add(jPanel3);
    }

    private JPanel addSpectralWindowComponent() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        SpectralWindowTabbedModel spectralWindowTabbedModel = this.getModel().getSwTabbedModel();
        SpectralWindowEditor spectralWindowEditor = new SpectralWindowEditor(spectralWindowTabbedModel.getSubModel());
        this.swTabEditor = new SpectralWindowTabbedEditor((TabbedEditorModel)spectralWindowTabbedModel, spectralWindowEditor);
        this.registerSubView(this.swTabEditor);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.swTabEditor);
        return this.addGroup(jPanel, "Spectral Windows");
    }

    protected void cancelCellEditingOnSwTable() {
        this.swTabEditor.cancellCellEditingOnSwTable();
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        BaseBandConfigModel baseBandConfigModel = this.getModel();
        if (fieldID.equals(BASEBANDNAME_CB_FID) || fieldID.equals(BASEBANDNAME_TF_FID)) {
            String string = (String)object;
            super.update(BASEBANDNAME_CB_FID, string);
            super.update(BASEBANDNAME_TF_FID, string);
            AbstractBaseBandConfig abstractBaseBandConfig = baseBandConfigModel.getBaseBandConfig();
            if (abstractBaseBandConfig != null) {
                OTComboBox oTComboBox = (OTComboBox)this.retrieve(BASEBANDNAME_CB_FID);
                oTComboBox.setValid(abstractBaseBandConfig.isValidBasebandName());
            }
            return;
        }
        if (fieldID.equals(DOCUMENTLABEL_FID)) {
            if (object != null) {
                this.updateDeviceDependingComponent();
                this.updateCorrelatorDependingComponent();
                this.updateSidebandSeparationComponent();
            }
            return;
        }
        if (fieldID.equals(PRODUCTS_FID)) {
            super.update(fieldID, object);
            this.getModel().getSwTabbedModel().publish();
            return;
        }
        super.update(fieldID, object);
    }

    public void setHardwareSetupMode(boolean bl) {
        this.use12GHzFilterButton.setEnabled(bl);
        this.useUSBButton.setEnabled(bl);
    }

    private void updateCorrelatorDependingComponent() {
        BaseBand baseBand = this.getModel().getBaseBand();
        if (baseBand == null) {
            return;
        }
        BaseBandSpecification baseBandSpecification = baseBand.getBaseBandSpecification();
        if (baseBandSpecification == null) {
            return;
        }
        SpectralSpec spectralSpec = baseBandSpecification.getSpectralSpec();
        if (spectralSpec == null) {
            return;
        }
        AbstractBaseBandConfig abstractBaseBandConfig = baseBand.getBaseBandConfig();
        boolean bl = abstractBaseBandConfig instanceof BLBaseBandConfig;
        for (Component component : this.blComponents) {
            component.setVisible(spectralSpec.hasCorrelatorConfiguration() && bl);
        }
        for (Component component : this.acaComponents) {
            component.setVisible(spectralSpec.hasCorrelatorConfiguration() && !bl);
        }
    }

    private void updateDeviceDependingComponent() {
        BaseBandSpecification baseBandSpecification = this.getModel().getBaseBandSpecification();
        if (baseBandSpecification == null) {
            return;
        }
        SpectralSpec spectralSpec = baseBandSpecification.getSpectralSpec();
        boolean bl = spectralSpec.hasCorrelatorConfiguration();
        for (Component component : this.correlatorComponents) {
            component.setVisible(bl);
        }
        for (Component component : this.squareLawComponents) {
            component.setVisible(!bl);
        }
    }

    private void updateSidebandSeparationComponent() {
        boolean bl;
        Object object;
        try {
            object = this.getModel().getBaseBandSpecification();
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = ((BaseBandSpecification)object).getSpectralSpec().getCorrelatorConfiguration();
            bl = abstractCorrelatorConfiguration.isSideBandSeprationMode();
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        object = (ValueUnitPairEditor)this.retrieve(DESIREDIMGFRQREST_VUP_FID);
        ((ValueUnitPairEditor)object).setEnabled(bl);
    }

    protected void updateSwitchingComponent() {
        BaseBandSpecification baseBandSpecification = this.getModel().getBaseBandSpecification();
        if (baseBandSpecification != null) {
            this.getModel().setFrequencySwitching();
        }
    }

    public class BaseBandSwitchingSetupEditor
    extends EditorWithGridBagLayout {
        private JCheckBox frqSwitchCheckBox;
        private NumberOfSwitchingPositionCombo numberOfPosCombo;
        private ValueUnitPairEditor dwellTimeEditor;

        protected BaseBandSwitchingSetupEditor(BaseBandConfigModel baseBandConfigModel) {
            this.setModel(baseBandConfigModel);
            this.build();
            baseBandConfigModel.publish();
        }

        private BaseBandConfigModel getMyModel() {
            return (BaseBandConfigModel)this.getModel();
        }

        @Override
        protected void addComponents(String string) {
            JPanel jPanel = this.createNewGroup();
            GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
            GridBagConstraints gridBagConstraints = this.createNewConstraints();
            this.numberOfPosCombo = new NumberOfSwitchingPositionCombo();
            this.initEvents(this.numberOfPosCombo, NUMPOS_FID);
            this.numberOfPosCombo.setToolTipText("Number of switching positions");
            this.dwellTimeEditor = new ValueUnitPairEditor(this.getMyModel().getDwellTimeModel());
            this.dwellTimeEditor.setToolTipText("Time spent integrating");
            this.register(this.dwellTimeEditor, DWELLTIME_VUP_FID);
            this.frqSwitchCheckBox = this.addBooleanComponent(jPanel, gridBagLayout, gridBagConstraints, FRQSWITCHING_FID, "LO2 Frequency Switching", "Turn on LO2 Frequency Switching");
            this.frqSwitchCheckBox.setEnabled(false);
            this.dwellTimeEditor.setEnabled(false);
            this.numberOfPosCombo.setEnabled(false);
            this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Number of Positions", (JComponent)this.numberOfPosCombo);
            this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Dwell Time", (JComponent)this.dwellTimeEditor);
            this.addComponent(this, this.layout, this.constraints, jPanel);
        }

        @Override
        protected void build() {
            super.build("Switching");
        }

        @Override
        public void set(JComponent jComponent, Object object) {
            if (jComponent instanceof NumberOfSwitchingPositionCombo) {
                super.set((JComboBox)jComponent, (String)object);
            } else {
                super.set(jComponent, object);
            }
        }

        protected void updateDwellTime() {
            JComboBox jComboBox = (JComboBox)this.retrieve(NUMPOS_FID);
            boolean bl = "Unswitched".equals(this.get(jComboBox));
            this.dwellTimeEditor.setEnabled(!bl);
        }

        @Override
        public void update(FieldID fieldID, Object object) {
            if (fieldID == SS_FRQSWITCHING_FID) {
                boolean bl = (Boolean)object;
                this.retrieve(FRQSWITCHING_FID).setEnabled(bl);
                return;
            }
            if (fieldID == FRQSWITCHING_FID) {
                super.update(fieldID, object);
                boolean bl = (Boolean)object;
                this.numberOfPosCombo.setEnabled(bl);
                if (bl) {
                    this.updateDwellTime();
                } else {
                    this.dwellTimeEditor.setEnabled(bl);
                }
                return;
            }
            if (fieldID == NUMPOS_FID) {
                Integer n = (Integer)object;
                String string = this.numberOfPosCombo.getLabel(n);
                super.update(fieldID, string);
                this.updateDwellTime();
                return;
            }
            super.update(fieldID, object);
        }
    }
}

