/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.acs.entityutil.EntityException;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.hla.runtime.obsprep.util.UnknownEntityPartException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.MendMyStruct;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class ProjectBackupAction
extends OTAction {
    private static final String DEFAULT_BACKUP_FILE = "~NewProject";
    private final ObservingToolGui gui;

    public ProjectBackupAction(ObservingToolGui observingToolGui, boolean bl) {
        this(observingToolGui);
    }

    public ProjectBackupAction(@NonNull ObservingToolGui observingToolGui) {
        if (observingToolGui == null) {
            throw new NullPointerException("gui is marked non-null but is null");
        }
        this.gui = observingToolGui;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        File file = InitServices.ALMAOT_BACKUP_FOLDER;
        file.mkdirs();
        if (!(file.exists() && file.canWrite() && file.canRead())) {
            Log.logger(ProjectBackupAction.class).warning("Unable to setup back up directory " + file);
            return;
        }
        File file2 = this.gui.primaryProjectCompartment().getFileLocation();
        ObsProject obsProject = this.gui.getPrimaryProject();
        if (obsProject == null) {
            return;
        }
        if (file2 == null) {
            string = obsProject.gettrueCode();
            file2 = StringUtils.isEmpty((CharSequence)string) || string.equalsIgnoreCase("None Assigned") ? new File(file, "~NewProject.aot") : new File(file, "~" + string + ".aot");
        } else {
            string = FilenameUtils.getBaseName((String)file2.getAbsolutePath());
            assert (string != null);
            file2 = new File(file, "~" + string + ".aot");
        }
        try {
            string = file2.getCanonicalPath();
            File file3 = new File(string);
            Log.logger(ProjectBackupAction.class).fine("Backup file : " + string + " created");
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            MendMyStruct.sanitizeEntityRefs(obsProject);
            ImpexFactory.getInstance().exportProject(obsProject, fileOutputStream, true, false);
        }
        catch (EntityException | UnknownEntityException | UnknownEntityPartException | IOException throwable) {
            Log.logger(ProjectBackupAction.class).warning("Unable to save backup file : " + throwable.getMessage());
        }
    }
}

