/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.AttachTASummaryInteractor;
import alma.obsprep.ot.actions.AttachTASummaryPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.project.ProjectTreeNode;

public class AttachTASummaryAction
extends OTAction
implements AttachTASummaryInteractor,
EventReceiver {
    protected BusinessObject m_selectedBO = null;
    protected ProjectTreeNode m_selectedNode = null;

    public AttachTASummaryAction() {
        AttachTASummaryPerformer attachTASummaryPerformer = new AttachTASummaryPerformer(this);
        this.setPerformer(attachTASummaryPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
    }

    @Override
    public ObsProposal getProposal() {
        BusinessObject businessObject = this.m_selectedBO;
        ObsProject obsProject = businessObject.findProject();
        if (obsProject != null) {
            try {
                return obsProject.getObsProposal();
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger((Object)this).warning(unknownEntityException.getMessage());
            }
        }
        return null;
    }

    private void setEnableFor(ProjectTreeNode projectTreeNode) {
        this.setEnabled(false);
    }

    private void setEnableFor(BusinessObject businessObject) {
        this.setEnabled(businessObject instanceof ObsProject || businessObject instanceof ObsProposal);
    }

    @Override
    public void receiveEvent(Event event) {
        this.m_selectedNode = (ProjectTreeNode)event.getSource();
        this.m_selectedBO = (BusinessObject)this.m_selectedNode.getUserObject();
        this.setEnableFor(this.m_selectedBO);
    }
}

