/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.BLCorrelatorConfigurationT;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLBaseBandConfig;
import alma.obsprep.bo.schedblock.data.BLCorrelatorConfigurationData;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.valuetypes.Time;

public class BLCorrelatorConfiguration
extends BLCorrelatorConfigurationData {
    public BLCorrelatorConfiguration(BLCorrelatorConfigurationT bLCorrelatorConfigurationT) {
        super(bLCorrelatorConfigurationT);
    }

    protected void initAsNew() {
        super.initAsNew();
        CorrelatorExpert correlatorExpert = CorrelatorExpert.getBLInstance();
        this.setDumpDuration(Time.createTime((double)correlatorExpert.calcDumpDurationInmsecs(), (String)Time.UNIT_MS));
        double d = correlatorExpert.calcChannelAverageDurationInsecs(1.0, this.getDumpDuration().getContentInUnits(Time.UNIT_S));
        this.getChannelAverageDuration().setContentAndUnit(d, Time.UNIT_S);
        double d2 = correlatorExpert.calcIntegrationDurationInsecs(5.0, this.getChannelAverageDuration().getContentInUnits(Time.UNIT_S));
        this.getIntegrationDuration().setContentAndUnit(d2, Time.UNIT_S);
    }

    public CorrelatorType getCorrelatorType() {
        return CorrelatorType.BL;
    }

    public int getBaseBandConfigCount() {
        return this.getBLBaseBandConfigCount();
    }

    public AbstractBaseBandConfig getBaseBandConfig(int n) {
        return this.getBLBaseBandConfig(n);
    }

    public BLBaseBandConfig[] getBaseBandConfig() {
        return this.getBLBaseBandConfig();
    }

    public BLBaseBandConfig newBaseBandConfig() {
        return BLBaseBandConfig.createBLBaseBandConfig();
    }

    public void clearBaseBandConfig() {
        this.clearBLBaseBandConfig();
    }

    public void clearBLBaseBandConfig() {
        int n = this.getBLBaseBandConfigCount();
        for (int i = 0; i < n; ++i) {
            BLBaseBandConfig bLBaseBandConfig = this.getBLBaseBandConfig(0);
            this.primitiveRemoveBaseBandConfig((AbstractBaseBandConfig)((Object)bLBaseBandConfig));
        }
    }

    public BLBaseBandConfig primitiveAddBaseBandConfig(int n, AbstractBaseBandConfig abstractBaseBandConfig) {
        BLBaseBandConfig bLBaseBandConfig = (BLBaseBandConfig)((Object)abstractBaseBandConfig);
        super.addBLBaseBandConfig(n, bLBaseBandConfig);
        return bLBaseBandConfig;
    }

    public boolean primitiveRemoveBaseBandConfig(AbstractBaseBandConfig abstractBaseBandConfig) {
        BLBaseBandConfig bLBaseBandConfig = (BLBaseBandConfig)((Object)abstractBaseBandConfig);
        return super.removeBLBaseBandConfig(bLBaseBandConfig);
    }

    public void addBLBaseBandConfig(BLBaseBandConfig bLBaseBandConfig) {
        this.primitiveAddBaseBandConfig(this.getBLBaseBandConfigCount(), (AbstractBaseBandConfig)((Object)bLBaseBandConfig));
    }

    public void setBLBaseBandConfig(BLBaseBandConfig[] bLBaseBandConfigArray) {
        this.clearBLBaseBandConfig();
        for (int i = 0; i < bLBaseBandConfigArray.length; ++i) {
            this.primitiveAddBaseBandConfig(i, (AbstractBaseBandConfig)((Object)bLBaseBandConfigArray[i]));
        }
    }

    public int getNumAntennas() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        return almaCapabilities.getNumAntennas(Array.ARRAY_12M, (AbstractCorrelatorConfiguration)((Object)this));
    }
}

