/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.AbstractTargetParametersT;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.FieldPatternI;
import alma.obsprep.bo.annotations.FieldTargetPart;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.data.AbstractTargetParametersData;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;

public abstract class AbstractTargetParameters
extends AbstractTargetParametersData
implements FieldPatternI,
FieldTargetPart {
    private String previousResolvedTargetName = "";
    private String previousTargetName = "";

    public AbstractTargetParameters(AbstractTargetParametersT abstractTargetParametersT) {
        super(abstractTargetParametersT);
    }

    public Velocity getSourceVelocityInDefaultReferenceFrame(Optional<ScienceGoal> optional) {
        return this.getSourceVelocity().getVelocityInDefaultReferenceFrame(this.getSourceCoordinates(), optional);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setSolarSystemObject(SOLARSYSTEMOBJECT_UNSPECIFIED);
        this.getPmRA().setUnit(AngularVelocity.UNIT_MAS_YR);
        this.getPmDec().setUnit(AngularVelocity.UNIT_MAS_YR);
        this.getParallax().setUnit(Angle.UNIT_MAS);
        this.setSourceVelocity(Velocity.createVelocity());
        this.setSolarMappingDiameter(Angle.createAngleDegs(0.0));
        this.setSolarMappingPattern(SOLARMAPPINGPATTERN_DOUBLECIRCLE);
        this.setSolarMapping(SOLARMAPPING_FULLSOLARDISC);
    }

    @Override
    public AngularVelocity getPMRA() {
        return this.getPmRA();
    }

    @Override
    public AngularVelocity getPMDec() {
        return this.getPmDec();
    }

    public String getPreviousResolvedTargetName() {
        return this.previousResolvedTargetName;
    }

    public boolean hasNoPreviousResolvedTargetName() {
        return this.previousResolvedTargetName == null || this.previousResolvedTargetName.length() == 0;
    }

    public void setPreviousResolvedTargetName(String string) {
        this.previousResolvedTargetName = string;
    }

    public String getPreviousTargetName() {
        return this.previousTargetName;
    }

    public boolean hasNoPreviousTargetName() {
        return this.previousTargetName == null || this.previousTargetName.length() == 0;
    }

    public void setPreviousTargetName(String string) {
        this.previousTargetName = string;
    }

    @Override
    public SkyCoordinates getOrigin() {
        return this.getSourceCoordinates();
    }

    @Override
    public SkyCoordinates getFieldCenterCoordinates() {
        return this.getSourceCoordinates();
    }

    @Override
    public boolean isRectanglePattern() {
        return false;
    }

    public boolean isCirclePattern() {
        return false;
    }

    @Override
    public boolean isCrossPattern() {
        return false;
    }

    public boolean isSpiralPattern() {
        return false;
    }

    @Override
    public boolean isPointingPattern() {
        return false;
    }

    @Override
    public boolean isAbsolutePointingPattern() {
        return false;
    }

    @Override
    public boolean isOffsetPointingPattern() {
        return false;
    }

    @Override
    public boolean isMosaic() {
        return false;
    }

    public abstract void setIsMosaic(boolean var1);

    public boolean isEphemerisSource() {
        String string = this.getSolarSystemObject();
        return this.getNonSiderealMotion() && string != null && (string.equals(SOLARSYSTEMOBJECT_EPHEMERIS) || string.equals(SOLARSYSTEMOBJECT_SUN));
    }

    public boolean isSun() {
        String string = this.getSolarSystemObject();
        return this.getNonSiderealMotion() && string != null && string.equals(SOLARSYSTEMOBJECT_SUN);
    }

    public static void setAttributesForHistoricalProjects(@NonNull ObsProject obsProject) throws UnknownEntityException {
        if (obsProject == null) {
            throw new NullPointerException("lastObsProjectLoaded is marked non-null but is null");
        }
        Stream.of(obsProject.getObsProposal().getAbstractScienceGoalScienceGoal()).map(scienceGoal -> scienceGoal.getTargetParameters()).forEach(targetParametersArray -> Stream.of(targetParametersArray).forEach(targetParameters -> {
            if (targetParameters.getSolarMapping() == null) {
                targetParameters.setSolarMapping(SOLARMAPPING_FULLSOLARDISC);
            }
        }));
        Stream.of(obsProject.getObsProgram().getAbstractScienceGoalScienceGoal()).map(scienceGoal -> scienceGoal.getTargetParameters()).forEach(targetParametersArray -> Stream.of(targetParametersArray).forEach(targetParameters -> {
            if (targetParameters.getSolarMappingPattern() == null) {
                targetParameters.setSolarMappingPattern(SOLARMAPPINGPATTERN_DOUBLECIRCLE);
            }
        }));
    }
}

