/*
 * Decompiled with CFR 0.152.
 */
package alma.observatorycharacteristics.policies;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.observatorycharacteristics.configuration.ArrayConfigurationType;
import alma.observatorycharacteristics.configuration.DataRateLimitType;
import alma.observatorycharacteristics.configuration.OTConfiguration;
import alma.observatorycharacteristics.configuration.OTXMLConfigurationReader;
import alma.observatorycharacteristics.configuration.ProposalType;
import alma.observatorycharacteristics.configuration.ScienceKeywordGroup;
import alma.observatorycharacteristics.configuration.ScienceKeywords;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.lang3.StringUtils;

public class AlmaPolicies {
    private boolean isVLBISpectralLineEnabled = false;
    private static AlmaPolicies almaPoliciesSingleton = null;
    private final Time nominalSBExecutionLength;
    private final Time tpNominalTPSBLength;
    private final Time itosForSolarSource;
    private final Time tpMaxTOSPerSB;
    private final String cycleNumber;
    private final String ddtCycleNumber;
    private final Time minTimeOnSrc;
    private final int maxAbstractWords;
    private final int maxScienceCasePages;
    private int maxManagementPlanPages;
    private final int maxAbstractCharacters;
    private final int maxTextAreaCharacters;
    private final int maxTechnicalJustificationTextCharacters;
    private final int minTechnicalJustificationTextCharacters;
    private final int maxRetuningsPerGoal;
    private final int maxNumberPointings;
    private final int warningNumberPointings;
    private final int maxScienceGoals;
    private final int maxSourcesPerGoal;
    private final Angle maxConeDiameter;
    private final Angle maxConeDiameterLongBaseline;
    private final double max12mDataRateMBPS;
    private final double warning12mDataRateMBPS;
    private final Time minTimeOnSourcePerSBExecution;
    private final Time maxStandardProposalTime;
    private final Time minTimeForPolarizationSG;
    private final Time minAdvisedTimeMargin;
    private final double nominalTotalToScienceRatio;
    private final double nominalTotalToScienceMultipleTuningsRatio;
    private final double nominalTotalToSciencePolarizationRatio;
    private final double nominalTotalToScienceACA7MRatio;
    private final Map<String, String[]> scienceKeywordGroups = new HashMap<String, String[]>();
    private final Map<String, String> scienceKeywordCodes = new HashMap<String, String>();
    public static final File ALMA_POLICIES_PROPERTIES_FOLDER = new File("alma/observatorycharacteristics/policies");
    private final Angle maxSeparationOfPointingFromSourceCoordinate;
    private boolean isTechnicalJustificationRequired = true;
    private boolean isSourceParametersRequired = true;
    private final Time minLargeProgramTimeNoSACA;
    private final Time minLargeProgramTimeWithSACA;
    private OTConfiguration.TelescopePolicies telescopePolicies;
    private final String[] scienceCodes;
    private final String[] scienceCategories;
    private final String[] proposalTypes;
    private final String[] proposalCodes;
    private final String[] observatoryTypes;
    private final String[] observatoryCodes;
    private final String telescope = System.getProperty("Telescope", "Cycle9");
    private final double instantaneous12mDataRateMBPS;
    private final double max7mDataRateMBPS;
    private final double warning7mDataRateMBPS;
    private final double instantaneous7mDataRateMBPS;
    private final double maxTPDataRateMBPS;
    private final double warningTPDataRateMBPS;
    private final double instantaneousTPDataRateMBPS;
    private final String supplementalCallCycleNumber;
    private boolean isSupplementalCallEnabled;
    private final double nominalTotalToWalshScienceRatio;
    private int maxScienceCasePagesForLargeProgram;
    private boolean onlineDGCCalibratorResolution;

    private AlmaPolicies() throws InvalidObsProgramParametersException {
        try {
            this.telescopePolicies = OTXMLConfigurationReader.getInstance().getOTConfiguration().getTelescopePolicies();
        }
        catch (OTXMLConfigurationReader.InvalidOTCOnfigurationException | JAXBException throwable) {
            if (throwable instanceof UnmarshalException) {
                UnmarshalException unmarshalException = (UnmarshalException)throwable;
                Log.logger(AlmaPolicies.class).warning("Unable to unmarshall XML file " + unmarshalException.getLinkedException());
            }
            throwable.printStackTrace();
            throw new RuntimeException("Unable to parse the " + this.telescope + "OTConfiguration.xml file " + throwable.getMessage());
        }
        this.maxScienceCasePagesForLargeProgram = this.telescopePolicies.getMaxScienceCasePagesLargeProgram().intValue();
        this.maxManagementPlanPages = this.telescopePolicies.getMaxManagementPlanPages().intValue();
        this.maxSeparationOfPointingFromSourceCoordinate = OTConfigurationHelper.getAngle(this.telescopePolicies.getMaxPointingSeparationFromSourceCoordinate());
        this.minLargeProgramTimeNoSACA = OTConfigurationHelper.getTime(this.telescopePolicies.getMinLargeProgramTimeNoSACA());
        this.minLargeProgramTimeWithSACA = OTConfigurationHelper.getTime(this.telescopePolicies.getMinLargeProgramTimeWithSACA());
        this.nominalSBExecutionLength = OTConfigurationHelper.getTime(this.telescopePolicies.getNominalSBLength());
        this.isVLBISpectralLineEnabled = this.telescopePolicies.isIsVLBISpectralLineEnabled();
        this.tpNominalTPSBLength = OTConfigurationHelper.getTime(this.telescopePolicies.getTPNominalSBLength());
        this.cycleNumber = this.telescopePolicies.getCycleNumber();
        this.tpMaxTOSPerSB = OTConfigurationHelper.getTime(this.telescopePolicies.getTPMaxTOSPerSB());
        this.itosForSolarSource = OTConfigurationHelper.getTime(this.telescopePolicies.getIntegrationTimeForSolarSource());
        this.ddtCycleNumber = this.telescopePolicies.getDDTCycleNumber();
        this.supplementalCallCycleNumber = this.telescopePolicies.getSupplementalCallCycleNumber();
        String string = System.getProperty("alma.obsprep.supplementalcall");
        this.isSupplementalCallEnabled = string != null ? string.toLowerCase().indexOf("true") >= 0 : this.telescopePolicies.isSupplementalCallEnabled();
        this.minTimeOnSourcePerSBExecution = OTConfigurationHelper.getTime(this.telescopePolicies.getMinTimeOnSourcePerSB());
        this.nominalTotalToScienceRatio = this.telescopePolicies.getNominalTotalToScienceRatio();
        this.nominalTotalToScienceMultipleTuningsRatio = this.telescopePolicies.getNominalTotalToScienceRatioForMultipleTunings();
        this.nominalTotalToWalshScienceRatio = this.telescopePolicies.getNominalTotalToScienceRatioForWalsh();
        this.nominalTotalToSciencePolarizationRatio = this.telescopePolicies.getNominalTotalToScienceRatioForFullPolarization();
        this.nominalTotalToScienceACA7MRatio = this.telescopePolicies.getNominalTotalToScienceRatioForACA7M();
        this.minTimeOnSrc = OTConfigurationHelper.getTime(this.telescopePolicies.getMinTimeOnSource());
        this.maxAbstractWords = this.telescopePolicies.getMaxWordsInAbstract().intValue();
        this.maxRetuningsPerGoal = this.telescopePolicies.getMaxTuningsPerScienceGoal().intValue();
        this.maxScienceCasePages = this.telescopePolicies.getMaxScienceCasePages().intValue();
        this.maxAbstractCharacters = this.telescopePolicies.getMaxCharactersInAbstract().intValue();
        this.maxTextAreaCharacters = this.telescopePolicies.getMaxTextAreaCharacters().intValue();
        this.maxTechnicalJustificationTextCharacters = this.telescopePolicies.getMaxCharactersInTJField().intValue();
        this.minTechnicalJustificationTextCharacters = this.telescopePolicies.getMinCharactersInTJField().intValue();
        this.maxNumberPointings = this.telescopePolicies.getMaxNoOfPointings().intValue();
        this.warningNumberPointings = this.telescopePolicies.getWarningNoOfPointings().intValue();
        this.maxSourcesPerGoal = this.telescopePolicies.getMaxSourcesPerScienceGoal().intValue();
        this.maxScienceGoals = this.telescopePolicies.getMaxScienceGoals().intValue();
        List<OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint> list = this.telescopePolicies.getDataRateConstraints().getDataRateConstraint();
        List list2 = list.stream().filter(dataRateConstraint -> dataRateConstraint.getLimit().equals((Object)DataRateLimitType.ABSOLUTE) && dataRateConstraint.getArray().equals((Object)ArrayConfigurationType.TWELVE_M)).collect(Collectors.toList());
        List list3 = list.stream().filter(dataRateConstraint -> dataRateConstraint.getLimit().equals((Object)DataRateLimitType.WARNING) && dataRateConstraint.getArray().equals((Object)ArrayConfigurationType.TWELVE_M)).collect(Collectors.toList());
        List list4 = list.stream().filter(dataRateConstraint -> dataRateConstraint.getLimit().equals((Object)DataRateLimitType.INSTANTANEOUS) && dataRateConstraint.getArray().equals((Object)ArrayConfigurationType.TWELVE_M)).collect(Collectors.toList());
        List list5 = list.stream().filter(dataRateConstraint -> dataRateConstraint.getLimit().equals((Object)DataRateLimitType.ABSOLUTE) && dataRateConstraint.getArray().equals((Object)ArrayConfigurationType.ACA_7_M)).collect(Collectors.toList());
        List list6 = list.stream().filter(dataRateConstraint -> dataRateConstraint.getLimit().equals((Object)DataRateLimitType.WARNING) && dataRateConstraint.getArray().equals((Object)ArrayConfigurationType.ACA_7_M)).collect(Collectors.toList());
        List list7 = list.stream().filter(dataRateConstraint -> dataRateConstraint.getLimit().equals((Object)DataRateLimitType.INSTANTANEOUS) && dataRateConstraint.getArray().equals((Object)ArrayConfigurationType.ACA_7_M)).collect(Collectors.toList());
        List list8 = list.stream().filter(dataRateConstraint -> dataRateConstraint.getLimit().equals((Object)DataRateLimitType.ABSOLUTE) && dataRateConstraint.getArray().equals((Object)ArrayConfigurationType.TP)).collect(Collectors.toList());
        List list9 = list.stream().filter(dataRateConstraint -> dataRateConstraint.getLimit().equals((Object)DataRateLimitType.WARNING) && dataRateConstraint.getArray().equals((Object)ArrayConfigurationType.TP)).collect(Collectors.toList());
        List list10 = list.stream().filter(dataRateConstraint -> dataRateConstraint.getLimit().equals((Object)DataRateLimitType.INSTANTANEOUS) && dataRateConstraint.getArray().equals((Object)ArrayConfigurationType.TP)).collect(Collectors.toList());
        if (list2.size() > 1) {
            Log.logger(AlmaPolicies.class).warning("Only one absolute data rate limit should be specified for the 12-m array: ");
            throw new RuntimeException("Only one absolute data rate limit should be specified for the 12-m array: ");
        }
        if (list3.size() > 1) {
            Log.logger(AlmaPolicies.class).warning("Only one warning data rate limit should be specified for the 12-m array");
            throw new RuntimeException("Only one warning data rate limit should be specified for the 12-m array");
        }
        if (list4.size() > 1) {
            Log.logger(AlmaPolicies.class).warning("Only one instantaneous data rate limit should be specified for the 12-m array");
            throw new RuntimeException("Only one instantaneous data rate limit should be specified for the 12-m array");
        }
        if (list5.size() > 1) {
            String string2 = "Only one absolute data rate limit should be specified for the 7-m array: " + list5.size();
            Log.logger(AlmaPolicies.class).warning(string2);
            throw new RuntimeException(string2);
        }
        if (list6.size() > 1) {
            Log.logger(AlmaPolicies.class).warning("Only one warning data rate limit should be specified for the 7-m array");
            throw new RuntimeException("Only one warning data rate limit should be specified for the 7-m array");
        }
        if (list7.size() > 1) {
            Log.logger(AlmaPolicies.class).warning("Only one instantaneous data rate limit should be specified for the 7-m array");
            throw new RuntimeException("Only one instantaneous data rate limit should be specified for the 7-m array");
        }
        if (list8.size() > 1) {
            Log.logger(AlmaPolicies.class).warning("Only one absolute data rate limit should be specified for the TP array");
            throw new RuntimeException("Only one absolute data rate limit should be specified for the TP array");
        }
        if (list9.size() > 1) {
            Log.logger(AlmaPolicies.class).warning("Only one warning data rate limit should be specified for the TP array");
            throw new RuntimeException("Only one warning data rate limit should be specified for the TP array");
        }
        if (list10.size() > 1) {
            Log.logger(AlmaPolicies.class).warning("Only one instantaneous data rate limit should be specified for the TP array");
            throw new RuntimeException("Only one instantaneous data rate limit should be specified for the TP array");
        }
        this.max12mDataRateMBPS = ((OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint)list2.get(0)).getDataRateMBPS();
        this.warning12mDataRateMBPS = ((OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint)list3.get(0)).getDataRateMBPS();
        this.instantaneous12mDataRateMBPS = ((OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint)list4.get(0)).getDataRateMBPS();
        this.max7mDataRateMBPS = ((OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint)list5.get(0)).getDataRateMBPS();
        this.warning7mDataRateMBPS = ((OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint)list6.get(0)).getDataRateMBPS();
        this.instantaneous7mDataRateMBPS = ((OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint)list7.get(0)).getDataRateMBPS();
        this.maxTPDataRateMBPS = ((OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint)list8.get(0)).getDataRateMBPS();
        this.warningTPDataRateMBPS = ((OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint)list9.get(0)).getDataRateMBPS();
        this.instantaneousTPDataRateMBPS = ((OTConfiguration.TelescopePolicies.DataRateConstraints.DataRateConstraint)list10.get(0)).getDataRateMBPS();
        this.maxConeDiameter = OTConfigurationHelper.getAngle(this.telescopePolicies.getMaxConeDiameter());
        this.maxConeDiameterLongBaseline = OTConfigurationHelper.getAngle(this.telescopePolicies.getMaxConeDiameterLongBaseline());
        this.maxStandardProposalTime = OTConfigurationHelper.getTime(this.telescopePolicies.getMaxTimeOfStandardProject());
        this.onlineDGCCalibratorResolution = this.telescopePolicies.isOnlineDGCCalibratorResolution();
        this.minTimeForPolarizationSG = OTConfigurationHelper.getTime(this.telescopePolicies.getMinTimeForPolarisationSG());
        this.minAdvisedTimeMargin = OTConfigurationHelper.getTime(this.telescopePolicies.getMinAdvisedTimeMargin());
        this.isTechnicalJustificationRequired = this.telescopePolicies.isTJRequired();
        this.isSourceParametersRequired = this.telescopePolicies.isSourceParametersRequired();
        List<OTConfiguration.TelescopePolicies.ScienceCategories.ScienceCategory> list11 = this.telescopePolicies.getScienceCategories().getScienceCategory();
        this.scienceCategories = (String[])list11.stream().map(scienceCategory -> scienceCategory.getCategory()).toArray(String[]::new);
        this.scienceCodes = (String[])list11.stream().map(scienceCategory -> scienceCategory.getIndex().toString()).toArray(String[]::new);
        if (this.scienceCategories == null || this.scienceCategories.length == 0) {
            throw new RuntimeException("Science categories is empty");
        }
        if (this.scienceCodes == null || this.scienceCodes.length == 0) {
            throw new RuntimeException("Science code is empty");
        }
        List<ProposalType> list12 = this.telescopePolicies.getStandardProposalTypes().getProposalType();
        this.proposalCodes = (String[])list12.stream().map(proposalType -> proposalType.getCode().toString()).toArray(String[]::new);
        this.proposalTypes = (String[])list12.stream().map(proposalType -> proposalType.getDescription()).toArray(String[]::new);
        if (this.proposalTypes == null || this.proposalTypes.length == 0) {
            throw new RuntimeException("Proposal types is empty");
        }
        if (this.proposalCodes == null || this.proposalCodes.length == 0) {
            throw new RuntimeException("Proposal codes is empty");
        }
        List<ProposalType> list13 = this.telescopePolicies.getObservatoryProposalTypes().getProposalType();
        this.observatoryTypes = (String[])list13.stream().map(proposalType -> proposalType.getDescription()).toArray(String[]::new);
        this.observatoryCodes = (String[])list13.stream().map(proposalType -> proposalType.getCode().toString()).toArray(String[]::new);
        if (this.observatoryCodes == null || this.observatoryCodes.length == 0) {
            throw new RuntimeException("Observatory proposal codes is empty");
        }
        if (this.observatoryTypes == null || this.observatoryTypes.length == 0) {
            throw new RuntimeException("Observatory proposal types is empty");
        }
        for (ScienceKeywordGroup scienceKeywordGroup : this.telescopePolicies.getScienceKeywords().getScienceGroup()) {
            String string3 = scienceKeywordGroup.getGroup().toString();
            for (ScienceKeywords scienceKeywords2 : scienceKeywordGroup.getKeyword()) {
                this.scienceKeywordCodes.put(scienceKeywords2.getKeyword(), string3 + scienceKeywords2.getCode());
            }
            this.scienceKeywordGroups.put(string3, (String[])scienceKeywordGroup.getKeyword().stream().map(scienceKeywords -> scienceKeywords.getKeyword()).toArray(String[]::new));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlmaPolicies getInstance() {
        if (almaPoliciesSingleton != null) return almaPoliciesSingleton;
        Class<AlmaPolicies> clazz = AlmaPolicies.class;
        synchronized (AlmaPolicies.class) {
            if (almaPoliciesSingleton != null) return almaPoliciesSingleton;
            try {
                almaPoliciesSingleton = new AlmaPolicies();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                Log.logger(AlmaPolicies.class).log(Level.WARNING, "", (Throwable)invalidObsProgramParametersException);
                throw new RuntimeException(invalidObsProgramParametersException);
            }
            return almaPoliciesSingleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void refreshPolicies() {
        if (almaPoliciesSingleton == null) return;
        Class<AlmaPolicies> clazz = AlmaPolicies.class;
        synchronized (AlmaPolicies.class) {
            if (almaPoliciesSingleton == null) return;
            almaPoliciesSingleton = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public Time getNominalSbLength() {
        return this.nominalSBExecutionLength.deepCopy();
    }

    public Time getTPNominalSbLength() {
        return this.tpNominalTPSBLength.deepCopy();
    }

    public String getCycleNumber() {
        return this.getCommandLineCycleNumber(this.cycleNumber, "ot.cyclenumber");
    }

    public Time getMinTimeOnSourcePerSB() {
        return this.minTimeOnSourcePerSBExecution.deepCopy();
    }

    public Time getMinimumTimeOnSrc() {
        return this.minTimeOnSrc.deepCopy();
    }

    public String getDDTCycleNumber() {
        return this.getCommandLineCycleNumber(this.ddtCycleNumber, "ot.ddtcyclenumber");
    }

    String getCommandLineCycleNumber(String string, String string2) {
        String string3 = string;
        if (System.getProperty(string2) != null) {
            String string4 = StringUtils.trimToEmpty((String)System.getProperty(string2));
            if (!string4.matches("\\w\\w\\w\\w\\.\\w")) {
                Log.logger(AlmaPolicies.class).warning("-D" + string2 + " value should have the format aaaa.n and use alphanumeric characters only : " + string4);
                System.exit(1);
            }
            string3 = string4;
        }
        return string3;
    }

    public Time getMaxStandardProposalTime() {
        return this.maxStandardProposalTime.deepCopy();
    }

    public Time getMinTimeForPolarisationSB() {
        return this.minTimeForPolarizationSG.deepCopy();
    }

    public Time getMinAdvisedTimeMargin() {
        return this.minAdvisedTimeMargin.deepCopy();
    }

    public Angle getMaxConeDiameter() {
        return this.maxConeDiameter.deepCopy();
    }

    public Angle getMaxConeDiameterLongBaseline() {
        return this.maxConeDiameterLongBaseline.deepCopy();
    }

    public String[] getKnownScientificCategories() {
        return this.getScienceCategories();
    }

    public String[] getScienceKeywords(String string) {
        return this.scienceKeywordGroups.get(string);
    }

    public String getScienceKeywordCode(String string) {
        return this.scienceKeywordCodes.get(string);
    }

    public String getScienceCodeForCategory(String string) {
        for (int i = 0; i < this.scienceCategories.length; ++i) {
            if (!this.scienceCategories[i].equals(string)) continue;
            return this.scienceCodes[i];
        }
        return "00";
    }

    public String getScienceCategoryForCode(String string) {
        for (int i = 0; i < this.scienceCodes.length; ++i) {
            if (!this.scienceCodes[i].equals(string)) continue;
            return this.scienceCategories[i];
        }
        return "Illegal Category";
    }

    public String[] getKnownProposalTypes() {
        return this.getProposalTypes();
    }

    public String getCodeForProposalType(String string) {
        for (int i = 0; i < this.proposalTypes.length; ++i) {
            if (!this.proposalTypes[i].equals(string)) continue;
            return this.proposalCodes[i];
        }
        throw new IllegalArgumentException("No code associated with the project type " + string + " found");
    }

    public String getCodeForObservatoryType(String string) {
        for (int i = 0; i < this.observatoryTypes.length; ++i) {
            if (!this.observatoryTypes[i].equals(string)) continue;
            return this.observatoryCodes[i];
        }
        return "?";
    }

    public String getProposalTypeForCode(String string) {
        for (int i = 0; i < this.proposalCodes.length; ++i) {
            if (!this.proposalCodes[i].equals(string)) continue;
            return this.proposalTypes[i];
        }
        throw new IllegalArgumentException("Unable to locate proposal type for code " + string);
    }

    public Time getMinLargeProgramTimeNoACA() {
        return this.minLargeProgramTimeNoSACA.deepCopy();
    }

    public Angle getMaxSeparationFromSourceCoordinate() {
        return this.maxSeparationOfPointingFromSourceCoordinate.deepCopy();
    }

    public Time getMinLargeProgramTimeWithSACA() {
        return this.minLargeProgramTimeWithSACA.deepCopy();
    }

    public Time getTpMaxTOSPerSB() {
        return this.tpMaxTOSPerSB.deepCopy();
    }

    public Time getItosForSolarSource() {
        return this.itosForSolarSource.deepCopy();
    }

    public boolean isVLBISpectralLineEnabled() {
        return this.isVLBISpectralLineEnabled;
    }

    public int getMaxAbstractWords() {
        return this.maxAbstractWords;
    }

    public int getMaxScienceCasePages() {
        return this.maxScienceCasePages;
    }

    public int getMaxManagementPlanPages() {
        return this.maxManagementPlanPages;
    }

    public int getMaxAbstractCharacters() {
        return this.maxAbstractCharacters;
    }

    public int getMaxTextAreaCharacters() {
        return this.maxTextAreaCharacters;
    }

    public int getMaxTechnicalJustificationTextCharacters() {
        return this.maxTechnicalJustificationTextCharacters;
    }

    public int getMinTechnicalJustificationTextCharacters() {
        return this.minTechnicalJustificationTextCharacters;
    }

    public int getMaxRetuningsPerGoal() {
        return this.maxRetuningsPerGoal;
    }

    public int getMaxNumberPointings() {
        return this.maxNumberPointings;
    }

    public int getWarningNumberPointings() {
        return this.warningNumberPointings;
    }

    public int getMaxScienceGoals() {
        return this.maxScienceGoals;
    }

    public int getMaxSourcesPerGoal() {
        return this.maxSourcesPerGoal;
    }

    public double getMax12mDataRateMBPS() {
        return this.max12mDataRateMBPS;
    }

    public double getWarning12mDataRateMBPS() {
        return this.warning12mDataRateMBPS;
    }

    public double getNominalTotalToScienceRatio() {
        return this.nominalTotalToScienceRatio;
    }

    public double getNominalTotalToScienceMultipleTuningsRatio() {
        return this.nominalTotalToScienceMultipleTuningsRatio;
    }

    public double getNominalTotalToSciencePolarizationRatio() {
        return this.nominalTotalToSciencePolarizationRatio;
    }

    public double getNominalTotalToScienceACA7MRatio() {
        return this.nominalTotalToScienceACA7MRatio;
    }

    public boolean isTechnicalJustificationRequired() {
        return this.isTechnicalJustificationRequired;
    }

    public boolean isSourceParametersRequired() {
        return this.isSourceParametersRequired;
    }

    public String[] getScienceCodes() {
        return this.scienceCodes;
    }

    public String[] getScienceCategories() {
        return this.scienceCategories;
    }

    public String[] getProposalTypes() {
        return this.proposalTypes;
    }

    public String[] getObservatoryTypes() {
        return this.observatoryTypes;
    }

    public double getInstantaneous12mDataRateMBPS() {
        return this.instantaneous12mDataRateMBPS;
    }

    public double getMax7mDataRateMBPS() {
        return this.max7mDataRateMBPS;
    }

    public double getWarning7mDataRateMBPS() {
        return this.warning7mDataRateMBPS;
    }

    public double getInstantaneous7mDataRateMBPS() {
        return this.instantaneous7mDataRateMBPS;
    }

    public double getMaxTPDataRateMBPS() {
        return this.maxTPDataRateMBPS;
    }

    public double getWarningTPDataRateMBPS() {
        return this.warningTPDataRateMBPS;
    }

    public double getInstantaneousTPDataRateMBPS() {
        return this.instantaneousTPDataRateMBPS;
    }

    public String getSupplementalCallCycleNumber() {
        return this.supplementalCallCycleNumber;
    }

    public boolean isSupplementalCallEnabled() {
        return this.isSupplementalCallEnabled;
    }

    public double getNominalTotalToWalshScienceRatio() {
        return this.nominalTotalToWalshScienceRatio;
    }

    public int getMaxScienceCasePagesForLargeProgram() {
        return this.maxScienceCasePagesForLargeProgram;
    }

    public void setOnlineDGCCalibratorResolution(boolean bl) {
        this.onlineDGCCalibratorResolution = bl;
    }

    public boolean isOnlineDGCCalibratorResolution() {
        return this.onlineDGCCalibratorResolution;
    }
}

