/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;

public class ChoiceParameter
extends Parameter {
    private final List optionList_ = new ArrayList();
    private final List nameList_ = new ArrayList();
    private Object objectValue_;
    private boolean usageSet_;

    public ChoiceParameter(String name, Object[] options) {
        super(name);
        if (options != null) {
            for (int iopt = 0; iopt < options.length; ++iopt) {
                this.addOption(options[iopt]);
            }
        }
    }

    public ChoiceParameter(String name) {
        this(name, null);
    }

    public void addOption(Object option, String name) {
        if (name == null) {
            name = this.getName(option);
        }
        if (this.nameList_.contains(name)) {
            throw new IllegalArgumentException("Option " + name + " already exists");
        }
        this.optionList_.add(option);
        this.nameList_.add(name);
    }

    public void addOption(Object option) {
        this.addOption(option, null);
    }

    public String getUsage() {
        if (this.usageSet_) {
            return super.getUsage();
        }
        StringBuffer sbuf = new StringBuffer();
        Iterator it = this.nameList_.iterator();
        while (it.hasNext()) {
            sbuf.append((String)it.next());
            if (!it.hasNext()) continue;
            sbuf.append('|');
        }
        return sbuf.toString();
    }

    public void setUsage(String usage) {
        this.usageSet_ = true;
        super.setUsage(usage);
    }

    public void setValueFromString(Environment env, String value) throws TaskException {
        if (value == null) {
            super.setValueFromString(env, value);
            return;
        }
        int nopt = this.optionList_.size();
        for (int i = 0; i < nopt; ++i) {
            if (!value.equalsIgnoreCase((String)this.nameList_.get(i))) continue;
            this.objectValue_ = this.optionList_.get(i);
            super.setValueFromString(env, value);
            return;
        }
        StringBuffer sbuf = new StringBuffer().append("Unknown value ").append(value).append(" - must be one of ");
        Iterator it = this.nameList_.iterator();
        while (it.hasNext()) {
            sbuf.append((String)it.next());
            if (!it.hasNext()) continue;
            sbuf.append(", ");
        }
        throw new ParameterValueException((Parameter)this, sbuf.toString());
    }

    public Object objectValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.objectValue_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDefaultOption(Object option) {
        if (option == null) {
            if (!this.isNullPermitted()) throw new IllegalArgumentException("null value not allowed");
            this.setDefault(null);
            return;
        } else {
            int iopt = this.optionList_.indexOf(option);
            if (iopt < 0) throw new IllegalArgumentException("No such option: " + option);
            this.setDefault((String)this.nameList_.get(iopt));
        }
    }

    public String[] getOptionNames() {
        return this.nameList_.toArray(new String[0]);
    }

    public Object[] getOptions() {
        return this.optionList_.toArray(new Object[0]);
    }

    public String getName(Object option) {
        return String.valueOf(option);
    }

    public Object getOption(String name) {
        int nopt = this.optionList_.size();
        for (int i = 0; i < nopt; ++i) {
            if (!name.equalsIgnoreCase((String)this.nameList_.get(i))) continue;
            return this.optionList_.get(i);
        }
        return null;
    }
}

