/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.lang.reflect.Array;

public abstract class PrimitiveList {
    private final Class componentType_;
    private int size_;
    Object array_;
    static final int DEFAULT_SIZE = 16;

    protected PrimitiveList(Object array, int size) {
        this.componentType_ = array.getClass().getComponentType();
        this.size_ = size;
        this.array_ = array;
    }

    public int size() {
        return this.size_;
    }

    public Object toArray() {
        Object array = Array.newInstance(this.componentType_, this.size_);
        System.arraycopy(this.array_, 0, array, 0, this.size_);
        return array;
    }

    void ensureCapacity(int minCapacity) {
        if (minCapacity > Array.getLength(this.array_)) {
            this.expandCapacity(minCapacity);
        }
    }

    void expandSize(int inc) {
        this.ensureCapacity(this.size_ + inc);
        this.size_ += inc;
    }

    void checkIndex(int i) {
        if (i >= this.size_) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void expandCapacity(int minCapacity) {
        int newCapacity = (Array.getLength(this.array_) + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minCapacity > newCapacity) {
            newCapacity = minCapacity;
        }
        Object array = Array.newInstance(this.componentType_, newCapacity);
        System.arraycopy(this.array_, 0, array, 0, this.size_);
        this.array_ = array;
    }
}

