/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.wrappers;

import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.exceptions.syntax.IllegalHistoryNumberException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.wrappers.DocumentData;
import alma.ngas.client.JClient;
import alma.ngas.client.Status;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DocumentFinder {
    private InternalIF xmlstore = null;
    private JClient ngasJClient = null;
    private ArrayList ngasTypes = null;
    boolean storeInNgast = false;
    private String testDirectory = "";

    public DocumentFinder(InternalIF xmlstore, JClient ngasJClient, Logger logger, boolean storeInNgast, String testDirectory) {
        this.xmlstore = xmlstore;
        this.ngasJClient = ngasJClient;
        this.ngasTypes = new ArrayList();
        this.storeInNgast = storeInNgast;
        this.testDirectory = testDirectory;
    }

    public void addNgasType(String schemaName) {
        this.ngasTypes.add(schemaName);
    }

    public InputStream fetch(URI uid) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, UserDoesNotExistException, IllegalHistoryNumberException, MalformedURIException, ModuleCriticalException, ArchiveException {
        DocumentData dd = this.xmlstore.status(uid, "archiveClient");
        URI schemaUri = dd.getSchema();
        SchemaManager smanager = this.xmlstore.getSchemaManager("archiveClient");
        String schemaName = smanager.getSchemaName(schemaUri);
        if (this.ngasTypes.contains(schemaName)) {
            if (this.storeInNgast) {
                Logger logger = Logger.global;
                String filename = uid.toASCIIString().substring(6);
                Status status = this.ngasJClient.retrieve(filename, this.uid2filename(uid.toASCIIString().substring(6)));
                if (status.getOK()) {
                    logger.info(status.getRequestStatus());
                    logger.fine(status.getMessage());
                    try {
                        FileInputStream fis = new FileInputStream(this.uid2filename(uid.toASCIIString().substring(6)));
                        return new BufferedInputStream(fis);
                    }
                    catch (FileNotFoundException e) {
                        throw new DatabaseException(e);
                    }
                }
                throw new DatabaseException(status.getMessage());
            }
            try {
                FileInputStream fis = new FileInputStream(this.uid2filename(uid.toASCIIString().substring(6)));
                return new BufferedInputStream(fis);
            }
            catch (FileNotFoundException e) {
                throw new DatabaseException(e);
            }
        }
        return new StringBufferInputStream(this.xmlstore.get(uid, "archiveClient"));
    }

    protected String uid2filename(String uid) {
        if (this.testDirectory.equalsIgnoreCase("")) {
            return uid.replace('/', '_');
        }
        return this.testDirectory + "/" + uid.replace('/', '_');
    }
}

